/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import javax.xml.transform.TransformerConfigurationException;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.tree.AttributeCollection;

public class XSLNamespaceAlias
extends StyleElement {
    private short stylesheetURICode;
    private int resultNamespaceCode;

    public void prepareAttributes() throws TransformerConfigurationException {
        String string = null;
        String string2 = null;
        AttributeCollection attributeCollection = this.getAttributeList();
        int n = 0;
        while (n < attributeCollection.getLength()) {
            int n2 = attributeCollection.getNameCode(n);
            String string3 = this.getNamePool().getClarkName(n2);
            if (string3 == "stylesheet-prefix") {
                string = attributeCollection.getValue(n).trim();
            } else if (string3 == "result-prefix") {
                string2 = attributeCollection.getValue(n).trim();
            } else {
                this.checkUnknownAttribute(n2);
            }
            ++n;
        }
        if (string == null) {
            this.reportAbsence("stylesheet-prefix");
            return;
        }
        if (string.equals("#default")) {
            string = "";
        }
        if (string2 == null) {
            this.reportAbsence("result-prefix");
            return;
        }
        if (string2.equals("#default")) {
            string2 = "";
        }
        try {
            this.stylesheetURICode = this.getURICodeForPrefix(string);
            NamePool namePool = this.getNamePool();
            this.resultNamespaceCode = namePool.getNamespaceCode(string2, this.getURIForPrefix(string2, true));
        }
        catch (NamespaceException namespaceException) {
            this.compileError(namespaceException.getMessage());
        }
    }

    public void validate() throws TransformerConfigurationException {
        this.checkTopLevel();
    }

    public Instruction compile() throws TransformerConfigurationException {
        return null;
    }

    public short getStylesheetURICode() {
        return this.stylesheetURICode;
    }

    public int getResultNamespaceCode() {
        return this.resultNamespaceCode;
    }
}

