### Reporting Bugs

Bug reports are welcome and appreciated. When filing an issue, please include a small code snippet that demonstrates the bug if you can, else include a good description of how to reproduce the bug.

### Contributing Bug Fixes

Pull requests for bugs related to existing features are always welcome.

### Requesting Features

Feature requests are welcome by filing an issue. In general we try to make sure that new features fit well with the existing ones and that they're broadly useful. If your feature will require new APIs or API changes, feel free to share an example of how you think the API should look.

### Contributing Features

If you have an idea for a new feature, the best place to start is not with a pull request but rather  by opening an issue describing how the feature or API change should work and why you think it is necessary. The reason we suggest starting with an issue rather than a pull request is that we like to make sure every feature and API change is widely useful and a good fit for the library, and would hate to reject a PR that someone puts a lot of time into if it's not a good fit.

If your feature idea sounds good, you can then submit a PR, else we'll schedule the feature for implementation.

### Contributing Documentation or Website Fixes

Fixes to the Failsafe documentation or website are welcome. Just clone the [website repo](https://github.com/failsafe-lib/failsafe-lib.github.io) and feel free to submit a pull request.
