/*
 * Decompiled with CFR 0.152.
 */
package com.google.caliper;

import com.google.caliper.Arguments;
import com.google.caliper.MeasurementSet;
import com.google.caliper.MeasurementType;
import com.google.caliper.Run;
import com.google.caliper.Scenario;
import com.google.caliper.ScenarioResult;
import com.google.caliper.util.LinearTranslation;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;

final class ConsoleReport {
    private static final int barGraphWidth = 30;
    private static final int UNITS_FOR_SCORE_100 = 1;
    private static final int UNITS_FOR_SCORE_10 = 1000000000;
    private static final LinearTranslation scoreTranslation = new LinearTranslation(Math.log(1.0E9), 10.0, Math.log(1.0), 100.0);
    public static final Ordering<Map.Entry<String, Integer>> UNIT_ORDERING = new Ordering<Map.Entry<String, Integer>>(){

        public int compare(Map.Entry<String, Integer> a, Map.Entry<String, Integer> b) {
            return a.getValue().compareTo(b.getValue());
        }
    };
    private final List<Variable> variables;
    private final Run run;
    private final List<Scenario> scenarios;
    private final List<MeasurementType> orderedMeasurementTypes;
    private final MeasurementType type;
    private final double maxValue;
    private final double logMinValue;
    private final double logMaxValue;
    private final EnumMap<MeasurementType, Integer> decimalDigitsMap = new EnumMap(MeasurementType.class);
    private final EnumMap<MeasurementType, Double> divideByMap = new EnumMap(MeasurementType.class);
    private final EnumMap<MeasurementType, String> unitMap = new EnumMap(MeasurementType.class);
    private final EnumMap<MeasurementType, Integer> measurementColumnLengthMap = new EnumMap(MeasurementType.class);
    private boolean printScore;

    ConsoleReport(Run run, Arguments arguments) {
        this.run = run;
        this.unitMap.put(MeasurementType.TIME, arguments.getTimeUnit());
        this.unitMap.put(MeasurementType.INSTANCE, arguments.getInstanceUnit());
        this.unitMap.put(MeasurementType.MEMORY, arguments.getMemoryUnit());
        this.orderedMeasurementTypes = arguments.getMeasureMemory() ? Arrays.asList(MeasurementType.TIME, MeasurementType.INSTANCE, MeasurementType.MEMORY) : Arrays.asList(MeasurementType.TIME);
        this.type = arguments.getPrimaryMeasurementType() != null ? arguments.getPrimaryMeasurementType() : MeasurementType.TIME;
        double min = Double.POSITIVE_INFINITY;
        double max = 0.0;
        LinkedHashMultimap nameToValues = LinkedHashMultimap.create();
        ArrayList<Variable> variablesBuilder = new ArrayList<Variable>();
        for (Map.Entry<Scenario, ScenarioResult> entry : this.run.getMeasurements().entrySet()) {
            Scenario scenario = entry.getKey();
            double d = entry.getValue().getMeasurementSet(this.type).medianUnits();
            min = Math.min(min, d);
            max = Math.max(max, d);
            for (Map.Entry<String, String> variable : scenario.getVariables().entrySet()) {
                String name = variable.getKey();
                nameToValues.put((Object)name, (Object)variable.getValue());
            }
        }
        for (Map.Entry<Scenario, ScenarioResult> entry : nameToValues.asMap().entrySet()) {
            Variable variable = new Variable((String)((Object)entry.getKey()), (Collection)((Object)entry.getValue()));
            variablesBuilder.add(variable);
        }
        double sumOfAllMeasurements = 0.0;
        for (ScenarioResult measurement : this.run.getMeasurements().values()) {
            sumOfAllMeasurements += measurement.getMeasurementSet(this.type).medianUnits();
        }
        for (Variable variable : variablesBuilder) {
            int numValues = variable.values.size();
            double[] sumForValue = new double[numValues];
            for (Map.Entry<Scenario, ScenarioResult> entry : this.run.getMeasurements().entrySet()) {
                Scenario scenario = entry.getKey();
                int n = variable.index(scenario);
                sumForValue[n] = sumForValue[n] + entry.getValue().getMeasurementSet(this.type).medianUnits();
            }
            double mean = sumOfAllMeasurements / (double)sumForValue.length;
            double stdDeviationSquared = 0.0;
            for (double value : sumForValue) {
                double distance = value - mean;
                stdDeviationSquared += distance * distance;
            }
            variable.stdDeviation = Math.sqrt(stdDeviationSquared / (double)numValues);
        }
        this.variables = new StandardDeviationOrdering().reverse().sortedCopy(variablesBuilder);
        this.scenarios = new ByVariablesOrdering().sortedCopy(this.run.getMeasurements().keySet());
        this.maxValue = max;
        this.logMinValue = Math.log(min);
        this.logMaxValue = Math.log(max);
        EnumMap<MeasurementType, Integer> digitsBeforeDecimalMap = new EnumMap<MeasurementType, Integer>(MeasurementType.class);
        EnumMap<MeasurementType, Integer> decimalPointMap = new EnumMap<MeasurementType, Integer>(MeasurementType.class);
        for (MeasurementType measurementType : this.orderedMeasurementTypes) {
            double maxForType = 0.0;
            double minForType = Double.POSITIVE_INFINITY;
            for (Map.Entry<Scenario, ScenarioResult> entry : this.run.getMeasurements().entrySet()) {
                double d = entry.getValue().getMeasurementSet(measurementType).medianUnits();
                minForType = Math.min(minForType, d);
                maxForType = Math.max(maxForType, d);
            }
            this.unitMap.put(measurementType, this.getUnit(this.unitMap.get((Object)measurementType), measurementType, minForType));
            this.divideByMap.put(measurementType, (double)this.getUnits(measurementType).get(this.unitMap.get((Object)measurementType)));
            int numDigitsInMin = ConsoleReport.ceil(Math.log10(minForType));
            this.decimalDigitsMap.put(measurementType, ConsoleReport.ceil(Math.max(0, ConsoleReport.ceil(Math.log10(this.divideByMap.get((Object)measurementType))) + 3 - numDigitsInMin)));
            digitsBeforeDecimalMap.put(measurementType, Math.max(1, ConsoleReport.ceil(Math.log10(maxForType / this.divideByMap.get((Object)measurementType)))));
            decimalPointMap.put(measurementType, this.decimalDigitsMap.get((Object)measurementType) > 0 ? 1 : 0);
            this.measurementColumnLengthMap.put(measurementType, Math.max(maxForType > 0.0 ? (Integer)digitsBeforeDecimalMap.get((Object)measurementType) + (Integer)decimalPointMap.get((Object)measurementType) + this.decimalDigitsMap.get((Object)measurementType) : 1, this.unitMap.get((Object)measurementType).trim().length()));
        }
        this.printScore = arguments.printScore();
    }

    private String getUnit(String userSuppliedUnit, MeasurementType measurementType, double min) {
        Map<String, Integer> units = this.getUnits(measurementType);
        if (userSuppliedUnit == null) {
            List entries = UNIT_ORDERING.reverse().sortedCopy(units.entrySet());
            for (Map.Entry entry : entries) {
                if (!(min / (double)((Integer)entry.getValue()).intValue() >= 1.0)) continue;
                return (String)entry.getKey();
            }
            return (String)((Map.Entry)entries.get(entries.size() - 1)).getKey();
        }
        if (!units.keySet().contains(userSuppliedUnit)) {
            throw new RuntimeException("\"" + this.unitMap.get((Object)measurementType) + "\" is not a valid unit.");
        }
        return userSuppliedUnit;
    }

    private Map<String, Integer> getUnits(MeasurementType measurementType) {
        Map<String, Integer> units = null;
        for (Map.Entry<Scenario, ScenarioResult> entry : this.run.getMeasurements().entrySet()) {
            if (units == null) {
                units = entry.getValue().getMeasurementSet(measurementType).getUnitNames();
                continue;
            }
            if (units.equals(entry.getValue().getMeasurementSet(measurementType).getUnitNames())) continue;
            throw new RuntimeException("measurement sets for run contain multiple, incompatible unit sets.");
        }
        if (units == null) {
            throw new RuntimeException("run has no measurements.");
        }
        if (units.isEmpty()) {
            throw new RuntimeException("no units specified.");
        }
        return units;
    }

    void displayResults() {
        this.printValues();
        System.out.println();
        this.printUninterestingVariables();
        this.printCharCounts();
    }

    private void printCharCounts() {
        int systemOutCharCount = 0;
        int systemErrCharCount = 0;
        for (ScenarioResult scenarioResult : this.run.getMeasurements().values()) {
            for (MeasurementType measurementType : MeasurementType.values()) {
                MeasurementSet measurementSet = scenarioResult.getMeasurementSet(measurementType);
                if (measurementSet == null) continue;
                systemOutCharCount += measurementSet.getSystemOutCharCount();
                systemErrCharCount += measurementSet.getSystemErrCharCount();
            }
        }
        if (systemOutCharCount > 0 || systemErrCharCount > 0) {
            System.out.println();
            System.out.println("Note: benchmarks printed " + systemOutCharCount + " characters to System.out and " + systemErrCharCount + " characters to System.err." + " Use --debug to see this output.");
        }
    }

    private void printValues() {
        for (Variable variable : this.variables) {
            if (!variable.isInteresting()) continue;
            System.out.printf("%" + variable.maxLength + "s ", variable.name);
        }
        boolean showGraphs = this.scenarios.size() > 1;
        EnumMap<MeasurementType, String> numbersFormatMap = new EnumMap<MeasurementType, String>(MeasurementType.class);
        for (MeasurementType measurementType : this.orderedMeasurementTypes) {
            if (measurementType != this.type) {
                System.out.printf("%" + this.measurementColumnLengthMap.get((Object)measurementType) + "s ", this.unitMap.get((Object)measurementType).trim());
            }
            numbersFormatMap.put(measurementType, "%" + this.measurementColumnLengthMap.get((Object)measurementType) + "." + this.decimalDigitsMap.get((Object)measurementType) + "f" + (this.type == measurementType ? "" : " "));
        }
        System.out.printf("%" + this.measurementColumnLengthMap.get((Object)this.type) + "s", this.unitMap.get((Object)this.type).trim());
        if (showGraphs) {
            System.out.print(" linear runtime");
        }
        System.out.println();
        double sumOfLogs = 0.0;
        for (Scenario scenario : this.scenarios) {
            for (Variable variable : this.variables) {
                if (!variable.isInteresting()) continue;
                System.out.printf("%" + variable.maxLength + "s ", variable.get(scenario));
            }
            ScenarioResult measurement = this.run.getMeasurements().get(scenario);
            sumOfLogs += Math.log(measurement.getMeasurementSet(this.type).medianUnits());
            for (MeasurementType measurementType : this.orderedMeasurementTypes) {
                if (measurementType == this.type) continue;
                System.out.printf((String)numbersFormatMap.get((Object)measurementType), measurement.getMeasurementSet(measurementType).medianUnits() / this.divideByMap.get((Object)measurementType));
            }
            System.out.printf((String)numbersFormatMap.get((Object)this.type), measurement.getMeasurementSet(this.type).medianUnits() / this.divideByMap.get((Object)this.type));
            if (showGraphs) {
                System.out.printf(" %s", this.barGraph(measurement.getMeasurementSet(this.type).medianUnits()));
            }
            System.out.println();
        }
        if (this.printScore) {
            double meanLogUnits = sumOfLogs / (double)this.scenarios.size();
            System.out.format("%nScore: %.3f%n", scoreTranslation.translate(meanLogUnits));
        }
    }

    private void printUninterestingVariables() {
        for (Variable variable : this.variables) {
            if (variable.isInteresting()) continue;
            System.out.println(variable.name + ": " + (String)Iterables.getOnlyElement(variable.values));
        }
    }

    private String barGraph(double value) {
        int graphLength = ConsoleReport.floor(value / this.maxValue * 30.0);
        graphLength = Math.max(1, graphLength);
        graphLength = Math.min(30, graphLength);
        return Strings.repeat((String)"=", (int)graphLength);
    }

    private static int floor(double d) {
        return (int)d;
    }

    private static int ceil(double d) {
        return (int)Math.ceil(d);
    }

    private class ByVariablesOrdering
    extends Ordering<Scenario> {
        private ByVariablesOrdering() {
        }

        public int compare(Scenario a, Scenario b) {
            for (Variable variable : ConsoleReport.this.variables) {
                int bValue;
                int aValue = variable.values.indexOf((Object)variable.get(a));
                int diff = aValue - (bValue = variable.values.indexOf((Object)variable.get(b)));
                if (diff == 0) continue;
                return diff;
            }
            return 0;
        }
    }

    private static class StandardDeviationOrdering
    extends Ordering<Variable> {
        private StandardDeviationOrdering() {
        }

        public int compare(Variable a, Variable b) {
            return Double.compare(a.stdDeviation, b.stdDeviation);
        }
    }

    private static class Variable {
        final String name;
        final ImmutableList<String> values;
        final int maxLength;
        double stdDeviation;

        Variable(String name, Collection<String> values) {
            this.name = name;
            this.values = ImmutableList.copyOf(values);
            int maxLen = name.length();
            for (String value : values) {
                maxLen = Math.max(maxLen, value.length());
            }
            this.maxLength = maxLen;
        }

        String get(Scenario scenario) {
            return scenario.getVariables().get(this.name);
        }

        int index(Scenario scenario) {
            return this.values.indexOf((Object)this.get(scenario));
        }

        boolean isInteresting() {
            return this.values.size() > 1;
        }
    }
}

