// Code generated by smithy-go-codegen DO NOT EDIT.

package customerprofiles

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/customerprofiles/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

//	Creates an integration workflow. An integration workflow is an async process
//
// which ingests historic data and sets up an integration for ongoing updates. The
// supported Amazon AppFlow sources are Salesforce, ServiceNow, and Marketo.
func (c *Client) CreateIntegrationWorkflow(ctx context.Context, params *CreateIntegrationWorkflowInput, optFns ...func(*Options)) (*CreateIntegrationWorkflowOutput, error) {
	if params == nil {
		params = &CreateIntegrationWorkflowInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateIntegrationWorkflow", params, optFns, c.addOperationCreateIntegrationWorkflowMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateIntegrationWorkflowOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateIntegrationWorkflowInput struct {

	// The unique name of the domain.
	//
	// This member is required.
	DomainName *string

	// Configuration data for integration workflow.
	//
	// This member is required.
	IntegrationConfig *types.IntegrationConfig

	// The name of the profile object type.
	//
	// This member is required.
	ObjectTypeName *string

	// The Amazon Resource Name (ARN) of the IAM role. Customer Profiles assumes this
	// role to create resources on your behalf as part of workflow execution.
	//
	// This member is required.
	RoleArn *string

	// The type of workflow. The only supported value is APPFLOW_INTEGRATION.
	//
	// This member is required.
	WorkflowType types.WorkflowType

	// The tags used to organize, track, or control access for this resource.
	Tags map[string]string

	noSmithyDocumentSerde
}

type CreateIntegrationWorkflowOutput struct {

	// A message indicating create request was received.
	//
	// This member is required.
	Message *string

	// Unique identifier for the workflow.
	//
	// This member is required.
	WorkflowId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateIntegrationWorkflowMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateIntegrationWorkflow{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateIntegrationWorkflow{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateIntegrationWorkflow"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpCreateIntegrationWorkflowValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateIntegrationWorkflow(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateIntegrationWorkflow(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateIntegrationWorkflow",
	}
}
