// Code generated by smithy-go-codegen DO NOT EDIT.

package codeguruprofiler

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/codeguruprofiler/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

//	Used by profiler agents to report their current state and to receive remote
//
// configuration updates. For example, ConfigureAgent can be used to tell an agent
// whether to profile or not and for how long to return profiling data.
func (c *Client) ConfigureAgent(ctx context.Context, params *ConfigureAgentInput, optFns ...func(*Options)) (*ConfigureAgentOutput, error) {
	if params == nil {
		params = &ConfigureAgentInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ConfigureAgent", params, optFns, c.addOperationConfigureAgentMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ConfigureAgentOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// The structure representing the configureAgentRequest.
type ConfigureAgentInput struct {

	//  The name of the profiling group for which the configured agent is collecting
	// profiling data.
	//
	// This member is required.
	ProfilingGroupName *string

	//  A universally unique identifier (UUID) for a profiling instance. For example,
	// if the profiling instance is an Amazon EC2 instance, it is the instance ID. If
	// it is an AWS Fargate container, it is the container's task ID.
	FleetInstanceId *string

	//  Metadata captured about the compute platform the agent is running on. It
	// includes information about sampling and reporting. The valid fields are:
	//
	//   - COMPUTE_PLATFORM - The compute platform on which the agent is running
	//
	//   - AGENT_ID - The ID for an agent instance.
	//
	//   - AWS_REQUEST_ID - The AWS request ID of a Lambda invocation.
	//
	//   - EXECUTION_ENVIRONMENT - The execution environment a Lambda function is
	//   running on.
	//
	//   - LAMBDA_FUNCTION_ARN - The Amazon Resource Name (ARN) that is used to invoke
	//   a Lambda function.
	//
	//   - LAMBDA_MEMORY_LIMIT_IN_MB - The memory allocated to a Lambda function.
	//
	//   - LAMBDA_REMAINING_TIME_IN_MILLISECONDS - The time in milliseconds before
	//   execution of a Lambda function times out.
	//
	//   - LAMBDA_TIME_GAP_BETWEEN_INVOKES_IN_MILLISECONDS - The time in milliseconds
	//   between two invocations of a Lambda function.
	//
	//   - LAMBDA_PREVIOUS_EXECUTION_TIME_IN_MILLISECONDS - The time in milliseconds
	//   for the previous Lambda invocation.
	Metadata map[string]string

	noSmithyDocumentSerde
}

// The structure representing the configureAgentResponse.
type ConfigureAgentOutput struct {

	//  An [AgentConfiguration]AgentConfiguration object that specifies if an agent profiles or not and
	// for how long to return profiling data.
	//
	// [AgentConfiguration]: https://docs.aws.amazon.com/codeguru/latest/profiler-api/API_AgentConfiguration.html
	//
	// This member is required.
	Configuration *types.AgentConfiguration

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationConfigureAgentMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpConfigureAgent{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpConfigureAgent{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ConfigureAgent"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpConfigureAgentValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opConfigureAgent(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opConfigureAgent(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ConfigureAgent",
	}
}
