#-*- coding: utf-8 -*-

# Copyright 2013 Calculate Ltd. http://www.calculate-linux.org
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

import os
import sys
from os import path
from calculate.lib.datavars import (Variable,VariableError,ReadonlyVariable,
                                    ActionVariable)

from calculate.lib.cl_lang import setLocalTranslate
from calculate.lib.cl_template import Template
setLocalTranslate('cl_lib3',sys.modules[__name__])

class VariableAcCustomName(Variable):
    """
    Пользовательское действие для выполнения шаблонов
    """
    opt = ["ac_custom_name"]
    metavalue = "ACTION"
    type = "choice"
    value = ""
    untrusted = True

    def init(self):
        self.label = _("Custom action")
        self.help = _("custom action")

    def choice(self):
        oldAction = self.Get('cl_action')
        oldName = self.Get('ac_custom_name')
        clTempl = Template(self.parent, cltObj = False)
        try:
            clTempl.applyTemplates()
        except:
            pass
        finally:
            self.parent.Set('cl_action',oldAction,force=True)
            self.parent.Set('ac_custom_name',oldName,force=True)
            clTempl.closeFiles()
        return list(set(map(lambda x:x[1],
               filter(lambda x:x[0] == 'ac_custom_name',
                      self.Get('cl_used_action')))))

    def check(self,value):
        if value == '':
            raise VariableError(_("Need to specify an action name"))
