#!/usr/bin/env python2
# -*- coding: utf-8 -*-

# setup.py --- Setup script for calculate-install

# Copyright 2010 Calculate Ltd. http://www.calculate-linux.org
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.

import os
from os import path
import stat
import distutils
import glob
import sys
from distutils.core import setup, Extension
import distutils.command.build
import distutils.command.install
import distutils.command.install_egg_info

locales = ("ru","bg","fr","uk","lt")
msg_params = "--check-format --check-domain -o"

def cout(string):
    sys.stdout.write(string)
    sys.stdout.flush()

class build_po( distutils.core.Command ) :

    description = "build translation files"
    user_options = []

    def initialize_options( self ) :
        pass
    def finalize_options( self ) :
        pass

    def run( self ) :
        #self.mkpath("build")
        #build.run( self )
        for locale in locales:
            localepath = path.join("build",locale,"LC_MESSAGES")
            self.mkpath(localepath)
            self.mkpath(locale)
            for po in glob.glob("%s/*.po"%locale) :
                if "packages.po" in po or "new.po" in po:
                    continue
                addon = "%s/packages.po"%locale
                if "cl_update" in po and path.exists(addon):
                    cmd = "msgfmt %s %s/%s %s %s" % \
                        (msg_params,localepath,
                        path.basename(po)[:-2]+'mo',po, addon)
                else:
                    cmd = "msgfmt %s %s/%s %s" % \
                        (msg_params,localepath,
                        path.basename(po)[:-2]+'mo',po)
                cout( cmd + "\n" )
                os.system(cmd)

class empty_egg_info( distutils.command.install_egg_info.install_egg_info ):
    def run(self):
        pass

class build( distutils.command.build.build ) :
    def run( self ) :
        distutils.command.build.build.run( self )

    def has_po( self ) :
        return any(len(glob.glob("%s/*.po"%x))>0 for x in ("ru","fr"))
    sub_commands = distutils.command.build.build.sub_commands + [
        ('build_po',has_po),
    ]

setup(
    name = "calculate-i18n",
    version = "3.5.0",
    description = "Calculate Linux internationalization",
    author = "Calculate Ltd.",
    author_email = "support@calculate.ru",
    url = "http://calculate-linux.org",
    license = "http://www.apache.org/licenses/LICENSE-2.0",
    data_files = [
        (path.join(locale,"LC_MESSAGES"),
         glob.glob(path.join("build",locale,"LC_MESSAGES/*.mo")))
         for locale in locales ],
    cmdclass = {'build':build,'build_po':build_po,'install_egg_info':empty_egg_info}
)
