/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.util;

import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.PdfCopy;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import java.awt.Dialog;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.icepdf.ri.common.ComponentKeyBinding;
import org.icepdf.ri.common.MyAnnotationCallback;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.common.SwingViewBuilder;
import org.icepdf.ri.common.views.AnnotationCallback;
import serpro.ppgd.irpf.exception.AplicacaoException;

public class PdfUtil {
    public static void exibirPdfs(List<byte[]> pdfs, String descricao, String nomeArquivo) throws AplicacaoException {
        Document doc = new Document();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            PdfCopy pdfCopy = new PdfCopy(doc, (OutputStream)bout);
            doc.open();
            for (byte[] pdf : pdfs) {
                PdfReader pdfReader = new PdfReader(pdf);
                PdfImportedPage importedPage = pdfCopy.getImportedPage(pdfReader, 1);
                pdfCopy.addPage(importedPage);
            }
        }
        catch (DocumentException | IOException e) {
            throw new AplicacaoException("Erro ao abrir arquivo PDF", e, false);
        }
        finally {
            try {
                doc.close();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        PdfUtil.exibirPdf(bout.toByteArray(), descricao, nomeArquivo);
    }

    public static void exibirPdf(byte[] pdf, String descricao, String nomeArquivo) {
        SwingController controller = new SwingController();
        SwingViewBuilder factory = new SwingViewBuilder(controller);
        JPanel viewerComponentPanel = factory.buildViewerPanel();
        ComponentKeyBinding.install((SwingController)controller, (JComponent)viewerComponentPanel);
        controller.getDocumentViewController().setAnnotationCallback((AnnotationCallback)new MyAnnotationCallback(controller.getDocumentViewController()));
        controller.openDocument(pdf, 0, pdf.length, descricao, nomeArquivo);
        controller.setPageViewMode(2, true);
        controller.setPageFitMode(4, false);
        JFrame window = new JFrame(descricao);
        window.getContentPane().add(viewerComponentPanel);
        window.setDefaultCloseOperation(2);
        window.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
        window.setLocationRelativeTo(null);
        window.pack();
        window.setVisible(true);
    }
}

