/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.util;

import java.awt.AWTKeyStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.border.TitledBorder;
import org.apache.commons.lang.StringEscapeUtils;
import serpro.ppgd.app.ConstantesMensagens;
import serpro.ppgd.gui.pendencia.MapeamentoInformacaoEditCampo;
import serpro.ppgd.gui.xbeans.JEditLogico;
import serpro.ppgd.gui.xbeans.JEditOpcao;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.irpf.exception.AplicacaoException;
import serpro.ppgd.irpf.exception.NegocioException;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.PainelDemonstrativoAb;
import serpro.ppgd.irpf.gui.PainelDemonstrativoIf;
import serpro.ppgd.irpf.gui.componente.JCustomDialog;
import serpro.ppgd.irpf.gui.componente.JHTMLPane;
import serpro.ppgd.irpf.gui.util.DisabledGlassPane;
import serpro.ppgd.irpf.gui.util.NegativeDefaultButtonJOptionPane;
import serpro.ppgd.irpf.util.IRPFUtil;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.util.LogPPGD;

public class GuiUtil {
    private static HashMap<String, ImageIcon> cacheImagens = new HashMap();

    public static Component getParent() {
        PlataformaPPGD lPlataformaPPGD = PlataformaPPGD.getPlataforma();
        JFrame lPai = null;
        if (lPlataformaPPGD != null) {
            try {
                lPai = lPlataformaPPGD.getJanelaPrincipal();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        return lPai;
    }

    public static Component getParent(JPanel painel) {
        return painel == null ? GuiUtil.getParent() : SwingUtilities.getRoot(painel);
    }

    private static String getTituloTelaConfirmacao() {
        return MensagemUtil.getMensagem((String)"TituloConfirmacao");
    }

    private static String getTituloTelaErro() {
        return MensagemUtil.getMensagem((String)"TituloMensagemErro");
    }

    private static String getTituloTelaInfo() {
        return MensagemUtil.getMensagem((String)"TituloMensagemInfo");
    }

    private static String getTituloTelaAviso() {
        return MensagemUtil.getMensagem((String)"TituloMensagemAviso");
    }

    public static void mostrarErro(Component pPai, String pMensagem) {
        String msgAcessivel = StringEscapeUtils.unescapeHtml((String)pMensagem.replaceAll("\\<.*?\\>", ""));
        GuiUtil.mostrarErro(pPai, pMensagem, msgAcessivel);
    }

    public static void mostrarErroHTML(String pMensagem) {
        JHTMLPane pane = new JHTMLPane(pMensagem);
        pane.setOpaque(false);
        String msgAcessivel = StringEscapeUtils.unescapeHtml((String)pMensagem.replaceAll("\\<.*?\\>", ""));
        GuiUtil.mostrarErro(GuiUtil.getParent(), pane, msgAcessivel);
    }

    public static void mostrarErroHTML(String pMensagem, String[] pArgs) {
        String mensagem = MensagemUtil.getMensagemComQuebraDeLinha((String)pMensagem, (String[])pArgs);
        JHTMLPane pane = new JHTMLPane(mensagem);
        pane.setOpaque(false);
        String msgAcessivel = StringEscapeUtils.unescapeHtml((String)mensagem.replaceAll("\\<.*?\\>", ""));
        GuiUtil.mostrarErro(GuiUtil.getParent(), pane, msgAcessivel);
    }

    public static void mostrarErro(Component pPai, Object pMensagem, String pMensagemAcessivel) {
        JOptionPane pane = new JOptionPane(pMensagem, 0);
        pane.getAccessibleContext().setAccessibleDescription(pMensagemAcessivel);
        JDialog dialog = pane.createDialog(pPai, GuiUtil.getTituloTelaAviso());
        dialog.show();
        dialog.dispose();
    }

    public static void mostrarErro(String pChaveMsg) {
        GuiUtil.mostrarErro(GuiUtil.getParent(), MensagemUtil.getMensagemComQuebraDeLinha((String)pChaveMsg));
    }

    public static void mostrarErroSemQuebraDeLinha(String pChaveMsg) {
        GuiUtil.mostrarErro(GuiUtil.getParent(), MensagemUtil.getMensagem((String)pChaveMsg));
    }

    public static void mostrarErro(String pChaveMsg, String[] pArgs) {
        GuiUtil.mostrarErro(GuiUtil.getParent(), MensagemUtil.getMensagemComQuebraDeLinha((String)pChaveMsg, (String[])pArgs));
    }

    public static void mostrarErro(Throwable pExcecao) {
        GuiUtil.mostrarErro(GuiUtil.getParent(), pExcecao.getMessage());
    }

    public static void mostrarErroFoco(NegocioException pExcecao) {
        GuiUtil.mostrarErro(GuiUtil.getParent(), pExcecao.getMessage());
        JComponent jComponent = (JComponent)MapeamentoInformacaoEditCampo.getEditAssociado((Informacao)pExcecao.getInformacao());
        jComponent.requestFocusInWindow();
    }

    public static void printComponents(Container container, String end) {
        for (Component component : container.getComponents()) {
            System.out.println(end + "component:" + component);
            if (component instanceof JComponent) {
                ((JComponent)component).setBorder(BorderFactory.createLineBorder(Color.BLACK));
            }
            if (!(component instanceof Container)) continue;
            GuiUtil.printComponents((Container)component, end + "\t");
        }
    }

    public static void mostrarAviso(Component pPai, String pMensagem) {
        JOptionPane pane = new JOptionPane(pMensagem, 2);
        String msgAcessivel = StringEscapeUtils.unescapeHtml((String)pMensagem.replaceAll("\\<.*?\\>", ""));
        pane.getAccessibleContext().setAccessibleDescription(msgAcessivel);
        JDialog dialog = pane.createDialog(pPai, GuiUtil.getTituloTelaAviso());
        dialog.show();
        dialog.dispose();
    }

    public static void mostrarAviso(String pChaveMsg) {
        GuiUtil.mostrarAviso(GuiUtil.getParent(), MensagemUtil.getMensagemComQuebraDeLinha((String)pChaveMsg));
    }

    public static void mostrarAviso(String pChaveMsg, String[] pArgs) {
        GuiUtil.mostrarAviso(GuiUtil.getParent(), MensagemUtil.getMensagemComQuebraDeLinha((String)pChaveMsg, (String[])pArgs));
    }

    public static void mostrarInfo(Component pPai, String pMensagem) {
        if (pMensagem.startsWith("<html>")) {
            GuiUtil.mostrarInfoHTML(pMensagem);
        } else {
            String msgAcessivel = StringEscapeUtils.unescapeHtml((String)pMensagem.replaceAll("\\<.*?\\>", ""));
            GuiUtil.mostrarInfo(pPai, pMensagem, msgAcessivel);
        }
    }

    public static void mostrarInfoHTML(String pMensagem) {
        JHTMLPane pane = new JHTMLPane(pMensagem);
        pane.setOpaque(false);
        String msgAcessivel = StringEscapeUtils.unescapeHtml((String)pMensagem.replaceAll("\\<.*?\\>", ""));
        GuiUtil.mostrarInfo(GuiUtil.getParent(), pane, msgAcessivel);
    }

    public static void mostrarInfo(Component pPai, Object pMensagem, String pMensagemAcessivel) {
        JOptionPane pane = new JOptionPane(pMensagem, 1);
        pane.getAccessibleContext().setAccessibleDescription(pMensagemAcessivel);
        JDialog dialog = pane.createDialog(pPai, GuiUtil.getTituloTelaInfo());
        dialog.show();
        dialog.dispose();
    }

    public static void mostrarInfo(Component pPai, String[] mensagens) {
        JPanel pnlMensagem = new JPanel();
        pnlMensagem.setLayout(new BoxLayout(pnlMensagem, 1));
        for (String msg : mensagens) {
            pnlMensagem.add(new JLabel(msg));
        }
        JOptionPane pane = new JOptionPane(pnlMensagem, 1);
        JDialog dialog = pane.createDialog(pPai, GuiUtil.getTituloTelaInfo());
        dialog.show();
        dialog.dispose();
    }

    public static void mostrarInfo(String pChaveMsg) {
        GuiUtil.mostrarInfo(GuiUtil.getParent(), MensagemUtil.getMensagemComQuebraDeLinha((String)pChaveMsg));
    }

    public static void mostrarInfo(String pChaveMsg, String[] pArgs) {
        GuiUtil.mostrarInfo(GuiUtil.getParent(), MensagemUtil.getMensagemComQuebraDeLinha((String)pChaveMsg, (String[])pArgs));
    }

    public static boolean mostrarConfirmaSemQuebraDeLinha(String pChaveMsg, String[] pArgsMsg) {
        return GuiUtil.mostrarConfirma(GuiUtil.getParent(), MensagemUtil.getMensagem((String)pChaveMsg, (String[])pArgsMsg));
    }

    public static boolean mostrarConfirma(Component pPai, String pMensagem) {
        JOptionPane pane = new JOptionPane(pMensagem, 3, 0);
        String msgAcessivel = StringEscapeUtils.unescapeHtml((String)pMensagem.replaceAll("\\<.*?\\>", ""));
        pane.getAccessibleContext().setAccessibleDescription(msgAcessivel);
        JDialog dialog = pane.createDialog(pPai, GuiUtil.getTituloTelaConfirmacao());
        dialog.setVisible(true);
        dialog.dispose();
        Object selectedValue = pane.getValue();
        return selectedValue != null && (Integer)selectedValue == 0;
    }

    public static boolean mostrarConfirma(String pChaveMsg) {
        return GuiUtil.mostrarConfirma(GuiUtil.getParent(), MensagemUtil.getMensagemComQuebraDeLinha((String)pChaveMsg));
    }

    public static boolean mostrarConfirma(String pChaveMsg, int pTamanhoLinha) {
        return GuiUtil.mostrarConfirma(GuiUtil.getParent(), MensagemUtil.getMensagemComQuebraDeLinha((String)pChaveMsg, (int)pTamanhoLinha));
    }

    public static boolean mostrarConfirma(String pChaveMsg, String[] pArgsMsg) {
        return GuiUtil.mostrarConfirma(GuiUtil.getParent(), MensagemUtil.getMensagemComQuebraDeLinha((String)pChaveMsg, (String[])pArgsMsg));
    }

    public static boolean mostrarConfirmaNaoPadrao(Component pPai, String pMensagem) {
        return NegativeDefaultButtonJOptionPane.showConfirmDialog(pPai, pMensagem, GuiUtil.getTituloTelaConfirmacao(), 0) == 0;
    }

    public static boolean mostrarConfirmaNaoPadrao(String pChaveMsg) {
        return GuiUtil.mostrarConfirmaNaoPadrao(GuiUtil.getParent(), MensagemUtil.getMensagemComQuebraDeLinha((String)pChaveMsg));
    }

    public static boolean mostrarConfirmaNaoPadrao(String pChaveMsg, String[] pArgsMsg) {
        return GuiUtil.mostrarConfirmaNaoPadrao(GuiUtil.getParent(), MensagemUtil.getMensagemComQuebraDeLinha((String)pChaveMsg, (String[])pArgsMsg));
    }

    public static void exibeDialog(Object pPai, JComponent pComp, boolean pModal, String pTitulo, boolean pRedimensionavel, Integer pLargura, Integer pAltura) {
        GuiUtil.exibeDialog(pPai, pComp, pModal, pTitulo, pRedimensionavel, pLargura, pAltura, false);
    }

    public static void exibeDialog(Object pPai, JComponent pComp, boolean pModal, String pTitulo, boolean pRedimensionavel, Integer pLargura, Integer pAltura, boolean pInibeSairNaoProgramado) {
        GuiUtil.exibeDialog(pPai, pComp, pModal, pTitulo, pRedimensionavel, pLargura, pAltura, pInibeSairNaoProgramado, 2, true, false);
    }

    public static void exibeDialog(Object pPai, JComponent pComp, boolean pModal, String pTitulo, boolean pRedimensionavel, Integer pLargura, Integer pAltura, boolean pInibeSairNaoProgramado, int defaultCloseOperation, boolean exibeBarraTitulo, boolean disabledGlass) {
        GuiUtil.exibeDialog(pPai, pComp, pModal, pTitulo, pRedimensionavel, pLargura, pAltura, pInibeSairNaoProgramado, defaultCloseOperation, exibeBarraTitulo, disabledGlass, false);
    }

    public static void exibeDialog(Object pPai, JComponent pComp, boolean pModal, String pTitulo, boolean pRedimensionavel, Integer pLargura, Integer pAltura, boolean pInibeSairNaoProgramado, int defaultCloseOperation, boolean exibeBarraTitulo, boolean disabledGlass, boolean isReadOnly) {
        JComponent lComponent;
        if (ControladorGui.isReadOnly() && isReadOnly) {
            ControladorGui.desabilitarTela(pComp);
        }
        GuiUtil.adicionarEnterComoTeclaDeNavegacao((JPanel)pComp);
        JCustomDialog lDialogo = null;
        if (pPai == null) {
            lDialogo = new JCustomDialog((Frame)null, pTitulo, pModal, pInibeSairNaoProgramado);
        } else if (pPai instanceof Dialog) {
            lDialogo = new JCustomDialog((Dialog)pPai, pTitulo, pModal, pInibeSairNaoProgramado);
            lDialogo.setLocationRelativeTo((Dialog)pPai);
        } else {
            lDialogo = pPai instanceof Frame ? new JCustomDialog((Frame)pPai, pTitulo, pModal, pInibeSairNaoProgramado) : new JCustomDialog((Frame)null, pTitulo, pModal, pInibeSairNaoProgramado);
        }
        lDialogo.getContentPane().add(pComp);
        lDialogo.setUndecorated(!exibeBarraTitulo);
        lDialogo.setDefaultCloseOperation(defaultCloseOperation);
        if (pComp instanceof WindowListener) {
            lDialogo.addWindowListener((WindowListener)((Object)pComp));
        }
        if (pComp instanceof PainelDemonstrativoIf) {
            ((PainelDemonstrativoIf)((Object)pComp)).initListener();
        }
        if (pLargura != null && pAltura != null) {
            lDialogo.setSize(pLargura, pAltura);
        } else {
            lDialogo.pack();
        }
        lDialogo.setLocationRelativeTo(null);
        lDialogo.setResizable(pRedimensionavel);
        if (pComp instanceof PainelDemonstrativoAb && (lComponent = ((PainelDemonstrativoAb)pComp).getDefaultFocus()) != null && IRPFUtil.getEstadoSistema() != 1) {
            lComponent.requestFocusInWindow();
        }
        if (disabledGlass) {
            Component glassPaneAnterior = PlataformaPPGD.getPlataforma().getJanelaPrincipal().getGlassPane();
            DisabledGlassPane glassPane = new DisabledGlassPane();
            PlataformaPPGD.getPlataforma().getJanelaPrincipal().setGlassPane(glassPane);
            PlataformaPPGD.getPlataforma().getJanelaPrincipal().getGlassPane();
            glassPane.activate("");
            lDialogo.setVisible(true);
            glassPane.deactivate();
            PlataformaPPGD.getPlataforma().getJanelaPrincipal().setGlassPane(glassPaneAnterior);
        } else {
            lDialogo.setVisible(true);
        }
        PlataformaPPGD.getPlataforma().getJanelaPrincipal().repaint();
        PlataformaPPGD.getPlataforma().getJanelaPrincipal().validate();
    }

    public static void exibePainelDemonstrativo(Object pPai, JComponent pComp, boolean pModal, String pTitulo, boolean pRedimensionavel, Integer pLargura, Integer pAltura) {
        GuiUtil.exibeDialog(pPai, pComp, pModal, pTitulo, pRedimensionavel, pLargura, pAltura);
    }

    public static void exibeDialog(JComponent pComp, boolean pModal, String pTitulo, boolean pRedimensionavel) {
        GuiUtil.exibeDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), pComp, pModal, pTitulo, pRedimensionavel, null, null);
    }

    public static void exibeDialog(JComponent pComp, boolean pModal, String pTitulo, boolean pRedimensionavel, boolean isReadOnly) {
        GuiUtil.exibeDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), pComp, pModal, pTitulo, pRedimensionavel, null, null, false, 2, true, false, isReadOnly);
    }

    public static void exibePainelDemonstrativo(JComponent pComp, boolean pModal, String pTitulo, boolean pRedimensionavel) {
        GuiUtil.exibePainelDemonstrativo(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), pComp, pModal, pTitulo, pRedimensionavel, null, null);
    }

    public static void exibeDialog(JComponent pComp, boolean pModal, String pTitulo, boolean pRedimensionavel, int pLargura, int pAltura) {
        GuiUtil.exibeDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), pComp, pModal, pTitulo, pRedimensionavel, pLargura, pAltura);
    }

    public static void exibePainelDemonstrativo(JComponent pComp, boolean pModal, String pTitulo, boolean pRedimensionavel, int pLargura, int pAltura) {
        GuiUtil.exibePainelDemonstrativo(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), pComp, pModal, pTitulo, pRedimensionavel, pLargura, pAltura);
    }

    public static ImageIcon getImage(String pPath) {
        ImageIcon lImg = null;
        if (lImg == null) {
            lImg = new ImageIcon(GuiUtil.class.getResource(pPath));
        }
        return lImg;
    }

    public static void abreURL(String pURL) {
        String os = System.getProperty("os.name").toLowerCase();
        try {
            if (os.startsWith("mac os")) {
                Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                openURL.invoke(null, pURL);
            } else if (os.startsWith("windows")) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + pURL);
            } else {
                String[] browsers = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
                String browser = null;
                for (int count = 0; count < browsers.length && browser == null; ++count) {
                    if (Runtime.getRuntime().exec(new String[]{"which", browsers[count]}).waitFor() != 0) continue;
                    browser = browsers[count];
                }
                if (browser == null) {
                    String lMensagem = MensagemUtil.getMensagem((String)"NavegadorNaoEncontrado");
                    throw new Exception(lMensagem);
                }
                Runtime.getRuntime().exec(new String[]{browser, pURL});
            }
        }
        catch (Exception e) {
            GuiUtil.mostrarErro("ErroNavegadorInternet", new String[]{e.getLocalizedMessage()});
        }
    }

    public static void fecharDialog(JPanel pPainel) {
        Component lFramePai = SwingUtilities.getRoot(pPainel);
        if (lFramePai != null) {
            if (lFramePai instanceof JCustomDialog) {
                ((JCustomDialog)lFramePai).dispose();
            } else {
                lFramePai.setVisible(false);
            }
        }
    }

    public static void adicionarEnterComoTeclaDeNavegacao(JPanel pPainel) {
        Set<AWTKeyStroke> forwardKeys = pPainel.getFocusTraversalKeys(0);
        HashSet<AWTKeyStroke> newForwardKeys = new HashSet<AWTKeyStroke>(forwardKeys);
        newForwardKeys.add(KeyStroke.getKeyStroke(10, 0));
        pPainel.setFocusTraversalKeys(0, newForwardKeys);
        GuiUtil.manterTabComoTeclaDeNavegacao(pPainel);
    }

    public static void manterTabComoTeclaDeNavegacao(Container pPainel) {
        for (Component component : pPainel.getComponents()) {
            if (component instanceof JButton) {
                JButton btn = (JButton)component;
                HashSet<KeyStroke> set = new HashSet<KeyStroke>();
                set.add(KeyStroke.getKeyStroke(9, 0));
                btn.setFocusTraversalKeys(0, set);
                continue;
            }
            if (!(component instanceof Container)) continue;
            GuiUtil.manterTabComoTeclaDeNavegacao((Container)component);
        }
    }

    public static void setaFonteTodosLabelContainer(Container c, Font pFonte) {
        Component[] components = c.getComponents();
        for (int i = 0; i < components.length; ++i) {
            Font fonte = pFonte;
            if (components[i] instanceof JComponent && ((JComponent)components[i]).getBorder() instanceof TitledBorder) {
                TitledBorder t = (TitledBorder)((JComponent)components[i]).getBorder();
                t.setTitleFont(fonte);
            }
            if (components[i] instanceof JEditLogico || components[i] instanceof JLabel || components[i] instanceof JEditOpcao) {
                components[i].setFont(fonte);
                continue;
            }
            if (!(components[i] instanceof Container)) continue;
            GuiUtil.setaFonteTodosLabelContainer((Container)components[i], fonte);
        }
    }

    public static void listaFontesDisponiveis() {
        String[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        for (int i = 0; i < fonts.length; ++i) {
            System.out.println(fonts[i]);
        }
    }

    public static void ajustaLabel(JLabel pCampo, int pMaximo) {
        String text = pCampo.getText();
        if (text.length() > pMaximo) {
            pCampo.setToolTipText(text);
            pCampo.setText(text.substring(0, pMaximo) + "...");
        }
    }

    public static void startWaitCursor() {
        PlataformaPPGD.getPlataforma().getJanelaPrincipal().setCursor(Cursor.getPredefinedCursor(3));
    }

    public static void stopWaitCursor() {
        PlataformaPPGD.getPlataforma().getJanelaPrincipal().setCursor(Cursor.getPredefinedCursor(0));
    }

    public static float getProporcaoTela16por9() {
        return 1.7777778f;
    }

    public static float getProporcaoTelaAtual() {
        GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        float width = 16.0f;
        float height = 10.0f;
        if (gd.getDisplayMode() != null) {
            width = gd.getDisplayMode().getWidth();
            height = gd.getDisplayMode().getHeight();
        }
        return width / height;
    }

    public static JFrame getJanelaPrincipal() {
        return PlataformaPPGD.getPlataforma().getJanelaPrincipal();
    }

    public static <T> T executarTarefa(String titulo, int esperaEmSegundos, final Callable<T> tarefa, boolean usarTitulo) throws CancellationException, Exception {
        Object retorno;
        SwingWorker sw = new SwingWorker<T, Integer>(){

            @Override
            protected T doInBackground() throws Exception {
                return tarefa.call();
            }
        };
        PainelEspera painelEspera = null;
        painelEspera = usarTitulo ? new PainelEspera(sw, esperaEmSegundos, titulo) : new PainelEspera(sw, esperaEmSegundos);
        GuiUtil.exibeDialog(GuiUtil.getJanelaPrincipal(), painelEspera, true, titulo, false, null, null, false, 0, false, false);
        try {
            retorno = sw.get();
        }
        catch (ExecutionException e) {
            LogPPGD.erro((String)(MensagemUtil.getMensagem((String)ConstantesMensagens.ConstantesEnum.MSG_TAREFA_RETORNOU_ERRO.getChave()) + " " + e));
            throw (Exception)e.getCause();
        }
        catch (InterruptedException | CancellationException e) {
            LogPPGD.erro((String)(MensagemUtil.getMensagem((String)ConstantesMensagens.ConstantesEnum.MSG_TAREFA_RETORNOU_ERRO.getChave()) + " " + e));
            throw e;
        }
        return retorno;
    }

    public static <T> T executarTarefa(String titulo, int esperaEmSegundos, Callable<T> tarefa) throws CancellationException, Exception {
        return GuiUtil.executarTarefa(titulo, esperaEmSegundos, tarefa, false);
    }

    public static void testeExecutarTarefa() {
        try {
            String resultado = GuiUtil.executarTarefa("Tarefa de Testes para saber o Tamanho", 30, () -> {
                System.out.println("Tarefa executando em " + Thread.currentThread());
                for (int i = 0; i < 20; ++i) {
                    System.out.println("Count " + i);
                    Thread.sleep(1000L);
                }
                throw new AplicacaoException("Erro de Testes", false);
            });
            System.out.println("Resultado: " + resultado);
            GuiUtil.mostrarInfo((Component)GuiUtil.getJanelaPrincipal(), "Tarefa finalizada");
        }
        catch (CancellationException e) {
            LogPPGD.erro((String)(MensagemUtil.getMensagem((String)ConstantesMensagens.ConstantesEnum.MSG_TAREFA_RETORNOU_ERRO.getChave()) + " " + e));
            e.printStackTrace();
            GuiUtil.mostrarErro(GuiUtil.getJanelaPrincipal(), "Operacao Cancelada");
        }
        catch (AplicacaoException e) {
            LogPPGD.erro((String)(MensagemUtil.getMensagem((String)ConstantesMensagens.ConstantesEnum.MSG_TAREFA_RETORNOU_ERRO.getChave()) + " " + e));
            e.printStackTrace();
            GuiUtil.mostrarErro(GuiUtil.getJanelaPrincipal(), e.getMessage());
        }
        catch (Exception e) {
            LogPPGD.erro((String)(MensagemUtil.getMensagem((String)ConstantesMensagens.ConstantesEnum.MSG_TAREFA_RETORNOU_ERRO.getChave()) + " " + e));
            e.printStackTrace();
            GuiUtil.mostrarErro(GuiUtil.getJanelaPrincipal(), "Ocorreu um erro");
        }
    }

    private static class PainelEspera<T>
    extends JPanel
    implements WindowListener {
        private transient SwingWorker<T, Integer> sw;
        private int esperaEmSegundos;

        public PainelEspera(SwingWorker<T, Integer> sw, int esperaEmSegundos, String titulo) {
            JProgressBar progressBar = new JProgressBar();
            progressBar.setIndeterminate(true);
            this.setLayout(new BoxLayout(this, 1));
            this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.add(progressBar);
            this.add(new JLabel(titulo));
            this.esperaEmSegundos = esperaEmSegundos;
            this.sw = sw;
        }

        public PainelEspera(SwingWorker<T, Integer> sw, int esperaEmSegundos) {
            this(sw, esperaEmSegundos, "Aguarde...");
        }

        @Override
        public void windowOpened(WindowEvent e) {
            Thread appThread = new Thread(){

                @Override
                public void run() {
                    block2: {
                        try {
                            sw.execute();
                            sw.get(esperaEmSegundos, TimeUnit.SECONDS);
                        }
                        catch (InterruptedException | CancellationException | ExecutionException | TimeoutException e) {
                            LogPPGD.erro((String)(MensagemUtil.getMensagem((String)ConstantesMensagens.ConstantesEnum.MSG_TAREFA_RETORNOU_ERRO.getChave()) + " " + e));
                            sw.cancel(true);
                            if (!(e instanceof InterruptedException)) break block2;
                            this.interrupt();
                        }
                    }
                    GuiUtil.fecharDialog(this);
                }
            };
            appThread.start();
        }

        @Override
        public void windowClosing(WindowEvent e) {
        }

        @Override
        public void windowClosed(WindowEvent e) {
        }

        @Override
        public void windowIconified(WindowEvent e) {
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
        }

        @Override
        public void windowActivated(WindowEvent e) {
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
        }
    }
}

