/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.table.TableRowSorter;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperPrintManager;
import net.sf.jasperreports.engine.data.JRMapArrayDataSource;
import org.jdesktop.layout.GroupLayout;
import serpro.ppgd.formatosexternos.PPGDJasperViewer;
import serpro.ppgd.infraestrutura.util.FontesUtil;
import serpro.ppgd.irpf.ColecaoIdDeclaracao;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.TableSelecionaDeclaracao;
import serpro.ppgd.irpf.txt.util.IRPFTxtUtil;
import serpro.ppgd.irpf.util.IRPFUtil;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.util.LogPPGD;
import serpro.ppgd.negocio.util.UtilitariosArquivo;

public class PainelImprimirRelacaoDeclaracoes
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final int INDICE_COLUNA_TIPO = 1;
    private static final int INDICE_COLUNA_AJUSTE_ESPOLIO_SAIDA = 2;
    private static final int INDICE_COLUNA_CPF = 3;
    private static final int INDICE_COLUNA_NOME = 4;
    private boolean cancelou = false;
    private JButton btnCancelar;
    private JButton btnOk;
    private ButtonGroup buttonGroup1;
    private TableSelecionaDeclaracao edtTableDecs;
    private JLabel jLabel10;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JRadioButton rbImprimir;
    private JRadioButton rbVisualizar;

    public PainelImprimirRelacaoDeclaracoes() {
        this.initComponents();
        this.jScrollPane1.getViewport().setBackground(Color.WHITE);
    }

    public PainelImprimirRelacaoDeclaracoes(boolean salvarImagem) {
        this();
        if (salvarImagem) {
            this.rbImprimir.setVisible(false);
            this.rbVisualizar.setSelected(true);
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel2 = new JPanel();
        this.btnOk = new JButton();
        this.btnCancelar = new JButton();
        this.rbVisualizar = new JRadioButton();
        this.jLabel10 = new JLabel();
        this.rbImprimir = new JRadioButton();
        this.jPanel3 = new JPanel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.edtTableDecs = new TableSelecionaDeclaracao();
        this.setBackground(new Color(241, 245, 249));
        this.setForeground(new Color(255, 255, 255));
        this.jPanel2.setBackground(new Color(241, 245, 249));
        this.jPanel2.setForeground(new Color(255, 255, 255));
        this.btnOk.setMnemonic('O');
        this.btnOk.setText("Ok");
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelImprimirRelacaoDeclaracoes.this.btnOkActionPerformed(evt);
            }
        });
        this.btnCancelar.setMnemonic('C');
        this.btnCancelar.setText("Cancelar");
        this.btnCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelImprimirRelacaoDeclaracoes.this.btnCancelarActionPerformed(evt);
            }
        });
        this.rbVisualizar.setBackground(new Color(241, 245, 249));
        this.buttonGroup1.add(this.rbVisualizar);
        this.rbVisualizar.setFont(FontesUtil.FONTE_NORMAL);
        this.rbVisualizar.setSelected(true);
        this.rbVisualizar.setText("Visualizar");
        this.jLabel10.setFont(FontesUtil.FONTE_NORMAL);
        this.jLabel10.setForeground(new Color(0, 74, 106));
        this.jLabel10.setText("Selecione a op\u00e7\u00e3o desejada:");
        this.rbImprimir.setBackground(new Color(241, 245, 249));
        this.buttonGroup1.add(this.rbImprimir);
        this.rbImprimir.setFont(FontesUtil.FONTE_NORMAL);
        this.rbImprimir.setText("Imprimir");
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jLabel10, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.rbVisualizar).add((Component)this.rbImprimir).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1, false).add((Component)this.btnCancelar, -1, -1, Short.MAX_VALUE).add((Component)this.btnOk, -2, 94, -2)))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.linkSize(new Component[]{this.btnCancelar, this.btnOk}, 1);
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.jLabel10, -2, 28, -2).add(18, 18, 18).add((Component)this.rbVisualizar).addPreferredGap(0).add((Component)this.rbImprimir).addPreferredGap(0, 115, Short.MAX_VALUE).add((Component)this.btnOk).addPreferredGap(0).add((Component)this.btnCancelar).add(47, 47, 47)));
        jPanel2Layout.linkSize(new Component[]{this.btnCancelar, this.btnOk}, 2);
        this.btnOk.getAccessibleContext().setAccessibleName("OK");
        this.jPanel3.setBackground(new Color(255, 255, 255));
        this.jPanel3.setBorder(BorderFactory.createLineBorder(new Color(211, 222, 232)));
        this.jLabel3.setFont(FontesUtil.FONTE_NORMAL);
        this.jLabel3.setIcon(new ImageIcon(this.getClass().getResource("/icones/png16px/AB_transmitido.png")));
        this.jLabel3.setText("Transmitida");
        this.jLabel4.setFont(FontesUtil.FONTE_NORMAL);
        this.jLabel4.setIcon(new ImageIcon(this.getClass().getResource("/icones/png16px/AB_completa.png")));
        this.jLabel4.setText("Completa");
        this.jLabel5.setFont(FontesUtil.FONTE_NORMAL);
        this.jLabel5.setIcon(new ImageIcon(this.getClass().getResource("/icones/png16px/AB_simplif.png")));
        this.jLabel5.setText("Simplificada");
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel3, -2, 105, -2).addPreferredGap(0).add((Component)this.jLabel4, -2, 91, -2).addPreferredGap(0).add((Component)this.jLabel5).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(3).add((Component)this.jLabel3, -2, 28, -2).add((Component)this.jLabel5).add((Component)this.jLabel4)));
        jPanel3Layout.linkSize(new Component[]{this.jLabel3, this.jLabel4, this.jLabel5}, 2);
        this.jLabel3.getAccessibleContext().setAccessibleName("");
        this.jLabel3.getAccessibleContext().setAccessibleDescription("");
        this.jLabel4.getAccessibleContext().setAccessibleName("");
        this.jLabel4.getAccessibleContext().setAccessibleDescription("");
        this.jLabel5.getAccessibleContext().setAccessibleName("");
        this.jLabel5.getAccessibleContext().setAccessibleDescription("");
        this.jScrollPane1.setViewportView(this.edtTableDecs);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel3, -1, -1, Short.MAX_VALUE).add((Component)this.jScrollPane1, -1, 631, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.jPanel2, -2, -1, -2).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1, false).add((Component)this.jScrollPane1, 0, 0, Short.MAX_VALUE).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.jPanel3, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void btnCancelarActionPerformed(ActionEvent evt) {
        this.cancelou = true;
        ((JDialog)SwingUtilities.getRoot(this)).setVisible(false);
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        ((JDialog)SwingUtilities.getRoot(this)).setVisible(false);
        ArrayList parametros = new ArrayList();
        ColecaoIdDeclaracao colIdDeclaracoes = IRPFFacade.getListaIdDeclaracoes();
        for (ObjetoNegocio objNegocio : colIdDeclaracoes.itens()) {
            String pathTransmitidas;
            String numRecibo;
            IdentificadorDeclaracao idDeclaracao = (IdentificadorDeclaracao)objNegocio;
            String resultadoDeclaracao = idDeclaracao.getResultadoDeclaracao().formatado();
            if (resultadoDeclaracao.isEmpty()) {
                DeclaracaoIRPF declaracao = IRPFFacade.getInstancia().recuperarDeclaracaoIRPF(idDeclaracao.getCpf().naoFormatado(), idDeclaracao.getNumReciboTransmitido().naoFormatado());
                Valor impostoRestituir = declaracao.getResumo().getCalculoImposto().getImpostoRestituir();
                Valor impostoPagar = declaracao.getResumo().getCalculoImposto().getSaldoImpostoPagar();
                int resultCompare = impostoPagar.compareTo(impostoRestituir);
                resultadoDeclaracao = resultCompare == 0 ? "SSI" : (resultCompare < 0 ? "IAR" : "IAP");
                declaracao.getIdentificadorDeclaracao().getResultadoDeclaracao().setConteudo(resultadoDeclaracao);
                try {
                    ControladorGui.salvarDemonstrativo(declaracao);
                }
                catch (Exception e) {
                    LogPPGD.erro((String)e.getMessage());
                }
            }
            boolean foiTransmitida = (numRecibo = IRPFTxtUtil.declaracaoFoiTransmitida((IdentificadorDeclaracao)idDeclaracao, (String)(pathTransmitidas = UtilitariosArquivo.getPathGravadas()))) != null;
            HashMap<String, String> registro = new HashMap<String, String>();
            registro.put("tipodeclaracao", idDeclaracao.isCompleta() ? "0" : "1");
            registro.put("transmitida", foiTransmitida ? "1" : "0");
            if (foiTransmitida) {
                registro.put("numerorecibo", IRPFTxtUtil.formataNumeroRecibo((String)numRecibo));
            } else {
                registro.put("numerorecibo", "");
            }
            registro.put("cpf", idDeclaracao.getCpf().formatado());
            registro.put("nome", idDeclaracao.getNome().naoFormatado());
            registro.put("tipodeclaracaoAES", idDeclaracao.isAjuste() ? "A" : (idDeclaracao.isEspolio() ? "E" : (idDeclaracao.isSaida() ? "S" : "")));
            registro.put("declaracaoretificadora", idDeclaracao.getDeclaracaoRetificadora().naoFormatado());
            registro.put("resultado", resultadoDeclaracao);
            parametros.add(registro);
        }
        Collections.sort(parametros, new Comparator<Map<String, String>>(){

            @Override
            public int compare(Map<String, String> registro1, Map<String, String> registro2) {
                TableRowSorter ts = (TableRowSorter)PainelImprimirRelacaoDeclaracoes.this.edtTableDecs.getRowSorter();
                List<RowSorter.SortKey> sortKeys = ts.getSortKeys();
                for (RowSorter.SortKey sk : sortKeys) {
                    SortOrder ordem;
                    if (sk.getColumn() == 1 && (ordem = sk.getSortOrder()) != SortOrder.UNSORTED) {
                        return registro1.get("declaracaoretificadora").compareToIgnoreCase(registro2.get("declaracaoretificadora")) * IRPFUtil.converterSortOrderParaInteiro((SortOrder)ordem);
                    }
                    if (sk.getColumn() == 2 && (ordem = sk.getSortOrder()) != SortOrder.UNSORTED) {
                        return registro1.get("tipodeclaracaoAES").compareToIgnoreCase(registro2.get("tipodeclaracaoAES")) * IRPFUtil.converterSortOrderParaInteiro((SortOrder)ordem);
                    }
                    if (sk.getColumn() == 3 && (ordem = sk.getSortOrder()) != SortOrder.UNSORTED) {
                        return registro1.get("cpf").compareToIgnoreCase(registro2.get("cpf")) * IRPFUtil.converterSortOrderParaInteiro((SortOrder)ordem);
                    }
                    if (sk.getColumn() != 4 || (ordem = sk.getSortOrder()) == SortOrder.UNSORTED) continue;
                    return registro1.get("nome").compareToIgnoreCase(registro2.get("nome")) * IRPFUtil.converterSortOrderParaInteiro((SortOrder)ordem);
                }
                return 0;
            }
        });
        try {
            int tipoOperacao = this.getTipoOperacao();
            InputStream streamRel = Thread.currentThread().getContextClassLoader().getResourceAsStream("relDeclaracoes.jasper");
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("exercicio", ConstantesGlobais.EXERCICIO);
            JasperPrint print = JasperFillManager.fillReport((InputStream)streamRel, params, (JRDataSource)new JRMapArrayDataSource(parametros.toArray()));
            print.setName(IRPFUtil.obterNomeArquivoPDF(null, null, (String)"relacaodecl", null));
            if (tipoOperacao == 1) {
                PPGDJasperViewer viewer = new PPGDJasperViewer(print, false, new Locale("pt", "BR"));
                viewer.setTitle("Declara\u00e7\u00e3o");
                viewer.setIconImage(Frame.getFrames()[0].getIconImage());
                viewer.addWindowFocusListener(new WindowFocusListener(){
                    private boolean firstLost = true;

                    @Override
                    public void windowLostFocus(WindowEvent e) {
                        if (this.firstLost) {
                            e.getWindow().toFront();
                            this.firstLost = false;
                        }
                    }

                    @Override
                    public void windowGainedFocus(WindowEvent e) {
                    }
                });
                viewer.setVisible(true);
            } else if (tipoOperacao == 2) {
                byte[] bytes = JasperExportManager.exportReportToPdf((JasperPrint)print);
                IRPFUtil.exibirArquivoNavegador((byte[])bytes, (String)IRPFUtil.obterNomeArquivoPDF(null, null, (String)"relacaodecl", null));
            } else if (tipoOperacao == 3) {
                JasperPrintManager.printReport((JasperPrint)print, (boolean)false);
            }
        }
        catch (JRException e) {
            e.printStackTrace(System.err);
        }
    }

    public int getTipoOperacao() {
        if (this.rbVisualizar.isSelected()) {
            return 1;
        }
        if (this.rbImprimir.isSelected()) {
            return 3;
        }
        return 0;
    }

    public boolean isCancelou() {
        return this.cancelou;
    }
}

