/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.ref.WeakReference;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.filechooser.FileSystemView;
import serpro.ppgd.gui.xbeans.JEditCodigo;
import serpro.ppgd.gui.xbeans.JEditData;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.exception.AplicacaoException;
import serpro.ppgd.irpf.exception.BarramentoException;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.gui.util.PainelDownloads;
import serpro.ppgd.irpf.gui.util.PdfUtil;
import serpro.ppgd.irpf.nuvem.BarramentoIRPFService;
import serpro.ppgd.irpf.tabelas.TabelaAliquotasIRPF;
import serpro.ppgd.irpf.tabelas.TabelaDatasIRPF;
import serpro.ppgd.irpf.util.ConstantesGlobaisIRPF;
import serpro.ppgd.irpf.util.IRPFUtil;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.util.PreenchedorCodigo;

public class PainelImprimirDARFEscolherCota
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String HELP_ID = "Como fazer para.../Imprimir Darf do IRPF";
    private WeakReference<DeclaracaoIRPF> declaracaoRef = null;
    private final int operacao;
    private Codigo listaOpcoesCota;
    private Data dataArrecadacao = new Data();
    private Path tempDir = null;
    private boolean declaracaoTransmitida = false;
    private int qtdCotas;
    private boolean primeiraCota;
    private boolean debitoAutomatico;
    private String dataVencimentoDFE;
    private JButton btnAjuda;
    private JButton btnCancelar;
    private JButton btnOk;
    private JEditData edtDtArrecadacao;
    private JEditCodigo edtNumQuotas;
    private Box.Filler filler1;
    private Box.Filler filler2;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JLabel lblDtArrecadacao;

    public PainelImprimirDARFEscolherCota(DeclaracaoIRPF dec, int tipoOperacao, Path tempDir) throws AplicacaoException {
        this(dec, tipoOperacao, "");
        this.tempDir = tempDir;
        this.declaracaoTransmitida = true;
    }

    public PainelImprimirDARFEscolherCota(DeclaracaoIRPF dec, int tipoOperacao, String dataVencimentoDFE) throws AplicacaoException {
        this.initComponents();
        this.dataVencimentoDFE = dataVencimentoDFE;
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)this, HELP_ID);
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)this.btnAjuda, HELP_ID);
        this.declaracaoRef = new WeakReference<DeclaracaoIRPF>(dec);
        this.operacao = tipoOperacao;
        DeclaracaoIRPF declaracaoIRPF = (DeclaracaoIRPF)this.declaracaoRef.get();
        int qtdeQuota = declaracaoIRPF.getResumo().getCalculoImposto().getNumQuotas().getConteudoInteiro();
        int qtdMaxQuotas = Integer.parseInt(TabelaAliquotasIRPF.ConstantesAliquotas.qtdMaxQuota.getValor().naoFormatado());
        if (qtdeQuota > qtdMaxQuotas) {
            qtdeQuota = qtdMaxQuotas;
        }
        this.qtdCotas = qtdeQuota;
        this.debitoAutomatico = declaracaoIRPF.getResumo().getCalculoImposto().getDebitoAutomatico().naoFormatado().equals("autorizado");
        this.primeiraCota = declaracaoIRPF.getResumo().getCalculoImposto().getIndicadorPrimeiraQuota().naoFormatado().equals("1");
        this.listaOpcoesCota = new Codigo();
        PreenchedorCodigo preenche = new PreenchedorCodigo(this.listaOpcoesCota);
        StringBuilder sbDescricao = null;
        String[] vencimentosQuotas = TabelaDatasIRPF.obterVencimentosQuotasComBarra((boolean)declaracaoIRPF.getEmCalamidade());
        if (!dataVencimentoDFE.isEmpty()) {
            vencimentosQuotas[0] = dataVencimentoDFE;
        }
        for (int i = 0; i < qtdeQuota; ++i) {
            int mes = i;
            int quota = i + 1;
            sbDescricao = new StringBuilder();
            sbDescricao.append("   0");
            sbDescricao.append(quota);
            sbDescricao.append("  -  Vencimento: ");
            StringBuilder sbDataVencimento = new StringBuilder(vencimentosQuotas[mes]);
            sbDescricao.append((CharSequence)sbDataVencimento);
            preenche.add(String.valueOf(i)).add(sbDescricao.toString()).add(sbDataVencimento.toString()).EOL();
        }
        preenche.aplicaAlteracoes();
        this.listaOpcoesCota.setConteudo(0);
        this.edtNumQuotas.setInformacao((Informacao)this.listaOpcoesCota);
        if (ConstantesGlobaisIRPF.VERSAO_TESTES) {
            this.dataArrecadacao.setConteudo(new Date());
            this.edtDtArrecadacao.setInformacao((Informacao)this.dataArrecadacao);
            this.edtDtArrecadacao.setaVisivel(true);
        } else {
            this.edtDtArrecadacao.setaVisivel(false);
        }
        this.lblDtArrecadacao.setText(this.obterTextoInformativo(declaracaoIRPF));
    }

    public String obterTextoInformativo(DeclaracaoIRPF dec) throws AplicacaoException {
        StringBuilder texto = new StringBuilder("<html>");
        int qtdMaxQuotas = Integer.parseInt(TabelaAliquotasIRPF.ConstantesAliquotas.qtdMaxQuota.getValor().naoFormatado());
        if (qtdMaxQuotas != 8) {
            texto.append("A quantidade m\u00e1xima de quotas para o parcelamento do imposto a pagar<br>foi alterada de 8 para <font color=#FF0000><b>").append(qtdMaxQuotas).append(" quotas</b></font>. Observe as novas datas de vencimento.<br><br>").append("Caso tenha selecionado originalmente mais de ").append(qtdMaxQuotas).append(" quotas e j\u00e1 tenha feito<br>o pagamento de alguma quota, os novos Darfs devem ser emitidos<br>exclusivamente por meio do Portal e-CAC.<br><br>").append("Para isso, acesse o Portal e-CAC no site da RFB<br>https://www.gov.br/receitafederal/, clique em \"Declara\u00e7\u00f5es e Demonstrativos\" e<br>selecione o servi\u00e7o \"Meu Imposto de Renda (Extrato da Dirpf)\". Na lista de<br>servi\u00e7os clique em Pagamento - Consultar D\u00e9bitos, Emitir Darf e Alterar Quotas.");
        }
        if (ControladorGui.emFaseEntrega(dec.getEmCalamidade())) {
            String dataVencimento = TabelaDatasIRPF.obterVencimentosQuotasComBarra((boolean)dec.getEmCalamidade())[0];
            if (dec.getIdentificadorDeclaracao().isEspolio()) {
                dataVencimento = this.listaOpcoesCota.getConteudoAtual(2);
            }
            texto.append("<br/><br/><font color=#FF0000><b>Darf v\u00e1lido para pagamento at\u00e9 ").append(dataVencimento).append("</b></font>");
        } else {
            texto.append("<br><br>Darf v\u00e1lido para pagamento at\u00e9 o \u00faltimo dia \u00fatil do m\u00eas atual.<br/>Darf em atraso at\u00e9 60 dias possuem como data de validade para pagamento o dia de impress\u00e3o.<br/><br/><font color=#FF0000><b>Verificar a DATA DE VALIDADE no campo OBSERVA\u00c7\u00c3O do Darf.</b></font>");
        }
        texto.append("</html>");
        return texto.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private byte[] obterPdfDarfQuota(Integer cotaSelecionada, Date dataArrecadacao, Date dataVencimentoQuota) throws BarramentoException, AplicacaoException {
        DeclaracaoIRPF declaracaoIRPF = (DeclaracaoIRPF)this.declaracaoRef.get();
        String cpf = declaracaoIRPF.getIdentificadorDeclaracao().getCpf().naoFormatado();
        int qtdMaxQuotas = Integer.parseInt(TabelaAliquotasIRPF.ConstantesAliquotas.qtdMaxQuota.getValor().naoFormatado());
        Valor valorPrincipal = declaracaoIRPF.getResumo().getCalculoImposto().getNumQuotas().asInteger() > qtdMaxQuotas ? declaracaoIRPF.getResumo().getCalculoImposto().getSaldoImpostoPagar().operacao('/', TabelaAliquotasIRPF.ConstantesAliquotas.qtdMaxQuota.getValor()) : declaracaoIRPF.getResumo().getCalculoImposto().getValorQuota();
        Data periodoApuracao = new Data();
        if (declaracaoIRPF.getIdentificadorDeclaracao().isEspolio()) {
            periodoApuracao = declaracaoIRPF.getEspolio().obterDataLimiteParaCalculos();
        } else if (declaracaoIRPF.getIdentificadorDeclaracao().isSaida()) {
            Date dtCondicaoNaoResidente = declaracaoIRPF.getSaida().getDtCondicaoNaoResidente().asDate();
            if (dtCondicaoNaoResidente == null) throw new AplicacaoException("darf_sem_info");
            Calendar c = Calendar.getInstance(new Locale("pt", "BR"));
            c.setTime(dtCondicaoNaoResidente);
            c.add(5, -1);
            Data diaAnterior = new Data();
            diaAnterior.setConteudo(c.getTime());
            periodoApuracao.setConteudo(diaAnterior);
        } else {
            periodoApuracao.setConteudo("31/12/" + ConstantesGlobais.ANO_BASE);
        }
        String nomeContribuinte = declaracaoIRPF.getIdentificadorDeclaracao().getNome().naoFormatado();
        String observacoes = "Caso seja feriado local, antecipe o pagamento||Imposto sobre a Renda da Pessoa F\u00edsica " + ConstantesGlobais.EXERCICIO;
        String descricaoPrincipal = "Imposto de Renda da Pessoa F\u00edsica";
        String textoAdicional1 = "";
        Object textoAdicional2 = "";
        if (declaracaoIRPF.getIdentificadorDeclaracao().isAjuste()) {
            textoAdicional1 = "Declara\u00e7\u00e3o de Ajuste Anual";
        } else if (declaracaoIRPF.getIdentificadorDeclaracao().isSaida()) {
            textoAdicional1 = "Declara\u00e7\u00e3o de Sa\u00edda Definitiva do Pa\u00eds";
        } else if (declaracaoIRPF.getIdentificadorDeclaracao().isEspolio()) {
            textoAdicional1 = "Declara\u00e7\u00e3o Final de Esp\u00f3lio";
        }
        textoAdicional2 = declaracaoIRPF.getResumo().getCalculoImposto().getNumQuotas().asInteger() <= 1 ? "Quota \u00fanica do IRPF " + ConstantesGlobais.EXERCICIO + "|" : this.nomeQuota(cotaSelecionada) + " quota do IRPF " + ConstantesGlobais.EXERCICIO + "|";
        String descricoesAdicionais = textoAdicional1 + "|" + (String)textoAdicional2;
        Data dataFinalEntrega = new Data();
        dataFinalEntrega.setConteudo(TabelaDatasIRPF.obterVencimentosQuotas((boolean)declaracaoIRPF.getEmCalamidade())[0]);
        return BarramentoIRPFService.obterPdfDarfQuota((String)cpf, (String)nomeContribuinte, (String)observacoes, (String)descricaoPrincipal, (String)descricoesAdicionais, (Date)periodoApuracao.asDate(), (Integer)cotaSelecionada, (Date)dataVencimentoQuota, (Date)dataArrecadacao, (Date)dataFinalEntrega.asDate(), (Double)Double.valueOf(valorPrincipal.getParteInteira() + "." + valorPrincipal.getParteDecimal()), (String)declaracaoIRPF.getContribuinte().getMunicipio().naoFormatado());
    }

    public String nomeQuota(Integer numero) {
        switch (numero) {
            case 1: {
                return "Primeira";
            }
            case 2: {
                return "Segunda";
            }
            case 3: {
                return "Terceira";
            }
            case 4: {
                return "Quarta";
            }
            case 5: {
                return "Quinta";
            }
            case 6: {
                return "Sexta";
            }
            case 7: {
                return "S\u00e9tima";
            }
            case 8: {
                return "Oitava";
            }
        }
        return numero + "\u00aa";
    }

    private void exibirPdfDarfQuota(final Integer quota) {
        final PainelDownloads painelDownlodas = new PainelDownloads("Darf de Quota", null);
        final SwingWorker<byte[], Integer> sw = new SwingWorker<byte[], Integer>(){

            @Override
            protected byte[] doInBackground() throws Exception {
                this.publish(new Integer[0]);
                return PainelImprimirDARFEscolherCota.this.obterPdfDarfQuota(quota + 1, PainelImprimirDARFEscolherCota.this.dataArrecadacao != null ? PainelImprimirDARFEscolherCota.this.dataArrecadacao.asDate() : null, new SimpleDateFormat("dd/MM/yyyy").parse(PainelImprimirDARFEscolherCota.this.listaOpcoesCota.getConteudoAtual(2)));
            }

            @Override
            protected void process(List<Integer> chunks) {
                painelDownlodas.getLblDescricao().setText("Obtendo Darf");
            }

            @Override
            protected void done() {
                if (this.isCancelled()) {
                    GuiUtil.mostrarAviso(GuiUtil.getParent(PainelImprimirDARFEscolherCota.this), "OperacaoCancelada pelo usu\u00e1rio");
                } else {
                    try {
                        GuiUtil.fecharDialog(painelDownlodas);
                        byte[] darf = (byte[])this.get();
                        DeclaracaoIRPF declaracaoIRPF = (DeclaracaoIRPF)PainelImprimirDARFEscolherCota.this.declaracaoRef.get();
                        String tipo = declaracaoIRPF.getContribuinte().getDeclaracaoRetificadora().formatado().equals("1") ? "retif" : "origi";
                        String nomeArq = IRPFUtil.obterNomeArquivoDarfPDF((String)declaracaoIRPF.getIdentificadorDeclaracao().getCpf().naoFormatado(), (String)tipo, (String)String.valueOf(quota + 1));
                        PdfUtil.exibirPdf(darf, "Darf - Quota", new File(FileSystemView.getFileSystemView().getDefaultDirectory(), nomeArq).getAbsolutePath());
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        Throwable cause = e.getCause();
                        if (cause != null && (cause instanceof AplicacaoException || cause instanceof BarramentoException)) {
                            GuiUtil.mostrarErro(GuiUtil.getParent(PainelImprimirDARFEscolherCota.this), cause.getMessage());
                        }
                        GuiUtil.mostrarErro(GuiUtil.getParent(PainelImprimirDARFEscolherCota.this), "Ocorreu um erro durante a gera\u00e7\u00e3o do Darf");
                    }
                }
            }
        };
        painelDownlodas.getBtnCancelar().setAction(new AbstractAction("Cancelar"){

            @Override
            public void actionPerformed(ActionEvent e) {
                sw.cancel(true);
                GuiUtil.fecharDialog(painelDownlodas);
            }
        });
        sw.execute();
        GuiUtil.exibeDialog(painelDownlodas, true, "Imprimir Darf", false);
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.jPanel2 = new JPanel();
        this.filler1 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.jPanel1 = new JPanel();
        this.btnOk = new JButton();
        this.btnCancelar = new JButton();
        this.btnAjuda = new JButton();
        this.filler2 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
        this.edtNumQuotas = new JEditCodigo();
        this.edtDtArrecadacao = new JEditData();
        this.lblDtArrecadacao = new JLabel();
        this.setBackground(new Color(241, 245, 249));
        this.jLabel2.setHorizontalAlignment(2);
        this.jLabel2.setText("<HTML>Selecione a quota:</HTML>");
        this.jLabel2.setToolTipText("");
        this.jLabel2.setMaximumSize(new Dimension(117, 15));
        this.jLabel2.setMinimumSize(new Dimension(117, 15));
        this.jLabel2.setPreferredSize(new Dimension(117, 21));
        this.jPanel2.setBackground(new Color(241, 245, 249));
        this.jPanel2.setOpaque(false);
        this.jPanel2.setLayout(new BoxLayout(this.jPanel2, 2));
        this.jPanel2.add(this.filler1);
        this.jPanel1.setOpaque(false);
        this.btnOk.setMnemonic('o');
        this.btnOk.setText("Ok");
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelImprimirDARFEscolherCota.this.btnOkActionPerformed(evt);
            }
        });
        this.btnCancelar.setMnemonic('c');
        this.btnCancelar.setText("Cancelar");
        this.btnCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelImprimirDARFEscolherCota.this.btnCancelarActionPerformed(evt);
            }
        });
        this.btnAjuda.setMnemonic('a');
        this.btnAjuda.setText("Ajuda");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.btnOk, -2, 82, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCancelar).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnAjuda).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnOk).addComponent(this.btnCancelar).addComponent(this.btnAjuda)).addContainerGap()));
        this.jPanel2.add(this.jPanel1);
        this.jPanel2.add(this.filler2);
        this.edtDtArrecadacao.setEstiloFonte(0);
        this.edtDtArrecadacao.setToolTipText("Informe a data de nascimento com dois d\u00edgitos para dia , m\u00eas e quatro para ano");
        this.lblDtArrecadacao.setText("<html>Darf v\u00e1lido para pagamento at\u00e9 o \u00faltimo dia \u00fatil do m\u00eas atual.<br/>Darf em atraso at\u00e9 60 dias possuem como data de validade para pagamento o dia de impress\u00e3o.<br/><br/><font color=#FF0000><b>Verificar a DATA DE VALIDADE no campo OBSERVA\u00c7\u00c3O do Darf.</b></font></html>");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(45, 45, 45).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.edtNumQuotas, -2, 250, -2).addComponent(this.jLabel2, -2, 131, -2).addComponent((Component)this.edtDtArrecadacao, -2, 158, -2).addComponent(this.lblDtArrecadacao, -2, -1, -2)).addContainerGap(45, Short.MAX_VALUE)).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(45, 45, 45).addComponent(this.jLabel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.edtNumQuotas, -2, -1, -2).addGap(18, 18, 18).addComponent(this.lblDtArrecadacao, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent((Component)this.edtDtArrecadacao, -2, -1, -2).addGap(18, 18, Short.MAX_VALUE).addComponent(this.jPanel2, -2, -1, -2).addContainerGap()));
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        String cotaSelecionada = this.listaOpcoesCota.getConteudoAtual(0);
        int cotaEscolhida = Integer.parseInt(cotaSelecionada);
        if (this.debitoAutomatico && (this.primeiraCota && cotaEscolhida == 0 || !this.primeiraCota && cotaEscolhida > 0 || this.qtdCotas > 1 && cotaEscolhida > 0)) {
            GuiUtil.mostrarInfo("aviso_darf_debito_automatico");
        }
        this.exibirPdfDarfQuota(Integer.valueOf(cotaSelecionada));
        if (this.declaracaoTransmitida) {
            IRPFUtil.finalizarPreencherObjetoDeclaracaoComTransmitida((DeclaracaoIRPF)((DeclaracaoIRPF)this.declaracaoRef.get()), (Path)this.tempDir);
        }
        ((JDialog)SwingUtilities.getRoot(this)).setVisible(false);
    }

    private void btnCancelarActionPerformed(ActionEvent evt) {
        if (this.declaracaoTransmitida) {
            IRPFUtil.finalizarPreencherObjetoDeclaracaoComTransmitida((DeclaracaoIRPF)((DeclaracaoIRPF)this.declaracaoRef.get()), (Path)this.tempDir);
        }
        ((JDialog)SwingUtilities.getRoot(this)).setVisible(false);
    }
}

