/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableRowSorter;
import org.jdesktop.layout.GroupLayout;
import serpro.ppgd.formatosexternos.txt.excecao.GeracaoTxtException;
import serpro.ppgd.gui.filechooser.FileChooser;
import serpro.ppgd.gui.filechooser.FileChooserFactory;
import serpro.ppgd.gui.filechooser.FileChooserResponse;
import serpro.ppgd.gui.filechooser.FileChooserSelectionMode;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.infraestrutura.util.FontesUtil;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.TableModelSelecionaDeclaracaoPreenchimento;
import serpro.ppgd.irpf.gui.dialogs.SubpainelDeclaracoesPreenchimento;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.txt.gravacaorestauracao.GravadorTXT;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.util.LogPPGD;

public class PainelGravarCopiaSegurancaPasso2
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String HELP_ID = "Como fazer para.../Gravar c\u00f3pia de seguran\u00e7a";
    private String mensagem;
    private IdentificadorDeclaracao idSelecionado = null;
    private JButton btnAjuda;
    private JButton btnAvancar;
    private JButton btnCancelar;
    private JLabel jLabel1;
    private JPanel jPanel2;
    private SubpainelDeclaracoesPreenchimento subpainelDeclaracoesPreenchimento;

    public PainelGravarCopiaSegurancaPasso2() {
        this.initComponents();
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)this, HELP_ID);
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)this.btnAjuda, HELP_ID);
        this.configurarPainelDeclaracoes();
    }

    private void configurarPainelDeclaracoes() {
        this.subpainelDeclaracoesPreenchimento.getTabela().addDeclaracaoSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (PainelGravarCopiaSegurancaPasso2.this.subpainelDeclaracoesPreenchimento.getTabela().getSelectedRowCount() > 0) {
                    PainelGravarCopiaSegurancaPasso2.this.btnAvancar.setEnabled(true);
                } else {
                    PainelGravarCopiaSegurancaPasso2.this.btnAvancar.setEnabled(false);
                }
            }
        });
        this.subpainelDeclaracoesPreenchimento.getTabela().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && PainelGravarCopiaSegurancaPasso2.this.subpainelDeclaracoesPreenchimento.getTabela().getSelectedRowCount() > 0) {
                    PainelGravarCopiaSegurancaPasso2.this.btnAvancarActionPerformed(null);
                }
            }
        });
    }

    public PainelGravarCopiaSegurancaPasso2(IdentificadorDeclaracao idSelecionado) {
        this();
        this.idSelecionado = idSelecionado;
        boolean selecionouDeclaracao = this.selecionarDeclaracao(idSelecionado);
        if (selecionouDeclaracao) {
            this.gravar();
            GuiUtil.fecharDialog(this);
        }
    }

    private boolean selecionarDeclaracao(IdentificadorDeclaracao idSelecionado) {
        boolean selecionouDeclaracao = false;
        TableModelSelecionaDeclaracaoPreenchimento tableModel = (TableModelSelecionaDeclaracaoPreenchimento)this.subpainelDeclaracoesPreenchimento.getTabela().getModel();
        int selIndice = -1;
        for (int i = 0; i < tableModel.getRowCount(); ++i) {
            IdentificadorDeclaracao idAtual = tableModel.getIdentificadorDeclaracao(i);
            if (!idAtual.getCpf().naoFormatado().equals(idSelecionado.getCpf().naoFormatado())) continue;
            selIndice = ((TableRowSorter)this.subpainelDeclaracoesPreenchimento.getTabela().getRowSorter()).convertRowIndexToView(i);
            break;
        }
        if (selIndice > -1) {
            this.subpainelDeclaracoesPreenchimento.getTabela().setRowSelectionInterval(selIndice, selIndice);
            selecionouDeclaracao = true;
        }
        return selecionouDeclaracao;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jPanel2 = new JPanel();
        this.btnCancelar = new JButton();
        this.btnAjuda = new JButton();
        this.btnAvancar = new JButton();
        this.subpainelDeclaracoesPreenchimento = new SubpainelDeclaracoesPreenchimento();
        this.setBackground(new Color(241, 245, 249));
        this.jLabel1.setFont(FontesUtil.FONTE_NORMAL);
        this.jLabel1.setForeground(new Color(0, 74, 106));
        this.jLabel1.setText("Selecione as declara\u00e7\u00f5es a serem copiadas e clique no bot\u00e3o Avan\u00e7ar");
        this.jPanel2.setBackground(new Color(241, 245, 249));
        this.btnCancelar.setMnemonic('C');
        this.btnCancelar.setText("Cancelar");
        this.btnCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelGravarCopiaSegurancaPasso2.this.btnCancelarActionPerformed(evt);
            }
        });
        this.btnAjuda.setMnemonic('A');
        this.btnAjuda.setText("Ajuda");
        this.btnAvancar.setMnemonic('v');
        this.btnAvancar.setText("Avan\u00e7ar");
        this.btnAvancar.setEnabled(false);
        this.btnAvancar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelGravarCopiaSegurancaPasso2.this.btnAvancarActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.btnAvancar, -1, 89, Short.MAX_VALUE).add((Component)this.btnCancelar, -1, 89, Short.MAX_VALUE).add((Component)this.btnAjuda, -1, 89, Short.MAX_VALUE)).addContainerGap()));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((Component)this.btnAvancar).addPreferredGap(0).add((Component)this.btnCancelar).addPreferredGap(0).add((Component)this.btnAjuda).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.linkSize(new Component[]{this.btnAjuda, this.btnAvancar, this.btnCancelar}, 2);
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.subpainelDeclaracoesPreenchimento, -1, 745, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jPanel2, -2, -1, -2))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE).add(133, 133, 133)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.subpainelDeclaracoesPreenchimento, -1, 310, Short.MAX_VALUE).addContainerGap()))));
        this.jLabel1.getAccessibleContext().setAccessibleName("Selecione as declara\u00e7\u00f5es a serem copiadas e clique no bot\u00e3o Avan\u00e7ar. Para colocar o foco na tabela de declara\u00e7\u00f5es, aperte a tecla TAB, e utilize as setas para cima e para baixo para navegar pelas declara\u00e7\u00f5es.");
    }

    private void btnAvancarActionPerformed(ActionEvent evt) {
        ((JDialog)SwingUtilities.getRoot(this)).setVisible(false);
        PlataformaPPGD.getPlataforma().getJanelaPrincipal().repaint();
        PlataformaPPGD.getPlataforma().getJanelaPrincipal().validate();
        this.gravar();
    }

    private void gravar() {
        FileChooser fc = FileChooserFactory.getInstance().createFileChooser();
        fc.setDialogTitle("Grava\u00e7\u00e3o de C\u00f3pia de Seguran\u00e7a");
        fc.setApproveButtonText("Salvar");
        fc.setApproveButtonToolTipText("Gravar C\u00f3pia de Seguran\u00e7a");
        fc.setMultiSelectionEnabled(false);
        fc.setAcceptAllFileFilterUsed(false);
        fc.setFileSelectionMode(FileChooserSelectionMode.DIRECTORIES_ONLY);
        FileChooserResponse retorno = fc.showSaveDialog((Component)PlataformaPPGD.getPlataforma().getJanelaPrincipal());
        PlataformaPPGD.getPlataforma().getJanelaPrincipal().repaint();
        PlataformaPPGD.getPlataforma().getJanelaPrincipal().validate();
        if (retorno == FileChooserResponse.APPROVE_OPTION) {
            ExecutarGravarIdDeclaracao executarGravarIdDeclaracao = new ExecutarGravarIdDeclaracao(fc.getSelectedFile());
            executarGravarIdDeclaracao.gravar();
        }
    }

    private void btnCancelarActionPerformed(ActionEvent evt) {
        ((JDialog)SwingUtilities.getRoot(this)).setVisible(false);
    }

    class ExecutarGravarIdDeclaracao {
        private File dir = null;

        public ExecutarGravarIdDeclaracao(File _dir) {
            this.dir = _dir;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void gravar() {
            ControladorGui.iniciarGravacaoDemonstrativo();
            String path = "";
            int[] linhasSelecionadas = PainelGravarCopiaSegurancaPasso2.this.subpainelDeclaracoesPreenchimento.getTabela().getSelectedRows();
            int[] rows = new int[linhasSelecionadas.length];
            for (int a = 0; a < rows.length; ++a) {
                rows[a] = ((TableRowSorter)PainelGravarCopiaSegurancaPasso2.this.subpainelDeclaracoesPreenchimento.getTabela().getRowSorter()).convertRowIndexToModel(linhasSelecionadas[a]);
            }
            TableModelSelecionaDeclaracaoPreenchimento tableModel = (TableModelSelecionaDeclaracaoPreenchimento)PainelGravarCopiaSegurancaPasso2.this.subpainelDeclaracoesPreenchimento.getTabela().getModel();
            try {
                if (rows.length > 0) {
                    path = this.dir.getPath();
                    boolean emiteMsgSucesso = false;
                    for (int i = 0; i < rows.length; ++i) {
                        IdentificadorDeclaracao idAtual = tableModel.getIdentificadorDeclaracao(rows[i]);
                        if (path.contentEquals("")) continue;
                        if (GravadorTXT.fileExists((IdentificadorDeclaracao)idAtual, (String)path, (byte)1)) {
                            String pathTratado = path;
                            if (pathTratado.charAt(pathTratado.length() - 1) == '\\') {
                                pathTratado = pathTratado.substring(0, pathTratado.length() - 1);
                            }
                            if (JOptionPane.showConfirmDialog(PainelGravarCopiaSegurancaPasso2.this.getParent(), MensagemUtil.getMensagem((String)"copia_seg_jah_existe", (String[])new String[]{idAtual.getCpf().formatado(), pathTratado}), "Confirma\u00e7\u00e3o", 0, 3) != 0) continue;
                        }
                        GravadorTXT.copiarDeclaracao((IdentificadorDeclaracao)idAtual, (String)path);
                        emiteMsgSucesso = true;
                    }
                    PainelGravarCopiaSegurancaPasso2.this.mensagem = emiteMsgSucesso ? "Grava\u00e7\u00e3o conclu\u00edda com sucesso." : "Grava\u00e7\u00e3o cancelada pelo usu\u00e1rio.";
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), PainelGravarCopiaSegurancaPasso2.this.mensagem, "Informa\u00e7\u00e3o", 1);
                        }
                    });
                }
            }
            catch (GeracaoTxtException ev) {
                LogPPGD.erro((String)ev.getMessage());
                JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), ev.getMessage(), "Erro", 0);
                return;
            }
            catch (FileNotFoundException ev) {
                LogPPGD.erro((String)ev.getMessage());
                JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), MensagemUtil.getMensagem((String)"gravar_pasta_sem_permissao"), "Erro", 0);
                return;
            }
            catch (IOException ev) {
                LogPPGD.erro((String)ev.getMessage());
                JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), MensagemUtil.getMensagem((String)"gravar_pasta_sem_permissao"), "Erro", 0);
                return;
            }
            catch (Exception ev) {
                ev.printStackTrace();
                LogPPGD.erro((String)ev.getMessage());
                JOptionPane.showMessageDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), MensagemUtil.getMensagem((String)"criarCopiaSegFalha"), "Erro", 0);
                return;
            }
            finally {
                ControladorGui.terminarGravacaoDemonstrativo();
            }
        }
    }
}

