/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableRowSorter;
import org.jdesktop.layout.GroupLayout;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.infraestrutura.util.FontesUtil;
import serpro.ppgd.irpf.IdentificadorDeclaracao;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.dialogs.SubpainelDeclaracoesPreenchimento;
import serpro.ppgd.irpf.gui.dialogs.SubpainelDeclaracoesTransmitidas;
import serpro.ppgd.irpf.util.MensagemUtil;

public class PainelExcluirDeclaracao
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String CEXCLUIR = "Como fazer para.../Excluir declara\u00e7\u00e3o";
    private SubpainelDeclaracoesPreenchimento subpainelDeclaracoesPreenchimento;
    private SubpainelDeclaracoesTransmitidas subpainelDeclaracoesTransmitidas;
    private JButton btnAjuda;
    private JButton btnCancelar;
    private JButton btnOk;
    private JButton btnTodos;
    private JLabel jLabel1;
    private JPanel jPanel2;
    private JTabbedPane tabPaneDeclaracoes;

    public PainelExcluirDeclaracao() {
        this.initComponents();
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)this, CEXCLUIR);
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)this.btnAjuda, CEXCLUIR);
        this.subpainelDeclaracoesPreenchimento = new SubpainelDeclaracoesPreenchimento();
        this.subpainelDeclaracoesTransmitidas = new SubpainelDeclaracoesTransmitidas();
        this.tabPaneDeclaracoes.addTab("Em Preenchimento", new ImageIcon(this.getClass().getResource("/icones/png16px/Icon_barraTitulo_16px.png")), this.subpainelDeclaracoesPreenchimento);
        this.tabPaneDeclaracoes.addTab("Transmitidas", new ImageIcon(this.getClass().getResource("/icones/png16px/AB_transmitido.png")), this.subpainelDeclaracoesTransmitidas);
        this.tabPaneDeclaracoes.setMnemonicAt(0, 69);
        this.tabPaneDeclaracoes.setMnemonicAt(1, 82);
        this.configurarBotaoOK();
        this.configurarPainelComAbas();
    }

    private void configurarPainelComAbas() {
        this.tabPaneDeclaracoes.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (PainelExcluirDeclaracao.this.tabPaneDeclaracoes.getSelectedIndex() == 0) {
                    PainelExcluirDeclaracao.this.subpainelDeclaracoesTransmitidas.getTabela().getSelectionModel().clearSelection();
                    if (PainelExcluirDeclaracao.this.subpainelDeclaracoesPreenchimento.getTabela().getSelectedRowCount() > 0) {
                        PainelExcluirDeclaracao.this.btnOk.setEnabled(true);
                    } else {
                        PainelExcluirDeclaracao.this.btnOk.setEnabled(false);
                    }
                } else {
                    PainelExcluirDeclaracao.this.subpainelDeclaracoesPreenchimento.getTabela().getSelectionModel().clearSelection();
                    if (PainelExcluirDeclaracao.this.subpainelDeclaracoesTransmitidas.getTabela().getSelectedRowCount() > 0) {
                        PainelExcluirDeclaracao.this.btnOk.setEnabled(true);
                    } else {
                        PainelExcluirDeclaracao.this.btnOk.setEnabled(false);
                    }
                }
            }
        });
    }

    private void configurarBotaoOK() {
        this.subpainelDeclaracoesPreenchimento.getTabela().addDeclaracaoSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (PainelExcluirDeclaracao.this.tabPaneDeclaracoes.getSelectedIndex() == 0 && PainelExcluirDeclaracao.this.subpainelDeclaracoesPreenchimento.getTabela().getSelectedRowCount() > 0) {
                    PainelExcluirDeclaracao.this.btnOk.setEnabled(true);
                } else {
                    PainelExcluirDeclaracao.this.btnOk.setEnabled(false);
                }
            }
        });
        this.subpainelDeclaracoesPreenchimento.getTabela().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && PainelExcluirDeclaracao.this.subpainelDeclaracoesPreenchimento.getTabela().getSelectedRowCount() > 0) {
                    PainelExcluirDeclaracao.this.btnOkActionPerformed(null);
                }
            }
        });
        this.subpainelDeclaracoesTransmitidas.getTabela().addDeclaracaoSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (PainelExcluirDeclaracao.this.tabPaneDeclaracoes.getSelectedIndex() == 1 && PainelExcluirDeclaracao.this.subpainelDeclaracoesTransmitidas.getTabela().getSelectedRowCount() > 0) {
                    PainelExcluirDeclaracao.this.btnOk.setEnabled(true);
                } else {
                    PainelExcluirDeclaracao.this.btnOk.setEnabled(false);
                }
            }
        });
        this.subpainelDeclaracoesTransmitidas.getTabela().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && PainelExcluirDeclaracao.this.subpainelDeclaracoesTransmitidas.getTabela().getSelectedRowCount() > 0) {
                    PainelExcluirDeclaracao.this.btnOkActionPerformed(null);
                }
            }
        });
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jPanel2 = new JPanel();
        this.btnOk = new JButton();
        this.btnCancelar = new JButton();
        this.btnAjuda = new JButton();
        this.btnTodos = new JButton();
        this.tabPaneDeclaracoes = new JTabbedPane();
        this.setBackground(new Color(241, 245, 249));
        this.setForeground(new Color(255, 255, 255));
        this.jLabel1.setFont(FontesUtil.FONTE_NORMAL);
        this.jLabel1.setForeground(new Color(0, 74, 106));
        this.jLabel1.setText("Selecione a(s) declara\u00e7\u00e3o(\u00f5es) que deseja excluir:");
        this.jPanel2.setBackground(new Color(241, 245, 249));
        this.jPanel2.setForeground(new Color(255, 255, 255));
        this.btnOk.setMnemonic('o');
        this.btnOk.setText("Ok");
        this.btnOk.setEnabled(false);
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelExcluirDeclaracao.this.btnOkActionPerformed(evt);
            }
        });
        this.btnCancelar.setMnemonic('c');
        this.btnCancelar.setText("Cancelar");
        this.btnCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelExcluirDeclaracao.this.btnCancelarActionPerformed(evt);
            }
        });
        this.btnAjuda.setMnemonic('A');
        this.btnAjuda.setText("Ajuda");
        this.btnTodos.setMnemonic('T');
        this.btnTodos.setText("Todos");
        this.btnTodos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelExcluirDeclaracao.this.btnTodosActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.btnOk, -2, 90, -2).add((Component)this.btnTodos, -1, -1, Short.MAX_VALUE).add((Component)this.btnAjuda, -1, -1, Short.MAX_VALUE).add((Component)this.btnCancelar)).addContainerGap()));
        jPanel2Layout.linkSize(new Component[]{this.btnAjuda, this.btnCancelar, this.btnOk, this.btnTodos}, 1);
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.btnOk).addPreferredGap(0).add((Component)this.btnTodos).addPreferredGap(0).add((Component)this.btnCancelar).addPreferredGap(0).add((Component)this.btnAjuda).addContainerGap(165, Short.MAX_VALUE)));
        jPanel2Layout.linkSize(new Component[]{this.btnAjuda, this.btnCancelar, this.btnOk, this.btnTodos}, 2);
        this.btnOk.getAccessibleContext().setAccessibleName("OK");
        this.btnTodos.getAccessibleContext().setAccessibleName("Excluir Todos");
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabel1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.tabPaneDeclaracoes, -1, 739, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jPanel2, -2, -1, -2))).add(6, 6, 6)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).add(8, 8, 8).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jPanel2, -2, -1, -2).add(0, 38, Short.MAX_VALUE)).add((Component)this.tabPaneDeclaracoes)).addContainerGap()));
        this.jLabel1.getAccessibleContext().setAccessibleName("Selecione as declara\u00e7\u00f5es que deseja excluir. Para colocar o foco na tabela de declara\u00e7\u00f5es, aperte a tecla TAB, e utilize as setas para cima e para baixo para navegar pelas declara\u00e7\u00f5es.");
    }

    private void btnTodosActionPerformed(ActionEvent evt) {
        if (this.tabPaneDeclaracoes.getSelectedIndex() == 0) {
            this.subpainelDeclaracoesPreenchimento.getTabela().selectAll();
        } else {
            this.subpainelDeclaracoesTransmitidas.getTabela().selectAll();
        }
    }

    private void btnCancelarActionPerformed(ActionEvent evt) {
        ((JDialog)SwingUtilities.getRoot(this)).setVisible(false);
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        if (this.tabPaneDeclaracoes.getSelectedIndex() == 0) {
            if (JOptionPane.showConfirmDialog(this.getParent(), "Tem certeza que deseja excluir esta(s) declara\u00e7\u00e3o(\u00f5es)?", "Confirma\u00e7\u00e3o", 0) == 0) {
                ((JDialog)SwingUtilities.getRoot(this)).setVisible(false);
                int[] linhasSelecionadas = this.subpainelDeclaracoesPreenchimento.getTabela().getSelectedRows();
                int[] retorno = new int[linhasSelecionadas.length];
                for (int i = 0; i < retorno.length; ++i) {
                    retorno[i] = ((TableRowSorter)this.subpainelDeclaracoesPreenchimento.getTabela().getRowSorter()).convertRowIndexToModel(linhasSelecionadas[i]);
                }
                List<IdentificadorDeclaracao> ids = this.subpainelDeclaracoesPreenchimento.getTabela().getIdentificadorDeclaracao(retorno);
                ControladorGui.excluirDemonstrativo(ids);
            }
        } else if (JOptionPane.showConfirmDialog(this.getParent(), MensagemUtil.getMensagem((String)"confirmarExcluirDeclaracaoTransmitida"), "Confirma\u00e7\u00e3o", 0) == 0) {
            Object[] options = new Object[]{"Excluir definitivamente", "Desistir"};
            int resposta = JOptionPane.showOptionDialog(this.getParent(), MensagemUtil.getMensagem((String)"confirmarExcluirDeclaracaoTransmitidaSeguinte"), "Confirma\u00e7\u00e3o", -1, -1, null, options, options[1]);
            if (resposta == 0) {
                ((JDialog)SwingUtilities.getRoot(this)).setVisible(false);
                int[] linhasSelecionadas = this.subpainelDeclaracoesTransmitidas.getTabela().getSelectedRows();
                int[] retorno = new int[linhasSelecionadas.length];
                for (int i = 0; i < retorno.length; ++i) {
                    retorno[i] = ((TableRowSorter)this.subpainelDeclaracoesTransmitidas.getTabela().getRowSorter()).convertRowIndexToModel(linhasSelecionadas[i]);
                }
                List<IdentificadorDeclaracao> ids = this.subpainelDeclaracoesTransmitidas.getTabela().getIdentificadorDeclaracao(retorno);
                ControladorGui.excluirDemonstrativo(ids, true);
            }
        }
    }
}

