/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.dashboard.fichas;

import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.NavegacaoIf;
import serpro.ppgd.irpf.gui.componente.JTaskAction;
import serpro.ppgd.irpf.gui.dashboard.fichas.DadosFicha;
import serpro.ppgd.irpf.gui.dashboard.fichas.GridFichasDataSource;
import serpro.ppgd.irpf.gui.dashboard.fichas.SortGridUtil;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.IdDeclaracao;
import serpro.ppgd.negocio.Logico;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.LogPPGD;

public class FichasSelecionadasDataSource
implements GridFichasDataSource {
    private WeakReference<DeclaracaoIRPF> declaracaoRef = null;
    private ArrayList<DadosFicha> fichasSelecionadas;
    private static ArrayList<DadosFicha> fichasDefault;
    private static HashMap<String, String> iconesDashboard;
    private SortGridUtil sortUtil = new SortGridUtil();

    public FichasSelecionadasDataSource(DeclaracaoIRPF dec) {
        this.declaracaoRef = new WeakReference<DeclaracaoIRPF>(dec);
        this.atualizar();
    }

    public List<DadosFicha> verificarFichasPreenchidas(Object pObj) {
        ArrayList<DadosFicha> retorno = new ArrayList<DadosFicha>();
        if (pObj == null) {
            return new ArrayList<DadosFicha>(0);
        }
        if (pObj instanceof ObjetoNegocio) {
            DadosFicha dadosFicha;
            ObjetoNegocio objNegocio = (ObjetoNegocio)pObj;
            if (objNegocio instanceof Colecao) {
                ObjetoNegocio item;
                Colecao objCol = (Colecao)objNegocio;
                objCol.excluirRegistrosEmBranco();
                if (objCol.itens().size() > 0 && (item = (ObjetoNegocio)objCol.itens().get(0)) instanceof ObjetoFicha) {
                    DadosFicha dadosFicha2 = this.getDadosFicha((ObjetoFicha)item);
                    if (dadosFicha2 != null && dadosFicha2.getTitulo().equals("Rendimentos Tribut\u00e1veis Recebidos de PJ pelo Titular")) {
                        dadosFicha2.setTitulo("Rendimentos Tribut\u00e1veis Recebidos de PJ");
                    } else if (dadosFicha2 != null && dadosFicha2.getTitulo().equals("Rendimentos Recebidos Acumuladamente pelo Titular")) {
                        dadosFicha2.setTitulo("Rendimentos Recebidos Acumuladamente");
                    }
                    if (dadosFicha2 != null) {
                        retorno.add(dadosFicha2);
                    }
                }
            } else if (!objNegocio.isVazio() && objNegocio instanceof ObjetoFicha && (dadosFicha = this.getDadosFicha((ObjetoFicha)objNegocio)) != null) {
                retorno.add(dadosFicha);
            }
        } else {
            return new ArrayList<DadosFicha>(0);
        }
        List<Field> fields = this.getFieldsCamposObjetoNegocio(pObj.getClass());
        Object valAtributo = null;
        for (Field field : fields) {
            valAtributo = null;
            try {
                valAtributo = FabricaUtilitarios.getValorField((Field)field, (Object)pObj);
            }
            catch (Exception e) {
                LogPPGD.erro((String)("N\u00e3o foi poss\u00edvel obter valor do atributo->" + field.getName()));
            }
            if (valAtributo == null || Modifier.isTransient(field.getModifiers()) || !(valAtributo instanceof ObjetoNegocio) || valAtributo instanceof IdDeclaracao) continue;
            if (pObj instanceof Colecao) {
                ((Colecao)pObj).excluirRegistrosEmBranco();
            }
            if (retorno == null) {
                retorno = new ArrayList();
            }
            retorno.addAll(this.verificarFichasPreenchidas(valAtributo));
        }
        return retorno;
    }

    @Override
    public void atualizar() {
        int count;
        DeclaracaoIRPF dec = (DeclaracaoIRPF)this.declaracaoRef.get();
        this.fichasSelecionadas = new ArrayList();
        if (dec != null) {
            List<DadosFicha> list = this.verificarFichasPreenchidas(this.declaracaoRef.get());
            HashSet<String> hash = new HashSet<String>();
            for (DadosFicha dados : list) {
                if (hash.contains(dados.getPainelFicha())) continue;
                this.fichasSelecionadas.add(dados);
                hash.add(dados.getPainelFicha());
            }
            if (((DeclaracaoIRPF)this.declaracaoRef.get()).getIdentificadorDeclaracao().getInNovaDeclaracao().naoFormatado().equals(Logico.SIM)) {
                for (DadosFicha dados : fichasDefault) {
                    if (hash.contains(dados.getPainelFicha())) continue;
                    this.fichasSelecionadas.add(dados);
                    hash.add(dados.getPainelFicha());
                }
            }
        }
        this.sortUtil.sort(this.fichasSelecionadas);
        ArrayList<Integer> indexRemover = new ArrayList<Integer>();
        int k = count = this.fichasSelecionadas.size();
        while (count > 12 && k > 0) {
            if (this.fichasSelecionadas.get(--k).getPainelFicha().equals(NavegacaoIf.PAINEL_RESUMO_CALCULO_IMPOSTO)) continue;
            indexRemover.add(k);
            --count;
        }
        Iterator iterator = indexRemover.iterator();
        while (iterator.hasNext()) {
            int index = (Integer)iterator.next();
            this.fichasSelecionadas.remove(index);
        }
    }

    private DadosFicha getDadosFicha(ObjetoFicha aObj) {
        JTaskAction taskAction = ControladorGui.getJanelaPrincipal().getTaskActionDoPainel(aObj.getClasseFicha());
        if (taskAction != null) {
            String strClassePainel = this.extraiNomePainel(aObj.getClasseFicha());
            String icone = iconesDashboard.get(strClassePainel);
            if (icone == null) {
                return null;
            }
            String tituloFicha = aObj.getTituloFichaDashboard();
            if (tituloFicha == null || tituloFicha.trim().length() == 0) {
                return null;
            }
            return new DadosFicha(tituloFicha, aObj.getClasseFicha(), GuiUtil.getImage(icone));
        }
        return null;
    }

    private String extraiNomePainel(String aClasse) {
        String strClassePainel = aClasse;
        int index = strClassePainel.lastIndexOf(46);
        strClassePainel = strClassePainel.substring(index + 1);
        return strClassePainel;
    }

    public List<Field> getFieldsCamposObjetoNegocio(Class<?> pClass) {
        Field[] fields = pClass.getDeclaredFields();
        ArrayList<Field> retorno = new ArrayList<Field>(fields.length);
        for (int i = 0; i < fields.length; ++i) {
            if (!ObjetoNegocio.class.isAssignableFrom(fields[i].getType())) continue;
            retorno.add(fields[i]);
        }
        if (pClass.getSuperclass() != null && !pClass.getSuperclass().equals(ObjetoNegocio.class)) {
            retorno.addAll(this.getFieldsCamposObjetoNegocio(pClass.getSuperclass()));
        }
        return retorno;
    }

    @Override
    public ArrayList<DadosFicha> getFichasSelecionadas() {
        return this.fichasSelecionadas;
    }

    @Override
    public int getTotalFichasSelecionadas() {
        if (this.fichasSelecionadas == null) {
            return 0;
        }
        return this.fichasSelecionadas.size();
    }

    static {
        iconesDashboard = new HashMap();
        iconesDashboard.put("PainelAlimentandosLista", "/icones/png40px/DE_aliment-dashboard.png");
        iconesDashboard.put("PainelApuracaoResultado", "/icones/png40px/AR_ap_result-dashboard.png");
        iconesDashboard.put("PainelDadosImovel", "/icones/png40px/AR_dados_imovel-dashboard.png");
        iconesDashboard.put("PainelReceitasDespesas", "/icones/png40px/AR_receitas_despesas-dashboard.png");
        iconesDashboard.put("PainelBensARLista", "/icones/png40px/AR_bens-dashboard.png");
        iconesDashboard.put("PainelDividasAR", "/icones/png40px/AR_dividas-dashboard.png");
        iconesDashboard.put("PainelMovimentacaoRebanho", "/icones/png40px/AR_mov_rebanho-dashboard.png");
        iconesDashboard.put("PainelBensLista", "/icones/png40px/DE_bens-dashboard.png");
        iconesDashboard.put("PainelEscolheContribuinte", "/icones/png40px/DE_ident-dashboard.png");
        iconesDashboard.put("PainelDependentesLista", "/icones/png40px/DE_depend-dashboard.png");
        iconesDashboard.put("PainelDividasLista", "/icones/png40px/DE_dividas-dashboard.png");
        iconesDashboard.put("PainelDoacoesLista", "/icones/png40px/DE_doacoes-dashboard.png");
        iconesDashboard.put("PainelDadosDDD", "/icones/png40px/DE_estatuto-dashboard.png");
        iconesDashboard.put("PainelDoacoesCampanhasLista", "/icones/png40px/DE_doacoes_politicos-dashboard.png");
        iconesDashboard.put("PainelEscolheEspolio", "/icones/png40px/DE_espolio-dashboard.png");
        iconesDashboard.put("PainelGCapBensImoveisLista", "/icones/png40px/GC_imoveis-dashboard.png");
        iconesDashboard.put("PainelGCapBensMoveisLista", "/icones/png40px/GC_moveis-dashboard.png");
        iconesDashboard.put("PainelGCapPSocietariasLista", "/icones/png40px/GC_socio-dashboard.png");
        iconesDashboard.put("PainelHerdeirosLista", "/icones/png40px/DE_herdeiros-dashboard.png");
        iconesDashboard.put("PainelImpostoPago", "/icones/png40px/DE_imposto_pago-dashboard.png");
        iconesDashboard.put("PainelPagamentosLista", "/icones/png40px/DE_pagamentos-dashboard.png");
        iconesDashboard.put("PainelDadosRendAcm", "/icones/png40px/DE_rend_acumul-dashboard.png");
        iconesDashboard.put("PainelDadosRendaVariavelOpComunsDayTrade", "/icones/png40px/RV_daytrade-dashboard.png");
        iconesDashboard.put("PainelDadosRendaVariavelFundosInvest", "/icones/png40px/RV_invimob-dashboard.png");
        iconesDashboard.put("PainelDadosRendIsentos", "/icones/png40px/DE_rend_isent-dashboard.png");
        iconesDashboard.put("PainelDadosRendTributExclusiva", "/icones/png40px/DE_rend_excl-dashboard.png");
        iconesDashboard.put("PainelDadosEscrituracao", "/icones/png40px/DE_rend_pf-dashboard.png");
        iconesDashboard.put("PainelDadosRendPJ", "/icones/png40px/DE_rend_pj-dashboard.png");
        iconesDashboard.put("PainelDadosRendPJComExigibilidade", "/icones/png40px/DE_rend_pj_susp-dashboard.png");
        iconesDashboard.put("PainelRendTributacaoExclusiva", "/icones/png40px/DE_rend_excl-dashboard.png");
        iconesDashboard.put("PainelCalculoImposto", "/icones/png40px/RE_calc-dashboard.png");
        iconesDashboard.put("PainelSaida", "/icones/png40px/DE_saida-dashboard.png");
        iconesDashboard.put("PainelGCMEBens", "/icones/png40px/ME_bens-dashboard.png");
        iconesDashboard.put("PainelGCMEEspecieLista", "/icones/png40px/ME_especie-dashboard.png");
        fichasDefault = new ArrayList();
        fichasDefault.add(new DadosFicha("Ident. do Contribuinte", NavegacaoIf.PAINEL_IDENTIFICACAO_CONTRIBUINTE, GuiUtil.getImage("/icones/png40px/DE_ident-dashboard.png")));
        fichasDefault.add(new DadosFicha("Dependentes", NavegacaoIf.PAINEL_DEPENDENTES, GuiUtil.getImage("/icones/png40px/DE_depend-dashboard.png")));
        fichasDefault.add(new DadosFicha("Rendimentos Tribut\u00e1veis Recebidos de PJ", NavegacaoIf.PAINEL_REND_TRIB_RECEB_PJ, GuiUtil.getImage("/icones/png40px/DE_rend_pj-dashboard.png")));
        fichasDefault.add(new DadosFicha("Rendimentos Isentos e N\u00e3o Tribut\u00e1veis", NavegacaoIf.PAINEL_REND_ISENTOS, GuiUtil.getImage("/icones/png40px/DE_rend_isent-dashboard.png")));
        fichasDefault.add(new DadosFicha("Rendimentos Sujeitos \u00e0 Tributa\u00e7\u00e3o Exclusiva/Definitiva", NavegacaoIf.PAINEL_REND_SUJ_TRIB_EXCLUSIVA, GuiUtil.getImage("/icones/png40px/DE_rend_excl-dashboard.png")));
        fichasDefault.add(new DadosFicha("Pagamentos Efetuados", NavegacaoIf.PAINEL_PAGAMENTOS, GuiUtil.getImage("/icones/png40px/DE_pagamentos-dashboard.png")));
        fichasDefault.add(new DadosFicha("Bens e Direitos", NavegacaoIf.PAINEL_BENS_DIREITOS, GuiUtil.getImage("/icones/png40px/DE_bens-dashboard.png")));
        fichasDefault.add(new DadosFicha("C\u00e1lculo do Imposto", NavegacaoIf.PAINEL_RESUMO_CALCULO_IMPOSTO, GuiUtil.getImage("/icones/png40px/RE_calc-dashboard.png")));
    }
}

