/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jdesktop.layout.GroupLayout;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.irpf.favoritos.Favoritos;
import serpro.ppgd.irpf.gui.HoraSalvamentoPanel;
import serpro.ppgd.irpf.gui.PainelDemonstrativoAb;
import serpro.ppgd.irpf.gui.PainelDemonstrativoIf;
import serpro.ppgd.irpf.gui.componente.BarraTitulo;
import serpro.ppgd.irpf.gui.componente.MensagemPanel;
import serpro.ppgd.irpf.gui.listener.CabecalhoFichaListener;
import serpro.ppgd.irpf.gui.listener.HelpListener;
import serpro.ppgd.irpf.gui.listener.MensagemFichaListener;
import serpro.ppgd.irpf.gui.listener.SubtituloFichaListener;
import serpro.ppgd.negocio.util.LogPPGD;

public class PainelContainer
extends JPanel
implements CabecalhoFichaListener,
MensagemFichaListener,
HelpListener,
SubtituloFichaListener {
    private static final long serialVersionUID = 1L;
    private BarraTitulo barraTitulo;
    private JButton btnAjuda;
    private JButton btnCancelar;
    private JButton btnImportar;
    private JButton btnVoltar;
    private HoraSalvamentoPanel horaSalvamentoPanel1;
    private JPanel jPanel1;
    private JLabel lblSubtitulo;
    public JPanel pnlAreaUtil;
    private MensagemPanel pnlMensagem;
    private JPanel pnlSubtitulo;
    private JScrollPane scrollAreaProg;

    public PainelContainer() {
        this.initComponents();
        this.pnlAreaUtil.setBackground(new Color(241, 245, 249));
        this.horaSalvamentoPanel1.setBackground(new Color(241, 245, 249));
        this.jPanel1.setBackground(new Color(241, 245, 249));
        this.pnlAreaUtil.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        this.scrollAreaProg.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
    }

    public PainelContainer(PainelDemonstrativoIf painel) {
        this();
        this.mudaCorpoPainelPrincipal(painel);
    }

    public void setImagem(ImageIcon pIcon) {
        this.barraTitulo.getLblIcone().setIcon(pIcon);
    }

    public ImageIcon getImagem() {
        return (ImageIcon)this.barraTitulo.getLblIcone().getIcon();
    }

    private void initComponents() {
        this.barraTitulo = new BarraTitulo();
        this.pnlAreaUtil = new JPanel();
        this.scrollAreaProg = new JScrollPane();
        this.jPanel1 = new JPanel();
        this.btnImportar = new JButton();
        this.btnVoltar = new JButton();
        this.btnCancelar = new JButton();
        this.btnAjuda = new JButton();
        this.horaSalvamentoPanel1 = new HoraSalvamentoPanel();
        this.pnlMensagem = new MensagemPanel();
        this.pnlSubtitulo = new JPanel();
        this.lblSubtitulo = new JLabel();
        this.setFocusCycleRoot(true);
        this.setLayout(new BorderLayout());
        this.add((Component)this.barraTitulo, "First");
        this.pnlAreaUtil.setBackground(new Color(238, 238, 238));
        this.pnlAreaUtil.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1), BorderFactory.createEmptyBorder(5, 5, 0, 5)));
        this.scrollAreaProg.setBorder(BorderFactory.createBevelBorder(1));
        this.jPanel1.setBackground(new Color(238, 238, 238));
        this.jPanel1.setLayout(new FlowLayout(2));
        this.btnImportar.setText("Importar");
        this.btnImportar.setToolTipText("Importar");
        this.btnImportar.setPreferredSize(new Dimension(250, 25));
        this.jPanel1.add(this.btnImportar);
        this.btnVoltar.setText("OK");
        this.btnVoltar.setToolTipText("Retornar a tela principal");
        this.btnVoltar.setPreferredSize(new Dimension(98, 25));
        this.jPanel1.add(this.btnVoltar);
        this.btnCancelar.setText("Cancelar");
        this.btnCancelar.setPreferredSize(new Dimension(98, 25));
        this.jPanel1.add(this.btnCancelar);
        this.btnAjuda.setText("Ajuda");
        this.btnAjuda.setToolTipText("Ajuda");
        this.btnAjuda.setPreferredSize(new Dimension(98, 25));
        this.jPanel1.add(this.btnAjuda);
        this.horaSalvamentoPanel1.setBackground(new Color(238, 238, 238));
        this.pnlMensagem.setBorder(BorderFactory.createLineBorder(new Color(225, 225, 225)));
        this.pnlSubtitulo.setBackground(new Color(241, 245, 249));
        this.pnlSubtitulo.setBorder(null);
        this.lblSubtitulo.setFont(new Font("Verdana", 1, 14));
        this.lblSubtitulo.setForeground(new Color(0, 74, 106));
        this.lblSubtitulo.setHorizontalAlignment(0);
        this.lblSubtitulo.setText("jLabel1");
        GroupLayout pnlSubtituloLayout = new GroupLayout((Container)this.pnlSubtitulo);
        this.pnlSubtitulo.setLayout((LayoutManager)pnlSubtituloLayout);
        pnlSubtituloLayout.setHorizontalGroup((GroupLayout.Group)pnlSubtituloLayout.createParallelGroup(1).add((Component)this.lblSubtitulo, -1, 738, Short.MAX_VALUE));
        pnlSubtituloLayout.setVerticalGroup((GroupLayout.Group)pnlSubtituloLayout.createParallelGroup(1).add((Component)this.lblSubtitulo));
        GroupLayout pnlAreaUtilLayout = new GroupLayout((Container)this.pnlAreaUtil);
        this.pnlAreaUtil.setLayout((LayoutManager)pnlAreaUtilLayout);
        pnlAreaUtilLayout.setHorizontalGroup((GroupLayout.Group)pnlAreaUtilLayout.createParallelGroup(1).add((GroupLayout.Group)pnlAreaUtilLayout.createSequentialGroup().add((Component)this.horaSalvamentoPanel1, -1, 161, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jPanel1, -2, 571, -2)).add((Component)this.scrollAreaProg).add((Component)this.pnlMensagem, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)pnlAreaUtilLayout.createParallelGroup(1).add((Component)this.pnlSubtitulo, -1, -1, Short.MAX_VALUE)));
        pnlAreaUtilLayout.setVerticalGroup((GroupLayout.Group)pnlAreaUtilLayout.createParallelGroup(1).add(2, (GroupLayout.Group)pnlAreaUtilLayout.createSequentialGroup().add(23, 23, 23).add((Component)this.pnlMensagem, -2, -1, -2).addPreferredGap(0).add((Component)this.scrollAreaProg, -1, 137, Short.MAX_VALUE).addPreferredGap(0).add((GroupLayout.Group)pnlAreaUtilLayout.createParallelGroup(1).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add((Component)this.horaSalvamentoPanel1, -2, -1, -2))).add((GroupLayout.Group)pnlAreaUtilLayout.createParallelGroup(1).add((GroupLayout.Group)pnlAreaUtilLayout.createSequentialGroup().add((Component)this.pnlSubtitulo, -2, -1, -2).add(0, 235, Short.MAX_VALUE))));
        pnlAreaUtilLayout.linkSize(new Component[]{this.horaSalvamentoPanel1, this.jPanel1}, 2);
        this.add((Component)this.pnlAreaUtil, "Center");
    }

    public final void mudaCorpoPainelPrincipal(final PainelDemonstrativoIf pPainel) {
        this.pnlMensagem.setVisible(pPainel.isTelaComMensagem());
        if (pPainel.isTelaComMensagem()) {
            this.pnlMensagem.setMensagem(pPainel.getMensagemTela());
        }
        if (pPainel instanceof PainelDemonstrativoAb) {
            PainelDemonstrativoAb painelComSubtitulo = (PainelDemonstrativoAb)pPainel;
            this.pnlSubtitulo.setVisible(painelComSubtitulo.isTelaComSubtitulo() && painelComSubtitulo.getSubtitulo() != null && !"".equals(painelComSubtitulo.getSubtitulo()));
        } else {
            this.pnlSubtitulo.setVisible(false);
        }
        this.scrollAreaProg.getViewport().removeAll();
        this.scrollAreaProg.getViewport().add((JPanel)((Object)pPainel));
        this.barraTitulo.getLblTitulo().setText(pPainel.getTituloPainel());
        ((JPanel)((Object)pPainel)).getAccessibleContext().setAccessibleName(pPainel.getTituloPainel());
        ((JPanel)((Object)pPainel)).getAccessibleContext().setAccessibleDescription(pPainel.getMensagemTela());
        this.scrollAreaProg.getViewport().validate();
        if (pPainel.isTelaComVoltar()) {
            this.btnVoltar.setVisible(true);
            this.btnVoltar.setAction(new AbstractAction("OK"){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent ae) {
                    pPainel.executaVoltar();
                }
            });
            this.btnVoltar.setMnemonic(pPainel.getAtalhoConfirmar());
            this.btnVoltar.setText(pPainel.getLabelConfirmar());
            this.btnVoltar.setToolTipText("Voltar a tela principal");
        } else {
            this.btnVoltar.setVisible(false);
        }
        if (pPainel.isTelaComCancelar()) {
            this.btnCancelar.setVisible(true);
            this.btnCancelar.setAction(new AbstractAction("Cancelar"){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent ae) {
                    pPainel.executaCancelar();
                }
            });
            this.btnCancelar.setMnemonic(pPainel.getAtalhoCancelar());
            this.btnCancelar.setText(pPainel.getLabelCancelar());
            this.btnCancelar.setToolTipText(pPainel.getLabelCancelar());
        } else {
            this.btnCancelar.setVisible(false);
        }
        if (pPainel.isTelaComImportacao()) {
            this.btnImportar.setVisible(true);
            this.btnImportar.setAction(pPainel.obterImportacaoAction());
            this.btnImportar.setMnemonic(73);
            this.btnImportar.setText(pPainel.getLabelImportacao());
            this.btnImportar.setToolTipText(pPainel.getLabelImportacao());
        } else {
            this.btnImportar.setVisible(false);
        }
        if (pPainel.isTelaComAjuda()) {
            if (pPainel.getHelpID() != null) {
                this.helpIdAlterado(pPainel.getHelpID());
            } else {
                LogPPGD.erro((String)("Aten\u00e7\u00e3o! A tela " + pPainel.getClass().getName() + " possui Ajuda mas n\u00e3o possui HelpID!"));
            }
            this.btnAjuda.setVisible(true);
            this.btnAjuda.setToolTipText("Ajuda");
            this.btnAjuda.setMnemonic(65);
        } else {
            this.btnAjuda.setVisible(false);
        }
        if (pPainel.isTelaComFavoritos()) {
            this.barraTitulo.getBtnFavoritos().setVisible(true);
            this.barraTitulo.getBtnFavoritos().setSelected(Favoritos.isFavorito(pPainel.getClass().getName()));
        } else {
            this.barraTitulo.getBtnFavoritos().setVisible(false);
        }
    }

    @Override
    public void cabecalhoAlterado(String novoTextoCabecalho) {
        this.barraTitulo.getLblTitulo().setText(novoTextoCabecalho);
    }

    @Override
    public void mensagemAlterada(String novaMensagem) {
        if (novaMensagem != null && !novaMensagem.trim().equals("")) {
            this.pnlMensagem.setVisible(true);
        } else {
            this.pnlMensagem.setVisible(false);
        }
        this.lblSubtitulo.setText(novaMensagem);
    }

    @Override
    public void subtituloAlterado(String novoSubtitulo) {
        if (novoSubtitulo != null && !novoSubtitulo.trim().equals("")) {
            this.pnlSubtitulo.setVisible(true);
        } else {
            this.pnlSubtitulo.setVisible(false);
        }
        this.lblSubtitulo.setText(novoSubtitulo);
    }

    @Override
    public void helpIdAlterado(String novoHelpId) {
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)this.btnAjuda, novoHelpId);
    }

    public HoraSalvamentoPanel getHoraSalvamentoPanel1() {
        return this.horaSalvamentoPanel1;
    }

    public JButton getBtnAjuda() {
        return this.btnAjuda;
    }
}

