/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.layout.GroupLayout;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.irpf.gui.PainelAbaIf;
import serpro.ppgd.irpf.gui.PainelDemonstrativoAb;
import serpro.ppgd.irpf.gui.PainelDemonstrativoIf;
import serpro.ppgd.irpf.gui.componente.JCustomTabbedPane;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.negocio.ObjetoNegocio;

public abstract class PainelComAbasAb
extends PainelDemonstrativoAb {
    private String[] nomeAbas;
    private static final long serialVersionUID = 1L;
    protected ImageIcon imagemTitulo;
    private ObjetoNegocio dataSource;
    private JCustomTabbedPane panelAreaPrincipal;

    protected abstract void montarAbas();

    protected void montarAbasComAninhamento(String abaSuperior) {
    }

    protected abstract void tratarMudancaTabbedPane();

    protected abstract String[] definirNomeAbas();

    protected abstract void configObservadores();

    public PainelComAbasAb() {
        this.initComponents();
        this.nomeAbas = this.definirNomeAbas();
        this.iniciarComponentes();
        this.montarAbas();
        this.configObservadores();
        this.configListeners();
        this.configuraAtalhoPadraoAbas();
        String helpId = this.getHelpID();
        if (helpId != null) {
            PlataformaPPGD.getPlataforma().setHelpID((JComponent)this, helpId);
        }
    }

    public PainelComAbasAb(ObjetoNegocio dataSource) {
        this.dataSource = dataSource;
        this.initComponents();
        this.nomeAbas = this.definirNomeAbas();
        this.iniciarComponentes();
        this.configObservadores();
        this.configListeners();
        this.configuraAtalhoPadraoAbas();
        String helpId = this.getHelpID();
        if (helpId != null) {
            PlataformaPPGD.getPlataforma().setHelpID((JComponent)this, helpId);
        }
    }

    public PainelComAbasAb(String pImagemTitulo) {
        this.initComponents();
        this.nomeAbas = this.definirNomeAbas();
        this.iniciarComponentes();
        this.imagemTitulo = GuiUtil.getImage(pImagemTitulo);
        this.montarAbas();
        this.configObservadores();
        this.configListeners();
        this.configuraAtalhoPadraoAbas();
        String helpId = this.getHelpID();
        if (helpId != null) {
            PlataformaPPGD.getPlataforma().setHelpID((JComponent)this, helpId);
        }
    }

    public PainelComAbasAb(String pImagemTitulo, String nomeAba) {
        this.initComponents();
        this.nomeAbas = this.definirNomeAbas();
        this.iniciarComponentes();
        this.imagemTitulo = GuiUtil.getImage(pImagemTitulo);
        this.montarAbasComAninhamento(nomeAba);
        this.configObservadores();
        this.configListeners();
        this.configuraAtalhoPadraoAbas();
        String helpId = this.getHelpID();
        if (helpId != null) {
            PlataformaPPGD.getPlataforma().setHelpID((JComponent)this, helpId);
        }
    }

    public PainelComAbasAb(String pImagemTitulo, String nomeAba, ObjetoNegocio dataSource) {
        this.dataSource = dataSource;
        this.initComponents();
        this.nomeAbas = this.definirNomeAbas();
        this.iniciarComponentes();
        this.imagemTitulo = GuiUtil.getImage(pImagemTitulo);
        this.montarAbasComAninhamento(nomeAba);
        this.configObservadores();
        this.configListeners();
        this.configuraAtalhoPadraoAbas();
        String helpId = this.getHelpID();
        if (helpId != null) {
            PlataformaPPGD.getPlataforma().setHelpID((JComponent)this, helpId);
        }
    }

    protected void configuraAtalhoPadraoAbas() {
        this.getTabbedPane().getInputMap(1).put(KeyStroke.getKeyStroke(33, 512), "abaAnterior");
        this.getTabbedPane().getInputMap(1).put(KeyStroke.getKeyStroke(34, 512), "abaPosterior");
        this.getTabbedPane().getActionMap().put("abaAnterior", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PainelComAbasAb.this.acionarProximaAba(-1);
            }
        });
        this.getTabbedPane().getActionMap().put("abaPosterior", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PainelComAbasAb.this.acionarProximaAba(1);
            }
        });
    }

    protected void acionarProximaAba(int i) {
        int selectedIndex = this.getTabbedPane().getSelectedIndex() + i;
        if (selectedIndex >= 0 && selectedIndex < this.getTabbedPane().getTabCount() && this.getTabbedPane().isEnabledAt(selectedIndex)) {
            this.getTabbedPane().setSelectedIndex(selectedIndex);
        }
    }

    public ObjetoNegocio getDataSource() {
        return this.dataSource;
    }

    protected void iniciarComponentes() {
    }

    @Override
    public ImageIcon getImagemTitulo() {
        return this.imagemTitulo;
    }

    @Override
    public boolean isPodeSair() {
        if (this.getTabbedPane().getSelectedComponent() instanceof PainelDemonstrativoAb) {
            return ((PainelDemonstrativoAb)this.getTabbedPane().getSelectedComponent()).isPodeSair();
        }
        return true;
    }

    @Override
    public void preExibir() {
        for (PainelAbaIf painelAba : this.getAbas()) {
            if (!(painelAba instanceof PainelDemonstrativoAb)) continue;
            ((PainelDemonstrativoAb)((Object)painelAba)).preExibir();
        }
    }

    @Override
    public void posExibir() {
        this.tratarHabilitacaoAbas();
    }

    @Override
    public JComponent getDefaultFocus() {
        JTabbedPane tabbedPane = this.getTabbedPane();
        Component painel = tabbedPane.getSelectedComponent();
        if (painel != null && PainelDemonstrativoIf.class.isAssignableFrom(painel.getClass())) {
            return ((PainelDemonstrativoIf)((Object)painel)).getDefaultFocus();
        }
        return tabbedPane;
    }

    protected void configListeners() {
        this.getTabbedPane().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JComponent component = PainelComAbasAb.this.getDefaultFocus();
                if (component != null) {
                    component.requestFocusInWindow();
                }
                PainelComAbasAb.this.tratarMudancaTabbedPane();
            }
        });
    }

    protected void tratarHabilitacaoAbas() {
    }

    @Override
    public JTabbedPane getTabbedPane() {
        return this.panelAreaPrincipal;
    }

    private void initComponents() {
        this.panelAreaPrincipal = new JCustomTabbedPane();
        this.setBackground(new Color(241, 245, 249));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.panelAreaPrincipal, -1, 408, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.panelAreaPrincipal, -1, 283, Short.MAX_VALUE).addContainerGap()));
    }

    public String[] getNomeAbas() {
        return this.nomeAbas;
    }

    public void setNomeAbas(String[] nomeAbas) {
        this.nomeAbas = nomeAbas;
    }
}

