/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.IRPFTableAb;
import serpro.ppgd.irpf.gui.IRPFTableModelAb;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.negocio.Valor;

public abstract class IRPFTableMonetariaAb
extends IRPFTableAb {
    private static final long serialVersionUID = 1L;

    @Override
    protected void executaValidacaoAposEdicao(final int col, final int row) {
        super.executaValidacaoAposEdicao(col, row);
        Valor valorCelula = (Valor)((IRPFTableModelAb)this.getModel()).getInformacaoAt(row, col);
        if (!valorCelula.isVazio()) {
            try {
                String parteInteira = valorCelula.getParteInteira();
                Pattern p = Pattern.compile(".*(\\d)\\1{4,}.*");
                Matcher m = p.matcher(parteInteira);
                boolean possuiCaracteresRepetidos = m.find();
                if (possuiCaracteresRepetidos && !GuiUtil.mostrarConfirma("msg_confirmacao_digitos_inteiros_repetidos")) {
                    valorCelula.setConteudo(valorCelula.getConteudoAntigo());
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            IRPFTableMonetariaAb.this.selecionaCelula(col, row);
                            IRPFTableMonetariaAb.this.editarCelula(row, col);
                        }
                    });
                }
            }
            catch (Exception ex) {
                ControladorGui.tratarException(ex);
            }
        }
    }
}

