/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui;

import java.awt.Color;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumnModel;
import serpro.ppgd.gui.xbeans.JEditCampo;
import serpro.ppgd.gui.xbeans.JEditValor;
import serpro.ppgd.irpf.gui.IRPFTableModelAb;
import serpro.ppgd.irpf.gui.rendpf.TableRendPF;
import serpro.ppgd.irpf.gui.table.JComponentCellEditor;
import serpro.ppgd.irpf.gui.table.JPPGDTable;
import serpro.ppgd.irpf.gui.table.editors.PPGDCellEditorIf;
import serpro.ppgd.irpf.gui.table.editors.PPGDDefaultEditor;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Valor;

public abstract class IRPFTableAb
extends JPPGDTable {
    private static final long serialVersionUID = 1L;
    private char veioDoKeyListener = (char)32;
    private PPGDDefaultEditor editorDefault = null;
    private PPGDDefaultEditor editorInteiro = null;
    protected String[] accessibleRowHeader;
    public String[] accessibleColumnHeader;
    private KeyAdapter defaultKeyAdapter;

    protected abstract void iniciaModelVazio();

    public IRPFTableAb() {
        this.setSelectionMode(1);
        this.configurarToolTip();
        this.configuraLayoutHeader();
        this.iniciaModelVazio();
        this.configuraLayout();
        this.setaDefaultRenderers();
        this.preparaEditores();
        this.preparaEditorInteiro();
        this.configurarKeyListenerEditor();
        this.defaultKeyAdapter = new KeyAdapter(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void keyPressed(KeyEvent e) {
                boolean eventosEhInclusao;
                if (e.getKeyCode() == 67 && e.getModifiers() == 2) {
                    e.consume();
                    return;
                }
                IRPFTableAb.this.setSurrendersFocusOnKeystroke(true);
                int row = IRPFTableAb.this.getSelectedRow();
                int col = IRPFTableAb.this.getSelectedColumn();
                if (col == 0) {
                    return;
                }
                if (e.getKeyCode() == 10) {
                    IRPFTableAb.this.setSurrendersFocusOnKeystroke(true);
                    if (row != -1 && col != -1) {
                        if (!IRPFTableAb.this.isCellEditable(row, col)) {
                            IRPFTableAb.this.proximaCelula(row, col);
                            return;
                        }
                        IRPFTableAb.this.editarCelula(row, col);
                    }
                }
                if (e.getKeyCode() == 127) return;
                if (e.getKeyCode() == 112) {
                    return;
                }
                int ch = e.getKeyCode();
                boolean bl = eventosEhInclusao = ch != 9 && ch != 10 && ch != 8 && ch != 127 && ch != 37 && ch != 39 && ch != 38 && ch != 40 && ch != 16 && ch != 18 && !e.isAltDown() && !e.isShiftDown() && !e.isAltGraphDown() && !e.isControlDown();
                if (eventosEhInclusao && IRPFTableAb.this.getModel().isCellEditable(row, col)) {
                    if (row != -1 && col != -1) {
                        PPGDCellEditorIf cellEditor = (PPGDCellEditorIf)((Object)IRPFTableAb.this.getCellEditor(row, col));
                        if (cellEditor.getEditCampo() instanceof JEditValor) {
                            boolean ehCaracterValido;
                            boolean bl2 = ehCaracterValido = Character.isDigit(e.getKeyChar()) || e.getKeyChar() == '-' || e.getKeyChar() == ',' || e.getKeyCode() == 10;
                            if (!ehCaracterValido) {
                                this.cancelaKeyTyped(e, cellEditor);
                                return;
                            }
                        }
                        IRPFTableAb.this.setValueAt("", row, col);
                        IRPFTableAb.this.veioDoKeyListener = e.getKeyChar();
                        return;
                    }
                    if (!(IRPFTableAb.this.getCellEditor(0, 0) instanceof PPGDCellEditorIf)) return;
                    PPGDCellEditorIf cellEditor = (PPGDCellEditorIf)((Object)IRPFTableAb.this.getCellEditor(0, 0));
                    this.cancelaKeyTyped(e, cellEditor);
                    return;
                }
                IRPFTableAb.this.setSurrendersFocusOnKeystroke(false);
            }

            private void cancelaKeyTyped(KeyEvent e, PPGDCellEditorIf cellEditor) {
                IRPFTableAb.this.setSurrendersFocusOnKeystroke(false);
                e.setKeyChar('\uffff');
                e.consume();
                UIManager.getLookAndFeel().provideErrorFeedback(cellEditor.getEditCampo().getComponenteFoco());
                cellEditor.getEditCampo().getInformacao().forcaDisparoObservadores();
            }
        };
        this.addKeyListener(this.defaultKeyAdapter);
    }

    protected void configurarKeyListenerEditor() {
        this.addKeyListener(new KeyAdapter(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void keyPressed(KeyEvent e) {
                boolean ehCaracterValido;
                boolean eventosEhInclusao;
                IRPFTableAb.this.setSurrendersFocusOnKeystroke(true);
                int row = IRPFTableAb.this.getSelectedRow();
                int col = IRPFTableAb.this.getSelectedColumn();
                if (col == 0) {
                    return;
                }
                if (e.getKeyCode() == 10) {
                    IRPFTableAb.this.setSurrendersFocusOnKeystroke(true);
                    if (row != -1 && col != -1) {
                        if (!IRPFTableAb.this.isCellEditable(row, col)) {
                            IRPFTableAb.this.proximaCelula(row, col);
                            return;
                        }
                        IRPFTableAb.this.editarCelula(row, col);
                    } else {
                        IRPFTableAb.this.proximaCelula(0, 0);
                        return;
                    }
                }
                if (e.getKeyCode() == 127) return;
                if (e.getKeyCode() == 112) {
                    return;
                }
                int ch = e.getKeyCode();
                boolean bl = eventosEhInclusao = ch != 9 && ch != 10 && ch != 127 && ch != 37 && ch != 39 && ch != 38 && ch != 40 && ch != 16 && ch != 18 && ch != 8 && !e.isAltDown() && !e.isShiftDown() && !e.isAltGraphDown() && !e.isControlDown();
                if (!eventosEhInclusao) {
                    IRPFTableAb.this.setSurrendersFocusOnKeystroke(false);
                    return;
                }
                if (row == -1) return;
                if (col == -1) return;
                if (!IRPFTableAb.this.isCellEditable(row, col)) return;
                PPGDCellEditorIf cellEditor = (PPGDCellEditorIf)((Object)IRPFTableAb.this.getCellEditor(row, col));
                boolean bl2 = ehCaracterValido = Character.isDigit(e.getKeyChar()) || e.getKeyChar() == '-' || e.getKeyChar() == ',' || e.getKeyCode() == 10;
                if (!ehCaracterValido) {
                    this.cancelaKeyTyped(e, cellEditor);
                    return;
                }
                IRPFTableAb.this.setValueAt("", row, col);
                IRPFTableAb.this.veioDoKeyListener = e.getKeyChar();
            }

            private void cancelaKeyTyped(KeyEvent e, PPGDCellEditorIf cellEditor) {
                IRPFTableAb.this.setSurrendersFocusOnKeystroke(false);
                e.setKeyChar('\uffff');
                e.consume();
                UIManager.getLookAndFeel().provideErrorFeedback(cellEditor.getEditCampo().getComponenteFoco());
                cellEditor.getEditCampo().getInformacao().forcaDisparoObservadores();
            }
        });
    }

    protected boolean hasToolTip() {
        return true;
    }

    protected void configurarToolTip() {
        if (this.hasToolTip()) {
            ToolTipManager.sharedInstance().registerComponent(this);
            this.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseMoved(MouseEvent me) {
                    String info;
                    IRPFTableAb.this.setToolTipText("");
                    int lin = IRPFTableAb.this.rowAtPoint(new Point(me.getX(), me.getY()));
                    int col = IRPFTableAb.this.columnAtPoint(new Point(me.getX(), me.getY()));
                    String msg = null;
                    if (col != -1 && lin != -1 && col != 0 && (info = ((IRPFTableModelAb)IRPFTableAb.this.getModel()).getValorExibir(lin, col)) != null) {
                        msg = "<HTML>" + info + "</HTML>";
                    }
                    IRPFTableAb.this.setToolTipText(msg);
                }
            });
        }
    }

    protected void setaDefaultRenderers() {
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public void preparaEditores() {
        TableColumnModel cm = this.getColumnModel();
        this.setEditorDefault(new PPGDDefaultEditor((JEditCampo)new JEditValor((Informacao)new Valor())));
        this.getEditorDefault().setClickCountToStart(1);
        Font fonteDefault = new JLabel().getFont();
        this.getEditorDefault().getEditCampo().getComponenteEditor().setFont(fonteDefault);
        ((JTextField)this.getEditorDefault().getComponent()).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (IRPFTableAb.this.isEditing()) {
                    int row = IRPFTableAb.this.getEditingRow();
                    int col = IRPFTableAb.this.getEditingColumn();
                    IRPFTableAb.this.getColumnModel().getColumn(col).getCellEditor().stopCellEditing();
                    IRPFTableAb.this.proximaCelula(row, col);
                }
            }
        });
        this.getEditorDefault().getComponent().addFocusListener(new FocusAdapter(){
            boolean keyListener = false;
            private int linhaEditada = -1;
            private int colunaEditada = -1;

            @Override
            public void focusGained(FocusEvent e) {
                String textoAjustado;
                this.linhaEditada = IRPFTableAb.this.getEditingRow();
                this.colunaEditada = IRPFTableAb.this.getEditingColumn();
                if (IRPFTableAb.this.veioDoKeyListener != ' ') {
                    ((JTextField)IRPFTableAb.this.getEditorDefault().getComponent()).setText(String.valueOf(IRPFTableAb.this.veioDoKeyListener));
                    IRPFTableAb.this.veioDoKeyListener = (char)32;
                    this.keyListener = true;
                }
                final String texto = textoAjustado = ((JTextField)IRPFTableAb.this.getEditorDefault().getComponent()).getText().trim();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int pos = texto.length();
                        if (keyListener) {
                            ((JTextField)IRPFTableAb.this.getEditorDefault().getComponent()).setSelectionStart(1);
                            ((JTextField)IRPFTableAb.this.getEditorDefault().getComponent()).setSelectionEnd(1);
                            keyListener = false;
                        } else {
                            ((JTextField)IRPFTableAb.this.getEditorDefault().getComponent()).setSelectionStart(0);
                            ((JTextField)IRPFTableAb.this.getEditorDefault().getComponent()).setSelectionEnd(pos);
                        }
                    }
                });
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (this.colunaEditada >= 0) {
                    if (e.getOppositeComponent() == null) {
                        IRPFTableAb.this.getColumnModel().getColumn(this.colunaEditada).getCellEditor().stopCellEditing();
                    }
                    IRPFTableAb.this.executaValidacaoAposEdicao(this.colunaEditada, this.linhaEditada);
                }
            }
        });
        ((JTextField)this.getEditorDefault().getComponent()).addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (IRPFTableAb.this.isEditing() && e.getKeyCode() == 10) {
                    int row = IRPFTableAb.this.getEditingRow();
                    int col = IRPFTableAb.this.getEditingColumn();
                    IRPFTableAb.this.getColumnModel().getColumn(col).getCellEditor().stopCellEditing();
                    IRPFTableAb.this.proximaCelula(row, col);
                }
            }
        });
        for (int i = 0; i < cm.getColumnCount(); ++i) {
            this.getColumnModel().getColumn(i).setCellEditor(this.instanciaCellEditor(i));
        }
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        TableCellEditor edt = super.getCellEditor(row, column);
        if (edt instanceof PPGDDefaultEditor) {
            ((PPGDDefaultEditor)edt).getComponent().getAccessibleContext().setAccessibleName(this.getColumnName(column));
        }
        return edt;
    }

    public void preparaEditorInteiro() {
        TableColumnModel cm = this.getColumnModel();
        this.setEditorInteiro(new PPGDDefaultEditor((JEditCampo)new JEditValor((Informacao)new Valor(null, "valor", 3, 0))));
        this.getEditorInteiro().setClickCountToStart(1);
        Font fonteDefault = new JLabel().getFont();
        this.getEditorInteiro().getEditCampo().getComponenteEditor().setFont(fonteDefault);
        ((JTextField)this.getEditorInteiro().getComponent()).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (IRPFTableAb.this.isEditing()) {
                    int row = IRPFTableAb.this.getEditingRow();
                    int col = IRPFTableAb.this.getEditingColumn();
                    IRPFTableAb.this.getColumnModel().getColumn(col).getCellEditor().stopCellEditing();
                    IRPFTableAb.this.proximaCelula(row, col);
                }
            }
        });
        this.getEditorInteiro().getComponent().addFocusListener(new FocusAdapter(){
            boolean keyListener = false;
            private int linhaEditada = -1;
            private int colunaEditada = -1;

            @Override
            public void focusGained(FocusEvent e) {
                String textoAjustado;
                this.linhaEditada = IRPFTableAb.this.getEditingRow();
                this.colunaEditada = IRPFTableAb.this.getEditingColumn();
                if (IRPFTableAb.this.veioDoKeyListener != ' ') {
                    ((JTextField)IRPFTableAb.this.getEditorInteiro().getComponent()).setText(String.valueOf(IRPFTableAb.this.veioDoKeyListener));
                    IRPFTableAb.this.veioDoKeyListener = (char)32;
                    this.keyListener = true;
                }
                final String texto = textoAjustado = ((JTextField)IRPFTableAb.this.getEditorInteiro().getComponent()).getText().trim();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int pos = texto.length();
                        if (keyListener) {
                            ((JTextField)IRPFTableAb.this.getEditorInteiro().getComponent()).setSelectionStart(1);
                            ((JTextField)IRPFTableAb.this.getEditorInteiro().getComponent()).setSelectionEnd(1);
                            keyListener = false;
                        } else {
                            ((JTextField)IRPFTableAb.this.getEditorInteiro().getComponent()).setSelectionStart(0);
                            ((JTextField)IRPFTableAb.this.getEditorInteiro().getComponent()).setSelectionEnd(pos);
                        }
                    }
                });
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (this.colunaEditada >= 0) {
                    if (e.getOppositeComponent() == null) {
                        IRPFTableAb.this.getColumnModel().getColumn(this.colunaEditada).getCellEditor().stopCellEditing();
                    }
                    IRPFTableAb.this.executaValidacaoAposEdicao(this.colunaEditada, this.linhaEditada);
                }
            }
        });
        ((JTextField)this.getEditorInteiro().getComponent()).addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (IRPFTableAb.this.isEditing() && e.getKeyCode() == 10) {
                    int row = IRPFTableAb.this.getEditingRow();
                    int col = IRPFTableAb.this.getEditingColumn();
                    IRPFTableAb.this.getColumnModel().getColumn(col).getCellEditor().stopCellEditing();
                    IRPFTableAb.this.proximaCelula(row, col);
                }
            }
        });
        for (int i = 0; i < cm.getColumnCount(); ++i) {
            this.getColumnModel().getColumn(i).setCellEditor(this.instanciaCellEditor(i));
        }
    }

    protected TableCellEditor instanciaCellEditor(int col) {
        if (col == 0) {
            return new JComponentCellEditor();
        }
        if (col == 6 && this instanceof TableRendPF) {
            return this.getEditorInteiro();
        }
        return this.getEditorDefault();
    }

    public void selecionaCelula(int col, int lin) {
        this.setRowSelectionInterval(lin, lin);
        this.setColumnSelectionInterval(col, col);
    }

    public void editarCelula(int pRow, int pCol) {
        this.editCellAt(pRow, pCol);
        ((PPGDCellEditorIf)((Object)this.getColumnModel().getColumn(pCol).getCellEditor())).getEditCampo().getComponenteEditor().requestFocusInWindow();
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (ks.getKeyCode() == 10) {
            return true;
        }
        return super.processKeyBinding(ks, e, condition, pressed);
    }

    public void setObjetoNegocio(ObjetoNegocio obj) {
        ((IRPFTableModelAb)this.getModel()).setObjetoNegocio(obj);
    }

    @Override
    public void editingStopped(ChangeEvent e) {
        super.editingStopped(e);
        this.repaint();
    }

    public void setEditorDefault(PPGDDefaultEditor editorDefault) {
        this.editorDefault = editorDefault;
    }

    public PPGDDefaultEditor getEditorDefault() {
        return this.editorDefault;
    }

    public void setEditorInteiro(PPGDDefaultEditor editorInteiro) {
        this.editorInteiro = editorInteiro;
    }

    public PPGDDefaultEditor getEditorInteiro() {
        return this.editorInteiro;
    }

    protected void executaValidacaoAposEdicao(int col, int row) {
    }

    protected void configuraLayoutHeader() {
        this.getTableHeader().setReorderingAllowed(false);
        this.getTableHeader().setForeground(new Color(0, 76, 119));
        this.getTableHeader().setFont(this.getTableHeader().getFont().deriveFont(1));
    }

    protected void configuraLayout() {
        this.setShowGrid(true);
        this.setRowHeight(20);
    }

    public void proximaCelula(int row, int col) {
    }

    public KeyAdapter getDefaultKeyAdapter() {
        return this.defaultKeyAdapter;
    }

    public KeyAdapter setDefaultKeyAdapter(KeyAdapter defaultKeyAdapter) {
        this.defaultKeyAdapter = defaultKeyAdapter;
        return this.defaultKeyAdapter;
    }
}

