/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.JanelaPrincipalIRPF;
import serpro.ppgd.irpf.gui.util.GuiUtil;

public class IRPFLabelInfo
extends JLabel {
    private static final long serialVersionUID = 1L;
    private String mensagem;

    public IRPFLabelInfo() {
        this.setText(null);
        this.setIcon(GuiUtil.getImage("/icones/png10px/info.png"));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                IRPFLabelInfo.this.exibirMensagem(evt);
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                if (IRPFLabelInfo.this.getTopLevelAncestor() instanceof JanelaPrincipalIRPF) {
                    PlataformaPPGD.getPlataforma().getJanelaPrincipal().setCursor(Cursor.getPredefinedCursor(12));
                } else {
                    IRPFLabelInfo.this.setCursor(Cursor.getPredefinedCursor(12));
                }
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                if (IRPFLabelInfo.this.getTopLevelAncestor() instanceof JanelaPrincipalIRPF) {
                    PlataformaPPGD.getPlataforma().getJanelaPrincipal().setCursor(Cursor.getDefaultCursor());
                } else {
                    IRPFLabelInfo.this.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
        });
    }

    public IRPFLabelInfo(String mensagem) {
        this();
        this.mensagem = mensagem;
    }

    public IRPFLabelInfo(String mensagem, boolean iconeGrande) {
        this(mensagem);
        if (iconeGrande) {
            this.setIcon(GuiUtil.getImage("/icones/png16px/info.png"));
        }
    }

    public void exibirMensagem(MouseEvent evt) {
        GuiUtil.mostrarInfo((Component)ControladorGui.getJanelaPrincipal(), this.mensagem);
    }

    public void setMensagem(String mensagem) {
        this.mensagem = mensagem;
    }

    public String getMensagem() {
        return this.mensagem;
    }
}

