/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.PainelDeclaracoesPreenchimento;
import serpro.ppgd.irpf.gui.PainelDeclaracoesTransmitidas;
import serpro.ppgd.irpf.gui.PainelDemonstrativoAb;
import serpro.ppgd.irpf.gui.PainelIRPFBemVindos;
import serpro.ppgd.irpf.gui.dialogs.PainelAbaBemVindos;
import serpro.ppgd.irpf.gui.dialogs.PainelCriarNovaDeclaracao;
import serpro.ppgd.irpf.gui.listener.DemonstrativoListener;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.util.AplicacaoPropertiesUtil;
import serpro.ppgd.irpf.util.MensagemUtil;

public class IRPFBemVindos
extends PainelDemonstrativoAb
implements DemonstrativoListener {
    private PainelDeclaracoesPreenchimento painelDeclaracoesPreenchimento;
    private PainelDeclaracoesTransmitidas painelDeclaracoesTransmitidas;
    private PainelCriarNovaDeclaracao painelNovaDeclaracao;
    private PainelAbaBemVindos painelAbaBemVindos;
    public static final String TAB_NAME_BEM_VINDOS = "Boas-vindas";
    public static final String TAB_NAME_NOVA = "Nova";
    public static final String TAB_NAME_EM_PREENCHIMENTO = "Em Preenchimento";
    public static final String TAB_NAME_TRANSMITIDAS = "Transmitidas";
    private JLabel lblExercicio;
    private PainelIRPFBemVindos painelIRPFBemVindos5;
    private JTabbedPane tabPaneDeclaracoes;

    public IRPFBemVindos() {
        this.initComponents();
        this.montarTabPane(0);
    }

    public void montarTabPane(int abaSelecionada) {
        this.configListeners();
        try {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        IRPFBemVindos.this.preencherListaDeclaracoesRecentes();
                    }
                });
            } else {
                this.preencherListaDeclaracoesRecentes();
            }
        }
        catch (Exception e) {
            ControladorGui.tratarException(e);
        }
        this.painelDeclaracoesPreenchimento = new PainelDeclaracoesPreenchimento();
        this.painelDeclaracoesTransmitidas = new PainelDeclaracoesTransmitidas();
        this.painelNovaDeclaracao = new PainelCriarNovaDeclaracao();
        this.painelAbaBemVindos = new PainelAbaBemVindos();
        this.tabPaneDeclaracoes.removeAll();
        this.tabPaneDeclaracoes.addTab(TAB_NAME_BEM_VINDOS, new ImageIcon(this.getClass().getResource("/icones/png16px/Icon_barraTitulo_16px.png")), this.painelAbaBemVindos);
        this.tabPaneDeclaracoes.addTab(TAB_NAME_NOVA, new ImageIcon(this.getClass().getResource("/icones/png20px/MN_novo.png")), this.painelNovaDeclaracao);
        this.tabPaneDeclaracoes.addTab(TAB_NAME_EM_PREENCHIMENTO, new ImageIcon(this.getClass().getResource("/icones/png16px/Icon_barraTitulo_16px.png")), this.painelDeclaracoesPreenchimento);
        this.tabPaneDeclaracoes.addTab(TAB_NAME_TRANSMITIDAS, new ImageIcon(this.getClass().getResource("/icones/png16px/AB_transmitido.png")), this.painelDeclaracoesTransmitidas);
        this.tabPaneDeclaracoes.setMnemonicAt(0, 79);
        this.tabPaneDeclaracoes.setMnemonicAt(1, 78);
        this.tabPaneDeclaracoes.setMnemonicAt(2, 69);
        this.tabPaneDeclaracoes.setMnemonicAt(3, 82);
        this.tabPaneDeclaracoes.setSelectedIndex(abaSelecionada);
    }

    @Override
    public JComponent getDefaultFocus() {
        return this.tabPaneDeclaracoes;
    }

    @Override
    public ImageIcon getImagemTitulo() {
        return GuiUtil.getImage("/icones/png40px/DE_rfb.png");
    }

    @Override
    public String getTituloPainel() {
        Object titulo = "";
        titulo = this.getTabbedPane().getSelectedIndex() == 1 ? MensagemUtil.getMensagem((String)"bem_vindos") + " Nova Declara\u00e7\u00e3o" : (this.getTabbedPane().getSelectedIndex() == 2 ? MensagemUtil.getMensagem((String)"bem_vindos") + " Declara\u00e7\u00e3o em Preenchimento" : (this.getTabbedPane().getSelectedIndex() == 3 ? MensagemUtil.getMensagem((String)"bem_vindos") + " Declara\u00e7\u00e3o Transmitida" : MensagemUtil.getMensagem((String)"bem_vindos")));
        return titulo;
    }

    protected void tratarMudancaTabbedPane() {
        this.getAccessibleContext().setAccessibleName(this.getTituloPainel());
        ControladorGui.obterPainelContainer().cabecalhoAlterado(this.getTituloPainel());
    }

    protected void configListeners() {
        this.getTabbedPane().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                JComponent component = IRPFBemVindos.this.getDefaultFocus();
                IRPFBemVindos.this.tratarMudancaTabbedPane();
                component.requestFocusInWindow();
            }
        });
    }

    private void initComponents() {
        this.painelIRPFBemVindos5 = new PainelIRPFBemVindos();
        this.lblExercicio = new JLabel();
        this.tabPaneDeclaracoes = new JTabbedPane();
        this.setBackground(new Color(241, 245, 249));
        this.setVerifyInputWhenFocusTarget(false);
        this.setLayout(new GridBagLayout());
        this.painelIRPFBemVindos5.setBorder(null);
        this.painelIRPFBemVindos5.setPreferredSize(new Dimension(900, 600));
        this.lblExercicio.setFont(this.lblExercicio.getFont().deriveFont(this.lblExercicio.getFont().getStyle() | 1, this.lblExercicio.getFont().getSize() + 29));
        this.lblExercicio.setForeground(new Color(87, 184, 237));
        this.lblExercicio.setText(AplicacaoPropertiesUtil.getExercicio());
        this.tabPaneDeclaracoes.setBackground(new Color(255, 255, 255));
        this.tabPaneDeclaracoes.setBorder(null);
        GroupLayout painelIRPFBemVindos5Layout = new GroupLayout(this.painelIRPFBemVindos5);
        this.painelIRPFBemVindos5.setLayout(painelIRPFBemVindos5Layout);
        painelIRPFBemVindos5Layout.setHorizontalGroup(painelIRPFBemVindos5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(painelIRPFBemVindos5Layout.createSequentialGroup().addGroup(painelIRPFBemVindos5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(painelIRPFBemVindos5Layout.createSequentialGroup().addGap(299, 299, 299).addComponent(this.lblExercicio, -2, 181, -2)).addGroup(painelIRPFBemVindos5Layout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.tabPaneDeclaracoes, -2, 765, -2))).addContainerGap(115, Short.MAX_VALUE)));
        painelIRPFBemVindos5Layout.setVerticalGroup(painelIRPFBemVindos5Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, painelIRPFBemVindos5Layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.lblExercicio).addGap(97, 97, 97).addComponent(this.tabPaneDeclaracoes, -2, 359, -2).addGap(82, 82, 82)));
        this.add((Component)this.painelIRPFBemVindos5, new GridBagConstraints());
    }

    public void atualizarListaDeclaracoesRecentes() {
        this.preencherListaDeclaracoesRecentes();
    }

    public void atualizaListaDeclaracoesPreenchimento() {
        this.painelDeclaracoesPreenchimento.atualizarListaDeclaracoesPreenchimento();
    }

    public void atualizaListaDeclaracoesTransmitidas() {
        this.painelDeclaracoesTransmitidas.atualizarListaDeclaracoesTransmitidas();
    }

    private void preencherListaDeclaracoesRecentes() {
    }

    @Override
    public void demonstrativoAberto() {
    }

    @Override
    public void demonstrativoFechado() {
    }

    @Override
    public void demonstrativoSalvo() {
    }

    @Override
    public void mudouNumeroDemonstrativos() {
        this.preencherListaDeclaracoesRecentes();
        this.atualizaListaDeclaracoesPreenchimento();
        this.atualizaListaDeclaracoesTransmitidas();
    }

    @Override
    public void alterouOpcaoTributacao(DeclaracaoIRPF dec) {
    }

    @Override
    public boolean demonstrativoVaiFechar() {
        return true;
    }

    @Override
    public boolean isTelaComAjuda() {
        return false;
    }

    public void configCursor(JComponent component) {
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent evt) {
                PlataformaPPGD.getPlataforma().getJanelaPrincipal().setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                PlataformaPPGD.getPlataforma().getJanelaPrincipal().setCursor(Cursor.getDefaultCursor());
            }
        });
    }

    @Override
    public void demonstrativoVaiGravar() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    @Override
    public void demonstrativoGravado() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    @Override
    public boolean isTelaComFavoritos() {
        return false;
    }

    public void repaintPaineis() {
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                IRPFBemVindos.this.repaint();
            }
        };
        new Thread(t).start();
    }

    @Override
    public void preExibir() {
        this.painelNovaDeclaracao.limparTela();
    }

    @Override
    public JTabbedPane getTabbedPane() {
        return this.tabPaneDeclaracoes;
    }

    public void selecionarAbaNovaDeclaracao() {
        this.acionarAba(TAB_NAME_NOVA, true);
        this.painelNovaDeclaracao.limparTela();
    }

    public void selecionarAbaNovaDeclaracaoAnoAnterior() {
        this.acionarAba(TAB_NAME_NOVA, true);
        this.painelNovaDeclaracao.selecionarCriacaoAnoAnterior();
    }

    public void selecionarAbaNovaDeclaracaoPrePreenchida() {
        this.acionarAba(TAB_NAME_NOVA, true);
        this.painelNovaDeclaracao.selecionarCriacaoPrePreenchida();
    }

    @Override
    public String getMensagemTela() {
        return "Use a tecla F11 para informa\u00e7\u00f5es de ajuda de acessibilidade";
    }
}

