/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import serpro.ppgd.irpf.util.ConstantesGlobaisIRPF;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Valor;

public class DefaultIRPFCellRenderer
implements TableCellRenderer {
    private boolean temSumario = false;

    public DefaultIRPFCellRenderer() {
    }

    public DefaultIRPFCellRenderer(boolean temSumario) {
        this.temSumario = temSumario;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel retorno = new JLabel();
        retorno.setOpaque(true);
        String texto = value instanceof Informacao ? ((Informacao)value).formatado() : value.toString();
        retorno.setText(texto);
        if (!table.getModel().isCellEditable(row, column)) {
            retorno.setBackground(new JPanel().getBackground());
        } else {
            retorno.setBackground(Color.WHITE);
            retorno.setFont(retorno.getFont().deriveFont(0));
        }
        if (value instanceof Valor) {
            retorno.setHorizontalAlignment(4);
        } else if (value instanceof Alfa) {
            retorno.setHorizontalAlignment(2);
        } else {
            retorno.setHorizontalAlignment(0);
        }
        if (hasFocus) {
            retorno.setForeground(Color.WHITE);
            retorno.setBackground(table.getSelectionBackground());
        }
        if (this.temSumario && row == table.getRowCount() - 1) {
            retorno.setFont(retorno.getFont().deriveFont(1));
        }
        JLabel jComp = retorno;
        jComp.setBorder(ConstantesGlobaisIRPF.bordaVazia);
        return retorno;
    }
}

