/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.app.acoes;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import serpro.ppgd.app.acoes.ActionAb;
import serpro.ppgd.app.acoes.LoginGovAction;
import serpro.ppgd.cacheni.CacheNI;
import serpro.ppgd.formatosexternos.txt.excecao.GeracaoTxtException;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.exception.AplicacaoException;
import serpro.ppgd.irpf.exception.BarramentoException;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.nuvem.PainelRecuperarDeclaracaoOnline;
import serpro.ppgd.irpf.gui.update.PainelDownloadAtualizacoes;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.nuvem.BarramentoIRPFService;
import serpro.ppgd.irpf.nuvem.BarramentoIRPFUtil;
import serpro.ppgd.irpf.nuvem.UsuarioLogado;
import serpro.ppgd.irpf.txt.gravacaorestauracao.ImportadorTxt;
import serpro.ppgd.irpf.util.IRPFUtil;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.irpf.util.TipoDeclaracaoAES;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.util.UtilitariosString;

public class RecuperarDecOnlineAction
extends ActionAb {
    private static final long serialVersionUID = 1L;

    public RecuperarDecOnlineAction() {
    }

    public RecuperarDecOnlineAction(String cpf) {
    }

    @Override
    public void executarAcao(ActionEvent actionEvent) {
        this.executarRecuperarDecOnLine();
    }

    public String obterCPFDeclarante(String cpfResponsavel) throws AplicacaoException {
        PainelRecuperarDeclaracaoOnline painelRecuperarDec = new PainelRecuperarDeclaracaoOnline(cpfResponsavel);
        GuiUtil.exibeDialog(painelRecuperarDec, true, "Recuperar Declara\u00e7\u00e3o On-line", false);
        String cpfDeclarante = painelRecuperarDec.obterCPFDeclarante();
        if (cpfDeclarante == null) {
            throw new AplicacaoException("Opera\u00e7\u00e3o cancelada.", false);
        }
        return cpfDeclarante;
    }

    public void executarRecuperarDecOnLine() {
        UsuarioLogado usuarioGov = BarramentoIRPFService.getUsuarioLogado();
        if (usuarioGov == null) {
            try {
                new LoginGovAction().iniciarLogon(this::executarRecuperarDecOnLine);
            }
            catch (AplicacaoException e) {
                GuiUtil.mostrarErro(ControladorGui.getJanelaPrincipal(), e.getMessage());
                return;
            }
        } else {
            this.executarRecuperarDecOnLine(usuarioGov);
        }
    }

    public void executarRecuperarDecOnLine(UsuarioLogado usuarioGov) {
        String cpfDeclarante;
        try {
            cpfDeclarante = this.obterCPFDeclarante(usuarioGov.getCpf());
        }
        catch (AplicacaoException e) {
            GuiUtil.mostrarErro(ControladorGui.getJanelaPrincipal(), e.getMessage());
            return;
        }
        final PainelDownloadAtualizacoes painelDownload = new PainelDownloadAtualizacoes("Recuperando Declara\u00e7\u00e3o On-line", GuiUtil.getImage("/icones/png20px/icon_recuperar_online_20x26.png"));
        painelDownload.getLblDescricao().setText("Recuperando...");
        painelDownload.getLblPercentual().setText("");
        painelDownload.getProgressBar().setIndeterminate(true);
        final SwingWorker<String, Void> sw = new SwingWorker<String, Void>(){

            @Override
            protected String doInBackground() throws Exception {
                IRPFUtil.setEstadoSistema((int)2);
                try {
                    RecuperarDecOnlineAction.this.recuperarDeclaracao(cpfDeclarante);
                }
                catch (AplicacaoException | BarramentoException e) {
                    String string = e.getMessage();
                    return string;
                }
                finally {
                    IRPFUtil.setEstadoSistema((int)0);
                }
                return null;
            }

            @Override
            protected void done() {
                String msgErro;
                try {
                    msgErro = (String)this.get();
                }
                catch (InterruptedException | CancellationException e) {
                    msgErro = "Opera\u00e7\u00e3o cancelada.";
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                    msgErro = MensagemUtil.getMensagem((String)"nuvem.erro.inesperado");
                }
                finally {
                    GuiUtil.fecharDialog(painelDownload);
                }
                if (msgErro == null) {
                    GuiUtil.mostrarInfo("nuvem.info.declaracao.recuperada");
                } else {
                    GuiUtil.mostrarErro(GuiUtil.getParent(), msgErro);
                }
            }
        };
        painelDownload.getBtnCancelar().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                sw.cancel(true);
            }
        });
        SwingUtilities.invokeLater(() -> GuiUtil.exibeDialog(PlataformaPPGD.getPlataforma().getJanelaPrincipal(), painelDownload, true, "Salvar Declara\u00e7\u00e3o On-line", false, null, null, false, 2, false, true));
        sw.execute();
    }

    public void recuperarDeclaracao(String cpf) throws AplicacaoException, BarramentoException {
        String declaracaoCompactada = BarramentoIRPFService.recuperarDecOnline((String)ConstantesGlobais.EXERCICIO, (String)cpf);
        ByteArrayInputStream bais = new ByteArrayInputStream(BarramentoIRPFUtil.descompactarDeclaracao((String)declaracaoCompactada));
        String cpfFormatado = UtilitariosString.formataCPF((String)cpf);
        if (!IRPFFacade.existeDeclaracao((String)cpf, (String)"0000000000") || GuiUtil.mostrarConfirma(ControladorGui.getJanelaPrincipal(), MensagemUtil.getMensagem((String)"nuvem.info.ja.existe.declaracao", (String[])new String[]{cpfFormatado}))) {
            ImportadorTxt importador = new ImportadorTxt();
            try {
                DeclaracaoIRPF dec = importador.recuperarDeclaracaoPersistenciaOnline((InputStream)bais, false, true, TipoDeclaracaoAES.AJUSTE.getTipo());
                CacheNI.getInstancia().importarNIs((ObjetoNegocio)dec, true);
            }
            catch (IOException | GeracaoTxtException e) {
                e.printStackTrace();
                throw new AplicacaoException("nuvem.erro.recuperar.online", e);
            }
            ControladorGui.atualizarNumeroDemonstrativos();
        }
    }

    @Override
    public boolean isDesabilitadoVersaoBeta() {
        return true;
    }

    @Override
    public boolean isFecharDemonstrativoExigido() {
        return true;
    }

    @Override
    protected boolean podeExecutarEmReadOnly() {
        return false;
    }
}

