/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.gcap.table;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import serpro.ppgd.irpf.gui.TableListaCellRenderer;
import serpro.ppgd.irpf.gui.TableListaModel;
import serpro.ppgd.irpf.gui.gcap.table.GCAPListSelectionModel;
import serpro.ppgd.irpf.gui.gcap.table.GCAPTableAb;
import serpro.ppgd.negocio.Data;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Inteiro;
import serpro.ppgd.negocio.util.UtilitariosString;

public class TableLista
extends GCAPTableAb {
    private static final long serialVersionUID = 1L;
    private int[] colunasNaoOrdenaveis = null;

    public TableLista() {
    }

    public TableLista(TableListaModel model) {
        super((TableModel)model);
        this.configuraTabela();
        this.configuraHeaderTabela();
        this.adicionaListeners();
        this.configurarAcessibilidadeColunas();
    }

    public TableLista(TableListaModel model, int colunaOrdenacao, Integer[] colunasOrdenaveis) {
        this(model);
        this.configuraOrdenacao(colunaOrdenacao, colunasOrdenaveis);
    }

    private void configurarAcessibilidadeColunas() {
        this.removeKeyListener(super.getDefaultKeyAdapter());
        this.setDefaultKeyAdapter(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                TableLista.this.setSurrendersFocusOnKeystroke(true);
                int row = TableLista.this.getSelectedRow();
                int col = TableLista.this.getSelectedColumn();
                if (e.getKeyCode() == 123) {
                    Object txtAviso = "";
                    if (TableLista.this.accessibleRowHeader != null) {
                        String linha = "".equals(TableLista.this.accessibleRowHeader[row]) ? String.valueOf(row + 1) : TableLista.this.accessibleRowHeader[row];
                        txtAviso = "Linha " + linha;
                    } else {
                        txtAviso = "Linha " + String.valueOf(row + 1);
                    }
                    if (TableLista.this.accessibleColumnHeader != null) {
                        String coluna = "".equals(TableLista.this.accessibleColumnHeader[col]) ? "" : TableLista.this.accessibleColumnHeader[col];
                        txtAviso = (String)txtAviso + ". Coluna " + coluna;
                    }
                    if (!"".equals(txtAviso)) {
                        // empty if block
                    }
                }
            }
        });
        this.addKeyListener(this.getDefaultKeyAdapter());
    }

    private void configuraTabela() {
        this.definirSelectionModel();
        this.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent event) {
                AbstractTableModel atm = (AbstractTableModel)event.getSource();
                ((GCAPListSelectionModel)TableLista.this.getSelectionModel()).setRowCount(atm.getRowCount());
            }
        });
        this.setSelectionMode(2);
        this.setColumnSelectionAllowed(false);
        this.setDefaultRenderer(Object.class, (TableCellRenderer)new TableListaCellRenderer());
    }

    protected void definirSelectionModel() {
        this.setSelectionModel(new GCAPListSelectionModel(this.getRowCount()));
    }

    private void configuraHeaderTabela() {
        this.getTableHeader().setReorderingAllowed(false);
        this.getTableHeader().setResizingAllowed(false);
    }

    private void adicionaListeners() {
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent me) {
                TableLista.this.setToolTipText("");
                int aux = TableLista.this.rowAtPoint(new Point(me.getX(), me.getY()));
                if (aux != -1) {
                    Informacao info;
                    int lin = ((TableRowSorter)TableLista.this.getRowSorter()).convertRowIndexToModel(aux);
                    int col = TableLista.this.columnAtPoint(new Point(me.getX(), me.getY()));
                    String msg = null;
                    if (col != -1 && lin != -1 && (info = ((TableListaModel)TableLista.this.getModel()).getInformacaoAt(lin, col)) != null && !info.isVazio()) {
                        msg = "<HTML><B><LEFT>" + UtilitariosString.insereQuebraDeLinha((String)info.formatado(), (int)100, (String)"<br>") + "</LEFT></B></HTML>";
                    }
                    TableLista.this.setToolTipText(msg);
                }
            }
        });
    }

    private void configuraOrdenacao(int colunaOrdenacao, Integer[] colunasOrdenaveis) {
        TableRowSorter<TableListaModel> sorter = this.getTableRowSorter();
        if (colunasOrdenaveis == null) {
            this.inicializaColunasNaoOrdenaveis();
        } else {
            this.setColunasOrdenaveis(colunasOrdenaveis);
        }
        for (int i = 0; i < this.colunasNaoOrdenaveis.length; ++i) {
            sorter.setSortable(this.colunasNaoOrdenaveis[i], false);
        }
        sorter.setComparator(0, new Comparator<Object>(){

            @Override
            public int compare(Object inteiro, Object outroInteiro) {
                if (inteiro instanceof Inteiro && outroInteiro instanceof Inteiro) {
                    return Integer.valueOf(((Inteiro)inteiro).getConteudoInteiro()).compareTo(((Inteiro)outroInteiro).getConteudoInteiro());
                }
                if (inteiro instanceof Data && outroInteiro instanceof Data) {
                    int resultado = 1;
                    try {
                        resultado = ((Data)inteiro).asDate().compareTo(((Data)outroInteiro).asDate());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return resultado;
                }
                return inteiro.toString().compareTo(outroInteiro.toString());
            }
        });
        ArrayList<RowSorter.SortKey> keys = new ArrayList<RowSorter.SortKey>();
        if (colunasOrdenaveis != null) {
            RowSorter.SortKey sk = new RowSorter.SortKey(colunaOrdenacao, SortOrder.ASCENDING);
            keys.add(sk);
        }
        sorter.setSortKeys(keys);
        this.setRowSorter(sorter);
    }

    private void inicializaColunasNaoOrdenaveis() {
        this.colunasNaoOrdenaveis = new int[this.getModel().getColumnCount()];
        for (int i = 0; i < this.colunasNaoOrdenaveis.length; ++i) {
            this.colunasNaoOrdenaveis[i] = i;
        }
    }

    public void setColunasOrdenaveis(Integer[] colunasOrdenaveis) {
        if (colunasOrdenaveis != null && colunasOrdenaveis.length != 0) {
            this.colunasNaoOrdenaveis = new int[this.getModel().getColumnCount() - colunasOrdenaveis.length];
            List<Integer> colunasOrdenaveisList = Arrays.asList(colunasOrdenaveis);
            int j = 0;
            for (int i = 0; i < this.getModel().getColumnCount(); ++i) {
                if (colunasOrdenaveisList.contains(i)) continue;
                this.colunasNaoOrdenaveis[j++] = i;
            }
        }
    }

    protected TableRowSorter<TableListaModel> getTableRowSorter() {
        return new TableRowSorter<TableListaModel>((TableListaModel)this.getModel());
    }

    protected JTableHeader createDefaultTableHeader() {
        return new JTableHeader(this.columnModel){
            private static final long serialVersionUID = 1L;
            private int preferredHeight;
            {
                this.preferredHeight = -1;
            }

            private Component getHeaderRenderer(int columnIndex) {
                TableColumn aColumn = this.getColumnModel().getColumn(columnIndex);
                TableCellRenderer renderer = aColumn.getHeaderRenderer();
                if (renderer == null) {
                    renderer = this.getDefaultRenderer();
                }
                return renderer.getTableCellRendererComponent(this.getTable(), aColumn.getHeaderValue(), false, false, -1, columnIndex);
            }

            private int getPreferredHeight() {
                if (this.preferredHeight == -1) {
                    this.preferredHeight = 0;
                    TableColumnModel columnModel = this.getColumnModel();
                    for (int column = 0; column < columnModel.getColumnCount(); ++column) {
                        Component comp = this.getHeaderRenderer(column);
                        int rendererHeight = comp.getPreferredSize().height;
                        this.preferredHeight = Math.max(this.preferredHeight, rendererHeight);
                    }
                }
                return this.preferredHeight + 3;
            }

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, this.getPreferredHeight());
            }

            @Override
            public void columnAdded(TableColumnModelEvent e) {
                this.preferredHeight = -1;
                super.columnAdded(e);
            }

            @Override
            public void columnRemoved(TableColumnModelEvent e) {
                this.preferredHeight = -1;
                super.columnRemoved(e);
            }
        };
    }

    @Override
    protected void iniciaModelVazio() {
    }
}

