/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.rendpjexigsuspensa;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.layout.GroupLayout;
import serpro.ppgd.gui.xbeans.JEditAlfa;
import serpro.ppgd.gui.xbeans.JEditNI;
import serpro.ppgd.gui.xbeans.JEditValor;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.infraestrutura.util.FontesUtil;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.NavegacaoIf;
import serpro.ppgd.irpf.gui.PainelDemonstrativoAb;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.rendpjexigibilidade.RendPJComExigibilidadeTitular;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;

public class PainelAbaRendPJComExigibilidadeTitularDetalhe
extends PainelDemonstrativoAb {
    private static final long serialVersionUID = 1L;
    private static final String HELP_ID = "Fichas da Declara\u00e7\u00e3o/Rendimentos Tribut\u00e1veis de PJ (Imposto com Exigibilidade Suspensa)/Rendimentos Tribut\u00e1veis de PJ (Imposto com Exigibilidade Suspensa) - Titular";
    private RendPJComExigibilidadeTitular rendPJComExigibilidadeTitular = null;
    private RendPJComExigibilidadeTitular itemInicial = null;
    protected boolean flagNovoItem;
    private boolean emEdicao;
    private JEditValor edtDepositosJudiciaisComExigibilidade;
    private JEditNI edtNIFontePagadora;
    private JEditAlfa edtNomePrincipalFontePagadora;
    private JEditValor edtRendRecebidoPJComExigibilidade;
    private JLabel jLabel1;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JPanel jPanel1;

    public PainelAbaRendPJComExigibilidadeTitularDetalhe(RendPJComExigibilidadeTitular rendPJComExigibilidadeTitular, boolean emEdicao) {
        this.rendPJComExigibilidadeTitular = rendPJComExigibilidadeTitular;
        this.emEdicao = emEdicao;
        if (emEdicao) {
            this.itemInicial = rendPJComExigibilidadeTitular.obterCopia();
        }
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)((Object)this), HELP_ID);
        this.initComponents();
        this.associarInformacao();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel6 = new JLabel();
        this.edtNIFontePagadora = new JEditNI();
        this.jLabel7 = new JLabel();
        this.edtRendRecebidoPJComExigibilidade = new JEditValor();
        this.jLabel8 = new JLabel();
        this.edtDepositosJudiciaisComExigibilidade = new JEditValor();
        this.jLabel5 = new JLabel();
        this.edtNomePrincipalFontePagadora = new JEditAlfa();
        this.jLabel1 = new JLabel();
        this.setBackground(new Color(241, 245, 249));
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.jPanel1.setBorder(BorderFactory.createLineBorder(new Color(211, 222, 232)));
        this.jLabel6.setFont(FontesUtil.FONTE_NORMAL);
        this.jLabel6.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.jLabel6.setText("CPF/CNPJ da fonte pagadora");
        this.jLabel6.setFocusable(false);
        this.jLabel7.setFont(FontesUtil.FONTE_NORMAL);
        this.jLabel7.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.jLabel7.setText("Rendimentos tribut\u00e1veis (imposto com exigibilidade suspensa)");
        this.jLabel8.setFont(FontesUtil.FONTE_NORMAL);
        this.jLabel8.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.jLabel8.setText("Dep\u00f3sitos judiciais do imposto");
        this.jLabel5.setFont(FontesUtil.FONTE_NORMAL);
        this.jLabel5.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.jLabel5.setText("Nome da fonte pagadora");
        this.jLabel5.setFocusable(false);
        this.edtNomePrincipalFontePagadora.setMaxChars(60);
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jLabel8).add((Component)this.jLabel7).add((Component)this.edtNIFontePagadora, -2, 169, -2).add((Component)this.jLabel6).add((Component)this.edtRendRecebidoPJComExigibilidade, -2, 170, -2).add((Component)this.edtDepositosJudiciaisComExigibilidade, -2, 171, -2).add((Component)this.edtNomePrincipalFontePagadora, -2, 395, -2).add((Component)this.jLabel5)).addContainerGap(358, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel6).add(2, 2, 2).add((Component)this.edtNIFontePagadora, -2, -1, -2).addPreferredGap(0).add((Component)this.jLabel5).add(2, 2, 2).add((Component)this.edtNomePrincipalFontePagadora, -2, -1, -2).addPreferredGap(0).add((Component)this.jLabel7).add(2, 2, 2).add((Component)this.edtRendRecebidoPJComExigibilidade, -2, -1, -2).addPreferredGap(0).add((Component)this.jLabel8).add(2, 2, 2).add((Component)this.edtDepositosJudiciaisComExigibilidade, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.linkSize(new Component[]{this.edtDepositosJudiciaisComExigibilidade, this.edtRendRecebidoPJComExigibilidade}, 2);
        this.jLabel6.getAccessibleContext().setAccessibleName("CPF ou CNPJ da fonte pagadora");
        this.edtNIFontePagadora.getAccessibleContext().setAccessibleName("CPF ou CNPJ da fonte pagadora");
        this.edtRendRecebidoPJComExigibilidade.getAccessibleContext().setAccessibleName("Rendimentos tribut\u00e1veis (imposto com exigibilidade suspensa)");
        this.edtDepositosJudiciaisComExigibilidade.getAccessibleContext().setAccessibleName("Dep\u00f3sitos judiciais do imposto");
        this.edtNomePrincipalFontePagadora.getAccessibleContext().setAccessibleName("Nome da fonte pagadora");
        this.jLabel1.setFont(FontesUtil.FONTE_TITULO_NORMAL);
        this.jLabel1.setForeground(new Color(0, 74, 106));
        this.jLabel1.setText("Dados da Fonte Pagadora");
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).add(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jPanel1, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private boolean verificaImposto() {
        boolean confirmou = true;
        if (this.edtRendRecebidoPJComExigibilidade.getInformacao().isVazio() && !this.edtDepositosJudiciaisComExigibilidade.getInformacao().isVazio()) {
            confirmou = GuiUtil.mostrarConfirma((String)"rendpj_exigsusp_semvalor");
            if (confirmou) {
                this.edtNIFontePagadora.getComponenteFoco().requestFocusInWindow();
            } else {
                this.edtRendRecebidoPJComExigibilidade.getComponenteFoco().requestFocusInWindow();
            }
        }
        return confirmou;
    }

    public String getTituloPainel() {
        boolean ehTransmitida = IRPFFacade.getInstancia().getDeclaracao().getCopiaIdentificador().isTransmitida();
        if (this.emEdicao) {
            if (ehTransmitida) {
                return "Detalhe Rendimento Trib. Receb. de PJ com Exigibilidade Suspensa";
            }
            return "Editar Rendimento Trib. Receb. de PJ com Exigibilidade Suspensa";
        }
        return "Novo Rendimento Trib. Receb. de PJ com Exigibilidade Suspensa";
    }

    public JComponent getDefaultFocus() {
        return this.edtNIFontePagadora;
    }

    public void executaVoltar() {
        ControladorGui.acionarPainel((String)NavegacaoIf.PAINEL_REND_TRIB_RECEB_PJ_EXIG_SUSPENSA);
        int posicao = ControladorGui.getDemonstrativoAberto().getColecaoRendPJComExigibilidadeTitular().itens().indexOf(this.rendPJComExigibilidadeTitular);
        ControladorGui.getDemonstrativoAberto().getRendPJComExigibilidade().getColecaoRendPJComExigibilidadeTitular().remove((ObjetoNegocio)this.rendPJComExigibilidadeTitular);
        ControladorGui.getDemonstrativoAberto().getColecaoRendPJComExigibilidadeTitular().itens().add(posicao, this.rendPJComExigibilidadeTitular);
    }

    public boolean isTelaComCancelar() {
        return true;
    }

    public void executaCancelar() {
        if (this.emEdicao) {
            int posicao = ControladorGui.getDemonstrativoAberto().getColecaoRendPJComExigibilidadeTitular().itens().indexOf(this.rendPJComExigibilidadeTitular);
            ControladorGui.getDemonstrativoAberto().getRendPJComExigibilidade().getColecaoRendPJComExigibilidadeTitular().remove((ObjetoNegocio)this.rendPJComExigibilidadeTitular);
            ControladorGui.getDemonstrativoAberto().getColecaoRendPJComExigibilidadeTitular().itens().add(posicao, this.itemInicial);
        } else {
            ControladorGui.getDemonstrativoAberto().getRendPJComExigibilidade().getColecaoRendPJComExigibilidadeTitular().remove((ObjetoNegocio)this.rendPJComExigibilidadeTitular);
        }
        ControladorGui.acionarPainel((String)NavegacaoIf.PAINEL_REND_TRIB_RECEB_PJ_EXIG_SUSPENSA);
    }

    public ImageIcon getImagemTitulo() {
        return GuiUtil.getImage((String)"/icones/png40px/DE_rend_pj_susp.png");
    }

    private void associarInformacao() {
        this.edtNIFontePagadora.setInformacao((Informacao)this.rendPJComExigibilidadeTitular.getNIFontePagadora());
        this.edtNomePrincipalFontePagadora.setInformacao((Informacao)this.rendPJComExigibilidadeTitular.getNomeFontePagadora());
        this.edtDepositosJudiciaisComExigibilidade.setInformacao((Informacao)this.rendPJComExigibilidadeTitular.getDepositoJudicial());
        this.edtRendRecebidoPJComExigibilidade.setInformacao((Informacao)this.rendPJComExigibilidadeTitular.getRendExigSuspensa());
    }

    public boolean isTelaComVoltar() {
        return true;
    }

    public boolean isPodeSair() {
        return this.verificaImposto();
    }

    public String getHelpID() {
        return HELP_ID;
    }

    public boolean isTelaComFavoritos() {
        return false;
    }
}

