/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.rendIsentos;

import java.util.Arrays;
import java.util.List;
import serpro.ppgd.irpf.gui.TableListaModel;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroAuxiliarAb;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroTransporteDetalhado;
import serpro.ppgd.irpf.rendIsentos.RendIsentos;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ElementoTabela;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Valor;

public class TableModelRendIsentos
extends TableListaModel {
    private static final long serialVersionUID = 1L;
    protected List<Colecao<? extends ItemQuadroAuxiliarAb>> rendIsentos;
    protected List<ElementoTabela> tiposRendimentos = CadastroTabelasIRPF.recuperarTiposRendimentosIsentos();

    public TableModelRendIsentos(RendIsentos rendimentosIsentos) {
        super((ObjetoNegocio)rendimentosIsentos);
        this.rendIsentos = rendimentosIsentos.getColecoesRendimentos();
    }

    public void limparRegistrosEmBranco() {
        for (Colecao<? extends ItemQuadroAuxiliarAb> colecao : this.rendIsentos) {
            colecao.excluirRegistrosEmBranco();
        }
    }

    public ItemQuadroAuxiliarAb novoItemRendimento(String tipo) {
        Colecao<? extends ItemQuadroAuxiliarAb> col = this.obterColecaoRendimento(tipo);
        ItemQuadroAuxiliarAb item = null;
        if (col != null) {
            item = (ItemQuadroAuxiliarAb)col.itens().get(col.novoObjeto());
        }
        return item;
    }

    protected Colecao<? extends ItemQuadroAuxiliarAb> obterColecaoRendimento(String tipo) {
        for (int i = 0; i < this.tiposRendimentos.size(); ++i) {
            if (!this.tiposRendimentos.get(i).getConteudo(0).equals(tipo)) continue;
            return this.rendIsentos.get(i);
        }
        return null;
    }

    protected ElementoTabela obterTipoRendimento(int row) {
        ParIndices indices = this.obterIndicesPorLinha(row);
        return this.tiposRendimentos.get(indices.getIndiceColecao());
    }

    protected ParIndices obterIndicesPorLinha(int row) {
        int indiceItemColecao = row;
        ParIndices indices = new ParIndices();
        for (int indiceColecao = 0; indiceColecao < this.rendIsentos.size(); ++indiceColecao) {
            if (indiceItemColecao < this.rendIsentos.get(indiceColecao).itens().size()) {
                indices.setIndiceColecao(indiceColecao);
                indices.setIndiceItemColecao(indiceItemColecao);
                return indices;
            }
            indiceItemColecao -= this.rendIsentos.get(indiceColecao).itens().size();
        }
        return null;
    }

    public ObjetoNegocio getObjetoNegocio(int rowIndex) {
        ParIndices indices = this.obterIndicesPorLinha(rowIndex);
        if (indices != null) {
            return (ObjetoNegocio)this.rendIsentos.get(indices.getIndiceColecao()).itens().get(indices.getIndiceItemColecao());
        }
        return null;
    }

    public void removeObjetoNegocio(Integer[] rowIndexes) {
        Arrays.sort((Object[])rowIndexes);
        for (int i = rowIndexes.length - 1; i >= 0; --i) {
            ParIndices indices = this.obterIndicesPorLinha(rowIndexes[i]);
            if (indices == null) continue;
            this.rendIsentos.get(indices.getIndiceColecao()).itens().remove(indices.getIndiceItemColecao());
        }
        this.fireTableDataChanged();
    }

    public int getColumnCount() {
        return 5;
    }

    public int getRowCount() {
        int count = 0;
        for (Colecao<? extends ItemQuadroAuxiliarAb> itens : this.rendIsentos) {
            count += itens.itens().size();
        }
        return count;
    }

    public Informacao<?> getInformacaoAt(int row, int col) {
        ItemQuadroAuxiliarAb item = (ItemQuadroAuxiliarAb)this.getObjetoNegocio(row);
        if (item != null) {
            switch (col) {
                case 0: {
                    return super.getInformacaoAt(row, col);
                }
                case 1: {
                    Alfa info = new Alfa();
                    info.setConteudo(this.obterTipoRendimento(row).getConteudo(1));
                    return info;
                }
                case 2: {
                    Alfa code = new Alfa();
                    code.setConteudo(this.obterTipoRendimento(row).getConteudo(0));
                    if (RendIsentos.TIPO_RENDISENTO_27.equals(code.naoFormatado())) {
                        return ((ItemQuadroTransporteDetalhado)item).getCpfAlimentante();
                    }
                    return item.getNomeFontePagadora();
                }
                case 3: {
                    if (!item.getTipoBeneficiario().naoFormatado().trim().isEmpty() && !item.getTipoBeneficiario().naoFormatado().equals("-1")) {
                        StringBuilder conteudo = new StringBuilder("<html>");
                        conteudo.append(item.getTipoBeneficiario().getConteudoAtual(1));
                        if (item.getTipoBeneficiario().naoFormatado().equals("Dependente") && !item.getCpfBeneficiario().isVazio()) {
                            conteudo.append(":<br>");
                            conteudo.append(item.getCpfBeneficiario().formatado());
                        }
                        conteudo.append("</html>");
                        Alfa info = new Alfa();
                        info.setConteudo(conteudo.toString());
                        return info;
                    }
                    return null;
                }
                case 4: {
                    Alfa code = new Alfa();
                    code.setConteudo(this.obterTipoRendimento(row).getConteudo(0));
                    if (RendIsentos.TIPO_RENDISENTO_10.equals(code.naoFormatado())) {
                        return item.getValor().operacao('+', (Valor)item.getValor13Salario());
                    }
                    return item.getValorRendimento();
                }
            }
        }
        return null;
    }

    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return super.getColumnName(column);
            }
            case 1: {
                return "<html><center>Tipo de Rendimento</center></html>";
            }
            case 2: {
                return "<html><center>Fonte Pagadora</center></html>";
            }
            case 3: {
                return "<html><center>Benefici\u00e1rio</center></html>";
            }
            case 4: {
                return "<html><center>Valor (R$)</center></html>";
            }
        }
        return "";
    }

    public void removerItem(ItemQuadroAuxiliarAb item, String tipoRendimento) {
        Colecao<? extends ItemQuadroAuxiliarAb> colecao = this.obterColecaoRendimento(tipoRendimento);
        if (colecao != null) {
            colecao.itens().remove(item);
        }
    }

    public int obterPosicaoCorretaPendencia(ItemQuadroAuxiliarAb item) {
        int count = 0;
        boolean achouPosicao = false;
        for (Colecao<? extends ItemQuadroAuxiliarAb> itens : this.rendIsentos) {
            for (ItemQuadroAuxiliarAb itemAtual : itens.itens()) {
                ++count;
                if (item != itemAtual) continue;
                achouPosicao = true;
                --count;
                break;
            }
            if (!achouPosicao) continue;
            break;
        }
        return count;
    }

    protected class ParIndices {
        private int indiceColecao = 0;
        private int indiceItemColecao = 0;

        protected ParIndices() {
        }

        public int getIndiceColecao() {
            return this.indiceColecao;
        }

        public void setIndiceColecao(int indiceColecao) {
            this.indiceColecao = indiceColecao;
        }

        public int getIndiceItemColecao() {
            return this.indiceItemColecao;
        }

        public void setIndiceItemColecao(int indiceItemColecao) {
            this.indiceItemColecao = indiceItemColecao;
        }
    }
}

