/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.rendIsentos;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import serpro.ppgd.cacheni.CacheNI;
import serpro.ppgd.gui.xbeans.JEditAlfa;
import serpro.ppgd.gui.xbeans.JEditCampo;
import serpro.ppgd.gui.xbeans.JEditCodigo;
import serpro.ppgd.gui.xbeans.JEditNI;
import serpro.ppgd.gui.xbeans.JEditValor;
import serpro.ppgd.gui.xbeans.autocomplete.JAutoCompleteEditCPF;
import serpro.ppgd.infraestrutura.util.FontesUtil;
import serpro.ppgd.irpf.bens.Bem;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.NavegacaoIf;
import serpro.ppgd.irpf.gui.PainelAbaAb;
import serpro.ppgd.irpf.gui.PainelDemonstrativoAb;
import serpro.ppgd.irpf.gui.PainelDemonstrativoIf;
import serpro.ppgd.irpf.gui.bens.PainelBensDetalhe;
import serpro.ppgd.irpf.gui.bens.PainelBensDetalheEspolio;
import serpro.ppgd.irpf.gui.componente.JTaskAction;
import serpro.ppgd.irpf.gui.rendIsentos.PainelAbaRendIsentosLista;
import serpro.ppgd.irpf.gui.rendIsentos.TableModelRendIsentos;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroAuxiliarAb;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroOutrosRendimentos;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.irpf.tabelas.CodigoTabelaMensagens;
import serpro.ppgd.negocio.ElementoTabela;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Observador;

public class PainelAbaDetalhes05X
extends PainelAbaAb {
    private PainelDemonstrativoIf painelPai;
    private ItemQuadroAuxiliarAb item;
    private boolean novoItem;
    private String codTipo;
    private Bem bem = null;
    private JButton btnBemAssociado;
    private JAutoCompleteEditCPF cmbBeneficiario;
    private JEditAlfa edtDescricao;
    private JEditNI edtNi;
    private JEditAlfa edtNome;
    private JEditCodigo edtTipoBeneficiario;
    private JEditAlfa edtTitular;
    private JEditValor edtValor;
    private JPanel jPanel1;
    private JLabel lblBemAssociado;
    private JLabel lblBeneficiario;
    private JLabel lblDescricao;
    private JLabel lblNIFontePagadora;
    private JLabel lblNomeFontePagadora;
    private JLabel lblTipoBeneficiario;
    private JLabel lblTipoRendIsento;
    private JLabel lblValor;

    public PainelAbaDetalhes05X(PainelDemonstrativoIf painelPai, String codTipo, String descricaoCompleta, ItemQuadroAuxiliarAb item, boolean novoItem) {
        super(painelPai);
        this.painelPai = painelPai;
        this.codTipo = codTipo;
        this.item = item;
        this.novoItem = novoItem;
        if (!item.getCodBem().isVazio()) {
            this.bem = ControladorGui.getDemonstrativoAberto().getBens().obterBemPorIndice(item.getCodBem().naoFormatado());
        }
        this.initComponents();
        this.lblTipoRendIsento.setText("<html><b><font color='#004a6a'>" + codTipo + ". </font></b>" + descricaoCompleta + "</html>");
        this.associarInformacao();
        this.adicionarObservadores();
        this.atualizaGui();
        this.configurarUIBemVinculado();
        this.listenerAcessoBemAssociado();
    }

    public void ajustaTipoDependenteNVDA() {
        JComboBox j = (JComboBox)this.edtTipoBeneficiario.getComponenteEditor();
        int indice = j.getSelectedIndex();
        int total = j.getItemCount();
        if (indice == 0 && total == 2) {
            j.setSelectedIndex(1);
            j.validate();
            j.setSelectedIndex(indice);
            j.validate();
        }
    }

    private void associarInformacao() {
        this.edtTipoBeneficiario.setInformacao((Informacao)this.item.getTipoBeneficiario());
        this.cmbBeneficiario.setInformacao((Informacao)this.item.getCpfBeneficiario());
        this.edtValor.setInformacao((Informacao)this.item.getValor());
        ItemQuadroOutrosRendimentos itemOutros = (ItemQuadroOutrosRendimentos)this.item;
        this.edtNi.setInformacao((Informacao)itemOutros.getNIFontePagadora());
        this.edtNome.setInformacao((Informacao)itemOutros.getNomeFonte());
        this.edtDescricao.setInformacao((Informacao)itemOutros.getDescricaoRendimento());
        CacheNI.getInstancia().bindEditCampoNI((JEditCampo)this.edtNi);
        CacheNI.getInstancia().bindEditCampoAlfa((JEditCampo)this.edtNome);
    }

    private void adicionarObservadores() {
        this.edtTipoBeneficiario.getInformacao().addObservador(new Observador(){

            public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
                if (PainelAbaDetalhes05X.this.edtTipoBeneficiario.getInformacao().getNomeCampo().equals(nomePropriedade) && valorAntigo != null && !valorAntigo.equals(valorNovo)) {
                    PainelAbaDetalhes05X.this.atualizaGui();
                }
            }
        });
    }

    private void atualizaGui() {
        String tipoBeneficiario = this.edtTipoBeneficiario.getInformacao().naoFormatado();
        if (tipoBeneficiario.equals("Titular")) {
            this.cmbBeneficiario.setDados(CadastroTabelasIRPF.recuperarTitular());
            this.cmbBeneficiario.getComponenteEditor().setEnabled(false);
            this.cmbBeneficiario.setVisible(false);
            this.edtTitular.setVisible(true);
            ElementoTabela elemento = (ElementoTabela)CadastroTabelasIRPF.recuperarTitular().get(0);
            this.edtTitular.getInformacao().setConteudo(elemento.getConteudo(1));
            this.edtTitular.getInformacao().setReadOnly(true);
        } else if (tipoBeneficiario.equals("Dependente")) {
            this.cmbBeneficiario.setDados(CadastroTabelasIRPF.recuperarDependentes());
            this.cmbBeneficiario.getComponenteEditor().setEnabled(true);
            this.cmbBeneficiario.getInformacao().sinalizaValidoEdit();
            this.cmbBeneficiario.setVisible(true);
            this.edtTitular.setVisible(false);
        } else {
            this.cmbBeneficiario.getComponenteEditor().setEnabled(false);
            this.cmbBeneficiario.setVisible(true);
            this.edtTitular.setVisible(false);
        }
    }

    private void configurarUIBemVinculado() {
        boolean temBemAssociado = false;
        if (this.bem != null && this.bem.buscarRendimentoIsentoAssociado(this.codTipo, ControladorGui.getDemonstrativoAberto()) != null) {
            temBemAssociado = true;
        }
        this.item.getTipoBeneficiario().setReadOnly(temBemAssociado);
        this.item.getTipoBeneficiario().setHabilitado(!temBemAssociado);
        this.item.getCpfBeneficiario().setReadOnly(temBemAssociado);
        this.item.getCpfBeneficiario().setHabilitado(!temBemAssociado);
        this.item.getNIFontePagadora().setReadOnly(temBemAssociado);
        this.btnBemAssociado.setVisible(temBemAssociado);
        this.lblBemAssociado.setVisible(temBemAssociado);
        try {
            this.lblBemAssociado.setText("<html>" + CadastroTabelasIRPF.recuperarMensagem((CodigoTabelaMensagens)CodigoTabelaMensagens.CODIGO_00509) + "</html>");
        }
        catch (Exception ex) {
            this.lblBemAssociado.setText("<html>O bot\u00e3o ao lado permite altera\u00e7\u00e3o dos campos Benefici\u00e1rio e CNPJ da Fonte Pagadora do bem associado a este rendimento.</html>");
        }
    }

    private void listenerAcessoBemAssociado() {
        this.btnBemAssociado.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                PainelDemonstrativoAb telaBens;
                if (ControladorGui.getDemonstrativoAberto().getIdentificadorDeclaracao().isEspolio()) {
                    telaBens = new PainelBensDetalheEspolio(PainelAbaDetalhes05X.this.bem, true);
                    ControladorGui.acionarPainel((PainelDemonstrativoIf)telaBens);
                } else {
                    telaBens = new PainelBensDetalhe(PainelAbaDetalhes05X.this.bem, true);
                    ControladorGui.acionarPainel((PainelDemonstrativoIf)telaBens);
                }
                JTaskAction task = new JTaskAction("Bens e Direitos", NavegacaoIf.PAINEL_BENS_DIREITOS, (Icon)GuiUtil.getImage((String)"/icones/png20px/DE_bens.png"), true);
                ControladorGui.getJanelaPrincipal().getAbas().setFicha("Bens e Direitos", task, true);
            }
        });
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.lblTipoRendIsento = new JLabel();
        this.lblTipoBeneficiario = new JLabel();
        this.edtTipoBeneficiario = new JEditCodigo();
        this.lblBeneficiario = new JLabel();
        this.cmbBeneficiario = new JAutoCompleteEditCPF();
        this.lblValor = new JLabel();
        this.edtValor = new JEditValor();
        this.lblNIFontePagadora = new JLabel();
        this.lblNomeFontePagadora = new JLabel();
        this.edtNome = new JEditAlfa();
        this.edtNi = new JEditNI();
        this.edtDescricao = new JEditAlfa();
        this.lblDescricao = new JLabel();
        this.edtTitular = new JEditAlfa();
        this.btnBemAssociado = new JButton();
        this.lblBemAssociado = new JLabel();
        this.setBackground(new Color(241, 245, 249));
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.lblTipoRendIsento.setFont(FontesUtil.FONTE_NORMAL);
        this.lblTipoRendIsento.setText("Descri\u00e7\u00e3o completa  de tipo de rendimento informado em tempo de execu\u00e7\u00e3o");
        this.lblTipoRendIsento.setHorizontalTextPosition(10);
        this.lblTipoBeneficiario.setFont(FontesUtil.FONTE_NORMAL);
        this.lblTipoBeneficiario.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblTipoBeneficiario.setText("Tipo de Benefici\u00e1rio");
        this.lblBeneficiario.setFont(FontesUtil.FONTE_NORMAL);
        this.lblBeneficiario.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblBeneficiario.setText("Benefici\u00e1rio");
        this.lblValor.setFont(FontesUtil.FONTE_NORMAL);
        this.lblValor.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblValor.setText("Valor");
        this.lblNIFontePagadora.setFont(FontesUtil.FONTE_NORMAL);
        this.lblNIFontePagadora.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblNIFontePagadora.setText("CPF/CNPJ da Fonte Pagadora");
        this.lblNomeFontePagadora.setFont(FontesUtil.FONTE_NORMAL);
        this.lblNomeFontePagadora.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblNomeFontePagadora.setText("Nome da Fonte Pagadora");
        this.edtNome.setMaxChars(60);
        this.edtDescricao.setMaxChars(60);
        this.lblDescricao.setFont(FontesUtil.FONTE_NORMAL);
        this.lblDescricao.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblDescricao.setText("Descri\u00e7\u00e3o");
        this.btnBemAssociado.setText("Visualizar Bem/Direito Associado");
        this.lblBemAssociado.setFont(FontesUtil.FONTE_NORMAL);
        this.lblBemAssociado.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblBemAssociado.setText("<html>O bot\u00e3o ao lado permite altera\u00e7\u00e3o dos campos Benefici\u00e1rio e CNPJ da Fonte Pagadora do bem associado a este rendimento.</html>");
        this.lblBemAssociado.setVerticalAlignment(1);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblTipoRendIsento, -2, 699, -2).addComponent(this.lblTipoBeneficiario).addComponent((Component)this.edtTipoBeneficiario, -2, 241, -2)).addContainerGap(-1, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblBeneficiario).addComponent((Component)this.cmbBeneficiario, -2, 376, -2).addComponent(this.lblValor).addComponent((Component)this.edtValor, -2, 190, -2).addComponent(this.lblDescricao).addComponent((Component)this.edtDescricao, -2, 464, -2).addComponent((Component)this.edtTitular, -2, 392, -2).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblNIFontePagadora).addComponent((Component)this.edtNi, -2, 204, -2)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.lblNomeFontePagadora).addComponent((Component)this.edtNome, -1, 376, Short.MAX_VALUE))).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.btnBemAssociado).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblBemAssociado, -2, 402, -2))).addGap(0, 0, Short.MAX_VALUE)))));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.lblTipoRendIsento).addGap(18, 18, 18).addComponent(this.lblTipoBeneficiario).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.edtTipoBeneficiario, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblBeneficiario).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addComponent((Component)this.cmbBeneficiario, -2, -1, -2).addGap(5, 5, 5).addComponent((Component)this.edtTitular, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblNIFontePagadora).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.edtNi, -2, -1, -2)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.lblNomeFontePagadora).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.edtNome, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblDescricao).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.edtDescricao, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblValor).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.edtValor, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.btnBemAssociado).addComponent(this.lblBemAssociado, -2, 48, -2))));
        this.edtTipoBeneficiario.getAccessibleContext().setAccessibleName("Contribui\u00e7\u00e3o Previdenci\u00e1ria Oficial");
        this.edtTipoBeneficiario.getAccessibleContext().setAccessibleDescription("");
        this.cmbBeneficiario.getAccessibleContext().setAccessibleName("Benefici\u00e1rio");
        this.cmbBeneficiario.getAccessibleContext().setAccessibleDescription("");
        this.edtValor.getAccessibleContext().setAccessibleName("Valor");
        this.edtValor.getAccessibleContext().setAccessibleDescription("");
        this.edtNome.getAccessibleContext().setAccessibleName("Nome da Fonte Pagadora");
        this.edtNome.getAccessibleContext().setAccessibleDescription("");
        this.edtNi.getAccessibleContext().setAccessibleName("CPF/CNPJ da Fonte Pagadora");
        this.edtNi.getAccessibleContext().setAccessibleDescription("");
        this.edtDescricao.getAccessibleContext().setAccessibleName("Descri\u00e7\u00e3o");
        this.edtDescricao.getAccessibleContext().setAccessibleDescription("");
        this.edtTitular.getAccessibleContext().setAccessibleName("Benefici\u00e1rio");
        this.edtTitular.getAccessibleContext().setAccessibleDescription("");
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
    }

    public String getNomeAba() {
        return "Rendimentos";
    }

    public boolean isTelaComAjuda() {
        return true;
    }

    public boolean isTelaComVoltar() {
        return true;
    }

    public void executaVoltar() {
        ControladorGui.acionarPainel((PainelDemonstrativoIf)this.getPainelPai());
    }

    public JComponent getDefaultFocus() {
        return this.edtTipoBeneficiario;
    }

    public String getTituloPainel() {
        return "Rendimentos Isentos e N\u00e3o Tribut\u00e1veis";
    }

    public boolean isTelaComCancelar() {
        return this.novoItem;
    }

    public void executaCancelar() {
        PainelAbaRendIsentosLista painelLista = (PainelAbaRendIsentosLista)this.getPainelPai().getAbas()[0];
        TableModelRendIsentos tableModel = (TableModelRendIsentos)((Object)painelLista.getTabela().getModel());
        tableModel.removerItem(this.item, this.codTipo);
        ControladorGui.acionarPainel((PainelDemonstrativoIf)this.getPainelPai());
    }
}

