/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.pagamentos;

import serpro.ppgd.irpf.gui.TableListaModel;
import serpro.ppgd.irpf.pagamentos.Pagamento;
import serpro.ppgd.irpf.pagamentos.Pagamentos;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;

public class TableModelPagamentos
extends TableListaModel {
    private static final long serialVersionUID = 1L;

    public TableModelPagamentos(Pagamentos pObj) {
        super((ObjetoNegocio)pObj);
    }

    public int getColumnCount() {
        return 7;
    }

    public Informacao getInformacaoAt(int row, int col) {
        Pagamentos dividas = (Pagamentos)this.getObjetoNegocio();
        Pagamento item = (Pagamento)dividas.itens().get(row);
        switch (col) {
            case 0: {
                return super.getInformacaoAt(row, col);
            }
            case 1: {
                if (item.getCodigo().formatado().equals("-1")) {
                    return null;
                }
                return item.getCodigo();
            }
            case 2: {
                StringBuilder conteudo = new StringBuilder();
                if (item.isPensao()) {
                    conteudo.append(item.getDependenteOuAlimentando().naoFormatado());
                } else {
                    if (item.getCodigo().naoFormatado().equals("50")) {
                        conteudo.append("<html>");
                    }
                    conteudo.append(item.getNomeBeneficiario().naoFormatado());
                }
                if (item.getCodigo().naoFormatado().equals("50")) {
                    conteudo.append("<br>");
                    conteudo.append("NIT Empregado Dom\u00e9stico: ");
                    conteudo.append(item.getNitEmpregadoDomestico().formatado());
                    conteudo.append("</html>");
                }
                Alfa nomeBeneficiario = new Alfa();
                nomeBeneficiario.setConteudo(conteudo.toString());
                return nomeBeneficiario;
            }
            case 3: {
                return item.getNiBeneficiario();
            }
            case 4: {
                Alfa tipo = new Alfa();
                String codTipo = item.getTipo().formatado();
                if (codTipo.equals("T")) {
                    tipo.setConteudo("Titular");
                } else if (codTipo.equals("D")) {
                    String dep = item.getDependenteOuAlimentando().naoFormatado();
                    StringBuilder aux = new StringBuilder("<html>Dependente");
                    if (!dep.equals("-1")) {
                        aux.append("<br>" + dep);
                    }
                    aux.append("</html>");
                    tipo.setConteudo(aux.toString());
                } else if (codTipo.equals("A")) {
                    StringBuilder aux = new StringBuilder("<html>Alimentando");
                    String alim = item.getDependenteOuAlimentando().naoFormatado();
                    if (!item.isPensao() && !alim.equals("-1")) {
                        aux.append("<br>" + alim);
                    }
                    aux.append("</html>");
                    tipo.setConteudo(aux.toString());
                }
                return tipo;
            }
            case 5: {
                return item.getValorPago();
            }
            case 6: {
                return item.getParcelaNaoDedutivel();
            }
        }
        return null;
    }

    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return super.getColumnName(column);
            }
            case 1: {
                return "<html><center>C\u00f3d.</center></html>";
            }
            case 2: {
                return "<html><center>Nome do<br>Benefici\u00e1rio</center></html>";
            }
            case 3: {
                return "<html><center>CPF/CNPJ do<br>Benefici\u00e1rio</center></html>";
            }
            case 4: {
                return "<html><center>Despesa<br>Realizada<br>Com<br>(Tit/Dep/Ali)</center></html>";
            }
            case 5: {
                return "<html><center>Valor Pago</center></html>";
            }
            case 6: {
                return "<html><center>Parc. N\u00e3o<br>Dedut\u00edvel</center></html>";
            }
        }
        return "";
    }
}

