/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.bens;

import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.bens.Bem;
import serpro.ppgd.irpf.bens.Bens;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.TableListaSumarioModel;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Informacao;

public class TableModelBens
extends TableListaSumarioModel {
    private static final long serialVersionUID = 1L;

    public TableModelBens(Bens pObj) {
        super((Colecao)pObj);
    }

    public int getColumnCount() {
        return 7;
    }

    public Informacao getInformacaoAt(int row, int col) {
        boolean ultimaLinha;
        Bem item = null;
        Bens bens = (Bens)this.getObjetoNegocio();
        boolean bl = ultimaLinha = row == this.getRowCount() - 1;
        if (!ultimaLinha) {
            item = (Bem)bens.itens().get(row);
        }
        switch (col) {
            case 0: {
                return ultimaLinha ? this.labelTotal : super.getInformacaoAt(row, col);
            }
            case 1: {
                if (ultimaLinha) {
                    return null;
                }
                return item.getGrupo();
            }
            case 2: {
                if (ultimaLinha || "00".equals(item.getCodigo().formatado())) {
                    return null;
                }
                return item.getCodigo();
            }
            case 3: {
                if (ultimaLinha) {
                    return null;
                }
                return item.getNomePais();
            }
            case 4: {
                return ultimaLinha ? null : item.getDiscriminacao();
            }
            case 5: {
                return ultimaLinha ? bens.getTotalExercicioAnterior() : item.getValorExercicioAnterior();
            }
            case 6: {
                return ultimaLinha ? bens.getTotalExercicioAtual() : item.getValorExercicioAtual();
            }
        }
        return null;
    }

    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return super.getColumnName(column);
            }
            case 1: {
                return "<html><center>Grupo</center></html>";
            }
            case 2: {
                return "<html><center>C\u00f3d.</center></html>";
            }
            case 3: {
                return "<html><center>Localiza\u00e7\u00e3o</center></html>";
            }
            case 4: {
                return "<html><center>Discrimina\u00e7\u00e3o</center></html>";
            }
            case 5: {
                StringBuilder tituloColuna3 = new StringBuilder();
                tituloColuna3.append("<html><center>");
                if (IRPFFacade.getInstancia().getIdDeclaracaoAberto().isEspolio()) {
                    tituloColuna3.append("Situa\u00e7\u00e3o na<br>data da partilha");
                } else if (IRPFFacade.getInstancia().getIdDeclaracaoAberto().isSaida()) {
                    if (ControladorGui.getDemonstrativoAberto().entrouSaiuNoMesmoAno()) {
                        tituloColuna3.append("Situa\u00e7\u00e3o na<br>data da<br>caracteriza\u00e7\u00e3o<br>da condi\u00e7\u00e3o de<br>residente");
                    } else {
                        tituloColuna3.append("Situa\u00e7\u00e3o em<br>31/12/" + ConstantesGlobais.ANO_BASE_ANTERIOR);
                    }
                } else {
                    tituloColuna3.append("Situa\u00e7\u00e3o em<br>31/12/" + ConstantesGlobais.ANO_BASE_ANTERIOR);
                }
                tituloColuna3.append("<br>R$</center></html>");
                return tituloColuna3.toString();
            }
            case 6: {
                StringBuilder tituloColuna4 = new StringBuilder();
                tituloColuna4.append("<html><center>");
                if (IRPFFacade.getInstancia().getIdDeclaracaoAberto().isEspolio()) {
                    tituloColuna4.append("Valor de<br>transfer\u00eancia");
                } else if (IRPFFacade.getInstancia().getIdDeclaracaoAberto().isSaida()) {
                    tituloColuna4.append("Situa\u00e7\u00e3o na<br>data da<br>caracteriza\u00e7\u00e3o<br>da condi\u00e7\u00e3o de<br>n\u00e3o residente");
                } else {
                    tituloColuna4.append("Situa\u00e7\u00e3o em<br>31/12/" + ConstantesGlobais.ANO_BASE);
                }
                tituloColuna4.append("<br>R$</center></html>");
                return tituloColuna4.toString();
            }
        }
        return "";
    }
}

