/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.bens;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.jdesktop.layout.GroupLayout;
import serpro.ppgd.gui.xbeans.autocomplete.JAutoCompleteEditCodigo;
import serpro.ppgd.infraestrutura.util.FontesUtil;
import serpro.ppgd.irpf.bens.Bem;
import serpro.ppgd.irpf.gui.PainelDemonstrativoAb;
import serpro.ppgd.irpf.gui.bens.PainelBensDetalhe;
import serpro.ppgd.irpf.gui.bens.PainelBensDetalheEspolio;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.negocio.Codigo;
import serpro.ppgd.negocio.ElementoTabela;
import serpro.ppgd.negocio.Informacao;

public class PainelSelecaoCodigoBem
extends PainelDemonstrativoAb {
    private static final long serialVersionUID = 1L;
    private Codigo codigo;
    private Bem bem;
    PainelDemonstrativoAb painelBensDetalhe;
    private JButton btnCancelar;
    private JButton btnOk;
    private JAutoCompleteEditCodigo edtCodigoBem;
    private JPanel jPanel2;
    private JLabel lblCodigo;

    public PainelSelecaoCodigoBem(Bem bem, PainelDemonstrativoAb painelBensDetalhe) {
        this.bem = bem;
        this.painelBensDetalhe = painelBensDetalhe;
        this.codigo = new Codigo(null, "C\u00f3digo", this.filtrarTiposBensPorGrupoPais(bem.getGrupo().naoFormatado(), bem.getPais().naoFormatado()));
        this.initComponents();
        this.associarInformacao();
        this.inibirEnterNavegacaoFocoBotoes();
    }

    private void associarInformacao() {
        this.edtCodigoBem.setInformacao((Informacao)this.codigo);
    }

    private List<ElementoTabela> filtrarTiposBensPorGrupoPais(String grupo, String pais) {
        ArrayList<ElementoTabela> resultado = new ArrayList<ElementoTabela>();
        if ((pais.equals("105") || pais.equals("")) && (grupo.equals("04") || grupo.equals("07"))) {
            for (ElementoTabela item : CadastroTabelasIRPF.recuperarTipoBens((String)this.bem.getGrupo().naoFormatado())) {
                String codigo = item.getConteudo(0);
                if (!this.bem.isBemApenasBrasil(grupo, codigo)) continue;
                resultado.add(item);
            }
            return resultado;
        }
        return CadastroTabelasIRPF.recuperarTipoBens((String)this.bem.getGrupo().naoFormatado());
    }

    private void inibirEnterNavegacaoFocoBotoes() {
        HashSet<KeyStroke> set = new HashSet<KeyStroke>();
        set.add(KeyStroke.getKeyStroke(9, 0));
        this.btnOk.setFocusTraversalKeys(0, set);
        this.btnCancelar.setFocusTraversalKeys(0, set);
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.lblCodigo = new JLabel();
        this.btnOk = new JButton();
        this.btnCancelar = new JButton();
        this.edtCodigoBem = new JAutoCompleteEditCodigo();
        this.setBackground(new Color(241, 245, 249));
        this.jPanel2.setBackground(new Color(255, 255, 255));
        this.jPanel2.setBorder(BorderFactory.createLineBorder(new Color(211, 222, 232)));
        this.lblCodigo.setFont(FontesUtil.FONTE_NORMAL);
        this.lblCodigo.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblCodigo.setText("C\u00f3digo:");
        this.btnOk.setMnemonic('O');
        this.btnOk.setText("OK");
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelSelecaoCodigoBem.this.btnOkActionPerformed(evt);
            }
        });
        this.btnCancelar.setMnemonic('C');
        this.btnCancelar.setText("Cancelar");
        this.btnCancelar.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelSelecaoCodigoBem.this.btnCancelarActionPerformed(evt);
            }
        });
        this.edtCodigoBem.setToolTipText("C\u00f3digo");
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((Component)this.lblCodigo).addPreferredGap(0).add((Component)this.edtCodigoBem, -2, 485, -2).addContainerGap(-1, Short.MAX_VALUE)).add(2, (GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((Component)this.btnOk).addPreferredGap(1).add((Component)this.btnCancelar).addContainerGap()));
        jPanel2Layout.linkSize(new Component[]{this.btnCancelar, this.btnOk}, 1);
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1, false).add((Component)this.lblCodigo, -1, -1, Short.MAX_VALUE).add((Component)this.edtCodigoBem, -1, -1, Short.MAX_VALUE)).addPreferredGap(1).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.btnCancelar).add((Component)this.btnOk)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.linkSize(new Component[]{this.btnCancelar, this.btnOk}, 2);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE).addContainerGap()));
    }

    private void btnOkActionPerformed(ActionEvent evt) {
        if (this.codigo.isVazio()) {
            GuiUtil.mostrarAviso(null, (String)"Informe o novo c\u00f3digo do bem.");
        } else {
            ((JDialog)SwingUtilities.getRoot((Component)((Object)this))).setVisible(false);
            int indiceSelecionado = ((JComboBox)this.edtCodigoBem.getComponenteEditor()).getSelectedIndex();
            if (this.painelBensDetalhe instanceof PainelBensDetalhe) {
                ((PainelBensDetalhe)this.painelBensDetalhe).atualizarCodigoBem(this.codigo.naoFormatado());
                ((JComboBox)((PainelBensDetalhe)this.painelBensDetalhe).getEdtCodigoBem().getComponenteEditor()).setSelectedIndex(indiceSelecionado);
            } else if (this.painelBensDetalhe instanceof PainelBensDetalheEspolio) {
                ((PainelBensDetalheEspolio)this.painelBensDetalhe).atualizarCodigoBem(this.codigo.naoFormatado());
                ((JComboBox)((PainelBensDetalheEspolio)this.painelBensDetalhe).getEdtCodigoBem().getComponenteEditor()).setSelectedIndex(indiceSelecionado);
            }
        }
    }

    private void btnCancelarActionPerformed(ActionEvent evt) {
        ((JDialog)SwingUtilities.getRoot((Component)((Object)this))).setVisible(false);
    }
}

