/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.alimentandos;

import serpro.ppgd.irpf.alimentandos.Alimentando;
import serpro.ppgd.irpf.alimentandos.Alimentandos;
import serpro.ppgd.irpf.gui.TableListaModel;
import serpro.ppgd.negocio.Alfa;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;

public class TableModelAlimentandos
extends TableListaModel {
    private static final long serialVersionUID = 1L;
    private Alfa residenteBrasil = new Alfa("No Brasil");
    private Alfa residenteExterior = new Alfa("No Exterior");

    public TableModelAlimentandos(Alimentandos pObj) {
        super((ObjetoNegocio)pObj);
        this.residenteBrasil.setConteudo("No Brasil");
        this.residenteExterior.setConteudo("No Exterior");
    }

    public int getColumnCount() {
        return 5;
    }

    public Informacao getInformacaoAt(int row, int col) {
        Colecao alimentandos = (Colecao)this.getObjetoNegocio();
        Alimentando item = (Alimentando)alimentandos.itens().get(row);
        switch (col) {
            case 0: {
                return super.getInformacaoAt(row, col);
            }
            case 1: {
                return item.getNome();
            }
            case 2: {
                return item.getResidente().formatado().equals("0") ? this.residenteBrasil : (item.getResidente().formatado().equals("1") ? this.residenteExterior : new Alfa());
            }
            case 3: {
                return item.getDtNascimento();
            }
            case 4: {
                return item.getCpf();
            }
        }
        return null;
    }

    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return super.getColumnName(0);
            }
            case 1: {
                return "<html><center>Nome</center></html>";
            }
            case 2: {
                return "<html><center>Residente</center></html>";
            }
            case 3: {
                return "<html><center>Data de<br>Nascimento</center></html>";
            }
            case 4: {
                return "<html><center>CPF</center></html>";
            }
        }
        return "";
    }
}

