/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.alimentandos;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jdesktop.layout.GroupLayout;
import serpro.ppgd.gui.xbeans.JButtonGroupPanel;
import serpro.ppgd.gui.xbeans.JButtonMensagem;
import serpro.ppgd.gui.xbeans.JEditAlfa;
import serpro.ppgd.gui.xbeans.JEditCPF;
import serpro.ppgd.gui.xbeans.JEditData;
import serpro.ppgd.gui.xbeans.PPGDRadioItem;
import serpro.ppgd.gui.xbeans.autocomplete.JAutoCompleteComboBox;
import serpro.ppgd.gui.xbeans.autocomplete.JAutoCompleteEditCPF;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.infraestrutura.util.FontesUtil;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.alimentandos.Alimentando;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.IRPFLabelInfo;
import serpro.ppgd.irpf.gui.NavegacaoIf;
import serpro.ppgd.irpf.gui.PainelDemonstrativoAb;
import serpro.ppgd.irpf.gui.PainelDemonstrativoIf;
import serpro.ppgd.irpf.gui.alimentandos.PainelAlimentandosTipoProcessoAbas;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroPensaoAlimenticia;
import serpro.ppgd.irpf.rendacm.RendAcmDependente;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;

public class PainelAlimentandosDetalhe
extends PainelDemonstrativoAb {
    private static final long serialVersionUID = 1L;
    private static final String TITULO = "Alimentandos";
    private static final String HELP_ID = "Fichas da Declara\u00e7\u00e3o/Alimentandos";
    private PainelDemonstrativoIf painelPai;
    private boolean emEdicao;
    private Alimentando alimentando = null;
    private Alimentando itemInicial = null;
    private String strCpfAlimentando = null;
    private String cpfResponsavelOriginal = null;
    private int indiceOriginal;
    boolean emRollback = false;
    private PainelAlimentandosTipoProcessoAbas painelAlimentandosTipoProcessoAbas;
    private JButtonGroupPanel btnGrpResidente;
    private JButtonGroupPanel btnGrpResponsavel;
    private JButtonMensagem btnMensagemResidente;
    private JButtonMensagem btnMensagemResponsavel;
    private JButtonMensagem btnMensagemTipoProcesso;
    private JAutoCompleteEditCPF cmbDependente;
    private JEditCPF edtCpf;
    private JEditData edtDataNascimento;
    private JEditAlfa edtNome;
    private JButtonGroupPanel grpTipoProcesso;
    private JPanel jPanel2;
    private IRPFLabelInfo lblAvisoDependenteAlimentandoVazio;
    private JLabel lblCpf;
    private JLabel lblDataNascimento;
    private JLabel lblNome;
    private JLabel lblNome1;
    private JLabel lblNome2;
    private JLabel lblNome3;
    private JLabel lblResidente;
    private JLabel lblTitulo;
    private JPanel pnlDependente;
    private JPanel pnlTipoProcesso;
    private PPGDRadioItem rdbAmbas;
    private PPGDRadioItem rdbBrasil;
    private PPGDRadioItem rdbDecisaoJudicial;
    private PPGDRadioItem rdbDependente;
    private PPGDRadioItem rdbEscrituraPublica;
    private PPGDRadioItem rdbExterior;
    private PPGDRadioItem rdbTitular;

    public PainelAlimentandosDetalhe(PainelDemonstrativoIf painelPai, Alimentando alimentando, boolean emEdicao) {
        this.painelPai = painelPai;
        this.alimentando = alimentando;
        this.emEdicao = emEdicao;
        this.cpfResponsavelOriginal = alimentando.getCpfResponsavel().naoFormatado();
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)((Object)this), HELP_ID);
        this.initComponents();
        if (emEdicao) {
            this.itemInicial = alimentando.obterCopia();
        }
        this.associarInformacao();
        this.edtCpf.getComponenteEditor().addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                if (!PainelAlimentandosDetalhe.this.strCpfAlimentando.equals(PainelAlimentandosDetalhe.this.edtCpf.getInformacao().naoFormatado())) {
                    if (!IRPFFacade.getInstancia().getDependentes().isExisteCpf(PainelAlimentandosDetalhe.this.strCpfAlimentando) && !IRPFFacade.getInstancia().getAlimentandos().confirmaExclusaoRelacionadasAlimentando(PainelAlimentandosDetalhe.this.edtNome.getInformacao().naoFormatado(), PainelAlimentandosDetalhe.this.strCpfAlimentando)) {
                        PainelAlimentandosDetalhe.this.edtCpf.getInformacao().setConteudo(PainelAlimentandosDetalhe.this.strCpfAlimentando);
                    } else {
                        PainelAlimentandosDetalhe.this.strCpfAlimentando = PainelAlimentandosDetalhe.this.edtCpf.getInformacao().naoFormatado();
                    }
                }
            }
        });
        this.adicionarEventoRollbackDependente();
        this.strCpfAlimentando = this.edtCpf.getInformacao().naoFormatado();
        this.painelAlimentandosTipoProcessoAbas = new PainelAlimentandosTipoProcessoAbas();
        this.painelAlimentandosTipoProcessoAbas.setAlimentando(alimentando);
        this.pnlTipoProcesso.add((Component)((Object)this.painelAlimentandosTipoProcessoAbas), "Center");
        this.atualizarVisibilidadeAbasTipoProcesso();
    }

    private void adicionarEventoRollbackDependente() {
        ((JComboBox)this.cmbDependente.getComponenteEditor()).addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                PainelAlimentandosDetalhe.this.checkRollbackDependente();
            }
        });
    }

    private void checkRollbackDependente() {
        if (!this.cpfResponsavelOriginal.isEmpty()) {
            boolean remover = false;
            boolean sair = false;
            if (!IRPFFacade.getInstancia().getIdDeclaracaoAberto().getCpf().naoFormatado().equals(this.cpfResponsavelOriginal) && !this.emRollback) {
                List rendimentosacm = IRPFFacade.getInstancia().getColecaoRendAcmDependente().obterRRAsPorCPF(this.cpfResponsavelOriginal);
                for (RendAcmDependente rendacm : rendimentosacm) {
                    ArrayList<ItemQuadroPensaoAlimenticia> pensoes = new ArrayList<ItemQuadroPensaoAlimenticia>();
                    for (ItemQuadroPensaoAlimenticia pensao : rendacm.getPensaoAlimenticiaQuadroAuxiliar().itens()) {
                        if (pensao.getAlimentando().naoFormatado().equals(this.alimentando.getNome().naoFormatado())) {
                            if (!remover && !sair) {
                                if (GuiUtil.mostrarConfirma((String)"alimentando_confirma_remover_pensoes_rra", (String[])new String[]{this.alimentando.getNome().naoFormatado()})) {
                                    remover = true;
                                } else {
                                    this.emRollback = true;
                                    sair = true;
                                    new Thread(){

                                        @Override
                                        public void run() {
                                            try {
                                                Thread.sleep(200L);
                                            }
                                            catch (Exception exception) {
                                                // empty catch block
                                            }
                                            PainelAlimentandosDetalhe.this.rdbDependente.setSelected(true);
                                            PainelAlimentandosDetalhe.this.configurarComboDependentes();
                                            ((JComboBox)PainelAlimentandosDetalhe.this.cmbDependente.getComponenteEditor()).setSelectedIndex(PainelAlimentandosDetalhe.this.indiceOriginal);
                                            ((JComboBox)PainelAlimentandosDetalhe.this.cmbDependente.getComponenteEditor()).repaint();
                                            PainelAlimentandosDetalhe.this.emRollback = false;
                                        }
                                    }.start();
                                }
                            }
                            pensoes.add(pensao);
                        }
                        if (!sair) continue;
                        break;
                    }
                    if (remover) {
                        Iterator itPensoes = pensoes.iterator();
                        while (itPensoes.hasNext()) {
                            rendacm.getPensaoAlimenticiaQuadroAuxiliar().remove((ObjetoNegocio)((ItemQuadroPensaoAlimenticia)itPensoes.next()));
                        }
                    }
                    if (!sair) continue;
                    break;
                }
            }
        }
    }

    private void associarInformacao() {
        if (this.alimentando.getResidente().isVazio()) {
            this.alimentando.getResidente().setConteudo("2");
        }
        this.btnGrpResidente.setInformacao((Informacao)this.alimentando.getResidente());
        this.edtNome.setInformacao((Informacao)this.alimentando.getNome());
        this.edtCpf.setInformacao((Informacao)this.alimentando.getCpf());
        this.edtDataNascimento.setInformacao((Informacao)this.alimentando.getDtNascimento());
        this.cmbDependente.setInformacao((Informacao)this.alimentando.getCpfResponsavel());
        this.grpTipoProcesso.setInformacao((Informacao)this.alimentando.getTipoProcesso());
    }

    private void configurarComboDependentes() {
        if (this.rdbDependente.isSelected()) {
            this.pnlDependente.setVisible(true);
        } else {
            this.pnlDependente.setVisible(false);
        }
    }

    public void preExibir() {
        if (!this.alimentando.getCpfResponsavel().isVazio()) {
            if (this.alimentando.getCpfResponsavel().naoFormatado().equals(IRPFFacade.getInstancia().getIdDeclaracaoAberto().getCpf().naoFormatado())) {
                this.rdbTitular.setSelected(true);
            } else {
                this.rdbDependente.setSelected(true);
            }
        }
        this.configurarComboDependentes();
        this.indiceOriginal = ((JComboBox)this.cmbDependente.getComponenteEditor()).getSelectedIndex();
    }

    private void initComponents() {
        this.lblTitulo = new JLabel();
        this.jPanel2 = new JPanel();
        this.lblResidente = new JLabel();
        this.btnGrpResidente = new JButtonGroupPanel();
        this.rdbBrasil = new PPGDRadioItem();
        this.rdbExterior = new PPGDRadioItem();
        this.lblNome = new JLabel();
        this.edtNome = new JEditAlfa();
        this.lblCpf = new JLabel();
        this.edtCpf = new JEditCPF();
        this.lblDataNascimento = new JLabel();
        this.edtDataNascimento = new JEditData();
        this.btnMensagemResidente = new JButtonMensagem();
        this.lblNome1 = new JLabel();
        this.btnGrpResponsavel = new JButtonGroupPanel();
        this.rdbTitular = new PPGDRadioItem();
        this.rdbDependente = new PPGDRadioItem();
        this.btnMensagemResponsavel = new JButtonMensagem();
        this.pnlDependente = new JPanel();
        this.lblNome2 = new JLabel();
        this.cmbDependente = new JAutoCompleteEditCPF();
        this.lblAvisoDependenteAlimentandoVazio = new IRPFLabelInfo(MensagemUtil.getMensagem((String)"info_listagem", (String[])new String[]{"Dependentes"}));
        this.lblNome3 = new JLabel();
        this.btnMensagemTipoProcesso = new JButtonMensagem();
        this.pnlTipoProcesso = new JPanel();
        this.grpTipoProcesso = new JButtonGroupPanel();
        this.rdbEscrituraPublica = new PPGDRadioItem();
        this.rdbDecisaoJudicial = new PPGDRadioItem();
        this.rdbAmbas = new PPGDRadioItem();
        this.setBackground(new Color(241, 245, 249));
        this.setForeground(new Color(255, 255, 255));
        this.lblTitulo.setFont(FontesUtil.FONTE_TITULO_NORMAL);
        this.lblTitulo.setForeground(new Color(0, 74, 106));
        this.lblTitulo.setText("Dados do Alimentando");
        this.jPanel2.setBackground(new Color(255, 255, 255));
        this.jPanel2.setBorder(BorderFactory.createLineBorder(new Color(211, 222, 232)));
        this.jPanel2.setPreferredSize(new Dimension(831, 264));
        this.lblResidente.setFont(FontesUtil.FONTE_NORMAL);
        this.lblResidente.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblResidente.setLabelFor((Component)this.btnGrpResidente);
        this.lblResidente.setText("Residente");
        this.btnGrpResidente.setBorder(null);
        this.btnGrpResidente.setButtonMensagem(this.btnMensagemResidente);
        this.rdbBrasil.setBackground(new Color(255, 255, 255));
        this.rdbBrasil.setText("No Brasil");
        this.rdbBrasil.setFont(FontesUtil.FONTE_NORMAL);
        this.rdbBrasil.setValorSelecionadoTrue("0");
        this.rdbBrasil.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                PainelAlimentandosDetalhe.this.rdbBrasilFocusLost(evt);
            }
        });
        this.rdbExterior.setBackground(new Color(255, 255, 255));
        this.rdbExterior.setText("No Exterior");
        this.rdbExterior.setFont(FontesUtil.FONTE_NORMAL);
        this.rdbExterior.setValorSelecionadoTrue("1");
        this.rdbExterior.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                PainelAlimentandosDetalhe.this.rdbExteriorFocusLost(evt);
            }
        });
        GroupLayout btnGrpResidenteLayout = new GroupLayout((Container)this.btnGrpResidente);
        this.btnGrpResidente.setLayout((LayoutManager)btnGrpResidenteLayout);
        btnGrpResidenteLayout.setHorizontalGroup((GroupLayout.Group)btnGrpResidenteLayout.createParallelGroup(1).add((GroupLayout.Group)btnGrpResidenteLayout.createSequentialGroup().add((Component)this.rdbBrasil, -1, 112, Short.MAX_VALUE).add(18, 18, 18).add((Component)this.rdbExterior, -2, 115, -2).addContainerGap()));
        btnGrpResidenteLayout.setVerticalGroup((GroupLayout.Group)btnGrpResidenteLayout.createParallelGroup(1).add((GroupLayout.Group)btnGrpResidenteLayout.createSequentialGroup().add((GroupLayout.Group)btnGrpResidenteLayout.createParallelGroup(3).add((Component)this.rdbBrasil, -2, 14, -2).add((Component)this.rdbExterior, -2, 14, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.rdbBrasil.getAccessibleContext().setAccessibleName("Residente no Brasil");
        this.rdbExterior.getAccessibleContext().setAccessibleName("Residente no Exterior");
        this.lblNome.setFont(FontesUtil.FONTE_NORMAL);
        this.lblNome.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblNome.setLabelFor((Component)this.edtNome);
        this.lblNome.setText("Nome");
        this.lblCpf.setFont(FontesUtil.FONTE_NORMAL);
        this.lblCpf.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblCpf.setLabelFor((Component)this.edtCpf);
        this.lblCpf.setText("CPF");
        this.lblDataNascimento.setFont(FontesUtil.FONTE_NORMAL);
        this.lblDataNascimento.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblDataNascimento.setLabelFor((Component)this.edtDataNascimento);
        this.lblDataNascimento.setText("Data de Nascimento");
        this.btnMensagemResidente.setText("jButtonMensagem1");
        this.lblNome1.setFont(FontesUtil.FONTE_NORMAL);
        this.lblNome1.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblNome1.setLabelFor((Component)this.edtNome);
        this.lblNome1.setText("Alimentando do:");
        this.btnGrpResponsavel.setBorder(null);
        this.btnGrpResponsavel.setButtonMensagem(this.btnMensagemResidente);
        this.rdbTitular.setBackground(new Color(255, 255, 255));
        this.rdbTitular.setText("Titular");
        this.rdbTitular.setFont(FontesUtil.FONTE_NORMAL);
        this.rdbTitular.setValorSelecionadoTrue("0");
        this.rdbTitular.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelAlimentandosDetalhe.this.rdbTitularActionPerformed(evt);
            }
        });
        this.rdbDependente.setBackground(new Color(255, 255, 255));
        this.rdbDependente.setText("Dependente");
        this.rdbDependente.setFont(FontesUtil.FONTE_NORMAL);
        this.rdbDependente.setValorSelecionadoTrue("1");
        this.rdbDependente.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelAlimentandosDetalhe.this.rdbDependenteActionPerformed(evt);
            }
        });
        GroupLayout btnGrpResponsavelLayout = new GroupLayout((Container)this.btnGrpResponsavel);
        this.btnGrpResponsavel.setLayout((LayoutManager)btnGrpResponsavelLayout);
        btnGrpResponsavelLayout.setHorizontalGroup((GroupLayout.Group)btnGrpResponsavelLayout.createParallelGroup(1).add((GroupLayout.Group)btnGrpResponsavelLayout.createSequentialGroup().add((Component)this.rdbTitular, -2, -1, -2).addPreferredGap(1).add((Component)this.rdbDependente, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        btnGrpResponsavelLayout.setVerticalGroup((GroupLayout.Group)btnGrpResponsavelLayout.createParallelGroup(1).add((GroupLayout.Group)btnGrpResponsavelLayout.createSequentialGroup().add((GroupLayout.Group)btnGrpResponsavelLayout.createParallelGroup(3).add((Component)this.rdbTitular, -2, 14, -2).add((Component)this.rdbDependente, -2, 14, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.rdbTitular.getAccessibleContext().setAccessibleName("Alimentando do Titular");
        this.rdbDependente.getAccessibleContext().setAccessibleName("Alimentando do Dependente");
        this.btnMensagemResponsavel.setText("jButtonMensagem1");
        this.pnlDependente.setBorder(null);
        this.pnlDependente.setOpaque(false);
        this.lblNome2.setFont(FontesUtil.FONTE_NORMAL);
        this.lblNome2.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblNome2.setLabelFor((Component)this.edtNome);
        this.lblNome2.setText("Nome do dependente:");
        this.cmbDependente.setDados(CadastroTabelasIRPF.recuperarDependentes());
        GroupLayout pnlDependenteLayout = new GroupLayout((Container)this.pnlDependente);
        this.pnlDependente.setLayout((LayoutManager)pnlDependenteLayout);
        pnlDependenteLayout.setHorizontalGroup((GroupLayout.Group)pnlDependenteLayout.createParallelGroup(1).add((GroupLayout.Group)pnlDependenteLayout.createSequentialGroup().add((Component)this.lblNome2).addPreferredGap(0).add((Component)this.lblAvisoDependenteAlimentandoVazio, -2, -1, -2).add(0, 479, Short.MAX_VALUE)).add((Component)this.cmbDependente, -1, -1, Short.MAX_VALUE));
        pnlDependenteLayout.setVerticalGroup((GroupLayout.Group)pnlDependenteLayout.createParallelGroup(1).add((GroupLayout.Group)pnlDependenteLayout.createSequentialGroup().add((GroupLayout.Group)pnlDependenteLayout.createParallelGroup(1).add((Component)this.lblNome2).add((Component)this.lblAvisoDependenteAlimentandoVazio, -2, -1, -2)).addPreferredGap(0).add((Component)this.cmbDependente, -2, -1, -2)));
        this.cmbDependente.getAccessibleContext().setAccessibleName("Dependente");
        this.lblNome3.setFont(FontesUtil.FONTE_NORMAL);
        this.lblNome3.setForeground(FontesUtil.COR_TEXTO_NORMAL);
        this.lblNome3.setLabelFor((Component)this.edtNome);
        this.lblNome3.setText("Tipo de Processo:");
        this.btnMensagemTipoProcesso.setText("jButtonMensagem1");
        this.pnlTipoProcesso.setBackground(Color.white);
        this.pnlTipoProcesso.setBorder(null);
        this.pnlTipoProcesso.setLayout(new BorderLayout());
        this.grpTipoProcesso.setBorder(null);
        this.grpTipoProcesso.setButtonMensagem(this.btnMensagemTipoProcesso);
        this.grpTipoProcesso.setFont(FontesUtil.FONTE_NORMAL);
        this.rdbEscrituraPublica.setBackground(new Color(255, 255, 255));
        this.rdbEscrituraPublica.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rdbEscrituraPublica.setText("Escritura p\u00fablica");
        this.rdbEscrituraPublica.setToolTipText("Escritura p\u00fablica (cart\u00f3rio)");
        this.rdbEscrituraPublica.setValorSelecionadoTrue("C");
        this.rdbEscrituraPublica.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                PainelAlimentandosDetalhe.this.rdbEscrituraPublicaFocusLost(evt);
            }
        });
        this.rdbEscrituraPublica.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelAlimentandosDetalhe.this.rdbEscrituraPublicaActionPerformed(evt);
            }
        });
        this.rdbDecisaoJudicial.setBackground(new Color(255, 255, 255));
        this.rdbDecisaoJudicial.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rdbDecisaoJudicial.setText("Decis\u00e3o judicial");
        this.rdbDecisaoJudicial.setValorSelecionadoTrue("J");
        this.rdbDecisaoJudicial.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                PainelAlimentandosDetalhe.this.rdbDecisaoJudicialFocusLost(evt);
            }
        });
        this.rdbDecisaoJudicial.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelAlimentandosDetalhe.this.rdbDecisaoJudicialActionPerformed(evt);
            }
        });
        this.rdbAmbas.setBackground(new Color(255, 255, 255));
        this.rdbAmbas.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rdbAmbas.setText("Escritura p\u00fablica e Decis\u00e3o judicial");
        this.rdbAmbas.setValorSelecionadoTrue("A");
        this.rdbAmbas.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                PainelAlimentandosDetalhe.this.rdbAmbasFocusLost(evt);
            }
        });
        this.rdbAmbas.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PainelAlimentandosDetalhe.this.rdbAmbasActionPerformed(evt);
            }
        });
        GroupLayout grpTipoProcessoLayout = new GroupLayout((Container)this.grpTipoProcesso);
        this.grpTipoProcesso.setLayout((LayoutManager)grpTipoProcessoLayout);
        grpTipoProcessoLayout.setHorizontalGroup((GroupLayout.Group)grpTipoProcessoLayout.createParallelGroup(1).add((GroupLayout.Group)grpTipoProcessoLayout.createSequentialGroup().add((Component)this.rdbEscrituraPublica, -2, -1, -2).add(18, 18, 18).add((Component)this.rdbDecisaoJudicial, -2, -1, -2).add(18, 18, 18).add((Component)this.rdbAmbas, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        grpTipoProcessoLayout.setVerticalGroup((GroupLayout.Group)grpTipoProcessoLayout.createParallelGroup(1).add((GroupLayout.Group)grpTipoProcessoLayout.createParallelGroup(3).add((Component)this.rdbEscrituraPublica, -2, -1, -2).add((Component)this.rdbDecisaoJudicial, -2, -1, -2).add((Component)this.rdbAmbas, -2, -1, -2)));
        this.rdbEscrituraPublica.getAccessibleContext().setAccessibleName("");
        this.rdbEscrituraPublica.getAccessibleContext().setAccessibleDescription("Tipo de Processo Escritura p\u00fablica (cart\u00f3rio)");
        this.rdbDecisaoJudicial.getAccessibleContext().setAccessibleName("Tipo de Processo Decis\u00e3o judicial");
        this.rdbAmbas.getAccessibleContext().setAccessibleName("Tipo de Processo Escritura p\u00fablica (cart\u00f3rio) e Decis\u00e3o judicial");
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.pnlTipoProcesso, -2, 800, -2).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.pnlDependente, -2, -1, -2).add((Component)this.lblResidente).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.edtCpf, -2, 148, -2).add((Component)this.lblCpf)).addPreferredGap(1).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.lblDataNascimento).add((Component)this.edtDataNascimento, -2, 120, -2))).add((Component)this.lblNome).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.btnGrpResidente, -2, -1, -2).add(45, 45, 45).add((Component)this.btnMensagemResidente, -2, -1, -2)).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.lblNome1).add(98, 98, 98).add((Component)this.btnMensagemResponsavel, -2, -1, -2)).add((Component)this.btnGrpResponsavel, -2, -1, -2).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.lblNome3).addPreferredGap(0).add((Component)this.grpTipoProcesso, -2, -1, -2).addPreferredGap(0).add((Component)this.btnMensagemTipoProcesso, -2, -1, -2)).add((Component)this.edtNome, -2, 620, -2)))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((Component)this.lblResidente).addPreferredGap(0).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.btnGrpResidente, -2, -1, -2).add((Component)this.btnMensagemResidente, -2, -1, -2)).addPreferredGap(1).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.lblCpf).add((Component)this.lblDataNascimento)).add(1, 1, 1).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.edtCpf, -2, -1, -2).add((Component)this.edtDataNascimento, -2, -1, -2)).add(12, 12, 12).add((Component)this.lblNome).add(1, 1, 1).add((Component)this.edtNome, -2, -1, -2).addPreferredGap(1).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.lblNome1).add((Component)this.btnMensagemResponsavel, -2, -1, -2)).addPreferredGap(0).add((Component)this.btnGrpResponsavel, -2, -1, -2).addPreferredGap(0).add((Component)this.pnlDependente, -2, -1, -2).add(18, 18, 18).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(2).add(1, (Component)this.lblNome3, -2, 20, -2).add(1, (Component)this.grpTipoProcesso, -2, -1, -2).add((Component)this.btnMensagemTipoProcesso, -2, -1, -2)).add(0, 0, 0).add((Component)this.pnlTipoProcesso, -2, 237, -2).addContainerGap()));
        this.edtNome.getAccessibleContext().setAccessibleName("Nome");
        this.edtCpf.getAccessibleContext().setAccessibleName("CPF");
        this.edtDataNascimento.getAccessibleContext().setAccessibleName("Data de nascimento");
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.lblTitulo).add(0, 658, Short.MAX_VALUE)).add((Component)this.jPanel2, -1, 814, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.lblTitulo).addPreferredGap(0).add((Component)this.jPanel2, -2, 616, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void rdbBrasilFocusLost(FocusEvent evt) {
        if (evt.getOppositeComponent() != this.rdbExterior) {
            this.btnGrpResidente.chamaValidacao();
        }
    }

    private void rdbExteriorFocusLost(FocusEvent evt) {
        if (evt.getOppositeComponent() != this.rdbBrasil) {
            this.btnGrpResidente.chamaValidacao();
        }
    }

    private void rdbTitularActionPerformed(ActionEvent evt) {
        if (!this.emRollback) {
            this.checkRollbackDependente();
            this.configurarComboDependentes();
            this.cmbDependente.setInformacao((Informacao)new CPF());
            this.alimentando.getCpfResponsavel().setConteudo(IRPFFacade.getInstancia().getIdDeclaracaoAberto().getCpf());
            ((JAutoCompleteComboBox)this.cmbDependente.getComponenteEditor()).setSelectedIndex(-1);
        }
    }

    private void rdbDependenteActionPerformed(ActionEvent evt) {
        if (!this.emRollback) {
            this.configurarComboDependentes();
            if (this.alimentando.getCpfResponsavel().naoFormatado().equals(IRPFFacade.getInstancia().getIdDeclaracaoAberto().getCpf().naoFormatado())) {
                this.cmbDependente.setInformacao((Informacao)this.alimentando.getCpfResponsavel());
                this.alimentando.getCpfResponsavel().clear();
            }
        }
    }

    private void rdbEscrituraPublicaActionPerformed(ActionEvent evt) {
        this.atualizarVisibilidadeAbasTipoProcesso();
    }

    private void rdbDecisaoJudicialActionPerformed(ActionEvent evt) {
        this.atualizarVisibilidadeAbasTipoProcesso();
    }

    private void rdbAmbasActionPerformed(ActionEvent evt) {
        this.atualizarVisibilidadeAbasTipoProcesso();
    }

    private void rdbAmbasFocusLost(FocusEvent evt) {
        this.grpTipoProcesso.chamaValidacao();
    }

    private void rdbDecisaoJudicialFocusLost(FocusEvent evt) {
        this.grpTipoProcesso.chamaValidacao();
    }

    private void rdbEscrituraPublicaFocusLost(FocusEvent evt) {
        this.grpTipoProcesso.chamaValidacao();
    }

    public JComponent getDefaultFocus() {
        return this.btnGrpResidente;
    }

    public String getTituloPainel() {
        boolean ehTransmitida = IRPFFacade.getInstancia().getDeclaracao().getCopiaIdentificador().isTransmitida();
        if (this.emEdicao) {
            if (ehTransmitida) {
                return "Detalhe Alimentando";
            }
            return "Editar Alimentando";
        }
        return "Novo Alimentando";
    }

    public boolean isTelaComVoltar() {
        return true;
    }

    public void executaVoltar() {
        ControladorGui.acionarPainel((String)NavegacaoIf.PAINEL_ALIMENTANDOS);
    }

    public boolean isTelaComCancelar() {
        return true;
    }

    public void executaCancelar() {
        if (this.emEdicao) {
            int posicao = ControladorGui.getDemonstrativoAberto().getAlimentandos().itens().indexOf(this.alimentando);
            ControladorGui.getDemonstrativoAberto().getAlimentandos().remove((ObjetoNegocio)this.alimentando);
            ControladorGui.getDemonstrativoAberto().getAlimentandos().itens().add(posicao, this.itemInicial);
        } else {
            ControladorGui.getDemonstrativoAberto().getAlimentandos().remove((ObjetoNegocio)this.alimentando);
        }
        ControladorGui.acionarPainel((PainelDemonstrativoIf)this.getPainelPai());
    }

    public ImageIcon getImagemTitulo() {
        return GuiUtil.getImage((String)"/icones/png40px/DE_aliment.png");
    }

    public String getHelpID() {
        return HELP_ID;
    }

    public boolean isTelaComFavoritos() {
        return false;
    }

    public PainelDemonstrativoIf getPainelPai() {
        return this.painelPai;
    }

    private void atualizarVisibilidadeAbasTipoProcesso() {
        if (this.rdbEscrituraPublica.isSelected()) {
            this.painelAlimentandosTipoProcessoAbas.getTabbedPane().setSelectedIndex(0);
        } else if (this.rdbDecisaoJudicial.isSelected()) {
            this.painelAlimentandosTipoProcessoAbas.getTabbedPane().setSelectedIndex(1);
        }
        this.painelAlimentandosTipoProcessoAbas.habilitarAba(PainelAlimentandosTipoProcessoAbas.ABA_ESCRITURA_PUBLICA, this.rdbEscrituraPublica.isSelected() || this.rdbAmbas.isSelected());
        this.painelAlimentandosTipoProcessoAbas.habilitarAba(PainelAlimentandosTipoProcessoAbas.ABA_DECISAO_JUDICIAL, this.rdbDecisaoJudicial.isSelected() || this.rdbAmbas.isSelected());
    }

    public void acionarAba(String pNomeAba, boolean pFocusPadraoDaAba) {
        this.painelAlimentandosTipoProcessoAbas.acionarAba(pNomeAba, pFocusPadraoDaAba);
    }
}

