/*
 * Decompiled with CFR 0.152.
 */
package serpro.receitanet;

import java.util.Arrays;

public class Retorno {
    private boolean sucesso;
    private boolean multaPresente;
    private String mensagem;
    private byte[] recibo;

    private Retorno() {
    }

    static Retorno criarSucessoSemMulta(byte[] byArray, String string) {
        Retorno retorno = new Retorno();
        new Retorno().recibo = byArray;
        retorno.mensagem = string;
        retorno.sucesso = true;
        retorno.multaPresente = false;
        return retorno;
    }

    static Retorno criarSucessoComMulta(byte[] byArray, String string) {
        Retorno retorno = new Retorno();
        new Retorno().recibo = byArray;
        retorno.mensagem = string;
        retorno.sucesso = true;
        retorno.multaPresente = true;
        return retorno;
    }

    static Retorno criarFalha(String string) {
        Retorno retorno = new Retorno();
        new Retorno().mensagem = string;
        retorno.sucesso = false;
        retorno.multaPresente = false;
        return retorno;
    }

    public boolean isSucessoComMulta() {
        return this.sucesso && this.multaPresente;
    }

    public boolean isSucessoSemMulta() {
        return this.sucesso && !this.multaPresente;
    }

    public boolean isFalha() {
        return !this.sucesso;
    }

    public String getMensagem() {
        return this.mensagem;
    }

    public byte[] getRecibo() {
        if (!this.sucesso) {
            throw new IllegalStateException("A transmiss\u00e3o falhou, n\u00e3o h\u00e1 recibo.");
        }
        return this.recibo;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Retorno [sucesso=");
        stringBuilder.append(this.sucesso);
        stringBuilder.append(", multaPresente=");
        stringBuilder.append(this.multaPresente);
        stringBuilder.append(", mensagem=");
        stringBuilder.append(this.mensagem);
        stringBuilder.append(", recibo=");
        stringBuilder.append(Arrays.toString(this.recibo));
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

