/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.calculos;

import serpro.ppgd.irpf.rendavariavel.GanhosLiquidosOuPerdas;
import serpro.ppgd.irpf.rendavariavel.RendaVariavel;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class CalculosTotaisRendaVariavel
extends Observador {
    private RendaVariavel rendaVariavel = null;

    public CalculosTotaisRendaVariavel(RendaVariavel rendaVariavel) {
        this.rendaVariavel = rendaVariavel;
    }

    public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
        this.setAtivo(false);
        this.calculaTotaisRendaVariavel(nomePropriedade);
        this.setAtivo(true);
    }

    public void calculaTotaisRendaVariavel(String nomePropriedade) {
        Valor totalBaseCalculo = new Valor();
        Valor totalIRFonteDayTrade = new Valor();
        Valor totalImpostoAPagar = new Valor();
        Valor totalImpostoPago = new Valor();
        Valor totalImpRetidoLei11033 = new Valor();
        if ("BASE CALCULO".equals(nomePropriedade)) {
            for (int i = 0; i <= 11; ++i) {
                GanhosLiquidosOuPerdas ganhosMesAtual = this.rendaVariavel.getGanhosPorIndice(i);
                totalBaseCalculo.append('+', ganhosMesAtual.getOperacoesComuns().getBaseCalculoImposto());
                totalBaseCalculo.append('+', ganhosMesAtual.getOperacoesDayTrade().getBaseCalculoImposto());
            }
            this.rendaVariavel.getTotalBaseCalculo().setConteudo(totalBaseCalculo);
        } else if ("IRFONTEDAYTRADE".equals(nomePropriedade)) {
            for (int i = 0; i <= 11; ++i) {
                GanhosLiquidosOuPerdas ganhosMesAtual = this.rendaVariavel.getGanhosPorIndice(i);
                totalIRFonteDayTrade.append('+', (Valor)ganhosMesAtual.getIrFonteDayTradeMesAtual());
            }
            this.rendaVariavel.getTotalIRFonteDayTrade().setConteudo(totalIRFonteDayTrade);
        } else if ("Imposto a Pagar".equals(nomePropriedade)) {
            for (int i = 0; i <= 11; ++i) {
                GanhosLiquidosOuPerdas ganhosMesAtual = this.rendaVariavel.getGanhosPorIndice(i);
                totalImpostoAPagar.append('+', (Valor)ganhosMesAtual.getImpostoApagar());
            }
            this.rendaVariavel.getTotalImpostoAPagar().setConteudo(totalImpostoAPagar);
        } else if ("IMP PAGO".equals(nomePropriedade)) {
            for (int i = 0; i <= 11; ++i) {
                GanhosLiquidosOuPerdas ganhosMesAtual = this.rendaVariavel.getGanhosPorIndice(i);
                totalImpostoPago.append('+', (Valor)ganhosMesAtual.getImpostoPago());
            }
            this.rendaVariavel.getTotalImpostoPago().setConteudo(totalImpostoPago);
        } else if ("IR LEI 11033".equals(nomePropriedade)) {
            for (int i = 0; i <= 11; ++i) {
                GanhosLiquidosOuPerdas ganhosMesAtual = this.rendaVariavel.getGanhosPorIndice(i);
                totalImpRetidoLei11033.append('+', (Valor)ganhosMesAtual.getImpostoRetidoFonteLei11033());
            }
            this.rendaVariavel.getTotalImpostoRetidoFonteLei11033().setConteudo(totalImpRetidoLei11033);
        }
    }
}

