/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.calculos;

import java.util.Iterator;
import serpro.ppgd.irpf.rendpf.ColecaoRendPFDependente;
import serpro.ppgd.irpf.rendpf.ItemRendPFDependente;
import serpro.ppgd.irpf.rendpf.RendPF;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class CalculosRendPFDependentes
extends Observador {
    private ColecaoRendPFDependente colecaoRendPFDependente = null;

    public CalculosRendPFDependentes(ColecaoRendPFDependente colecao) {
        this.colecaoRendPFDependente = colecao;
    }

    public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
        if (nomePropriedade != null) {
            if (nomePropriedade.equals("ObjetoInserido")) {
                ItemRendPFDependente rendPJ = (ItemRendPFDependente)valorNovo;
                rendPJ.getRendimentos().addObservador((Observador)this);
                this.calculaTotaisPessoaFisica();
                this.calculaTotaisAlugueis();
                this.calculaTotaisOutros();
                this.calculaTotaisDarfPago();
                this.calculaTotaisDependentes();
                this.calculaTotaisExterior();
                this.calculaTotaisImpostoPagoExteriorCompensar();
                this.calculaTotaisLivroCaixa();
                this.calculaTotaisPensao();
                this.calculaTotaisPrevidenciaOficial();
            } else if (nomePropriedade.equals("ObjetoRemovido")) {
                ItemRendPFDependente rendPJ = (ItemRendPFDependente)valorNovo;
                rendPJ.getRendimentos().removeObservador((Observador)this);
                this.calculaTotaisPessoaFisica();
                this.calculaTotaisAlugueis();
                this.calculaTotaisOutros();
                this.calculaTotaisDarfPago();
                this.calculaTotaisDependentes();
                this.calculaTotaisExterior();
                this.calculaTotaisImpostoPagoExteriorCompensar();
                this.calculaTotaisLivroCaixa();
                this.calculaTotaisPensao();
                this.calculaTotaisPrevidenciaOficial();
            } else if (nomePropriedade.equals("Pessoa F\u00edsica")) {
                this.calculaTotaisPessoaFisica();
            } else if (nomePropriedade.equals("Alugu\u00e9is")) {
                this.calculaTotaisAlugueis();
            } else if (nomePropriedade.equals("Outros")) {
                this.calculaTotaisOutros();
            } else if (nomePropriedade.equals("Darf Pago c\u00f3d. 0190")) {
                this.calculaTotaisDarfPago();
            } else if (nomePropriedade.equals("Dependentes")) {
                this.calculaTotaisDependentes();
            } else if (nomePropriedade.equals("Exterior")) {
                this.calculaTotaisExterior();
            } else if (nomePropriedade.equals("Imposto Pago no Exterior a Compensar")) {
                this.calculaTotaisImpostoPagoExteriorCompensar();
            } else if (nomePropriedade.equals("Livro Caixa")) {
                this.calculaTotaisLivroCaixa();
            } else if (nomePropriedade.equals("Pens\u00e3o Aliment\u00edcia")) {
                this.calculaTotaisPensao();
            } else if (nomePropriedade.equals("Previd\u00eancia oficial")) {
                this.calculaTotaisPrevidenciaOficial();
            }
        }
    }

    public void calculaTotaisPessoaFisica() {
        Valor total = new Valor();
        Valor totalDependente = new Valor();
        Iterator itRend = this.colecaoRendPFDependente.itens().iterator();
        while (itRend.hasNext()) {
            RendPF rendPF = ((ItemRendPFDependente)itRend.next()).getRendimentos();
            totalDependente.clear();
            totalDependente.append('+', rendPF.getJaneiro().getPessoaFisica());
            totalDependente.append('+', rendPF.getFevereiro().getPessoaFisica());
            totalDependente.append('+', rendPF.getMarco().getPessoaFisica());
            totalDependente.append('+', rendPF.getAbril().getPessoaFisica());
            totalDependente.append('+', rendPF.getMaio().getPessoaFisica());
            totalDependente.append('+', rendPF.getJunho().getPessoaFisica());
            totalDependente.append('+', rendPF.getJulho().getPessoaFisica());
            totalDependente.append('+', rendPF.getAgosto().getPessoaFisica());
            totalDependente.append('+', rendPF.getSetembro().getPessoaFisica());
            totalDependente.append('+', rendPF.getOutubro().getPessoaFisica());
            totalDependente.append('+', rendPF.getNovembro().getPessoaFisica());
            totalDependente.append('+', rendPF.getDezembro().getPessoaFisica());
            rendPF.getTotalPessoaFisica().setConteudo(totalDependente);
            total.append('+', totalDependente);
        }
        this.colecaoRendPFDependente.getTotalPessoaFisica().setConteudo(total);
    }

    public void calculaTotaisAlugueis() {
        Valor total = new Valor();
        Valor totalDependente = new Valor();
        Iterator itRend = this.colecaoRendPFDependente.itens().iterator();
        while (itRend.hasNext()) {
            RendPF rendPF = ((ItemRendPFDependente)itRend.next()).getRendimentos();
            totalDependente.clear();
            totalDependente.append('+', rendPF.getJaneiro().getAlugueis());
            totalDependente.append('+', rendPF.getFevereiro().getAlugueis());
            totalDependente.append('+', rendPF.getMarco().getAlugueis());
            totalDependente.append('+', rendPF.getAbril().getAlugueis());
            totalDependente.append('+', rendPF.getMaio().getAlugueis());
            totalDependente.append('+', rendPF.getJunho().getAlugueis());
            totalDependente.append('+', rendPF.getJulho().getAlugueis());
            totalDependente.append('+', rendPF.getAgosto().getAlugueis());
            totalDependente.append('+', rendPF.getSetembro().getAlugueis());
            totalDependente.append('+', rendPF.getOutubro().getAlugueis());
            totalDependente.append('+', rendPF.getNovembro().getAlugueis());
            totalDependente.append('+', rendPF.getDezembro().getAlugueis());
            rendPF.getTotalAlugueis().setConteudo(totalDependente);
            total.append('+', totalDependente);
        }
        this.colecaoRendPFDependente.getTotalAlugueis().setConteudo(total);
    }

    public void calculaTotaisOutros() {
        Valor total = new Valor();
        Valor totalDependente = new Valor();
        Iterator itRend = this.colecaoRendPFDependente.itens().iterator();
        while (itRend.hasNext()) {
            RendPF rendPF = ((ItemRendPFDependente)itRend.next()).getRendimentos();
            totalDependente.clear();
            totalDependente.append('+', rendPF.getJaneiro().getOutros());
            totalDependente.append('+', rendPF.getFevereiro().getOutros());
            totalDependente.append('+', rendPF.getMarco().getOutros());
            totalDependente.append('+', rendPF.getAbril().getOutros());
            totalDependente.append('+', rendPF.getMaio().getOutros());
            totalDependente.append('+', rendPF.getJunho().getOutros());
            totalDependente.append('+', rendPF.getJulho().getOutros());
            totalDependente.append('+', rendPF.getAgosto().getOutros());
            totalDependente.append('+', rendPF.getSetembro().getOutros());
            totalDependente.append('+', rendPF.getOutubro().getOutros());
            totalDependente.append('+', rendPF.getNovembro().getOutros());
            totalDependente.append('+', rendPF.getDezembro().getOutros());
            rendPF.getTotalOutros().setConteudo(totalDependente);
            total.append('+', totalDependente);
        }
        this.colecaoRendPFDependente.getTotalOutros().setConteudo(total);
    }

    public void calculaTotaisExterior() {
        Valor total = new Valor();
        Valor totalDependente = new Valor();
        Iterator itRend = this.colecaoRendPFDependente.itens().iterator();
        while (itRend.hasNext()) {
            RendPF rendPF = ((ItemRendPFDependente)itRend.next()).getRendimentos();
            totalDependente.clear();
            totalDependente.append('+', rendPF.getJaneiro().getExterior());
            totalDependente.append('+', rendPF.getFevereiro().getExterior());
            totalDependente.append('+', rendPF.getMarco().getExterior());
            totalDependente.append('+', rendPF.getAbril().getExterior());
            totalDependente.append('+', rendPF.getMaio().getExterior());
            totalDependente.append('+', rendPF.getJunho().getExterior());
            totalDependente.append('+', rendPF.getJulho().getExterior());
            totalDependente.append('+', rendPF.getAgosto().getExterior());
            totalDependente.append('+', rendPF.getSetembro().getExterior());
            totalDependente.append('+', rendPF.getOutubro().getExterior());
            totalDependente.append('+', rendPF.getNovembro().getExterior());
            totalDependente.append('+', rendPF.getDezembro().getExterior());
            rendPF.getTotalExterior().setConteudo(totalDependente);
            total.append('+', totalDependente);
        }
        this.colecaoRendPFDependente.getTotalExterior().setConteudo(total);
    }

    public void calculaTotaisPrevidenciaOficial() {
        Valor total = new Valor();
        Valor totalDependente = new Valor();
        Iterator itRend = this.colecaoRendPFDependente.itens().iterator();
        while (itRend.hasNext()) {
            RendPF rendPF = ((ItemRendPFDependente)itRend.next()).getRendimentos();
            totalDependente.clear();
            totalDependente.append('+', rendPF.getJaneiro().getPrevidencia());
            totalDependente.append('+', rendPF.getFevereiro().getPrevidencia());
            totalDependente.append('+', rendPF.getMarco().getPrevidencia());
            totalDependente.append('+', rendPF.getAbril().getPrevidencia());
            totalDependente.append('+', rendPF.getMaio().getPrevidencia());
            totalDependente.append('+', rendPF.getJunho().getPrevidencia());
            totalDependente.append('+', rendPF.getJulho().getPrevidencia());
            totalDependente.append('+', rendPF.getAgosto().getPrevidencia());
            totalDependente.append('+', rendPF.getSetembro().getPrevidencia());
            totalDependente.append('+', rendPF.getOutubro().getPrevidencia());
            totalDependente.append('+', rendPF.getNovembro().getPrevidencia());
            totalDependente.append('+', rendPF.getDezembro().getPrevidencia());
            rendPF.getTotalPrevidencia().setConteudo(totalDependente);
            total.append('+', totalDependente);
        }
        this.colecaoRendPFDependente.getTotalPrevidencia().setConteudo(total);
    }

    public void calculaTotaisDependentes() {
        Valor total = new Valor();
        Valor totalDependente = new Valor();
        Iterator itRend = this.colecaoRendPFDependente.itens().iterator();
        while (itRend.hasNext()) {
            RendPF rendPF = ((ItemRendPFDependente)itRend.next()).getRendimentos();
            totalDependente.clear();
            totalDependente.append('+', rendPF.getJaneiro().getDependentes());
            totalDependente.append('+', rendPF.getFevereiro().getDependentes());
            totalDependente.append('+', rendPF.getMarco().getDependentes());
            totalDependente.append('+', rendPF.getAbril().getDependentes());
            totalDependente.append('+', rendPF.getMaio().getDependentes());
            totalDependente.append('+', rendPF.getJunho().getDependentes());
            totalDependente.append('+', rendPF.getJulho().getDependentes());
            totalDependente.append('+', rendPF.getAgosto().getDependentes());
            totalDependente.append('+', rendPF.getSetembro().getDependentes());
            totalDependente.append('+', rendPF.getOutubro().getDependentes());
            totalDependente.append('+', rendPF.getNovembro().getDependentes());
            totalDependente.append('+', rendPF.getDezembro().getDependentes());
            rendPF.getTotalDependentes().setConteudo(totalDependente);
            total.append('+', totalDependente);
        }
        this.colecaoRendPFDependente.getTotalDependentes().setConteudo(total);
    }

    public void calculaTotaisPensao() {
        Valor total = new Valor();
        Valor totalDependente = new Valor();
        Iterator itRend = this.colecaoRendPFDependente.itens().iterator();
        while (itRend.hasNext()) {
            RendPF rendPF = ((ItemRendPFDependente)itRend.next()).getRendimentos();
            totalDependente.clear();
            totalDependente.append('+', rendPF.getJaneiro().getPensao());
            totalDependente.append('+', rendPF.getFevereiro().getPensao());
            totalDependente.append('+', rendPF.getMarco().getPensao());
            totalDependente.append('+', rendPF.getAbril().getPensao());
            totalDependente.append('+', rendPF.getMaio().getPensao());
            totalDependente.append('+', rendPF.getJunho().getPensao());
            totalDependente.append('+', rendPF.getJulho().getPensao());
            totalDependente.append('+', rendPF.getAgosto().getPensao());
            totalDependente.append('+', rendPF.getSetembro().getPensao());
            totalDependente.append('+', rendPF.getOutubro().getPensao());
            totalDependente.append('+', rendPF.getNovembro().getPensao());
            totalDependente.append('+', rendPF.getDezembro().getPensao());
            rendPF.getTotalPensao().setConteudo(totalDependente);
            total.append('+', totalDependente);
        }
        this.colecaoRendPFDependente.getTotalPensao().setConteudo(total);
    }

    public void calculaTotaisImpostoPagoExteriorCompensar() {
        Valor total = new Valor();
        Valor totalDependente = new Valor();
        Iterator itRend = this.colecaoRendPFDependente.itens().iterator();
        while (itRend.hasNext()) {
            RendPF rendPF = ((ItemRendPFDependente)itRend.next()).getRendimentos();
            totalDependente.clear();
            totalDependente.append('+', rendPF.getJaneiro().getImpostoPagoCompensarExterior());
            totalDependente.append('+', rendPF.getFevereiro().getImpostoPagoCompensarExterior());
            totalDependente.append('+', rendPF.getMarco().getImpostoPagoCompensarExterior());
            totalDependente.append('+', rendPF.getAbril().getImpostoPagoCompensarExterior());
            totalDependente.append('+', rendPF.getMaio().getImpostoPagoCompensarExterior());
            totalDependente.append('+', rendPF.getJunho().getImpostoPagoCompensarExterior());
            totalDependente.append('+', rendPF.getJulho().getImpostoPagoCompensarExterior());
            totalDependente.append('+', rendPF.getAgosto().getImpostoPagoCompensarExterior());
            totalDependente.append('+', rendPF.getSetembro().getImpostoPagoCompensarExterior());
            totalDependente.append('+', rendPF.getOutubro().getImpostoPagoCompensarExterior());
            totalDependente.append('+', rendPF.getNovembro().getImpostoPagoCompensarExterior());
            totalDependente.append('+', rendPF.getDezembro().getImpostoPagoCompensarExterior());
            rendPF.getTotalImpostoPagoExteriorCompensar().setConteudo(totalDependente);
            total.append('+', totalDependente);
        }
        this.colecaoRendPFDependente.getTotalImpostoPagoExteriorCompensar().setConteudo(total);
    }

    public void calculaTotaisLivroCaixa() {
        Valor total = new Valor();
        Valor totalDependente = new Valor();
        Iterator itRend = this.colecaoRendPFDependente.itens().iterator();
        while (itRend.hasNext()) {
            RendPF rendPF = ((ItemRendPFDependente)itRend.next()).getRendimentos();
            totalDependente.clear();
            totalDependente.append('+', rendPF.getJaneiro().getLivroCaixa());
            totalDependente.append('+', rendPF.getFevereiro().getLivroCaixa());
            totalDependente.append('+', rendPF.getMarco().getLivroCaixa());
            totalDependente.append('+', rendPF.getAbril().getLivroCaixa());
            totalDependente.append('+', rendPF.getMaio().getLivroCaixa());
            totalDependente.append('+', rendPF.getJunho().getLivroCaixa());
            totalDependente.append('+', rendPF.getJulho().getLivroCaixa());
            totalDependente.append('+', rendPF.getAgosto().getLivroCaixa());
            totalDependente.append('+', rendPF.getSetembro().getLivroCaixa());
            totalDependente.append('+', rendPF.getOutubro().getLivroCaixa());
            totalDependente.append('+', rendPF.getNovembro().getLivroCaixa());
            totalDependente.append('+', rendPF.getDezembro().getLivroCaixa());
            rendPF.getTotalLivroCaixa().setConteudo(totalDependente);
            total.append('+', totalDependente);
        }
        this.colecaoRendPFDependente.getTotalLivroCaixa().setConteudo(total);
    }

    public void calculaTotaisDarfPago() {
        Valor total = new Valor();
        Valor totalDependente = new Valor();
        Iterator itRend = this.colecaoRendPFDependente.itens().iterator();
        while (itRend.hasNext()) {
            RendPF rendPF = ((ItemRendPFDependente)itRend.next()).getRendimentos();
            totalDependente.clear();
            totalDependente.append('+', rendPF.getJaneiro().getDarfPago());
            totalDependente.append('+', rendPF.getFevereiro().getDarfPago());
            totalDependente.append('+', rendPF.getMarco().getDarfPago());
            totalDependente.append('+', rendPF.getAbril().getDarfPago());
            totalDependente.append('+', rendPF.getMaio().getDarfPago());
            totalDependente.append('+', rendPF.getJunho().getDarfPago());
            totalDependente.append('+', rendPF.getJulho().getDarfPago());
            totalDependente.append('+', rendPF.getAgosto().getDarfPago());
            totalDependente.append('+', rendPF.getSetembro().getDarfPago());
            totalDependente.append('+', rendPF.getOutubro().getDarfPago());
            totalDependente.append('+', rendPF.getNovembro().getDarfPago());
            totalDependente.append('+', rendPF.getDezembro().getDarfPago());
            rendPF.getTotalDarfPago().setConteudo(totalDependente);
            total.append('+', totalDependente);
        }
        this.colecaoRendPFDependente.getTotalDarfPago().setConteudo(total);
    }
}

