/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.calculos;

import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.atividaderural.brasil.ApuracaoResultadoBrasil;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Valor;

public class CalculosApuracaoResultadoARBrasil
extends Observador {
    private DeclaracaoIRPF declaracaoIRPF = null;

    public CalculosApuracaoResultadoARBrasil(DeclaracaoIRPF dec) {
        this.declaracaoIRPF = dec;
    }

    public void notifica(Object observado, String nomePropriedade, Object valorAntigo, Object valorNovo) {
        if (nomePropriedade != null) {
            this.calculaApuracao();
        }
    }

    private void calculaApuracao() {
        ApuracaoResultadoBrasil apuracaoResultadoBrasil = this.declaracaoIRPF.getAtividadeRural().getBrasil().getApuracaoResultado();
        apuracaoResultadoBrasil.getReceitaBrutaTotal().setConteudo(this.declaracaoIRPF.getAtividadeRural().getBrasil().getReceitasDespesas().getTotalReceita());
        apuracaoResultadoBrasil.getDespesaCusteio().setConteudo(this.declaracaoIRPF.getAtividadeRural().getBrasil().getReceitasDespesas().getTotalDespesas());
        apuracaoResultadoBrasil.getResultadoI().setConteudo(apuracaoResultadoBrasil.getReceitaBrutaTotal().operacao('-', apuracaoResultadoBrasil.getDespesaCusteio()));
        Valor receitaBrutaTotal = new Valor();
        receitaBrutaTotal.setConteudo(apuracaoResultadoBrasil.getReceitaBrutaTotal());
        receitaBrutaTotal.append('*', "0,20");
        apuracaoResultadoBrasil.getLimiteVintePorCentoReceitaBruta().setConteudo(receitaBrutaTotal);
        if (apuracaoResultadoBrasil.getOpcaoFormaApuracao().naoFormatado().equals("1")) {
            apuracaoResultadoBrasil.getResultadoTributavel().setConteudo(apuracaoResultadoBrasil.getLimiteVintePorCentoReceitaBruta());
            apuracaoResultadoBrasil.getPrejuizoCompensar().clear();
            apuracaoResultadoBrasil.getCompensacaoPrejuizoExerciciosAnteriores().clear();
            apuracaoResultadoBrasil.getCompensacaoPrejuizoExerciciosAnteriores().setReadOnly(true);
        } else if (apuracaoResultadoBrasil.getOpcaoFormaApuracao().naoFormatado().equals("2")) {
            if (apuracaoResultadoBrasil.getPrejuizoExercicioAnterior().comparacao(">", "0,00") && apuracaoResultadoBrasil.getResultadoI().comparacao(">", "0,00")) {
                apuracaoResultadoBrasil.getCompensacaoPrejuizoExerciciosAnteriores().setReadOnly(false);
                apuracaoResultadoBrasil.getResultadoTributavel().setConteudo(apuracaoResultadoBrasil.getResultadoI().operacao('-', (Valor)apuracaoResultadoBrasil.getCompensacaoPrejuizoExerciciosAnteriores()));
            } else {
                apuracaoResultadoBrasil.getCompensacaoPrejuizoExerciciosAnteriores().clear();
                apuracaoResultadoBrasil.getCompensacaoPrejuizoExerciciosAnteriores().setReadOnly(true);
                if (apuracaoResultadoBrasil.getResultadoI().comparacao(">", "0,00")) {
                    apuracaoResultadoBrasil.getResultadoTributavel().setConteudo(apuracaoResultadoBrasil.getResultadoI());
                } else {
                    apuracaoResultadoBrasil.getResultadoTributavel().clear();
                }
            }
            if (apuracaoResultadoBrasil.getPrejuizoExercicioAnterior().comparacao(">", (Valor)apuracaoResultadoBrasil.getCompensacaoPrejuizoExerciciosAnteriores())) {
                apuracaoResultadoBrasil.getPrejuizoCompensar().setConteudo(apuracaoResultadoBrasil.getPrejuizoExercicioAnterior().operacao('-', (Valor)apuracaoResultadoBrasil.getCompensacaoPrejuizoExerciciosAnteriores()));
            } else {
                apuracaoResultadoBrasil.getPrejuizoCompensar().clear();
            }
            if (apuracaoResultadoBrasil.getResultadoI().comparacao("<", "0,00")) {
                apuracaoResultadoBrasil.getPrejuizoCompensar().append('+', apuracaoResultadoBrasil.getResultadoI().getValorAbsoluto());
            }
        }
        Valor resultNaoTributavel = new Valor();
        resultNaoTributavel.append('+', apuracaoResultadoBrasil.getReceitaBrutaTotal());
        resultNaoTributavel.append('-', apuracaoResultadoBrasil.getDespesaCusteio());
        resultNaoTributavel.append('+', (Valor)apuracaoResultadoBrasil.getReceitaRecebidaContaVenda());
        resultNaoTributavel.append('-', (Valor)apuracaoResultadoBrasil.getValorAdiantamento());
        if (apuracaoResultadoBrasil.getResultadoTributavel().comparacao(">=", "0,00")) {
            resultNaoTributavel.append('-', (Valor)apuracaoResultadoBrasil.getResultadoTributavel());
        }
        if (resultNaoTributavel.comparacao("<", "0,00")) {
            resultNaoTributavel.clear();
        }
        apuracaoResultadoBrasil.getResultadoNaoTributavel().setConteudo(resultNaoTributavel);
    }
}

