/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.util.certificadodigital;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.LogPPGD;
import serpro.ppgd.negocio.util.UtilitariosArquivo;

public class TokenUtil {
    protected final String CONFIG_FILES_DIRECTORY_PATH = System.getProperty("user.home");
    protected final String CONFIG_FILES_DIRECTORY_NAME = ".receitanet";
    protected final String PROPERTIE_NAME_LIBRARY = "library";
    protected final String PROPERTIE_NAME_NAME = "name";
    protected final String CONFIG_FILE_EXT = ".cfg";
    protected final String CONFIG_FILE_PREFIX = "token_config_";
    protected final String CONFIG_FILE_DESC = "#Gerado automaticamente pelo PGD IRPF\n";

    public static void main(String[] args) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configurarTokens() {
        Gson g = new Gson();
        Type type = new TypeToken<ArrayList<TokenDriverConfig>>(){}.getType();
        List configs = null;
        String configsFileName = null;
        UtilitariosArquivo.getPathLib();
        if (FabricaUtilitarios.isWindows()) {
            configsFileName = "tokens-windows.config";
        } else if (FabricaUtilitarios.isMac()) {
            configsFileName = "tokens-mac.config";
        } else if (FabricaUtilitarios.isLinux()) {
            configsFileName = "tokens-linux.config";
        }
        InputStream configsFileIS = this.getClass().getClassLoader().getResourceAsStream(configsFileName);
        if (configsFileIS != null) {
            try (InputStreamReader reader = new InputStreamReader(configsFileIS);){
                System.out.println("Lendo arquivo de configuracao de tokens: " + configsFileName);
                try {
                    configs = (List)g.fromJson((Reader)reader, type);
                }
                finally {
                    ((Reader)reader).close();
                }
            }
            catch (IOException e) {
                LogPPGD.erro((String)e.getMessage());
            }
        }
        File tokensConfigFilesDirectory = new File(this.CONFIG_FILES_DIRECTORY_PATH, ".receitanet");
        File[] preConfigFiles = tokensConfigFilesDirectory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().endsWith(".cfg");
            }
        });
        ArrayList<File> preConfigDrivers = new ArrayList<File>();
        if (preConfigFiles != null) {
            for (File preConfigFile : preConfigFiles) {
                Properties propriedades = new Properties();
                try {
                    propriedades.load(new FileInputStream(preConfigFile));
                    String preConfigDriver = propriedades.getProperty("library");
                    if (preConfigDriver == null || preConfigDriver.isEmpty()) continue;
                    preConfigDrivers.add(new File(preConfigDriver));
                }
                catch (IOException e) {
                    LogPPGD.erro((String)e.getMessage());
                }
            }
        }
        if (configs != null) {
            long time = new Date().getTime();
            for (TokenDriverConfig config : configs) {
                File driveFile = new File(config.getLibrary());
                if (!driveFile.isFile() || preConfigDrivers.contains(driveFile)) continue;
                System.out.println("Driver localizado: " + driveFile.getAbsolutePath());
                File arqConfig = new File(tokensConfigFilesDirectory, "token_config_" + time + ".cfg");
                String strConfig = "#Gerado automaticamente pelo PGD IRPF\n\n\nname=" + config.getName() + "\nlibrary=" + config.getLibrary();
                System.out.println("Criando arquivo de configuracao: " + arqConfig.getAbsolutePath());
                try {
                    FileUtils.writeStringToFile((File)arqConfig, (String)strConfig);
                }
                catch (IOException e) {
                    LogPPGD.erro((String)e.getMessage());
                }
                ++time;
            }
        }
    }

    public class TokenDriverConfig {
        private String name;
        private String library;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getLibrary() {
            return this.library;
        }

        public void setLibrary(String library) {
            this.library = library;
        }
    }
}

