/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.nuvem;

import com.google.gson.Gson;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpServer;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import jsignnet.aplicacao.Hash;
import jsignnet.crypto.X509CertificadoWrapper;
import jsignnet.erro.ErroAoGerarPKCS7;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import serpro.ppgd.app.PGDAb;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.exception.AplicacaoException;
import serpro.ppgd.irpf.exception.BarramentoException;
import serpro.ppgd.irpf.nuvem.BarramentoIRPFUtil;
import serpro.ppgd.irpf.nuvem.Captcha;
import serpro.ppgd.irpf.nuvem.RetornoBarramento;
import serpro.ppgd.irpf.nuvem.RetornoDarf;
import serpro.ppgd.irpf.nuvem.UsuarioLogado;
import serpro.ppgd.irpf.nuvem.carneleao.CarneLeao;
import serpro.ppgd.irpf.util.AplicacaoPropertiesUtil;
import serpro.ppgd.irpf.util.ConstantesGlobaisIRPF;
import serpro.ppgd.irpf.util.DataUtil;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.ConstantesGlobais;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.util.FabricaUtilitarios;
import serpro.ppgd.negocio.util.LogPPGD;

public class BarramentoIRPFService {
    public static final String RETORNO_OK = "00";
    public static final String RETORNO_CAPTCHA_INCORRETO = "90";
    public static final String RETORNO_ERRO = "99";
    public static final String RETORNO_ERRO_406 = "406";
    public static final String RETORNO_CPF_NAO_EXISTE = "94";
    private static final String URL_BASE_REST = Boolean.valueOf(FabricaUtilitarios.getProperties().getProperty("versao_testes")) != false ? "https://hom-mir-barramentoirpf.estaleiro.serpro.gov.br/pgdirpf/rest" : "https://mir-barramentoirpf.estaleiro.serpro.gov.br/pgdirpf/rest";
    private static final String URL_OBTER_CAPTCHA = URL_BASE_REST + "/captcha";
    private static final String URL_OBTER_CAPTCHA_AUDIO = URL_OBTER_CAPTCHA + "/som";
    private static final String URL_SALVAR_ONLINE = URL_BASE_REST + "/declaracao/salvar";
    private static final String URL_RECUPERAR_ONLINE = URL_BASE_REST + "/declaracao/recuperar";
    private static final String URL_CALCULAR_MULTA_DARF_AUXILIO = URL_BASE_REST + "/darfAuxilioEmergencial";
    public static final String URL_AUTENTICACAO_GOV_LOGIN_REDIRECT = URL_BASE_REST + "/acessogov/login/redirect";
    private static final String URL_AUTENTICACAO_GOV_TOKEN = URL_BASE_REST + "/acessogov/login/token";
    public static final String URL_AUTENTICACAO_GOV_CONFRIMA_LOGIN = URL_BASE_REST + "/acessogov/login/finished";
    public static final String URL_AUTENTICACAO_GOV_LOGOUT_REDIRECT = URL_BASE_REST + "/acessogov/logout/redirect";
    private static final String URL_IMPORTAR_CARNE_LEAO = URL_BASE_REST + "/importar/carneleao";
    private static final String URL_PRE_PREENCHIDA = URL_BASE_REST + "/importar/prepreenchida";
    private static final String URL_DARF_ECA = URL_BASE_REST + "/darf/eca";
    private static final String URL_DARF_IDOSO = URL_BASE_REST + "/darf/idoso";
    private static final String URL_DARF_QUOTA = URL_BASE_REST + "/darf/quota";
    private static final String URL_DARF_MAED = URL_BASE_REST + "/darf/maed";
    private static final String URL_DARF_MAED_ESPOLIO = URL_BASE_REST + "/darf/maedEspolio";
    public static final String URL_AVALIACAO_USR_LOGADO = URL_BASE_REST + "/avaliacao/usuarioAutenticado";
    public static final String URL_AVALIACAO_USR_ANONIMO = URL_BASE_REST + "/avaliacao/usuarioAnonimo";
    public static final String URL_DATA_HORA = URL_BASE_REST + "/dataHora";
    private static final String URL_DATA_VENCIMENTO_DARF_DFE = URL_BASE_REST + "/darf/irpf/vencimentoDFE";
    private static final String URL_TODOS_MUNICIPIOS = URL_BASE_REST + "/municipios/todos";
    private static final String versaoPGD = FabricaUtilitarios.getProperties().getProperty("versao_txt");
    private static HttpServer server = null;
    private static UsuarioLogado usuarioLogado = null;
    private static String token = null;

    private BarramentoIRPFService() {
    }

    public static Map<String, String> getQueryMap(String query) {
        String[] params = query.split("&");
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (String param : params) {
            String[] paramPair = param.split("=");
            String name = paramPair[0];
            String value = paramPair[1];
            map.put(name, value);
        }
        return map;
    }

    public static void logout() {
        usuarioLogado = null;
        token = null;
    }

    private static boolean login(HttpExchange httpExchange, String originalState) throws BarramentoException {
        boolean ret;
        String url;
        String query = httpExchange.getRequestURI().getQuery();
        System.out.println("Query: " + query);
        BarramentoException ex = null;
        if (query != null) {
            Object mensagemRetorno;
            String codigoRetorno;
            block9: {
                Map<String, String> queryMap = BarramentoIRPFService.getQueryMap(query);
                String code = queryMap.get("code");
                String state = queryMap.get("state");
                if (originalState.equals(state)) {
                    try {
                        token = BarramentoIRPFService.obterTokenAcessoIRPF(code, state);
                        usuarioLogado = BarramentoIRPFService.obterUsuarioLogado(token);
                        codigoRetorno = "0";
                        mensagemRetorno = usuarioLogado.getNome();
                        if (!ConstantesGlobaisIRPF.VERSAO_TESTES) break block9;
                        try {
                            System.out.println("tokenAcessoIRPF:" + new String(Base64.decodeBase64((byte[])token.split("\\.")[1].getBytes()), "UTF-8"));
                        }
                        catch (Exception exception) {
                        }
                    }
                    catch (BarramentoException e) {
                        codigoRetorno = "1";
                        mensagemRetorno = "Ocorreu um erro durante a solicita\u00e7\u00e3o de acesso a dados do contribuinte. " + e.getMessage();
                        ex = new BarramentoException((String)mensagemRetorno, codigoRetorno, (Exception)((Object)e));
                    }
                } else {
                    codigoRetorno = "1";
                    mensagemRetorno = "Dados de entrada incorretos. Estado inv\u00e1lido.";
                    ex = new BarramentoException((String)mensagemRetorno, codigoRetorno);
                }
            }
            String responseQuery = "exercicio=" + ConstantesGlobais.EXERCICIO + "&codigoRetorno=" + codigoRetorno + "&mensagemRetorno=" + URLEncoder.encode((String)mensagemRetorno, StandardCharsets.ISO_8859_1);
            url = URL_AUTENTICACAO_GOV_CONFRIMA_LOGIN + "?" + responseQuery;
            ret = true;
        } else {
            url = URL_AUTENTICACAO_GOV_LOGIN_REDIRECT + "?exercicio=" + ConstantesGlobais.EXERCICIO + "&state=" + originalState;
            ret = false;
        }
        BarramentoIRPFService.redirectHTTP(httpExchange, url);
        if (ex != null) {
            throw ex;
        }
        return ret;
    }

    public static void redirectHTTP(HttpExchange httpExchange, String url) throws BarramentoException {
        httpExchange.getResponseHeaders().add("Content-Type", "text/html; charset=UTF-8");
        httpExchange.getResponseHeaders().add("Cache-Control", "no-cache, no-store, must-revalidate");
        httpExchange.getResponseHeaders().add("Location", url);
        try {
            httpExchange.sendResponseHeaders(301, 0L);
            httpExchange.getResponseBody().close();
        }
        catch (Exception e) {
            throw new BarramentoException("Ocorreu um erro ao acessar servi\u00e7o para confirma\u00e7\u00e3o de Login.", RETORNO_ERRO);
        }
    }

    public static void stopHTTPLocalhostServer() {
        if (server != null) {
            ExecutorService ex = (ExecutorService)server.getExecutor();
            try {
                ex.submit(() -> ex.shutdown());
                server.stop(0);
                server = null;
                System.out.println("\nHTTP stoping server");
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public static void initHTTPLocalhostServer(Runnable executarAposSucesso, Runnable executarAposErro, String state) throws BarramentoException {
        try {
            if (server == null) {
                server = HttpServer.create(new InetSocketAddress(9991), 0);
                ExecutorService ex = Executors.newSingleThreadExecutor();
                server.createContext("/irpf/login", httpExchange -> {
                    System.out.println("-----------------------------------------");
                    System.out.println("Executando /irpf/login");
                    System.out.println("-----------------------------------------");
                    try {
                        if (BarramentoIRPFService.login(httpExchange, state)) {
                            executarAposSucesso.run();
                        }
                    }
                    catch (BarramentoException e) {
                        e.printStackTrace();
                        executarAposErro.run();
                    }
                });
                server.setExecutor(ex);
                server.start();
                System.out.println("HTTP server started");
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            RetornoBarramento retornoBarramento = new RetornoBarramento();
            retornoBarramento.setCodigoRetorno(RETORNO_ERRO);
            retornoBarramento.setMensagemRetorno("N\u00e3o foi poss\u00edvel iniciar o servi\u00e7o de Login");
            retornoBarramento.setException(e.getMessage());
            throw new BarramentoException(retornoBarramento);
        }
    }

    public static String obterTokenAcessoIRPF(String code, String state) throws BarramentoException {
        RetornoBarramento retornoBarramento;
        LinkedHashMap<String, String> parametros = new LinkedHashMap<String, String>();
        parametros.put("code", code);
        parametros.put("state", state);
        String hashParametros = BarramentoIRPFUtil.gerarHashParametros(parametros);
        String json = StringUtils.newStringUtf8((byte[])BarramentoIRPFService.chamarServicoRestPost(URL_AUTENTICACAO_GOV_TOKEN, parametros, hashParametros)).trim();
        if (ConstantesGlobaisIRPF.VERSAO_TESTES) {
            System.out.println("Parametros: " + ((Object)parametros).toString());
            System.out.println("Retorno: " + json);
        }
        if (!(retornoBarramento = (RetornoBarramento)new Gson().fromJson(json, RetornoBarramento.class)).getCodigoRetorno().equals(RETORNO_OK)) {
            throw new BarramentoException(retornoBarramento);
        }
        return retornoBarramento.getConteudo();
    }

    public static UsuarioLogado obterUsuarioLogado(String token) throws BarramentoException {
        UsuarioLogado usuario;
        try {
            String json = new String(Base64.decodeBase64((byte[])token.split("\\.")[1].getBytes()), "UTF-8");
            usuario = (UsuarioLogado)new Gson().fromJson(json, UsuarioLogado.class);
        }
        catch (Throwable e) {
            RetornoBarramento retBarramento = new RetornoBarramento();
            retBarramento.setCodigoRetorno(RETORNO_ERRO);
            retBarramento.setMensagemRetorno("Servi\u00e7o retornou um dado inv\u00e1lido.");
            retBarramento.setException(ExceptionUtils.getFullStackTrace((Throwable)e));
            throw new BarramentoException(retBarramento);
        }
        return usuario;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CarneLeao importarCarneLeaoComLoginGovBr(String cpfContribuinte) throws BarramentoException, AplicacaoException {
        String url = URL_IMPORTAR_CARNE_LEAO + "/" + cpfContribuinte + "/" + ConstantesGlobais.EXERCICIO_ANTERIOR + "?cpfTitular=" + IRPFFacade.getInstancia().getIdDeclaracaoAberto().getCpf().naoFormatado();
        HttpURLConnection con = BarramentoIRPFService.getURLConnection(url);
        try {
            con.setRequestProperty("Authorization", token);
            String json = StringUtils.newStringUtf8((byte[])BarramentoIRPFService.chamarServicoRest(con, "GET", null, null)).trim();
            if (ConstantesGlobaisIRPF.VERSAO_TESTES) {
                System.out.println("Retorno: " + json);
            }
            CarneLeao carneLeao = BarramentoIRPFService.tratarRetornoCarneLeao(json);
            return carneLeao;
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
    }

    public static CarneLeao importarCarneLeaoComCodigoAcesso(String cpfContribuinte, String cpfSolicitante, String codigoAcesso, String senhaAcesso) throws BarramentoException {
        LinkedHashMap<String, String> parametros = new LinkedHashMap<String, String>();
        parametros.put("cpfTitular", IRPFFacade.getInstancia().getIdDeclaracaoAberto().getCpf().naoFormatado());
        parametros.put("cpfSolicitante", cpfSolicitante);
        parametros.put("codigo", codigoAcesso);
        parametros.put("senha", senhaAcesso);
        String hashParametros = BarramentoIRPFUtil.gerarHashParametros(parametros);
        String json = StringUtils.newStringUtf8((byte[])BarramentoIRPFService.chamarServicoRestPost(URL_IMPORTAR_CARNE_LEAO + "/" + cpfContribuinte + "/" + ConstantesGlobais.EXERCICIO_ANTERIOR, parametros, hashParametros)).trim();
        if (ConstantesGlobaisIRPF.VERSAO_TESTES) {
            System.out.println("Parametros: " + ((Object)parametros).toString());
            System.out.println("Retorno: " + json);
        }
        return BarramentoIRPFService.tratarRetornoCarneLeao(json);
    }

    private static CarneLeao tratarRetornoCarneLeao(String json) throws BarramentoException {
        Gson gson = new Gson();
        RetornoBarramento retornoBarramento = (RetornoBarramento)gson.fromJson(json, RetornoBarramento.class);
        if (!retornoBarramento.getCodigoRetorno().equals(RETORNO_OK)) {
            throw new BarramentoException(retornoBarramento);
        }
        return (CarneLeao)gson.fromJson(retornoBarramento.getConteudo(), CarneLeao.class);
    }

    @Deprecated
    public static Captcha obterCaptcha() throws BarramentoException {
        throw new BarramentoException("Captcha Descontinuado...", RETORNO_ERRO);
    }

    @Deprecated
    public static byte[] obterCaptchaSom(String token) throws BarramentoException {
        throw new BarramentoException("Captcha Descontinuado...", RETORNO_ERRO);
    }

    public static void salvarDecOnline(String declaracao, boolean retificadora, String exercicio, String cpf) throws BarramentoException {
        Gson gson;
        RetornoBarramento retornoBarramento;
        HttpURLConnection con;
        LinkedHashMap<String, String> parametros = new LinkedHashMap<String, String>();
        parametros.put("dec", declaracao);
        parametros.put("inRetificadora", retificadora ? "S" : "N");
        if (ConstantesGlobaisIRPF.VERSAO_TESTES) {
            System.out.println("Parametros: " + ((Object)parametros).toString());
        }
        String hashParametros = BarramentoIRPFUtil.gerarHashParametros(parametros);
        try {
            URL obj = new URL(URL_SALVAR_ONLINE + "/" + cpf + "/" + exercicio);
            if (ConstantesGlobaisIRPF.VERSAO_TESTES) {
                System.out.println("URL: " + obj);
            }
            con = BarramentoIRPFService.getURLConnection(obj);
            con.setRequestProperty("Authorization", token);
        }
        catch (IOException e) {
            LogPPGD.erro((String)e.getMessage());
            String msgErro = MensagemUtil.getMensagem((String)"nuvem.erro.inesperado");
            RetornoBarramento retornoBarramento2 = new RetornoBarramento();
            retornoBarramento2.setCodigoRetorno(RETORNO_ERRO);
            retornoBarramento2.setMensagemRetorno(msgErro);
            retornoBarramento2.setException(ExceptionUtils.getFullStackTrace((Throwable)e));
            throw new BarramentoException(retornoBarramento2);
        }
        String json = StringUtils.newStringUtf8((byte[])BarramentoIRPFService.chamarServicoRest(con, "POST", parametros, hashParametros)).trim();
        if (ConstantesGlobaisIRPF.VERSAO_TESTES) {
            System.out.println("Retorno: " + json);
        }
        if (!(retornoBarramento = (RetornoBarramento)(gson = new Gson()).fromJson(json, RetornoBarramento.class)).getCodigoRetorno().equals(RETORNO_OK)) {
            throw new BarramentoException(retornoBarramento);
        }
    }

    public static String recuperarDecOnline(String exercicio, String cpf) throws BarramentoException {
        Gson gson;
        RetornoBarramento retornoBarramento;
        HttpURLConnection con;
        try {
            URL obj = new URL(URL_RECUPERAR_ONLINE + "/" + cpf + "/" + exercicio);
            if (ConstantesGlobaisIRPF.VERSAO_TESTES) {
                System.out.println("URL: " + obj);
                System.out.println("Authorization: " + token);
            }
            con = BarramentoIRPFService.getURLConnection(obj);
            con.setRequestProperty("Authorization", token);
        }
        catch (IOException e) {
            LogPPGD.erro((String)e.getMessage());
            String msgErro = MensagemUtil.getMensagem((String)"nuvem.erro.inesperado");
            RetornoBarramento retornoBarramento2 = new RetornoBarramento();
            retornoBarramento2.setCodigoRetorno(RETORNO_ERRO);
            retornoBarramento2.setMensagemRetorno(msgErro);
            retornoBarramento2.setException(ExceptionUtils.getFullStackTrace((Throwable)e));
            throw new BarramentoException(retornoBarramento2);
        }
        String json = StringUtils.newStringUtf8((byte[])BarramentoIRPFService.chamarServicoRest(con, "GET", null, null)).trim();
        if (ConstantesGlobaisIRPF.VERSAO_TESTES) {
            System.out.println("Retorno: " + json);
        }
        if (!(retornoBarramento = (RetornoBarramento)(gson = new Gson()).fromJson(json, RetornoBarramento.class)).getCodigoRetorno().equals(RETORNO_OK)) {
            throw new BarramentoException(retornoBarramento);
        }
        return retornoBarramento.getConteudo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RetornoBarramento obterPrePreenchida(String cpf) throws BarramentoException, AplicacaoException {
        String url = URL_PRE_PREENCHIDA + "/" + cpf + "/" + ConstantesGlobais.EXERCICIO;
        HttpURLConnection con = BarramentoIRPFService.getURLConnection(url);
        try {
            Gson gson;
            RetornoBarramento retornoBarramento;
            con.setRequestProperty("Authorization", token);
            byte[] retorno = BarramentoIRPFService.chamarServicoRest(con, "GET", null, null);
            String json = StringUtils.newStringUtf8((byte[])retorno).trim();
            if (ConstantesGlobaisIRPF.VERSAO_TESTES) {
                System.out.println("Parametros: Authorization:" + token);
                System.out.println("Retorno: " + json);
            }
            if (!(retornoBarramento = (RetornoBarramento)(gson = new Gson()).fromJson(json, RetornoBarramento.class)).getCodigoRetorno().equals(RETORNO_OK)) {
                throw new BarramentoException(retornoBarramento.getMensagemRetorno(), retornoBarramento.getCodigoRetorno(), new Exception("Erro: " + retornoBarramento.getException()));
            }
            RetornoBarramento retornoBarramento2 = retornoBarramento;
            return retornoBarramento2;
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
    }

    public static String gerarAssinaturaBase64(X509CertificadoWrapper certificado, byte[] conteudo) throws AplicacaoException {
        try {
            byte[] assinatura = certificado.assinaPKCS7(Hash.MESMO_DO_CERTIFICADO, conteudo, certificado.getSenhaContainer(), true, true);
            return new String(Base64.encodeBase64((byte[])assinatura, (boolean)true, (boolean)true));
        }
        catch (ErroAoGerarPKCS7 e) {
            throw new AplicacaoException("Ocorreu um erro durante assinatura de dados.", (Throwable)e, false);
        }
    }

    public static byte[] obterPdfDarfQuota(String cpf, String nomeContribuinte, String observacoes, String descricaoPrincipal, String descricoesAdicionais, Date periodoApuracao, Integer quota, Date dataVencimento, Date dataArrecadacao, Date dataFinalEntrega, Double valorPrincipal, String codigoMunicipioContribuinte) throws AplicacaoException, BarramentoException {
        RetornoBarramento retornoBarramento;
        String principal;
        DecimalFormat df = new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.US));
        try {
            principal = df.format(valorPrincipal);
        }
        catch (Exception e) {
            throw new AplicacaoException("Valor da quota com formato inv\u00e1lido.", false);
        }
        LinkedHashMap<String, String> parametros = new LinkedHashMap<String, String>();
        parametros.put("nomeContribuinte", URLEncoder.encode(nomeContribuinte, StandardCharsets.UTF_8));
        parametros.put("observacoes", URLEncoder.encode(observacoes, StandardCharsets.UTF_8));
        parametros.put("descricaoPrincipal", URLEncoder.encode(descricaoPrincipal, StandardCharsets.UTF_8));
        parametros.put("descricoesAdicionais", URLEncoder.encode(descricoesAdicionais, StandardCharsets.UTF_8));
        parametros.put("principal", principal);
        parametros.put("quota", quota.toString());
        parametros.put("periodoApuracao", DataUtil.formatarDataSemBarras((Date)periodoApuracao));
        parametros.put("dataFinalEntrega", DataUtil.formatarDataSemBarras((Date)dataFinalEntrega));
        parametros.put("dataVencimento", DataUtil.formatarDataSemBarras((Date)dataVencimento));
        parametros.put("codigoMunicipioContribuinte", codigoMunicipioContribuinte);
        if (dataArrecadacao != null) {
            parametros.put("dataArrecadacao", DataUtil.formatarDataSemBarras((Date)dataArrecadacao));
        }
        String hashParametros = BarramentoIRPFUtil.gerarHashParametros(parametros);
        String json = StringUtils.newStringUtf8((byte[])BarramentoIRPFService.chamarServicoRestPost(URL_DARF_QUOTA + "/" + cpf, parametros, hashParametros)).trim();
        if (ConstantesGlobaisIRPF.VERSAO_TESTES) {
            System.out.println("Parametros: " + ((Object)parametros).toString());
            System.out.println("Retorno: " + json);
        }
        Gson gson = new Gson();
        try {
            retornoBarramento = (RetornoBarramento)gson.fromJson(json, RetornoBarramento.class);
        }
        catch (Exception e) {
            RetornoBarramento retorno = new RetornoBarramento();
            retorno.setCodigoRetorno(RETORNO_ERRO);
            retorno.setMensagemRetorno("Ocorreu um erro ao gerar o Darf.");
            retorno.setException("Erro durante consulta ao DARF. [Retorno:" + json + "]");
            throw new BarramentoException(retorno.getMensagemRetorno(), retorno.getCodigoRetorno(), e);
        }
        if (!retornoBarramento.getCodigoRetorno().equals(RETORNO_OK)) {
            throw new BarramentoException(retornoBarramento);
        }
        try {
            return Base64.decodeBase64((String)retornoBarramento.getConteudo());
        }
        catch (Throwable e) {
            RetornoBarramento retorno = new RetornoBarramento();
            retorno.setCodigoRetorno(RETORNO_ERRO);
            retorno.setMensagemRetorno("Ocorreu um erro ao gerar o Darf.");
            retorno.setException("Erro durante consulta ao DARF. [Retorno:" + json + "]");
            e.printStackTrace();
            throw new BarramentoException(retorno);
        }
    }

    public static byte[] obterPdfDarfECA(String cpf, String nomeContribuinte, String observacoes, String descricaoPrincipal, String descricoesAdicionais, Date periodoApuracao, Date dataVencimento, Date dataLimitePagamento, Double valorPrincipal, String cnpjFundo, String codigoMunicipioContribuinte) throws AplicacaoException, BarramentoException {
        return BarramentoIRPFService.obterPdfDarfDoacoes(URL_DARF_ECA, cpf, nomeContribuinte, observacoes, descricaoPrincipal, descricoesAdicionais, periodoApuracao, dataVencimento, dataLimitePagamento, valorPrincipal, cnpjFundo, codigoMunicipioContribuinte);
    }

    public static byte[] obterPdfDarfIdoso(String cpf, String nomeContribuinte, String observacoes, String descricaoPrincipal, String descricoesAdicionais, Date periodoApuracao, Date dataVencimento, Date dataLimitePagamento, Double valorPrincipal, String cnpjFundo, String codigoMunicipioContribuinte) throws AplicacaoException, BarramentoException {
        return BarramentoIRPFService.obterPdfDarfDoacoes(URL_DARF_IDOSO, cpf, nomeContribuinte, observacoes, descricaoPrincipal, descricoesAdicionais, periodoApuracao, dataVencimento, dataLimitePagamento, valorPrincipal, cnpjFundo, codigoMunicipioContribuinte);
    }

    protected static byte[] obterPdfDarfDoacoes(String url, String cpf, String nomeContribuinte, String observacoes, String descricaoPrincipal, String descricoesAdicionais, Date periodoApuracao, Date dataVencimento, Date dataLimitePagamento, Double valorPrincipal, String cnpjFundo, String codigoMunicipioContribuinte) throws AplicacaoException, BarramentoException {
        RetornoBarramento retornoBarramento;
        String principal;
        DecimalFormat df = new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.US));
        try {
            principal = df.format(valorPrincipal);
        }
        catch (Exception e) {
            throw new AplicacaoException("Valor da quota com formato inv\u00e1lido.", false);
        }
        LinkedHashMap<String, String> parametros = new LinkedHashMap<String, String>();
        parametros.put("nomeContribuinte", URLEncoder.encode(nomeContribuinte, StandardCharsets.UTF_8));
        parametros.put("observacoes", URLEncoder.encode(observacoes, StandardCharsets.UTF_8));
        parametros.put("descricaoPrincipal", URLEncoder.encode(descricaoPrincipal, StandardCharsets.UTF_8));
        parametros.put("descricoesAdicionais", URLEncoder.encode(descricoesAdicionais, StandardCharsets.UTF_8));
        parametros.put("principal", principal);
        parametros.put("periodoApuracao", DataUtil.formatarDataSemBarras((Date)periodoApuracao));
        parametros.put("dataLimitePagamento", DataUtil.formatarDataSemBarras((Date)dataLimitePagamento));
        parametros.put("dataVencimento", DataUtil.formatarDataSemBarras((Date)dataVencimento));
        parametros.put("Referencia", URLEncoder.encode(cnpjFundo, StandardCharsets.UTF_8));
        parametros.put("codigoMunicipioContribuinte", codigoMunicipioContribuinte);
        String hashParametros = BarramentoIRPFUtil.gerarHashParametros(parametros);
        String json = StringUtils.newStringUtf8((byte[])BarramentoIRPFService.chamarServicoRestPost(url + "/" + cpf, parametros, hashParametros)).trim();
        if (ConstantesGlobaisIRPF.VERSAO_TESTES) {
            System.out.println("Parametros: " + ((Object)parametros).toString());
            System.out.println("Retorno: " + json);
        }
        Gson gson = new Gson();
        try {
            retornoBarramento = (RetornoBarramento)gson.fromJson(json, RetornoBarramento.class);
        }
        catch (Exception e) {
            RetornoBarramento retorno = new RetornoBarramento();
            retorno.setCodigoRetorno(RETORNO_ERRO);
            retorno.setMensagemRetorno("Ocorreu um erro ao gerar o Darf.");
            retorno.setException("Erro durante consulta ao DARF. Retorno inv\u00e1lidos. [Retorno:" + json + "]");
            e.printStackTrace();
            throw new BarramentoException(retorno);
        }
        if (!retornoBarramento.getCodigoRetorno().equals(RETORNO_OK)) {
            throw new BarramentoException(retornoBarramento);
        }
        try {
            return Base64.decodeBase64((String)retornoBarramento.getConteudo());
        }
        catch (Throwable e) {
            RetornoBarramento retorno = new RetornoBarramento();
            retorno.setCodigoRetorno(RETORNO_ERRO);
            retorno.setMensagemRetorno("Ocorreu um erro ao gerar o Darf.");
            retorno.setException("Erro durante consulta ao DARF. Formato inv\u00e1lido. [Retorno:" + json + "]");
            e.printStackTrace();
            throw new BarramentoException(retorno);
        }
    }

    public static byte[] obterPdfDarfMaed(String cpf, String nomeContribuinte, String observacoes, String descricaoPrincipal, String descricoesAdicionais, Date periodoApuracao, Date dataVencimento, Double valorPrincipal, String codigoMunicipioContribuinte) throws AplicacaoException, BarramentoException {
        return BarramentoIRPFService.obterPdfDarfMaed(URL_DARF_MAED, cpf, nomeContribuinte, observacoes, descricaoPrincipal, descricoesAdicionais, periodoApuracao, dataVencimento, valorPrincipal, codigoMunicipioContribuinte);
    }

    public static byte[] obterPdfDarfMaedEspolio(String cpf, String nomeContribuinte, String observacoes, String descricaoPrincipal, String descricoesAdicionais, Date periodoApuracao, Date dataVencimento, Double valorPrincipal, String codigoMunicipioContribuinte) throws AplicacaoException, BarramentoException {
        return BarramentoIRPFService.obterPdfDarfMaed(URL_DARF_MAED_ESPOLIO, cpf, nomeContribuinte, observacoes, descricaoPrincipal, descricoesAdicionais, periodoApuracao, dataVencimento, valorPrincipal, codigoMunicipioContribuinte);
    }

    protected static byte[] obterPdfDarfMaed(String url, String cpf, String nomeContribuinte, String observacoes, String descricaoPrincipal, String descricoesAdicionais, Date periodoApuracao, Date dataVencimento, Double valorPrincipal, String codigoMunicipioContribuinte) throws AplicacaoException, BarramentoException {
        RetornoBarramento retornoBarramento;
        String principal;
        DecimalFormat df = new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.US));
        try {
            principal = df.format(valorPrincipal);
        }
        catch (Exception e) {
            throw new AplicacaoException("Valor da quota com formato inv\u00e1lido.", false);
        }
        LinkedHashMap<String, String> parametros = new LinkedHashMap<String, String>();
        parametros.put("nomeContribuinte", URLEncoder.encode(nomeContribuinte, StandardCharsets.UTF_8));
        parametros.put("observacoes", URLEncoder.encode(observacoes, StandardCharsets.UTF_8));
        parametros.put("descricaoPrincipal", URLEncoder.encode(descricaoPrincipal, StandardCharsets.UTF_8));
        parametros.put("descricoesAdicionais", URLEncoder.encode(descricoesAdicionais, StandardCharsets.UTF_8));
        parametros.put("principal", principal);
        parametros.put("periodoApuracao", DataUtil.formatarDataSemBarras((Date)periodoApuracao));
        parametros.put("dataVencimento", DataUtil.formatarDataSemBarras((Date)dataVencimento));
        parametros.put("codigoMunicipioContribuinte", codigoMunicipioContribuinte);
        String hashParametros = BarramentoIRPFUtil.gerarHashParametros(parametros);
        String json = StringUtils.newStringUtf8((byte[])BarramentoIRPFService.chamarServicoRestPost(url + "/" + cpf, parametros, hashParametros)).trim();
        if (ConstantesGlobaisIRPF.VERSAO_TESTES) {
            System.out.println("Parametros: " + ((Object)parametros).toString());
            System.out.println("Retorno: " + json);
        }
        Gson gson = new Gson();
        try {
            retornoBarramento = (RetornoBarramento)gson.fromJson(json, RetornoBarramento.class);
        }
        catch (Exception e) {
            RetornoBarramento retorno = new RetornoBarramento();
            retorno.setCodigoRetorno(RETORNO_ERRO);
            retorno.setMensagemRetorno("Ocorreu um erro ao gerar o Darf.");
            retorno.setException("Erro durante consulta ao DARF. Retorno inv\u00e1lidos. [Retorno:" + json + "]");
            e.printStackTrace();
            throw new BarramentoException(retorno);
        }
        if (!retornoBarramento.getCodigoRetorno().equals(RETORNO_OK)) {
            throw new BarramentoException(retornoBarramento);
        }
        try {
            return Base64.decodeBase64((String)retornoBarramento.getConteudo());
        }
        catch (Throwable e) {
            RetornoBarramento retorno = new RetornoBarramento();
            retorno.setCodigoRetorno(RETORNO_ERRO);
            retorno.setMensagemRetorno("Ocorreu um erro ao gerar o Darf.");
            retorno.setException("Erro durante consulta ao DARF. Formato inv\u00e1lido. [Retorno:" + json + "]");
            e.printStackTrace();
            throw new BarramentoException(retorno);
        }
    }

    public static RetornoDarf calcularMultaJurosDarfAuxilio(String exercicio, Valor valorPrincipal) throws BarramentoException {
        RetornoDarf retornoBarramento;
        LinkedHashMap<String, String> parametros = new LinkedHashMap<String, String>();
        parametros.put("exercicio", exercicio);
        parametros.put("valorPrincipal", valorPrincipal.getParteInteira() + "." + valorPrincipal.getParteDecimal());
        String hashParametros = BarramentoIRPFUtil.gerarHashParametros(parametros);
        String json = StringUtils.newStringUtf8((byte[])BarramentoIRPFService.chamarServicoRestPost(URL_CALCULAR_MULTA_DARF_AUXILIO, parametros, hashParametros)).trim();
        if (ConstantesGlobaisIRPF.VERSAO_TESTES) {
            System.out.println("Parametros: " + ((Object)parametros).toString());
            System.out.println("Retorno: " + json);
        }
        Gson gson = new Gson();
        try {
            retornoBarramento = (RetornoDarf)gson.fromJson(json, RetornoDarf.class);
        }
        catch (Exception e) {
            RetornoBarramento retorno = new RetornoBarramento();
            retorno.setCodigoRetorno(RETORNO_ERRO);
            retorno.setMensagemRetorno(MensagemUtil.getMensagem((String)"erro_generico_calcula_multa_darf_auxilio"));
            retorno.setException("Erro durante consulta ao DARF Auxilio. [Retorno:" + json + "]");
            e.printStackTrace();
            throw new BarramentoException(retorno);
        }
        if (retornoBarramento.getCodigoRetorno().equals(RETORNO_OK)) {
            return retornoBarramento;
        }
        throw new BarramentoException((RetornoBarramento)retornoBarramento);
    }

    public static RetornoBarramento obterLinkAvaliacaoUsuarioAnonimo(String protocolo) throws BarramentoException {
        Gson gson;
        RetornoBarramento retornoBarramento;
        String url = URL_AVALIACAO_USR_ANONIMO + "?protocolo=" + protocolo;
        String json = StringUtils.newStringUtf8((byte[])BarramentoIRPFService.chamarServicoRestGet(url, null, null)).trim();
        if (ConstantesGlobaisIRPF.VERSAO_TESTES) {
            System.out.println("Retorno: " + json);
        }
        if (!(retornoBarramento = (RetornoBarramento)(gson = new Gson()).fromJson(json, RetornoBarramento.class)).getCodigoRetorno().equals(RETORNO_OK)) {
            throw new BarramentoException(retornoBarramento);
        }
        return retornoBarramento;
    }

    public static RetornoBarramento obterLinkAvaliacaoUsuarioLogado(String protocolo) throws BarramentoException, AplicacaoException {
        String url = URL_AVALIACAO_USR_LOGADO + "?protocolo=" + protocolo;
        HttpURLConnection con = BarramentoIRPFService.getURLConnection(url);
        con.setRequestProperty("Authorization", token);
        byte[] retorno = BarramentoIRPFService.chamarServicoRest(con, "GET", null, null);
        String json = StringUtils.newStringUtf8((byte[])retorno).trim();
        Gson gson = new Gson();
        RetornoBarramento retornoBarramento = (RetornoBarramento)gson.fromJson(json, RetornoBarramento.class);
        if (!retornoBarramento.getCodigoRetorno().equals(RETORNO_OK)) {
            throw new BarramentoException(retornoBarramento);
        }
        return retornoBarramento;
    }

    public static Date obterDataServidor() throws BarramentoException {
        RetornoBarramento retornoBarramento;
        String url = URL_DATA_HORA;
        String retorno = StringUtils.newStringUtf8((byte[])BarramentoIRPFService.chamarServicoRestGet(url, null, null));
        if (ConstantesGlobaisIRPF.VERSAO_TESTES) {
            System.out.println("Retorno: " + retorno);
        }
        try {
            if (retorno.matches("^\\d{14}$")) {
                return new SimpleDateFormat("yyyyMMddHHmmss").parse(retorno);
            }
            retornoBarramento = (RetornoBarramento)new Gson().fromJson(retorno, RetornoBarramento.class);
        }
        catch (Exception e) {
            retornoBarramento = new RetornoBarramento();
            retornoBarramento.setCodigoRetorno(RETORNO_ERRO);
            retornoBarramento.setMensagemRetorno(MensagemUtil.getMensagem((String)"nuvem.erro.servico_indisponivel"));
            retornoBarramento.setException("Erro durante consulta a Data atual. [Retorno:" + retorno + "]");
        }
        throw new BarramentoException(retornoBarramento);
    }

    public static String obterDataVencimentoDFE(String cpf, Date periodoApuracao, Date dataTransitoJulgado) throws AplicacaoException, BarramentoException {
        RetornoBarramento retornoBarramento;
        LinkedHashMap<String, String> parametros = new LinkedHashMap<String, String>();
        try {
            parametros.put("exercicio", AplicacaoPropertiesUtil.getExercicio());
            parametros.put("periodoApuracao", DataUtil.formatarDataSemBarras((Date)periodoApuracao));
            parametros.put("DataTransitoJulgado", DataUtil.formatarDataSemBarras((Date)dataTransitoJulgado));
        }
        catch (Throwable e) {
            throw new AplicacaoException("Parametros Invalidos.", e);
        }
        String hashParametros = BarramentoIRPFUtil.gerarHashParametros(parametros);
        String json = StringUtils.newStringUtf8((byte[])BarramentoIRPFService.chamarServicoRestPost(URL_DATA_VENCIMENTO_DARF_DFE + "/" + cpf, parametros, hashParametros)).trim();
        if (AplicacaoPropertiesUtil.isTestes()) {
            System.out.println("Parametros: " + ((Object)parametros).toString());
            System.out.println("Retorno: " + json);
        }
        Gson gson = new Gson();
        try {
            retornoBarramento = (RetornoBarramento)gson.fromJson(json, RetornoBarramento.class);
        }
        catch (Exception e) {
            RetornoBarramento retorno = new RetornoBarramento();
            retorno.setCodigoRetorno(RETORNO_ERRO);
            retorno.setMensagemRetorno("Ocorreu um erro ao obter a data de vencimento do DARF de DFE.");
            retorno.setException("Erro durante consulta ao vencimento de DARF de DFE. [Retorno:" + json + "]");
            throw new BarramentoException(retorno.getMensagemRetorno(), retorno.getCodigoRetorno(), e);
        }
        if (retornoBarramento.getCodigoRetorno().equals(RETORNO_ERRO_406)) {
            RetornoBarramento retorno = new RetornoBarramento();
            retorno.setCodigoRetorno(RETORNO_ERRO_406);
            retorno.setMensagemRetorno("N\u00e3o \u00e9 permitido informar data de tr\u00e2nsito em julgado posterior ao ano atual.");
            retorno.setException("Erro durante consulta ao vencimento de DARF de DFE. [Retorno:" + json + "]");
            throw new BarramentoException(retorno);
        }
        if (!retornoBarramento.getCodigoRetorno().equals(RETORNO_OK)) {
            throw new BarramentoException(retornoBarramento);
        }
        try {
            return retornoBarramento.getConteudo();
        }
        catch (Throwable e) {
            RetornoBarramento retorno = new RetornoBarramento();
            retorno.setCodigoRetorno(RETORNO_ERRO);
            retorno.setMensagemRetorno("Ocorreu um erro ao obter a data de vencimento do DARF de DFE.");
            retorno.setException("Erro durante consulta ao vencimento de DARF de DFE. [Retorno:" + json + "]");
            e.printStackTrace();
            throw new BarramentoException(retorno);
        }
    }

    private static byte[] chamarServicoRestGet(String url, Map<String, String> parametros, String hash) {
        return BarramentoIRPFService.chamarServicoRest("GET", url, parametros, hash);
    }

    private static byte[] chamarServicoRestPost(String url, Map<String, String> parametros, String hash) {
        return BarramentoIRPFService.chamarServicoRest("POST", url, parametros, hash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] chamarServicoRest(String method, String url, Map<String, String> parametros, String hash) {
        String msgErro;
        HttpURLConnection con = null;
        try {
            URL obj = new URL(url);
            con = BarramentoIRPFService.getURLConnection(obj);
            byte[] byArray = BarramentoIRPFService.chamarServicoRest(con, method, parametros, hash);
            return byArray;
        }
        catch (IOException e) {
            LogPPGD.erro((String)("Erro de conex\u00e3o: " + e));
            e.printStackTrace();
            msgErro = MensagemUtil.getMensagem((String)"nuvem.erro.inesperado");
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
        RetornoBarramento retornoBarramento = new RetornoBarramento();
        retornoBarramento.setCodigoRetorno(RETORNO_ERRO);
        retornoBarramento.setMensagemRetorno(msgErro);
        return StringUtils.getBytesUtf8((String)new Gson().toJson((Object)retornoBarramento));
    }

    private static byte[] chamarServicoRest(HttpURLConnection con, String method, Map<String, String> parametros, String hash) {
        byte[] retorno = null;
        RetornoBarramento retornoBarramento = new RetornoBarramento();
        try {
            ByteArrayOutputStream baf;
            BufferedInputStream bis;
            int responseCode;
            boolean first = true;
            StringBuilder urlParameters = null;
            if (parametros != null && !parametros.isEmpty()) {
                urlParameters = new StringBuilder();
                for (String nomeParametro : parametros.keySet()) {
                    if (first) {
                        first = false;
                    } else {
                        urlParameters.append("&");
                    }
                    String valorParametro = parametros.get(nomeParametro);
                    urlParameters.append(nomeParametro).append("=").append(valorParametro);
                }
            }
            con.setRequestMethod(method);
            con.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            con.setRequestProperty("charset", "iso-8859-1");
            if (urlParameters != null) {
                con.setRequestProperty("Content-Length", Integer.toString(urlParameters.toString().getBytes().length));
            }
            if (hash != null) {
                con.setRequestProperty("hash", hash);
            }
            con.setRequestProperty("versao_pgd", versaoPGD);
            con.setRequestProperty("exercicio", ConstantesGlobais.EXERCICIO);
            con.setDoOutput(true);
            if (urlParameters != null) {
                try (DataOutputStream wr = new DataOutputStream(con.getOutputStream());){
                    wr.writeBytes(urlParameters.toString());
                    wr.flush();
                }
                catch (Exception e) {
                    throw new AplicacaoException("nuvem.erro.inesperado", (Throwable)e);
                }
            }
            if ((responseCode = con.getResponseCode()) == 200) {
                bis = new BufferedInputStream(con.getInputStream());
                try {
                    baf = new ByteArrayOutputStream(50);
                    try {
                        int read = 0;
                        int bufSize = 512;
                        byte[] buffer = new byte[bufSize];
                        while ((read = bis.read(buffer)) != -1) {
                            baf.write(buffer, 0, read);
                        }
                        retorno = baf.toByteArray();
                    }
                    finally {
                        baf.close();
                    }
                }
                finally {
                    bis.close();
                }
                return retorno;
            }
            bis = new BufferedInputStream(con.getErrorStream());
            try {
                baf = new ByteArrayOutputStream(50);
                try {
                    int read = 0;
                    int bufSize = 512;
                    byte[] buffer = new byte[bufSize];
                    while ((read = bis.read(buffer)) != -1) {
                        baf.write(buffer, 0, read);
                    }
                    retornoBarramento.setException(new String(baf.toByteArray()));
                }
                finally {
                    baf.close();
                }
            }
            finally {
                bis.close();
            }
            if (responseCode / 100 == 5) {
                retornoBarramento.setMensagemRetorno(MensagemUtil.getMensagem((String)"nuvem.erro.servico_indisponivel"));
            } else {
                retornoBarramento.setMensagemRetorno(MensagemUtil.getMensagem((String)"nuvem.erro.inesperado"));
            }
        }
        catch (AplicacaoException e) {
            LogPPGD.erro((String)e.getMessage());
            e.printStackTrace();
            retornoBarramento.setMensagemRetorno(e.getMessage());
        }
        catch (Throwable e) {
            LogPPGD.erro((String)e.getMessage());
            e.printStackTrace();
            retornoBarramento.setMensagemRetorno(MensagemUtil.getMensagem((String)"nuvem.erro.inesperado"));
        }
        retornoBarramento.setCodigoRetorno(RETORNO_ERRO);
        return StringUtils.getBytesUtf8((String)new Gson().toJson((Object)retornoBarramento));
    }

    private static HttpURLConnection getURLConnection(String url) throws AplicacaoException {
        try {
            return BarramentoIRPFService.getURLConnection(new URL(url));
        }
        catch (IOException e) {
            throw new AplicacaoException("N\u00e3o \u00e9 poss\u00edvel conectar ao servi\u00e7o.", (Throwable)e, false);
        }
    }

    private static HttpURLConnection getURLConnection(URL url) throws IOException {
        return (HttpURLConnection)url.openConnection();
    }

    private static void verificarVersaoJava() throws AplicacaoException {
        try {
            PGDAb.verificaVersaoMinimaJava();
        }
        catch (Exception e) {
            throw new AplicacaoException(e.getMessage());
        }
    }

    public static UsuarioLogado getUsuarioLogado() {
        return usuarioLogado;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RetornoBarramento obterTodosMunicipios() throws BarramentoException, AplicacaoException {
        String url = URL_TODOS_MUNICIPIOS;
        HttpURLConnection con = BarramentoIRPFService.getURLConnection(url);
        try {
            Gson gson;
            RetornoBarramento retornoBarramento;
            con.setRequestProperty("Authorization", token);
            byte[] retorno = BarramentoIRPFService.chamarServicoRest(con, "GET", null, null);
            String json = StringUtils.newStringUtf8((byte[])retorno).trim();
            if (ConstantesGlobaisIRPF.VERSAO_TESTES) {
                System.out.println("Parametros: Authorization:" + token);
                System.out.println("Retorno: " + json);
            }
            if (!(retornoBarramento = (RetornoBarramento)(gson = new Gson()).fromJson(json, RetornoBarramento.class)).getCodigoRetorno().equals(RETORNO_OK)) {
                throw new BarramentoException(retornoBarramento.getMensagemRetorno(), retornoBarramento.getCodigoRetorno(), new Exception("Erro: " + retornoBarramento.getException()));
            }
            RetornoBarramento retornoBarramento2 = retornoBarramento;
            return retornoBarramento2;
        }
        finally {
            if (con != null) {
                con.disconnect();
            }
        }
    }
}

