/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.zip.ExportZipEntry;
import net.sf.jasperreports.engine.export.zip.FileBufferedZip;
import net.sf.jasperreports.repo.RepositoryUtil;

public class XlsxZip
extends FileBufferedZip {
    private final JasperReportsContext jasperReportsContext;
    private ExportZipEntry workbookEntry;
    private ExportZipEntry stylesEntry;
    private ExportZipEntry relsEntry;
    private ExportZipEntry contentTypesEntry;

    public XlsxZip() throws IOException {
        this(DefaultJasperReportsContext.getInstance());
    }

    public XlsxZip(JasperReportsContext jasperReportsContext) throws IOException {
        this(jasperReportsContext, null);
    }

    public XlsxZip(JasperReportsContext jasperReportsContext, Integer memoryThreshold) throws IOException {
        super(memoryThreshold);
        this.jasperReportsContext = jasperReportsContext;
        this.workbookEntry = this.createEntry("xl/workbook.xml");
        this.addEntry(this.workbookEntry);
        this.stylesEntry = this.createEntry("xl/styles.xml");
        this.addEntry(this.stylesEntry);
        this.relsEntry = this.createEntry("xl/_rels/workbook.xml.rels");
        this.addEntry(this.relsEntry);
        this.contentTypesEntry = this.createEntry("[Content_Types].xml");
        this.addEntry(this.contentTypesEntry);
        this.addEntry("_rels/.rels", "net/sf/jasperreports/engine/export/ooxml/xlsx/_rels/xml.rels");
    }

    public ExportZipEntry getWorkbookEntry() {
        return this.workbookEntry;
    }

    public ExportZipEntry getStylesEntry() {
        return this.stylesEntry;
    }

    public ExportZipEntry getRelsEntry() {
        return this.relsEntry;
    }

    public ExportZipEntry getContentTypesEntry() {
        return this.contentTypesEntry;
    }

    public ExportZipEntry addSheet(int index) {
        ExportZipEntry sheetEntry = this.createEntry("xl/worksheets/sheet" + index + ".xml");
        this.exportZipEntries.add(sheetEntry);
        return sheetEntry;
    }

    public ExportZipEntry addSheetRels(int index) {
        ExportZipEntry sheetRelsEntry = this.createEntry("xl/worksheets/_rels/sheet" + index + ".xml.rels");
        this.exportZipEntries.add(sheetRelsEntry);
        return sheetRelsEntry;
    }

    public ExportZipEntry addDrawing(int index) {
        ExportZipEntry drawingEntry = this.createEntry("xl/drawings/drawing" + index + ".xml");
        this.exportZipEntries.add(drawingEntry);
        return drawingEntry;
    }

    public ExportZipEntry addDrawingRels(int index) {
        ExportZipEntry drawingRelsEntry = this.createEntry("xl/drawings/_rels/drawing" + index + ".xml.rels");
        this.exportZipEntries.add(drawingRelsEntry);
        return drawingRelsEntry;
    }

    public void addMacro(String template) {
        InputStream templateIs = null;
        ZipInputStream templateZipIs = null;
        try {
            try {
                templateIs = RepositoryUtil.getInstance(this.jasperReportsContext).getInputStreamFromLocation(template);
                if (templateIs == null) {
                    throw new JRRuntimeException("Macro template not found at : " + template);
                }
                templateZipIs = new ZipInputStream(templateIs);
                ZipEntry entry = null;
                while ((entry = templateZipIs.getNextEntry()) != null) {
                    if ("xl/vbaProject.bin".equals(entry.getName())) break;
                }
                if (entry != null) {
                    ExportZipEntry macroEntry = this.createEntry("xl/vbaProject.bin");
                    OutputStream entryOs = macroEntry.getOutputStream();
                    long entryLength = entry.getSize();
                    byte[] bytes = new byte[10000];
                    int ln = 0;
                    long readBytesLength = 0L;
                    while (readBytesLength < entryLength && (ln = templateZipIs.read(bytes)) >= 0) {
                        readBytesLength += (long)ln;
                        entryOs.write(bytes, 0, ln);
                    }
                    this.exportZipEntries.add(macroEntry);
                }
            }
            catch (JRException e) {
                throw new JRRuntimeException(e);
            }
            catch (IOException e) {
                throw new JRRuntimeException(e);
            }
        }
        finally {
            if (templateZipIs != null) {
                try {
                    templateZipIs.close();
                }
                catch (IOException iOException) {}
            }
            if (templateIs != null) {
                try {
                    templateIs.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

