/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.negocio;

import java.util.Random;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.util.UtilitariosString;
import serpro.ppgd.negocio.util.Validador;

public class NIRF
extends Informacao<NIRF> {
    public NIRF() {
        super(null, "");
    }

    public NIRF(ObjetoNegocio owner, String nomeCampo) {
        super(owner, nomeCampo);
    }

    public NIRF(String pNomeCampo) {
        super(pNomeCampo);
    }

    @Override
    public String getConteudoFormatado() {
        return UtilitariosString.formataNIRF(this.asString());
    }

    @Override
    public void setConteudo(String conteudo) {
        super.setConteudo(UtilitariosString.retiraMascara(conteudo));
    }

    @Override
    public void setConteudo(NIRF pValor) {
        this.setConteudo(pValor.naoFormatado());
    }

    @Override
    public String formatado() {
        return UtilitariosString.formataNIRF(this.naoFormatado());
    }

    public static String gerarAleatorio() {
        Random r = new Random();
        StringBuilder sbNirfNumber = new StringBuilder();
        for (int i = 0; i < 7; ++i) {
            sbNirfNumber.append(r.nextInt(9));
        }
        return NIRF.generateDigits(sbNirfNumber.toString());
    }

    private static String generateDigits(String nirf) {
        String dv1 = String.valueOf(Validador.calcularModulo11(nirf, null, 2));
        String dv2 = String.valueOf(Validador.calcularModulo11(nirf + dv1, "6543298765432", 2));
        return nirf + dv1 + dv2;
    }
}

