/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.negocio;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import serpro.ppgd.negocio.IdDeclaracao;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.NI;
import serpro.ppgd.negocio.Nome;
import serpro.ppgd.negocio.ObjetoNegocio;

public abstract class IdUsuario
extends ObjetoNegocio {
    public static final String LABEL_NI = "Identifica\u00e7\u00e3o do Contribuinte";
    public static final String NOME = "Nome";
    private NI niContribuinte;
    private Nome nome = new Nome(this, "Nome");
    private List<IdDeclaracao> idDeclaracoes;

    public IdUsuario() {
        this.niContribuinte = new NI(this, LABEL_NI);
        this.niContribuinte.setReadOnly(true);
        this.nome.setReadOnly(true);
        this.idDeclaracoes = new ArrayList<IdDeclaracao>(5);
    }

    public NI getNiContribuinte() {
        return this.niContribuinte;
    }

    public Nome getNome() {
        return this.nome;
    }

    public List<IdDeclaracao> getIdDeclaracoes() {
        return this.idDeclaracoes;
    }

    public IdDeclaracao recuperarIdDeclaracao(int index) {
        List<IdDeclaracao> listaIdDeclaracaoes = this.getIdDeclaracoes();
        if (listaIdDeclaracaoes != null && listaIdDeclaracaoes.size() >= index) {
            return listaIdDeclaracaoes.get(index);
        }
        return null;
    }

    public final boolean equals(IdUsuario id) {
        List<Informacao> listaAtributosPkParametro = id.getListaAtributosPK();
        List<Informacao> listaAtributosPk = this.getListaAtributosPK();
        if (listaAtributosPk.size() != listaAtributosPkParametro.size()) {
            return false;
        }
        Iterator<Informacao> itAtributos = listaAtributosPk.iterator();
        Iterator<Informacao> itParametro = listaAtributosPkParametro.iterator();
        while (itAtributos.hasNext()) {
            Informacao atributoAtual = itAtributos.next();
            Informacao atributoParametroAtual = itParametro.next();
            if (atributoAtual == null || atributoParametroAtual == null) {
                return false;
            }
            if (atributoAtual.asString().equals(atributoParametroAtual.asString())) continue;
            return false;
        }
        return true;
    }

    public abstract List<Informacao> getListaAtributosPK();
}

