/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.rendpf;

import java.awt.Color;
import java.awt.Dimension;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import serpro.ppgd.infraestrutura.util.FontesUtil;
import serpro.ppgd.irpf.gui.IRPFTableModelAb;
import serpro.ppgd.irpf.gui.IRPFTableMonetariaAb;
import serpro.ppgd.irpf.gui.rendpf.RendPFCellRenderer;
import serpro.ppgd.irpf.gui.rendpf.RendPFHeaderCellRenderer;
import serpro.ppgd.irpf.gui.rendpf.RendPFMesCellRenderer;
import serpro.ppgd.irpf.gui.rendpf.TableModelRendPF;
import serpro.ppgd.irpf.gui.table.ColumnGroup;
import serpro.ppgd.irpf.gui.table.GroupableTableColumnModel;
import serpro.ppgd.irpf.gui.table.GroupableTableHeader;
import serpro.ppgd.irpf.rendpf.RendPF;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Valor;

public class TableRendPF
extends IRPFTableMonetariaAb {
    private static final long serialVersionUID = 1L;
    private static final NumberFormat nf = DecimalFormat.getInstance(new Locale("pt", "BR"));
    private static RendPF vazio = null;

    public TableRendPF() {
        this.accessibleColumnHeader = new String[]{"", "Pessoa F\u00edsica", "Alugu\u00e9is, inclusive por temporada", "Outros", "Exterior", "Previd\u00eancia oficial", "Dependentes", "Pens\u00e3o Aliment\u00edcia", "Livro Caixa", "Darf pago c\u00f3d. 0190"};
        this.accessibleRowHeader = new String[]{"Janeiro", "Fevereiro", "Mar\u00e7o", "Abril", "Maio", "Junho", "Julho", "Agosto", "Setembro", "Outubro", "Novembro", "Dezembro", "Total"};
    }

    protected void iniciaModelVazio() {
        this.setModel((TableModel)((Object)new TableModelRendPF(TableRendPF.getRendPFVazio())));
    }

    protected static RendPF getRendPFVazio() {
        if (vazio == null) {
            vazio = new RendPF();
        }
        return vazio;
    }

    protected void setaDefaultRenderers() {
        this.setDefaultRenderer(JPanel.class, new RendPFMesCellRenderer());
        this.setDefaultRenderer(Informacao.class, new RendPFCellRenderer());
    }

    protected void configuraLayout() {
        super.configuraLayout();
        final GroupableTableColumnModel cm = (GroupableTableColumnModel)this.getColumnModel();
        cm.getColumn(0).setPreferredWidth(45);
        cm.getColumn(1).setPreferredWidth(85);
        cm.getColumn(2).setPreferredWidth(85);
        cm.getColumn(3).setPreferredWidth(85);
        cm.getColumn(4).setPreferredWidth(85);
        cm.getColumn(5).setPreferredWidth(85);
        cm.getColumn(6).setPreferredWidth(85);
        cm.getColumn(7).setPreferredWidth(85);
        cm.getColumn(8).setPreferredWidth(85);
        cm.getColumn(9).setPreferredWidth(85);
        ColumnGroup g_vazio = new ColumnGroup((TableCellRenderer)new RendPFHeaderCellRenderer(), "");
        ColumnGroup g_rend = new ColumnGroup(new RendPFHeaderCellRenderer(), "<HTML><CENTER>Rendimentos</CENTER></HTML>"){

            public Dimension getSize(JTable table) {
                return new Dimension(cm.getColumn(1).getWidth() + cm.getColumn(2).getWidth() + cm.getColumn(3).getWidth() + cm.getColumn(4).getWidth(), 20);
            }
        };
        g_rend.add((Object)cm.getColumn(1));
        g_rend.add((Object)cm.getColumn(2));
        g_rend.add((Object)cm.getColumn(3));
        g_rend.add((Object)cm.getColumn(4));
        ColumnGroup g_deducoes = new ColumnGroup(new RendPFHeaderCellRenderer(), "<HTML><CENTER>Dedu\u00e7\u00f5es</CENTER></HTML>"){

            public Dimension getSize(JTable table) {
                return new Dimension(cm.getColumn(5).getWidth() + cm.getColumn(6).getWidth() + cm.getColumn(7).getWidth() + cm.getColumn(8).getWidth(), 20);
            }
        };
        g_deducoes.add((Object)cm.getColumn(5));
        g_deducoes.add((Object)cm.getColumn(6));
        g_deducoes.add((Object)cm.getColumn(7));
        g_deducoes.add((Object)cm.getColumn(8));
        ColumnGroup g_carneleao = new ColumnGroup(new RendPFHeaderCellRenderer(), "<HTML><CENTER>Carn\u00ea-Le\u00e3o</CENTER></HTML>"){

            public Dimension getSize(JTable table) {
                return new Dimension(cm.getColumn(9).getWidth(), 20);
            }
        };
        g_carneleao.add((Object)cm.getColumn(9));
        cm.addColumnGroup(g_vazio);
        cm.addColumnGroup(g_rend);
        cm.addColumnGroup(g_deducoes);
        cm.addColumnGroup(g_carneleao);
        this.getTableHeader().setPreferredSize(new Dimension(this.getTableHeader().getWidth(), 70));
    }

    protected void executaValidacaoAposEdicao(int col, int row) {
        super.executaValidacaoAposEdicao(col, row);
        if (col == 6) {
            Valor valor = (Valor)((IRPFTableModelAb)this.getModel()).getInformacaoAt(row, col);
        }
    }

    public void proximaCelula(int row, int col) {
        if (col == 9 && row == 11) {
            this.selecionaCelula(1, 0);
            this.editarCelula(0, 1);
        } else if (col == 9) {
            this.selecionaCelula(1, row + 1);
            this.editarCelula(row + 1, 1);
        } else {
            this.selecionaCelula(col + 1, row);
            this.editarCelula(row, col + 1);
        }
    }

    protected void configuraLayoutHeader() {
        super.configuraLayoutHeader();
        this.setColumnModel((TableColumnModel)new GroupableTableColumnModel());
        this.setTableHeader((JTableHeader)new GroupableTableHeader(this.getColumnModel()));
        this.getTableHeader().setForeground(new Color(0, 74, 106));
        this.getTableHeader().setFont(FontesUtil.FONTE_TITULO_MENOR);
    }
}

