/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.rendpf;

import serpro.ppgd.gui.xbeans.JEditValor;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.gui.IRPFTableModelAb;
import serpro.ppgd.irpf.rendpf.MesRendPF;
import serpro.ppgd.irpf.rendpf.RendPF;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;

public class TableModelRendPF
extends IRPFTableModelAb {
    private static final long serialVersionUID = 1L;
    private RendPF rendPF = null;
    private static final String TIT_MES = "<html><center>M\u00eas</center></html>";
    private static final String TIT_PESSOA_FISICA = "<html><center>Trabalho<br>N\u00e3o<br>Assalariado</center></html>";
    private static final String TIT_ALUGUEIS = "<html><center>Alugu\u00e9is,<br>inclusive por<br>temporada</center></html>";
    private static final String TIT_OUTROS = "<html><center>Outros</center></html>";
    private static final String TIT_EXTERIOR = "<html><center>Exterior</center></html>";
    private static final String TIT_PREVIDENCIA_OFICIAL = "<html><center>Previd\u00eancia<br>Oficial</center></html>";
    private static final String TIT_DEPENDENTES = "<html><center>Quantidade <br>de <br>Dependentes</center></html>";
    private static final String TIT_PENSAO = "<html><center>Pens\u00e3o<br>Aliment\u00edcia</center></html>";
    private static final String TIT_IMPOSTO_PAGO_EXTERIOR_COMPENSAR = "<html><center>Imposto Pago<br>Exterior a<br>Compensar</center></html>";
    private static final String TIT_LIVRO_CAIXA = "<html><center>Livro Caixa</center></html>";
    private static final String TIT_DARF = "<html><center>Darf pago<br>c\u00f3d. 0190</center></html>";

    public TableModelRendPF(RendPF pRend) {
        super((ObjetoNegocio)pRend);
        this.rendPF = pRend;
    }

    public int getRowCount() {
        return 13;
    }

    public int getColumnCount() {
        return 10;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this.getCelulaMes(rowIndex);
        }
        return this.getInformacaoAt(rowIndex, columnIndex);
    }

    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return TIT_MES;
            }
            case 1: {
                return TIT_PESSOA_FISICA;
            }
            case 2: {
                return TIT_ALUGUEIS;
            }
            case 3: {
                return TIT_OUTROS;
            }
            case 4: {
                return TIT_EXTERIOR;
            }
            case 5: {
                return TIT_PREVIDENCIA_OFICIAL;
            }
            case 6: {
                return TIT_DEPENDENTES;
            }
            case 7: {
                return TIT_PENSAO;
            }
            case 8: {
                return TIT_LIVRO_CAIXA;
            }
            case 9: {
                return TIT_DARF;
            }
        }
        return "";
    }

    public Informacao getInformacaoAt(int row, int col) {
        MesRendPF mes = null;
        switch (row) {
            case 0: {
                mes = this.rendPF.getJaneiro();
                break;
            }
            case 1: {
                mes = this.rendPF.getFevereiro();
                break;
            }
            case 2: {
                mes = this.rendPF.getMarco();
                break;
            }
            case 3: {
                mes = this.rendPF.getAbril();
                break;
            }
            case 4: {
                mes = this.rendPF.getMaio();
                break;
            }
            case 5: {
                mes = this.rendPF.getJunho();
                break;
            }
            case 6: {
                mes = this.rendPF.getJulho();
                break;
            }
            case 7: {
                mes = this.rendPF.getAgosto();
                break;
            }
            case 8: {
                mes = this.rendPF.getSetembro();
                break;
            }
            case 9: {
                mes = this.rendPF.getOutubro();
                break;
            }
            case 10: {
                mes = this.rendPF.getNovembro();
                break;
            }
            case 11: {
                mes = this.rendPF.getDezembro();
                break;
            }
            case 12: {
                switch (col) {
                    case 1: {
                        return this.rendPF.getTotalPessoaFisica();
                    }
                    case 2: {
                        return this.rendPF.getTotalAlugueis();
                    }
                    case 3: {
                        return this.rendPF.getTotalOutros();
                    }
                    case 4: {
                        return this.rendPF.getTotalExterior();
                    }
                    case 5: {
                        return this.rendPF.getTotalPrevidencia();
                    }
                    case 6: {
                        return this.rendPF.getTotalNumDependentes();
                    }
                    case 7: {
                        return this.rendPF.getTotalPensao();
                    }
                    case 8: {
                        return this.rendPF.getTotalLivroCaixa();
                    }
                    case 9: {
                        return this.rendPF.getTotalDarfPago();
                    }
                }
            }
        }
        switch (col) {
            case 1: {
                return mes.getPessoaFisica();
            }
            case 2: {
                return mes.getAlugueis();
            }
            case 3: {
                return mes.getOutros();
            }
            case 4: {
                return mes.getExterior();
            }
            case 5: {
                return mes.getPrevidencia();
            }
            case 6: {
                return mes.getNumDependentes();
            }
            case 7: {
                return mes.getPensao();
            }
            case 8: {
                return mes.getLivroCaixa();
            }
            case 9: {
                return mes.getDarfPago();
            }
        }
        return null;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex == 1) {
            return false;
        }
        if (rowIndex < this.getRowCount() - 1 && columnIndex > 0 && IRPFFacade.getInstancia().getDeclaracao() != null) {
            return !IRPFFacade.getInstancia().getDeclaracao().getIdentificadorDeclaracao().isTransmitida() && IRPFFacade.getInstancia().getDeclaracao().permiteInformarRendimento(rowIndex + 1);
        }
        return false;
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (rowIndex < this.getRowCount() - 1 && columnIndex > 1) {
            Informacao val = this.getInformacaoAt(rowIndex, columnIndex);
            val.setConteudo((String)aValue);
        }
    }

    public void setRendPF(RendPF pRendPF) {
        if (this.rendPF != null) {
            this.rendPF.removeObservadores(new Class[]{JEditValor.class});
        }
        this.rendPF = pRendPF;
        this.fireTableDataChanged();
    }

    public void setObjetoNegocio(ObjetoNegocio pObj) {
        this.setRendPF((RendPF)pObj);
    }

    public ObjetoNegocio getObjetoNegocio() {
        return this.rendPF;
    }
}

