/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.gui.rendpf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableRowSorter;
import serpro.ppgd.infraestrutura.PlataformaPPGD;
import serpro.ppgd.infraestrutura.util.FontesUtil;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.dependentes.Dependente;
import serpro.ppgd.irpf.gui.ControladorGui;
import serpro.ppgd.irpf.gui.IRPFTableAb;
import serpro.ppgd.irpf.gui.IRPFTableModelAb;
import serpro.ppgd.irpf.gui.JIRPFToolbar;
import serpro.ppgd.irpf.gui.PainelAbaAb;
import serpro.ppgd.irpf.gui.PainelComAbasAb;
import serpro.ppgd.irpf.gui.PainelDemonstrativoIf;
import serpro.ppgd.irpf.gui.TableLista;
import serpro.ppgd.irpf.gui.TableListaModel;
import serpro.ppgd.irpf.gui.TableListaSumarioModel;
import serpro.ppgd.irpf.gui.listener.CustomToolBarListener;
import serpro.ppgd.irpf.gui.listener.ToolBarListener;
import serpro.ppgd.irpf.gui.rendpf.CarneLeaoTableDecorator;
import serpro.ppgd.irpf.gui.rendpf.EscrituracaoTableCellRenderer;
import serpro.ppgd.irpf.gui.rendpf.PainelAbaEscrituracaoDetalheDependentes;
import serpro.ppgd.irpf.gui.rendpf.PainelDadosEscrituracao;
import serpro.ppgd.irpf.gui.rendpf.TableModelEscrituracao;
import serpro.ppgd.irpf.gui.util.GuiUtil;
import serpro.ppgd.irpf.rendpf.Conta;
import serpro.ppgd.irpf.rendpf.ContasMes;
import serpro.ppgd.irpf.rendpf.ItemRendPFDependente;
import serpro.ppgd.irpf.util.AplicacaoPropertiesUtil;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoNegocio;

public class PainelAbaLancamentosEscrituracaoDependentes
extends PainelAbaAb
implements CustomToolBarListener {
    private static final String HELP_ID = "Instru\u00e7\u00f5es de Preenchimento/Fichas de Livro Caixa e Carn\u00ea-le\u00e3o/Livro Caixa - Escritura\u00e7\u00e3o";
    private PainelDemonstrativoIf painelPai;
    private ItemRendPFDependente itemRendPFDependente;
    private String siglaMes;
    private JIRPFToolbar irpfToolbar;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private TableLista tableLista;

    public PainelAbaLancamentosEscrituracaoDependentes(PainelDemonstrativoIf painelPai, String mes, ItemRendPFDependente itemRendPFDependente) {
        super(painelPai);
        this.painelPai = painelPai;
        this.siglaMes = mes;
        this.itemRendPFDependente = itemRendPFDependente;
        this.initComponents();
        String nome = "";
        Dependente dependente = IRPFFacade.getInstancia().getDeclaracao().getDependentes().getDependenteByCpf(itemRendPFDependente.getCpf().naoFormatado());
        if (dependente != null) {
            nome = dependente.getNome().naoFormatado();
        }
        this.getTabela().setRowHeight(30);
        this.configurarTamanhoColunas();
        CarneLeaoTableDecorator.decorate(this.getTabela(), (ToolBarListener)this);
        this.getTabela().getSelectionModel().addListSelectionListener((ListSelectionListener)this.irpfToolbar);
        this.irpfToolbar.addToolBarListener((ToolBarListener)this);
        this.getTabela().setDefaultRenderer(Informacao.class, (TableCellRenderer)((Object)new EscrituracaoTableCellRenderer(1)));
        this.jScrollPane1.getViewport().setBackground(Color.white);
        PlataformaPPGD.getPlataforma().setHelpID((JComponent)((Object)this), HELP_ID);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tableLista = this.instanciarTabela(this.getTableModel(), this.getColunaOrdenacao(), this.getColunasOrdenaveis());
        this.jLabel1 = new JLabel();
        this.irpfToolbar = new JIRPFToolbar();
        this.setBackground(new Color(241, 245, 249));
        this.jPanel1.setBackground(Color.white);
        this.jPanel1.setBorder(BorderFactory.createLineBorder(new Color(211, 222, 232)));
        this.jScrollPane1.setBorder(BorderFactory.createLineBorder(new Color(211, 222, 232)));
        this.jScrollPane1.setViewportView((Component)this.tableLista);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 673, Short.MAX_VALUE).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 294, Short.MAX_VALUE).addContainerGap()));
        this.jLabel1.setFont(FontesUtil.FONTE_TITULO_MAIOR);
        this.jLabel1.setForeground(new Color(26, 135, 191));
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText(String.format("Rendimentos do Trabalho N\u00e3o Assalariado - %1$s", this.siglaMes));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent((Component)this.irpfToolbar, -2, -1, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.irpfToolbar, -2, -1, -2).addContainerGap()));
    }

    public TableListaModel getTableModel() {
        ObjetoNegocio dataSource = ((PainelComAbasAb)this.painelPai).getDataSource();
        return new TableModelEscrituracao(((ItemRendPFDependente)dataSource).getRendimentos().getContasAno().obterMesEscrituracaoAbaSelecionada(this.siglaMes));
    }

    public int getColunaOrdenacao() {
        return 0;
    }

    public Integer[] getColunasOrdenaveis() {
        return new Integer[]{0};
    }

    public void configurarTamanhoColunas() {
        TableColumnModel tcm = this.getTabela().getColumnModel();
        tcm.getColumn(0).setPreferredWidth(210);
        tcm.getColumn(1).setPreferredWidth(230);
        tcm.getColumn(2).setPreferredWidth(150);
    }

    public IRPFTableAb getTabela() {
        return this.tableLista;
    }

    public TableLista instanciarTabela(TableListaModel model, int colunaOrdenacao, Integer[] colunasOrdenaveis) {
        TableLista tableLista = new TableLista(model, colunaOrdenacao, colunasOrdenaveis);
        tableLista.accessibleColumnHeader = new String[]{"Item", "C\u00f3digo", "Nome", "Data de Nascimento", "CPF"};
        return tableLista;
    }

    public void aposCriarAbas() {
    }

    public String getNomeAba() {
        return this.siglaMes;
    }

    public PainelDemonstrativoIf getPainelPai() {
        return this.painelPai;
    }

    public JComponent getDefaultFocus() {
        if (!(this.getTabela().getModel().getRowCount() <= 0 || TableListaSumarioModel.class.isAssignableFrom(this.getTabela().getModel().getClass()) && this.getTabela().getModel().getRowCount() <= 1)) {
            return this.getTabela();
        }
        return this.getIrpfToolbar().getBtnNovo();
    }

    public String getTituloPainel() {
        return "Rendimentos Tribut\u00e1veis Recebidos de Pessoa F\u00edsica e do Exterior pelos Dependentes";
    }

    public void onBtnNovoClick(ActionEvent e) {
        TableModelEscrituracao lModel = (TableModelEscrituracao)((Object)this.getTabela().getModel());
        Conta lItem = new Conta();
        lItem.getCpfContribuinte().setConteudo(this.itemRendPFDependente.getCpf().naoFormatado());
        lItem.getDataMesAno().setConteudo(ContasMes.obterIndiceAsString((String)this.siglaMes) + AplicacaoPropertiesUtil.getExercicio());
        ContasMes contasMes = this.itemRendPFDependente.getRendimentos().getContasAno().obterMesEscrituracaoAbaSelecionada(this.siglaMes);
        contasMes.itens().add(lItem);
        ControladorGui.acionarPainel((PainelDemonstrativoIf)new PainelAbaEscrituracaoDetalheDependentes(this.painelPai, lItem, this.itemRendPFDependente, this.siglaMes, true));
        lModel.refresh();
    }

    public void onBtnAbrirClick(ActionEvent e) {
        if (this.getTabela().getSelectedRow() >= 0 && this.getTabela().getSelectedRow() < this.getTabela().getRowCount()) {
            int nLinha = this.getTabela().getSelectedRow();
            int indiceVetor = ((TableRowSorter)this.getTabela().getRowSorter()).convertRowIndexToModel(nLinha);
            IRPFTableModelAb model = (IRPFTableModelAb)this.getTabela().getModel();
            ContasMes colecao = (ContasMes)model.getObjetoNegocio();
            Conta item = (Conta)colecao.recuperarLista().get(indiceVetor);
            ControladorGui.acionarPainel((PainelDemonstrativoIf)new PainelAbaEscrituracaoDetalheDependentes(this.painelPai, item, this.itemRendPFDependente, this.siglaMes, false));
        } else {
            GuiUtil.mostrarAviso((String)"ErroSelecioneItem");
        }
    }

    public void onBtnExcluirClick(ActionEvent e) {
        IRPFTableAb tabela = this.getTabela();
        if (tabela.getSelectedRowCount() > 0) {
            int[] linhasTabela = tabela.getSelectedRows();
            if (GuiUtil.mostrarConfirmaNaoPadrao((String)"ConfirmaExcluirItens1", (String[])new String[]{"Lan\u00e7amento(s)"})) {
                ArrayList<ObjetoNegocio> listaRemocao = new ArrayList<ObjetoNegocio>(linhasTabela.length);
                Colecao<ObjetoNegocio> colecao = new Colecao<ObjetoNegocio>(){};
                for (int linhaTabela : linhasTabela) {
                    int indiceVetor = ((TableRowSorter)tabela.getRowSorter()).convertRowIndexToModel(linhaTabela);
                    TableListaModel model = (TableListaModel)tabela.getModel();
                    colecao = (Colecao)model.getObjetoNegocio();
                    ObjetoNegocio objetoNegocio = (ObjetoNegocio)colecao.itens().get(indiceVetor);
                    listaRemocao.add(objetoNegocio);
                }
                colecao.itens().removeAll(listaRemocao);
            }
        } else {
            GuiUtil.mostrarAviso((String)"ErroSelecioneItem");
        }
    }

    public void preExibir() {
        ((ContasMes)((TableListaModel)this.getTabela().getModel()).getObjetoNegocio()).removerContasEmBranco();
    }

    public void onBtnCustomClick(ActionEvent e) {
        PainelDadosEscrituracao painel = new PainelDadosEscrituracao("Dependentes");
        ControladorGui.acionarPainel((PainelDemonstrativoIf)painel);
        painel.acionarAba("Dependentes", true);
        painel.acionarAba("Dependentes", true);
    }

    public JIRPFToolbar getIrpfToolbar() {
        return this.irpfToolbar;
    }
}

