/*
 * Decompiled with CFR 0.152.
 */
package br.gov.serpro.midas.xmlada;

import br.gov.serpro.midas.xmlada.DomDocument;
import br.gov.serpro.midas.xmlada.Util;
import java.text.NumberFormat;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class DocTipos
extends DomDocument {
    public DocTipos(String doc) {
        super(doc);
    }

    public String formataCampo(String tipo, String valor) {
        if (tipo.trim().length() == 0) {
            return valor;
        }
        String valorPadrao = "";
        Element tipoCampo = this.getSingleNode("tipo", this.getRaiz(), "id=" + tipo);
        if (tipoCampo != null) {
            String formato = tipoCampo.getAttribute("formato");
            if (formato.trim().equals("NUMBER")) {
                String dec = tipoCampo.getAttribute("dec");
                return Util.isNumeric(dec) ? this.formataValor(valor, Integer.parseInt(dec)) : this.formataValor(valor, 0);
            }
            if (formato.trim().equals("STRING")) {
                String Formula;
                String Mask = tipoCampo.getAttribute("mask");
                String ret = Mask.trim().length() > 0 ? valor : ((Formula = tipoCampo.getAttribute("formula")).trim().length() <= 0 ? valor : this.formataFormula(valor, Formula));
                return ret;
            }
            if (formato.equals("TRANSLATE")) {
                NodeList nodeItemList;
                String formatacao = tipoCampo.getAttribute("formatacao");
                if (formatacao.length() > 0) {
                    valor = this.formataFormula(valor, formatacao);
                }
                if ((nodeItemList = tipoCampo.getChildNodes()).getLength() > 0) {
                    int i = 0;
                    while (i < nodeItemList.getLength()) {
                        if (nodeItemList.item(i).getNodeType() == 1 && nodeItemList.item(i).getNodeName().equals("item")) {
                            Element nodeItem = (Element)nodeItemList.item(i);
                            if (nodeItem.getAttribute("valor").length() == 0) {
                                valorPadrao = nodeItem.getAttribute("mostra");
                            } else if (nodeItem.getAttribute("valor").equals(valor)) {
                                return nodeItem.getAttribute("mostra");
                            }
                        }
                        ++i;
                    }
                    return valorPadrao.length() <= 0 ? valor : valorPadrao;
                }
            } else if (formato.equals("CONDITIONAL")) {
                NodeList nodeCondList = tipoCampo.getChildNodes();
                if (nodeCondList.getLength() > 0) {
                    int i = 0;
                    while (i < nodeCondList.getLength()) {
                        if (nodeCondList.item(i).getNodeType() == 1 && nodeCondList.item(i).getNodeName().equals("cond")) {
                            Element nodeCond = (Element)nodeCondList.item(i);
                            if (nodeCond.getAttribute("len").length() == 0) {
                                valorPadrao = nodeCond.getAttribute("tipo");
                            } else if (new Integer(nodeCond.getAttribute("len")).intValue() == valor.trim().length()) {
                                return this.formataCampo(nodeCond.getAttribute("tipo"), valor);
                            }
                        }
                        ++i;
                    }
                    return valorPadrao.length() <= 0 ? valor : this.formataCampo(valorPadrao, valor);
                }
            } else {
                return valor;
            }
            tipoCampo = null;
        }
        return valor;
    }

    private String formataFormula(String valorCampo, String formula) {
        block9: {
            if (!valorCampo.trim().equals("")) break block9;
            return "";
        }
        try {
            String valorAux = "";
            String valor = "";
            String[] funcoes = formula.split(";");
            if (funcoes.length == 0) {
                funcoes = new String[]{formula};
            }
            int i = 0;
            while (i < funcoes.length) {
                if (funcoes[i].indexOf("SUBSTR(") >= 0) {
                    String args = this.getDelimitedSubstr(funcoes[i], "(", ")");
                    String[] parametros = args.split(",");
                    if (parametros.length == 0) {
                        parametros = new String[]{args};
                    }
                    valorAux = parametros.length != 1 ? valorCampo.substring(Integer.parseInt(parametros[0]) - 1, Integer.parseInt(parametros[0]) + Integer.parseInt(parametros[1]) - 1) : valorCampo.substring(Integer.parseInt(parametros[0]) - 1);
                } else if (funcoes[i].substring(0, 4).equals("STR(")) {
                    valorAux = this.getDelimitedSubstr(funcoes[i], "(", ")");
                }
                valor = String.valueOf(valor) + valorAux;
                ++i;
            }
            return valor;
        }
        catch (Exception e) {
            return valorCampo;
        }
    }

    private String formataValor(String valor, int QtdDecimais) {
        double valorDouble = 0.0;
        int cvValor = -1;
        int fator = 1;
        String sinal = valor.substring(0, 1);
        if (sinal == "+") {
            valor = valor.substring(1);
        } else if (sinal == "-") {
            valor = valor.substring(1);
            fator = -1;
        }
        int qtdDec = QtdDecimais;
        if (Util.isNumeric(valor) && qtdDec < valor.length()) {
            valorDouble = qtdDec != 0 ? Double.parseDouble(valor) / (double)(0xA ^ qtdDec) * (double)fator : Double.parseDouble(valor) * (double)fator;
        }
        return this.formatNumber(valorDouble, qtdDec);
    }

    private String getDelimitedSubstr(String str, String del1, String del2) {
        int n1 = str.indexOf(del1);
        int n2 = str.indexOf(del2, n1 + 1);
        return str.substring(n1 + 1, n2);
    }

    private String formatNumber(double vlrDouble, int qtdDec) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setMinimumFractionDigits(qtdDec);
        nf.setMaximumFractionDigits(qtdDec);
        String strDouble = Double.toString(vlrDouble);
        try {
            return nf.parse(strDouble).toString();
        }
        catch (Exception e) {
            return "";
        }
    }
}

