/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.util.calculos;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.util.calculos.CampoInformacao;
import serpro.ppgd.irpf.util.calculos.FichaInformacao;
import serpro.ppgd.irpf.util.calculos.ListaFichaInformacao;
import serpro.ppgd.negocio.Observador;

public class MapeamentoDependencias {
    HashMap<String, ArrayList<String>> dependenciasMap = new HashMap();
    HashMap<String, ArrayList<String>> dependentesMap = new HashMap();

    public Field[] getFields(Class<?> c) {
        Field[] thisFields = c.getDeclaredFields();
        if (c.getSuperclass() != null) {
            Field[] superClassFields = this.getFields(c.getSuperclass());
            Field[] allFields = new Field[superClassFields.length + thisFields.length];
            System.arraycopy(superClassFields, 0, allFields, 0, superClassFields.length);
            System.arraycopy(thisFields, 0, allFields, superClassFields.length, thisFields.length);
            return allFields;
        }
        return thisFields;
    }

    public Field getField(Class<?> c, String name) {
        try {
            return c.getDeclaredField(name);
        }
        catch (Exception e) {
            if (c.getSuperclass() != null) {
                return this.getField(c.getSuperclass(), name);
            }
            return null;
        }
    }

    public void mapearInformacoes(Class<?> ficha, String prefixo) throws MapeamentoDependenciasException {
        String nomeDependente = null;
        FichaInformacao fichaInfo = ficha.getAnnotation(FichaInformacao.class);
        if (fichaInfo != null) {
            Field[] fields;
            for (Field field : fields = this.getFields(ficha)) {
                nomeDependente = prefixo + "." + field.getName();
                CampoInformacao campoInfo = field.getAnnotation(CampoInformacao.class);
                if (campoInfo != null) {
                    String[] dependencias = campoInfo.dependencias();
                    if (dependencias.length <= 0) continue;
                    System.out.println("\nCampo Dependente: " + nomeDependente);
                    for (String dependencia : dependencias) {
                        String nomeDependencia = null;
                        int lastIndex = nomeDependente.length();
                        for (int i = 0; i < dependencia.length() && dependencia.startsWith(".", i); ++i) {
                            if ((lastIndex = nomeDependente.lastIndexOf(".", lastIndex)) >= 0) {
                                nomeDependencia = nomeDependente.substring(0, lastIndex) + dependencia.substring(i);
                                --lastIndex;
                                continue;
                            }
                            throw new MapeamentoDependenciasException("Identificacao de campo Informacao inconsistente: \"" + dependencia + "\"");
                        }
                        if (nomeDependencia == null) {
                            nomeDependencia = "." + dependencia;
                            int index = nomeDependente.indexOf(".");
                            if (index > 0) {
                                nomeDependencia = nomeDependente.substring(0, index) + nomeDependencia;
                            }
                        }
                        System.out.println("\t" + nomeDependencia);
                        String idDependente = nomeDependente.replaceAll("\\[N?\\]", "");
                        ArrayList<String> listDependencias = this.dependentesMap.get(idDependente);
                        if (listDependencias == null) {
                            listDependencias = new ArrayList();
                            this.dependentesMap.put(idDependente, listDependencias);
                        }
                        listDependencias.add(nomeDependencia);
                        String idDependencia = nomeDependencia.replaceAll("\\[N?\\]", "");
                        ArrayList<String> listDependentes = this.dependenciasMap.get(idDependencia);
                        if (listDependentes == null) {
                            listDependentes = new ArrayList();
                            this.dependenciasMap.put(idDependencia, listDependentes);
                        }
                        CharSequence[] pathNomeDependente = nomeDependente.split("\\.");
                        String[] pathNomeDependencia = nomeDependencia.split("\\.");
                        int i = 0;
                        int j = 0;
                        while (i < pathNomeDependente.length) {
                            if (j < pathNomeDependencia.length) {
                                if (!((String)pathNomeDependente[i]).equals(pathNomeDependencia[j])) {
                                    if ("_itens[N]".equals(pathNomeDependente[i])) {
                                        pathNomeDependente[i] = "_itens[]";
                                    }
                                    if (!((String)pathNomeDependente[i]).equals(pathNomeDependencia[j])) {
                                        j = pathNomeDependencia.length;
                                    }
                                }
                            } else if ("_itens[N]".equals(pathNomeDependente[i])) {
                                pathNomeDependente[i] = "_itens[]";
                            }
                            ++i;
                            ++j;
                        }
                        String nomeDependenteMapeado = String.join((CharSequence)".", pathNomeDependente);
                        listDependentes.add(nomeDependenteMapeado);
                    }
                    continue;
                }
                this.mapearInformacoes(field.getType(), nomeDependente);
            }
            ListaFichaInformacao listaFicha = ficha.getAnnotation(ListaFichaInformacao.class);
            if (listaFicha != null) {
                nomeDependente = prefixo + "._itens[N]";
                this.mapearInformacoes(listaFicha.classeFicha(), nomeDependente);
            }
        }
    }

    public ArrayList<String> obterDependentes(String ... dependencias) {
        ArrayList<String> listDependentes = new ArrayList<String>();
        LinkedHashSet<String> setDependentes = new LinkedHashSet<String>();
        for (String dependencia : dependencias) {
            String idDependencia = dependencia.replaceAll("\\[(N?|\\d+)\\]", "");
            ArrayList<String> dependentes = this.dependenciasMap.get(idDependencia);
            if (dependentes == null) continue;
            for (String dependente : dependentes) {
                CharSequence[] pathDependente = dependente.split("\\.");
                String[] pathDependencia = dependencia.split("\\.");
                for (int i = 0; i < pathDependente.length && i < pathDependencia.length; ++i) {
                    if (((String)pathDependente[i]).equals(pathDependencia[i])) continue;
                    if (!pathDependencia[i].startsWith("_itens") || !"_itens[N]".equals(pathDependente[i])) break;
                    pathDependente[i] = pathDependencia[i];
                }
                String _dependente = String.join((CharSequence)".", pathDependente);
                setDependentes.remove(_dependente);
                setDependentes.add(_dependente);
            }
        }
        if (setDependentes.size() > 0) {
            listDependentes.addAll(setDependentes);
            String[] dependentes = new String[setDependentes.size()];
            dependentes = setDependentes.toArray(dependentes);
            listDependentes.addAll(this.obterDependentes(dependentes));
        }
        return listDependentes;
    }

    public ArrayList<String> obterDependencias(String dependente) {
        ArrayList<String> listDependencias = new ArrayList<String>();
        String idDependente = dependente.replaceAll("\\[(N?|\\d+)\\]", "");
        ArrayList<String> dependencias = this.dependentesMap.get(idDependente);
        if (dependencias != null) {
            for (String dependencia : dependencias) {
                CharSequence[] pathDependencia = dependencia.split("\\.");
                String[] pathDependente = dependente.split("\\.");
                for (int i = 0; i < pathDependencia.length && i < pathDependente.length; ++i) {
                    if (((String)pathDependencia[i]).equals(pathDependente[i])) continue;
                    if (!pathDependente[i].startsWith("_itens") || !"_itens[N]".equals(pathDependencia[i])) break;
                    pathDependencia[i] = pathDependente[i];
                }
                String _dependente = String.join((CharSequence)".", pathDependencia);
                listDependencias.add(_dependente);
            }
        }
        return listDependencias;
    }

    public <T> List<T> obterInformacao(Object ficha, String nomeInformacao) throws MapeamentoDependenciasException {
        String[] pathInfo = nomeInformacao.split("\\.");
        ArrayList<Object> listaInformacao = new ArrayList<Object>();
        Object fichaAtual = ficha;
        block17: for (int i = 0; i < pathInfo.length; ++i) {
            Class<?> classeFicha = fichaAtual.getClass();
            Field[] fields = this.getFields(classeFicha);
            if (pathInfo[i].startsWith("_itens")) {
                ListaFichaInformacao listaFichaInfo = classeFicha.getAnnotation(ListaFichaInformacao.class);
                if (listaFichaInfo != null) {
                    List lista = null;
                    String indice = pathInfo[i].replaceAll("_itens\\[|\\]", "");
                    String nomeLista = listaFichaInfo.lista();
                    if (!nomeLista.isEmpty()) {
                        Field field = null;
                        boolean accessible = false;
                        try {
                            field = this.getField(classeFicha, nomeLista);
                            if (field != null) {
                                accessible = field.isAccessible();
                                field.setAccessible(true);
                                lista = (List)field.get(fichaAtual);
                            }
                        }
                        catch (Exception e) {
                            throw new MapeamentoDependenciasException("Ocorreu um erro ao acessar Informacao.", e);
                        }
                        finally {
                            if (field != null) {
                                field.setAccessible(accessible);
                            }
                        }
                        if (lista == null) {
                            try {
                                Method m = classeFicha.getMethod(nomeLista, new Class[0]);
                                lista = (List)m.invoke(fichaAtual, new Object[0]);
                            }
                            catch (Exception e) {
                                throw new MapeamentoDependenciasException("Ocorreu um erro ao acessar Informacao.", e);
                            }
                        }
                    } else {
                        lista = (List)fichaAtual;
                    }
                    if (indice.isEmpty()) {
                        String info = String.join((CharSequence)".", Arrays.copyOfRange(pathInfo, i, pathInfo.length));
                        for (Object item : lista) {
                            listaInformacao.addAll(this.obterInformacao(item, info));
                        }
                        break;
                    }
                    try {
                        int ind = Integer.parseInt(indice);
                        if (ind >= lista.size()) {
                            throw new MapeamentoDependenciasException("A lista (" + String.join((CharSequence)".", Arrays.copyOfRange(pathInfo, 0, i)) + ") est\u00e1 vazia.");
                        }
                        fichaAtual = lista.get(ind);
                        continue;
                    }
                    catch (MapeamentoDependenciasException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new MapeamentoDependenciasException("Ocorreu um erro ao acessar Informacao.", e);
                    }
                }
                throw new MapeamentoDependenciasException("A Classe (" + fichaAtual.getClass().getName() + ") n\u00e3o \u00e9 uma @ListaFichaInformacao.");
            }
            for (Field field : fields) {
                if (!field.getName().equals(pathInfo[i])) continue;
                if (field.isAnnotationPresent(CampoInformacao.class)) {
                    boolean accessible = field.isAccessible();
                    try {
                        field.setAccessible(true);
                        listaInformacao.add(field.get(fichaAtual));
                        continue block17;
                    }
                    catch (Exception e) {
                        throw new MapeamentoDependenciasException("Ocorreu um erro ao acessar Informacao.", e);
                    }
                    finally {
                        field.setAccessible(accessible);
                    }
                }
                try {
                    fichaAtual = field.get(fichaAtual);
                    continue block17;
                }
                catch (Exception e) {
                    throw new MapeamentoDependenciasException("Ocorreu um erro ao acessar Informacao.", e);
                }
            }
        }
        return listaInformacao;
    }

    public void atualizarDependentes(Object ficha, String ... dependentes) {
        for (String string : dependentes) {
        }
    }

    public <T> List<T> teste(T[] a) {
        ArrayList<T> lista = new ArrayList<T>();
        for (T t : a) {
            lista.add(t);
        }
        return lista;
    }

    public static void mainTeste1(String[] args) {
        MapeamentoDependencias mapeamento = new MapeamentoDependencias();
        try {
            mapeamento.mapearInformacoes(FichaDeclaracao.class, "dec");
            System.out.println("\n////////////////////////////////////////////////////");
            System.out.println("dependenciasMap: " + mapeamento.dependenciasMap);
            System.out.println("dependentesMap: " + mapeamento.dependentesMap);
            System.out.println("////////////////////////////////////////////////////");
            String dependencia = "dec.listaRendPJ._itens[2].campoA";
            ArrayList<String> listDependentes = mapeamento.obterDependentes(dependencia);
            System.out.println("\nLista dependentes de \"" + dependencia + "\":\n" + listDependentes);
            System.out.println("---------------------------------------------------");
            FichaDeclaracao ficha = mapeamento.new FichaDeclaracao();
            for (String dependente : listDependentes) {
                List listInfo = mapeamento.obterInformacao(ficha, dependente);
                System.out.println("\nLista dependencias de \"" + dependente + "\" (Conteudo: " + listInfo + ") :");
                ArrayList<String> listDependencias = mapeamento.obterDependencias(dependente);
                System.out.println("\nLista dependencias de \"" + dependente + "\":\n" + listDependencias);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        MapeamentoDependencias mapeamento = new MapeamentoDependencias();
        try {
            mapeamento.mapearInformacoes(FichaDeclaracao.class, "dec");
            System.out.println("\n////////////////////////////////////////////////////");
            System.out.println("dependenciasMap: " + mapeamento.dependenciasMap);
            System.out.println("dependentesMap: " + mapeamento.dependentesMap);
            System.out.println("////////////////////////////////////////////////////");
            String dependencia = "dec.listaRendPJ._itens[2].campoA";
            ArrayList<String> listDependentes = mapeamento.obterDependentes(dependencia);
            System.out.println("\nLista dependentes de \"" + dependencia + "\":\n" + listDependentes);
            System.out.println("---------------------------------------------------");
            FichaDeclaracao ficha = mapeamento.new FichaDeclaracao();
            for (String dependente : listDependentes) {
                List listInfo = mapeamento.obterInformacao(ficha, dependente);
                System.out.println("\nLista dependencias de \"" + dependente + "\" (Conteudo: " + listInfo + ") :");
                ArrayList<String> listDependencias = mapeamento.obterDependencias(dependente);
                System.out.println("\nLista dependencias de \"" + dependente + "\":\n" + listDependencias);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public class ObservadorDependenciaInformacao
    extends Observador {
        String idInfoDependencia;

        public ObservadorDependenciaInformacao(String idDependencia) {
            this.idInfoDependencia = idDependencia;
        }

        public void notifica(Object arg0, String arg1, Object arg2, Object arg3) {
            IRPFFacade.getInstancia();
        }
    }

    public class MapeamentoDependenciasException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public MapeamentoDependenciasException(String arg0, Throwable arg1) {
            super(arg0, arg1);
        }

        public MapeamentoDependenciasException(String arg0) {
            super(arg0);
        }
    }

    @FichaInformacao
    public class FichaClaculo {
        @CampoInformacao
        private String campoA = "FichaClaculo:campoA";
        @CampoInformacao
        private String campoB = "FichaClaculo:campoB";
        @CampoInformacao
        private String campoC = "FichaClaculo:campoC";
        @CampoInformacao(dependencias={".campoA", ".campoB"})
        private String campoD = "FichaClaculo:campoD";
        @CampoInformacao(dependencias={".campoB", ".campoC"})
        private String campoE = "FichaClaculo:campoE";
        @CampoInformacao(dependencias={".campoD", ".campoE"})
        private String campoF = "FichaClaculo:campoF";
        @CampoInformacao(dependencias={"campoA"})
        private String campoG = "FichaClaculo:campoG";
    }

    @FichaInformacao
    @ListaFichaInformacao(classeFicha=FichaDetalheRendPJ.class)
    public class ListaRendPJ
    extends ArrayList<FichaDetalheRendPJ> {
        private static final long serialVersionUID = 1L;
        @CampoInformacao(dependencias={"._itens[].campoC"})
        private String campoA = "ListaRendPJ:campoA";
    }

    @FichaInformacao
    public class FichaDetalheRendPJ {
        @CampoInformacao
        private String campoA = "FichaDetalheRendPJ:campoA";
        @CampoInformacao
        private String campoB = "FichaDetalheRendPJ:campoB";
        @CampoInformacao(dependencias={".campoA", ".campoB"})
        private String campoC = "FichaDetalheRendPJ:campoC";
        private String campoD = "FichaDetalheRendPJ:campoD";
        private String campoE = "FichaDetalheRendPJ:campoE";
        private ListaRend listaRend = new ListaRend();

        public FichaDetalheRendPJ() {
            this.listaRend.add(new FichaDetalheRend());
            this.listaRend.add(new FichaDetalheRend());
            this.listaRend.add(new FichaDetalheRend());
            this.listaRend.add(new FichaDetalheRend());
        }
    }

    @FichaInformacao
    @ListaFichaInformacao(classeFicha=FichaDetalheRend.class)
    public class ListaRend
    extends ArrayList<FichaDetalheRend> {
        private static final long serialVersionUID = 1L;
        @CampoInformacao(dependencias={"._itens[].campoC"})
        private String campoA = "ListaRend:campoA";
    }

    @FichaInformacao
    public class FichaDetalheRend {
        @CampoInformacao
        private String campoA = "FichaDetalheRend:campoA";
        @CampoInformacao
        private String campoB = "FichaDetalheRend:campoB";
        @CampoInformacao(dependencias={".campoA", ".campoB"})
        private String campoC = "FichaDetalheRend:campoC";
        @CampoInformacao(dependencias={"fichaCalculo.campoA"})
        private String campoD = "FichaDetalheRend:campoD";
        @CampoInformacao(dependencias={".._itens[].campoA"})
        private String campoE = "FichaDetalheRend:campoE";
    }

    @FichaInformacao
    public class FichaDeclaracao {
        ListaRendPJ listaRendPJ;
        FichaClaculo fichaCalculo;
        @CampoInformacao
        private String campoA;

        public FichaDeclaracao() {
            this.listaRendPJ = new ListaRendPJ();
            this.fichaCalculo = new FichaClaculo();
            this.campoA = "FichaDeclaracao::campoA";
            this.listaRendPJ.add(new FichaDetalheRendPJ());
            this.listaRendPJ.add(new FichaDetalheRendPJ());
            this.listaRendPJ.add(new FichaDetalheRendPJ());
        }
    }
}

