/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.util.calculos;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import serpro.ppgd.irpf.util.calculos.CampoInformacao;
import serpro.ppgd.irpf.util.calculos.FichaInformacao;
import serpro.ppgd.irpf.util.calculos.ListaFichaInformacao;

public class MapeadorCalculosPPGD {
    final Map<String, ArrayList<String>> dependenciasMap = new HashMap<String, ArrayList<String>>();
    final Map<String, ArrayList<String>> dependentesMap = new HashMap<String, ArrayList<String>>();

    public static void main(String[] args) {
        MapeadorCalculosPPGD map;
        String[] caminho;
        for (String string : caminho = "...contrib.id".split("\\.\\.", -1)) {
            System.out.println("'" + string + "'");
        }
        MapeadorCalculosPPGD mapeadorCalculosPPGD = map = new MapeadorCalculosPPGD();
        Objects.requireNonNull(mapeadorCalculosPPGD);
        IdentificadorFicha ficha = mapeadorCalculosPPGD.new IdentificadorFicha("dec.contrib.id");
        System.out.println(ficha.obterId());
        System.out.println(ficha.obterFichaPorReferencia(".....bens").obterId());
        System.out.println(ficha.obterFichaPorReferencia("...endereco").obterId());
        System.out.println(ficha.obterFichaPorReferencia(".").obterId());
    }

    public Field[] getFields(Class<?> c) {
        Field[] thisFields = c.getDeclaredFields();
        if (c.getSuperclass() != null) {
            Field[] superClassFields = this.getFields(c.getSuperclass());
            Field[] allFields = new Field[superClassFields.length + thisFields.length];
            System.arraycopy(superClassFields, 0, allFields, 0, superClassFields.length);
            System.arraycopy(thisFields, 0, allFields, superClassFields.length, thisFields.length);
            return allFields;
        }
        return thisFields;
    }

    public void mapearInformacoes(Class<?> classFicha, IdentificadorFicha ficha) throws MapeamentoDependenciasException {
        FichaInformacao fichaInfo = classFicha.getAnnotation(FichaInformacao.class);
        if (fichaInfo != null) {
            Field[] fields;
            for (Field field : fields = this.getFields(classFicha)) {
                if (field.getName().startsWith("this$")) continue;
                String nomeCampo = field.getName();
                CampoInformacao campoInfo = field.getAnnotation(CampoInformacao.class);
                if (campoInfo != null) {
                    String[] dependencias = campoInfo.dependencias();
                    if (dependencias.length <= 0) continue;
                    IdentificadorCampo idCampoDependente = new IdentificadorCampo(ficha.obterId(), nomeCampo);
                    System.out.println("\nCampo Dependente: " + idCampoDependente.obterId());
                    for (String dependencia : dependencias) {
                        ArrayList<String> listDependencias = this.dependentesMap.get(idCampoDependente.obterId());
                        if (listDependencias == null) {
                            listDependencias = new ArrayList();
                            this.dependentesMap.put(idCampoDependente.obterId(), listDependencias);
                        }
                        listDependencias.add(dependencia);
                        IdentificadorCampo idCampoDependencia = idCampoDependente.obterCampoPorReferencia(dependencia);
                        System.out.println("\t" + idCampoDependencia.obterId());
                        ArrayList<String> listDependentes = this.dependenciasMap.get(idCampoDependencia.obterId());
                        if (listDependentes != null) continue;
                        listDependentes = new ArrayList();
                        this.dependenciasMap.put(idCampoDependencia.obterId(), listDependentes);
                    }
                    continue;
                }
                ficha.adicionarFicha(nomeCampo);
                this.mapearInformacoes(field.getType(), ficha);
            }
            ListaFichaInformacao listaFicha = classFicha.getAnnotation(ListaFichaInformacao.class);
            if (listaFicha != null) {
                // empty if block
            }
        }
    }

    public class MapeamentoDependenciasException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public MapeamentoDependenciasException(String arg0, Throwable arg1) {
            super(arg0, arg1);
        }

        public MapeamentoDependenciasException(String arg0) {
            super(arg0);
        }
    }

    public class IdentificadorFicha {
        private Stack<String> fichas = new Stack();
        private String raiz;

        public IdentificadorFicha(String raiz) {
            this.adicionarFicha(raiz);
            this.raiz = (String)this.fichas.firstElement();
        }

        public void adicionarFicha(String ficha) {
            String[] caminho;
            for (String nomeFicha : caminho = ficha.split("\\.", -1)) {
                if (nomeFicha.isEmpty()) continue;
                this.fichas.push(nomeFicha);
            }
        }

        public String obterId() {
            StringBuilder sbId = new StringBuilder(this.raiz);
            for (int i = 1; i < this.fichas.size(); ++i) {
                sbId.append(".").append((String)this.fichas.elementAt(i));
            }
            return sbId.toString();
        }

        public IdentificadorFicha obterFichaPorReferencia(String referencia) {
            int i;
            IdentificadorFicha ficha = new IdentificadorFicha(this.obterId());
            String[] fichas = referencia.split("\\.\\.", -1);
            for (i = 0; i < fichas.length - 1; ++i) {
                ficha.fichas.pop();
            }
            fichas = fichas[fichas.length - 1].split("\\.", -1);
            for (i = 1; i < fichas.length; ++i) {
                if (fichas[i].isEmpty()) continue;
                ficha.fichas.push(fichas[i]);
            }
            return ficha;
        }
    }

    public class IdentificadorCampo {
        private IdentificadorFicha ficha;
        private String campo;

        public IdentificadorCampo(String idFicha, String campo) {
            this.ficha = new IdentificadorFicha(idFicha);
            this.campo = campo;
        }

        public IdentificadorCampo obterCampoPorReferencia(String referencia) {
            String[] partes = referencia.split("\\:", -1);
            String idFicha = this.ficha.obterFichaPorReferencia(partes[0]).obterId();
            return new IdentificadorCampo(idFicha, partes[1]);
        }

        public String obterId() {
            return this.ficha.obterId() + ":" + this.campo;
        }

        public String getNomeCampo() {
            return this.campo;
        }
    }
}

