/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.util;

import java.util.ArrayList;
import java.util.List;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroAuxiliar;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroAuxiliarAb;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroPensaoMolestiaGrave;
import serpro.ppgd.irpf.rendIsentos.ItemQuadroTransporteDetalhado;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.Colecao;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.Pendencia;
import serpro.ppgd.negocio.Valor;
import serpro.ppgd.negocio.util.FabricaUtilitarios;

public final class QuadroAuxiliarUtil {
    private QuadroAuxiliarUtil() {
    }

    public static Valor recuperarTotalQuadroAuxiliarTitular(Colecao<? extends ItemQuadroAuxiliar> colecaoQuadroAuxiliar) {
        return QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarPorTipo(colecaoQuadroAuxiliar, "Titular");
    }

    public static Valor recuperarTotalQuadroAuxiliarDependente(Colecao<? extends ItemQuadroAuxiliar> colecaoQuadroAuxiliar) {
        return QuadroAuxiliarUtil.recuperarTotalQuadroAuxiliarPorTipo(colecaoQuadroAuxiliar, "Dependente");
    }

    public static List<Pendencia> validarQuadroAuxiliar(Colecao<? extends ItemQuadroAuxiliar> colecao, Informacao informacao, String complementoMensagem) {
        ArrayList<Pendencia> pendencias = new ArrayList<Pendencia>();
        List itens = colecao.itens();
        for (ItemQuadroAuxiliar item : itens) {
            item.adicionaCamposParaPendencia();
            pendencias.addAll(FabricaUtilitarios.verificarPendencias(colecao));
            item.removeCamposParaPendencia();
        }
        for (Pendencia p : pendencias) {
            p.setCampoInformacao(informacao);
            p.setCampo(informacao.getNomeCampo());
            p.setMsg(complementoMensagem + " - " + p.getMsg());
        }
        return pendencias;
    }

    public static List<Pendencia> validarQuadroAuxiliarAb(Colecao<? extends ItemQuadroAuxiliarAb> colecao, int posicaoInicial, String complementoMensagem, boolean isIsento) {
        ArrayList<Pendencia> pendencias = new ArrayList<Pendencia>();
        List itens = colecao.itens();
        for (ItemQuadroAuxiliarAb item : itens) {
            item.adicionaCamposParaPendencia();
            List novasPendencias = FabricaUtilitarios.verificarPendencias((Object)((Object)item));
            for (Pendencia p : novasPendencias) {
                p.setMsg(p.getMsg() + " (" + complementoMensagem + ")");
                p.setNumItem(posicaoInicial);
                if (isIsento) {
                    p.getCampoInformacao().setFicha("Rendimentos Isentos e N\u00e3o Tribut\u00e1veis");
                    continue;
                }
                p.getCampoInformacao().setFicha("Rendimentos Sujeitos \u00e0 Tributa\u00e7\u00e3o Exclusiva/Definitiva");
            }
            ++posicaoInicial;
            pendencias.addAll(novasPendencias);
            item.removeCamposParaPendencia();
        }
        return pendencias;
    }

    public static Valor recuperarTotalQuadroAuxiliarPorBeneficiario(Colecao<? extends ItemQuadroAuxiliar> colecaoQuadroAuxiliar, CPF cpfBeneficiario, boolean somar13Salario) {
        Valor total = new Valor();
        for (ItemQuadroAuxiliar item : colecaoQuadroAuxiliar.itens()) {
            if (!item.getCpfBeneficiario().naoFormatado().equals(cpfBeneficiario.naoFormatado())) continue;
            total.append('+', item.getValor());
            if (!somar13Salario) continue;
            total.append('+', (Valor)item.getValor13Salario());
        }
        return total;
    }

    private static Valor recuperarTotalQuadroAuxiliarPorTipo(Colecao<? extends ItemQuadroAuxiliar> colecaoQuadroAuxiliar, String tipo) {
        Valor total = new Valor();
        for (ItemQuadroAuxiliar item : colecaoQuadroAuxiliar.itens()) {
            ItemQuadroTransporteDetalhado itemDetalhado;
            if (!item.getTipoBeneficiario().naoFormatado().equals(tipo)) continue;
            total.append('+', item.getValor());
            if (item instanceof ItemQuadroPensaoMolestiaGrave) {
                total.append('+', (Valor)((ItemQuadroPensaoMolestiaGrave)item).getValor13Salario());
                continue;
            }
            if (!(item instanceof ItemQuadroTransporteDetalhado) || !(itemDetalhado = (ItemQuadroTransporteDetalhado)item).isParcIsentaAposentadoria()) continue;
            total.append('+', (Valor)((ItemQuadroTransporteDetalhado)item).getValor13Salario());
        }
        return total;
    }
}

