/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.util;

import serpro.ppgd.irpf.ValorPositivo;
import serpro.ppgd.irpf.gcap.ValorBigDecimalGCME;
import serpro.ppgd.negocio.Data;

public class CalculoImpostoDevidoUtil {
    private static final TabelaImposto[] tabelasImposto = new TabelaImposto[]{new TabelaImposto("01/01/2017", new String[][]{{"30000000,00", "0,2250"}, {"10000000,00", "0,2000"}, {"5000000,00", "0,1750"}, {"0,00", "0,1500"}}), new TabelaImposto("01/01/1900", new String[][]{{"0,00", "0,1500"}})};

    public static ValorBigDecimalGCME calcularAliquotaEfetivaDeImposto(ValorPositivo resultadoLiquido, ValorPositivo impostoDevido) {
        ValorBigDecimalGCME aliquotaEfetiva = new ValorBigDecimalGCME(null, "Al\u00edquota M\u00e9dia", 3, 9);
        if (resultadoLiquido.comparacao(">", "0,00")) {
            aliquotaEfetiva.setConteudo(impostoDevido.naoFormatado());
            aliquotaEfetiva.append('*', "100");
            aliquotaEfetiva.append('/', resultadoLiquido.naoFormatado());
            if (aliquotaEfetiva.comparacao("<", "15,00")) {
                aliquotaEfetiva.setConteudo("15,000000000");
            }
        } else {
            aliquotaEfetiva.setConteudo(0L);
        }
        aliquotaEfetiva.setConteudo(aliquotaEfetiva);
        return aliquotaEfetiva;
    }

    public static ValorPositivo calcularImpostoDevido(ValorPositivo ganhoCapital, Data dataAlienacao) {
        for (int i = 0; i < tabelasImposto.length; ++i) {
            if (dataAlienacao.maisAntiga(tabelasImposto[i].getDataInicioVigencia())) continue;
            return CalculoImpostoDevidoUtil.calcularImpostoDevido(ganhoCapital, tabelasImposto[i].getTabela());
        }
        return new ValorPositivo();
    }

    public static ValorPositivo calcularImpostoDevido(ValorPositivo ganhoCapital, String[][] tabelaImposto) {
        ValorPositivo tributavel = new ValorPositivo(null, "tributavel", 11, 4);
        tributavel.append('+', ganhoCapital);
        ValorPositivo imposto = new ValorPositivo(null, "imposto", 11, 4);
        for (int i = 0; i < tabelaImposto.length && tributavel.comparacao(">", "0,00"); ++i) {
            if (!tributavel.comparacao(">", tabelaImposto[i][0])) continue;
            ValorPositivo faixa = new ValorPositivo(null, "faixa", 11, 4);
            faixa.append('+', tributavel);
            faixa.append('-', tabelaImposto[i][0]);
            faixa.append('*', tabelaImposto[i][1]);
            imposto.append('+', faixa);
            tributavel.setConteudo(tabelaImposto[i][0]);
        }
        return imposto;
    }

    public static class TabelaImposto {
        private Data dataInicioVigencia = new Data();
        private String[][] tabela = null;

        public TabelaImposto(String data, String[][] tabela) {
            this.getDataInicioVigencia().setConteudo(data);
            this.setTabela(tabela);
        }

        public String[][] getTabela() {
            return this.tabela;
        }

        public void setTabela(String[][] tabela) {
            this.tabela = tabela;
        }

        public Data getDataInicioVigencia() {
            return this.dataInicioVigencia;
        }
    }
}

