/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.tabelas;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import serpro.ppgd.irpf.exception.AplicacaoException;
import serpro.ppgd.irpf.exception.BarramentoException;
import serpro.ppgd.irpf.nuvem.BarramentoIRPFService;
import serpro.ppgd.irpf.nuvem.RetornoBarramento;
import serpro.ppgd.irpf.tabelas.CadastroTabelasIRPF;
import serpro.ppgd.negocio.ElementoTabela;
import serpro.ppgd.negocio.util.UtilitariosString;

public class AtualizadorMunicipios {
    public static final String NOME_ARQUIVO_JSON_PGD = "municipios-pgd.json";
    public static final String NOME_ARQUIVO_JSON_TOM = "municipios-tom.json";

    private List<String> obterLinhasJSonTabelasMunicipiosPGD() {
        ArrayList<String> linhasJson = new ArrayList<String>();
        String[] ufs = new String[]{"AC", "AL", "AP", "AM", "BA", "CE", "DF", "ES", "GO", "MA", "MT", "MS", "MG", "PR", "PB", "PA", "PE", "PI", "RN", "RS", "RJ", "RO", "RR", "SC", "SE", "SP", "TO"};
        linhasJson.add("[");
        for (String uf : ufs) {
            List<ElementoTabela> municipios = CadastroTabelasIRPF.recuperarMunicipios(uf, 1);
            linhasJson.add("{");
            linhasJson.add("\"sigla\": \"" + uf + "\",");
            linhasJson.add("\"municipios\": [");
            boolean primeiro = true;
            for (ElementoTabela municipio : municipios) {
                if (!primeiro) {
                    linhasJson.add(",");
                }
                primeiro = false;
                linhasJson.add("{");
                linhasJson.add("\"codigo\": \"" + municipio.getConteudo(0) + "\",");
                linhasJson.add("\"nome\": \"" + UtilitariosString.retiraCaracteresEspeciais((String)municipio.getConteudo(1)).toUpperCase() + "\"");
                linhasJson.add("}");
            }
            linhasJson.add("]");
            linhasJson.add("}");
            if ("TO".equals(uf)) continue;
            linhasJson.add(",");
        }
        linhasJson.add("]");
        return linhasJson;
    }

    private List<String> indicarDiferencasPGDTOM(Map<String, String> mapA, Map<String, String> mapB, String nomeMapA, String nomeMapB, boolean indicarDiferencaGrafia) {
        ArrayList<String> diferencas = new ArrayList<String>();
        for (String key : mapA.keySet()) {
            String valorA = mapA.get(key);
            String valorB = mapB.get(key);
            if (valorB == null) {
                diferencas.add("O munic\u00edpio " + valorA + " existe em " + nomeMapA + " mas n\u00e3o existe em " + nomeMapB + ".");
                continue;
            }
            if (valorA.equals(valorB) || !indicarDiferencaGrafia) continue;
            diferencas.add("O munic\u00edpio " + valorA + " da " + nomeMapA + " se chama " + valorB + " no " + nomeMapB + ".");
        }
        return diferencas;
    }

    private void compararTabelaMunicipiosPGDTOM() {
        String filePathMunicipioTOM = NOME_ARQUIVO_JSON_TOM;
        String filePathMunicipioPGD = NOME_ARQUIVO_JSON_PGD;
        HashMap<String, String> mapMunicipiosTOM = new HashMap<String, String>();
        HashMap<String, String> mapMunicipiosPGD = new HashMap<String, String>();
        JsonElement jsonMunicipioTOM = null;
        JsonElement jsonMunicipioPGD = null;
        try (FileReader readerMunicipiosTOM = new FileReader(filePathMunicipioTOM);){
            FileReader readerMunicipiosPGD = new FileReader(filePathMunicipioPGD);
            jsonMunicipioTOM = new JsonParser().parse((Reader)readerMunicipiosTOM);
            jsonMunicipioPGD = new JsonParser().parse((Reader)readerMunicipiosPGD);
            JsonArray arrayMunicipiosTOM = jsonMunicipioTOM.getAsJsonArray();
            JsonArray arrayMunicipiosPGD = jsonMunicipioPGD.getAsJsonArray();
            int qtdeEstados = arrayMunicipiosTOM.size() > 27 ? 27 : arrayMunicipiosTOM.size();
            for (int i = 0; i < qtdeEstados; ++i) {
                JsonElement estadoTOM = arrayMunicipiosTOM.get(i);
                JsonElement estadoPGD = arrayMunicipiosPGD.get(i);
                JsonArray municipiosTOM = estadoTOM.getAsJsonObject().getAsJsonArray("municipios");
                JsonArray municipiosPGD = estadoPGD.getAsJsonObject().getAsJsonArray("municipios");
                mapMunicipiosTOM.clear();
                mapMunicipiosPGD.clear();
                System.out.println("=====================" + estadoTOM.getAsJsonObject().getAsJsonPrimitive("sigla").getAsString() + "=====================");
                if (estadoTOM.getAsJsonObject().getAsJsonPrimitive("sigla").getAsString().toUpperCase().equals("EX")) {
                    System.out.println("Pula exterior porque s\u00f3 existe no arquivo da TOM");
                    continue;
                }
                int limite = municipiosTOM.size() > municipiosPGD.size() ? municipiosTOM.size() : municipiosPGD.size();
                for (int j = 0; j < limite; ++j) {
                    if (j < municipiosTOM.size()) {
                        String codigoMunicipioTOM = municipiosTOM.get(j).getAsJsonObject().getAsJsonPrimitive("codigo").getAsString();
                        String nomeMunicipioTOM = municipiosTOM.get(j).getAsJsonObject().getAsJsonPrimitive("nome").getAsString();
                        mapMunicipiosTOM.put(codigoMunicipioTOM, codigoMunicipioTOM + "-" + nomeMunicipioTOM.replaceAll("'", " "));
                    }
                    if (j >= municipiosPGD.size()) continue;
                    String codigoMunicipioPGD = municipiosPGD.get(j).getAsJsonObject().getAsJsonPrimitive("codigo").getAsString();
                    String nomeMunicipioPGD = municipiosPGD.get(j).getAsJsonObject().getAsJsonPrimitive("nome").getAsString();
                    mapMunicipiosPGD.put(codigoMunicipioPGD, codigoMunicipioPGD + "-" + nomeMunicipioPGD);
                }
                List<String> diffTOMPGD = this.indicarDiferencasPGDTOM(mapMunicipiosTOM, mapMunicipiosPGD, "TOM", "PGD", true);
                List<String> diffPGDTOM = this.indicarDiferencasPGDTOM(mapMunicipiosPGD, mapMunicipiosTOM, "PGD", "TOM", false);
                if (diffTOMPGD.size() == 0 && diffPGDTOM.size() == 0) {
                    System.out.println("sem diferen\u00e7as");
                    continue;
                }
                for (String linha : diffTOMPGD) {
                    System.out.println(linha);
                }
                for (String linha : diffPGDTOM) {
                    System.out.println(linha);
                }
            }
        }
        catch (IOException e) {
            System.out.println("Erro ao ler o arquivo: " + e.getMessage());
        }
    }

    public void criarArquivo(String nomeArquivo) {
        try {
            new File(nomeArquivo).createNewFile();
        }
        catch (IOException e) {
            System.out.println("Ocorreu um erro ao criar o arquivo.");
            e.printStackTrace();
        }
    }

    public void escreverNoArquivo(String nomeArquivo, List<String> conteudo) {
        try (FileWriter writer = new FileWriter(nomeArquivo);){
            for (String linha : conteudo) {
                writer.write(linha);
            }
            writer.close();
            System.out.println("Json criado: " + nomeArquivo);
        }
        catch (IOException e) {
            System.out.println("Ocorreu um erro ao escrever no arquivo.");
            e.printStackTrace();
        }
    }

    public void deletarArquivo(String nomeArquivo) {
        File arquivo = new File(nomeArquivo);
        arquivo.delete();
    }

    private void obterMunicipiosPGD() {
        String nomeArquivo = NOME_ARQUIVO_JSON_PGD;
        this.deletarArquivo(nomeArquivo);
        this.criarArquivo(nomeArquivo);
        this.escreverNoArquivo(nomeArquivo, this.obterLinhasJSonTabelasMunicipiosPGD());
    }

    private void criarArquivoMunicipiosTOM(String json) {
        String nomeArquivo = NOME_ARQUIVO_JSON_TOM;
        ArrayList<String> municipiosTOM = new ArrayList<String>();
        municipiosTOM.add(json);
        this.deletarArquivo(nomeArquivo);
        this.criarArquivo(nomeArquivo);
        this.escreverNoArquivo(nomeArquivo, municipiosTOM);
    }

    private boolean obterMunicipiosTOM() {
        boolean retorno = false;
        try {
            RetornoBarramento retornoBarramento = BarramentoIRPFService.obterTodosMunicipios();
            if ("00".equals(retornoBarramento.getCodigoRetorno())) {
                this.criarArquivoMunicipiosTOM(retornoBarramento.getConteudo());
                retorno = true;
            } else {
                System.out.println("Falha na obten\u00e7\u00e3o dos munic\u00edpios da TOM.");
            }
        }
        catch (AplicacaoException | BarramentoException ex) {
            System.out.println("Falha na chamada do servi\u00e7o de obten\u00e7\u00e3o dos munic\u00edpios da TOM.");
        }
        return retorno;
    }

    public static void main(String[] args) {
        AtualizadorMunicipios AtualizadorMunicipios2 = new AtualizadorMunicipios();
        if (AtualizadorMunicipios2.obterMunicipiosTOM()) {
            AtualizadorMunicipios2.obterMunicipiosPGD();
            AtualizadorMunicipios2.compararTabelaMunicipiosPGDTOM();
        }
    }
}

