/*
 * Decompiled with CFR 0.152.
 */
package serpro.ppgd.irpf.rendpjexigibilidade;

import java.lang.ref.WeakReference;
import java.util.List;
import serpro.ppgd.irpf.DeclaracaoIRPF;
import serpro.ppgd.irpf.IRPFFacade;
import serpro.ppgd.irpf.ObservadorEspacosDuplicados;
import serpro.ppgd.irpf.ValidadorNaoNuloIRPF;
import serpro.ppgd.irpf.rendpjexigibilidade.RendPJComExigibilidadeTitular;
import serpro.ppgd.irpf.util.MensagemUtil;
import serpro.ppgd.negocio.CPF;
import serpro.ppgd.negocio.Informacao;
import serpro.ppgd.negocio.ObjetoFicha;
import serpro.ppgd.negocio.ObjetoNegocio;
import serpro.ppgd.negocio.Observador;
import serpro.ppgd.negocio.Pendencia;
import serpro.ppgd.negocio.RetornoValidacao;
import serpro.ppgd.negocio.ValidadorDefault;
import serpro.ppgd.negocio.ValidadorIf;
import serpro.ppgd.negocio.util.Validador;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorCPF;
import serpro.ppgd.negocio.validadoresBasicos.ValidadorNI;

public class RendPJComExigibilidadeDependente
extends RendPJComExigibilidadeTitular
implements ObjetoFicha {
    protected CPF cpfDependente = new CPF((ObjetoNegocio)this, "CPF");
    private WeakReference<DeclaracaoIRPF> declaracaoRef = null;

    public RendPJComExigibilidadeDependente(DeclaracaoIRPF dec) {
        super(dec.getIdentificadorDeclaracao());
        this.declaracaoRef = new WeakReference<DeclaracaoIRPF>(dec);
        ValidadorNaoNuloIRPF validadorNaoNulo = new ValidadorNaoNuloIRPF(3);
        validadorNaoNulo.setMensagemValidacao(MensagemUtil.getMensagem("rendpjdep_cpf_branco"));
        this.getCpfDependente().addValidador((ValidadorIf)validadorNaoNulo);
        ValidadorCPF validadorCPF = new ValidadorCPF(3);
        validadorCPF.setMensagemValidacao(MensagemUtil.getMensagem("rendpjdep_cpf_invalido"));
        this.getCpfDependente().addValidador((ValidadorIf)validadorCPF);
        this.getCpfDependente().addValidador((ValidadorIf)new ValidadorDefault(3){

            public RetornoValidacao validarImplementado() {
                DeclaracaoIRPF declaracaoIRPF = (DeclaracaoIRPF)((Object)RendPJComExigibilidadeDependente.this.declaracaoRef.get());
                if (!declaracaoIRPF.getDependentes().isExisteCpf(RendPJComExigibilidadeDependente.this.getCpfDependente().naoFormatado())) {
                    return new RetornoValidacao(MensagemUtil.getMensagem("rendpjdep_cpf_nao_existe"), 3);
                }
                return null;
            }
        });
    }

    @Override
    public void addValidadores() {
        ValidadorNaoNuloIRPF validadorNaoNuloNomeFontePagadora = new ValidadorNaoNuloIRPF(3){

            @Override
            public RetornoValidacao validarImplementado() {
                RetornoValidacao retornoValidacao = Validador.validarNI((String)RendPJComExigibilidadeDependente.this.getNIFontePagadora().naoFormatado());
                if (retornoValidacao == null && RendPJComExigibilidadeDependente.this.getNomeFontePagadora().isVazio()) {
                    this.setSeveridade((byte)2);
                    return new RetornoValidacao(MensagemUtil.getMensagem("nome_fonte_pagadora_ausente"), 2);
                }
                if (retornoValidacao != null && RendPJComExigibilidadeDependente.this.getNomeFontePagadora().isVazio()) {
                    this.setSeveridade((byte)3);
                    return new RetornoValidacao(MensagemUtil.getMensagem("nome_fonte_pagadora_ausente"), 3);
                }
                return null;
            }
        };
        this.getNomeFontePagadora().addObservador((Observador)new ObservadorEspacosDuplicados());
        this.getNomeFontePagadora().addValidador((ValidadorIf)validadorNaoNuloNomeFontePagadora);
        ValidadorNaoNuloIRPF validadorNaoNuloNI = new ValidadorNaoNuloIRPF(3){

            @Override
            public RetornoValidacao validarImplementado() {
                if (!RendPJComExigibilidadeDependente.this.getNIFontePagadora().naoFormatado().isEmpty() && RendPJComExigibilidadeDependente.this.getNIFontePagadora().naoFormatado().equals(RendPJComExigibilidadeDependente.this.getCpfDependente().naoFormatado())) {
                    this.setSeveridade((byte)3);
                    return new RetornoValidacao(MensagemUtil.getMensagem("ni_fonte_pagadora_igual_dependente"), 3);
                }
                if (!RendPJComExigibilidadeDependente.this.getNomeFontePagadora().isVazio() && RendPJComExigibilidadeDependente.this.getNIFontePagadora().isVazio()) {
                    this.setSeveridade((byte)2);
                    return new RetornoValidacao(MensagemUtil.getMensagem("ni_fonte_pagadora_branco"), 3);
                }
                return null;
            }
        };
        this.getNIFontePagadora().addValidador((ValidadorIf)new ValidadorNI(3, MensagemUtil.getMensagem("campo_invalido", new String[]{this.getNIFontePagadora().getNomeCampo()})));
        this.getNIFontePagadora().addValidador((ValidadorIf)validadorNaoNuloNI);
    }

    public CPF getCpfDependente() {
        return this.cpfDependente;
    }

    @Override
    public RendPJComExigibilidadeDependente obterCopia() {
        RendPJComExigibilidadeDependente copia = new RendPJComExigibilidadeDependente(IRPFFacade.getInstancia().getDeclaracao());
        copia.getCpfDependente().setConteudo(this.getCpfDependente());
        copia.getNIFontePagadora().setConteudo(this.getNIFontePagadora());
        copia.getNomeFontePagadora().setConteudo(this.getNomeFontePagadora());
        copia.getRendExigSuspensa().setConteudo(this.getRendExigSuspensa());
        copia.getDepositoJudicial().setConteudo(this.getDepositoJudicial());
        return copia;
    }

    @Override
    public List<Pendencia> verificarPendencias(int numeroItem) {
        List<Pendencia> retorno = super.verificarPendencias(numeroItem);
        return retorno;
    }

    @Override
    protected List<Informacao> recuperarListaCamposPendencia() {
        List retorno = this.recuperarCamposInformacao();
        return retorno;
    }

    @Override
    public String getNomeAba() {
        return "Dependentes";
    }
}

